/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.http;

import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpMediaType;
import com.google.api.client.util.Charsets;
import com.google.api.client.util.IOUtils;
import java.io.IOException;
import java.nio.charset.Charset;

public abstract class AbstractHttpContent
implements HttpContent {
    private long computedLength;
    private HttpMediaType mediaType;

    protected AbstractHttpContent(HttpMediaType httpMediaType) {
        this.computedLength = -1L;
        this.mediaType = httpMediaType;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected AbstractHttpContent(String string2) {
        HttpMediaType httpMediaType = string2 == null ? null : new HttpMediaType(string2);
        this(httpMediaType);
    }

    public static long computeLength(HttpContent httpContent) throws IOException {
        if (!httpContent.retrySupported()) {
            return -1L;
        }
        return IOUtils.computeLength(httpContent);
    }

    protected long computeLength() throws IOException {
        return AbstractHttpContent.computeLength(this);
    }

    protected final Charset getCharset() {
        if (this.mediaType == null || this.mediaType.getCharsetParameter() == null) {
            return Charsets.UTF_8;
        }
        return this.mediaType.getCharsetParameter();
    }

    @Override
    public long getLength() throws IOException {
        if (this.computedLength == -1L) {
            this.computedLength = this.computeLength();
        }
        return this.computedLength;
    }

    public final HttpMediaType getMediaType() {
        return this.mediaType;
    }

    @Override
    public String getType() {
        if (this.mediaType == null) {
            return null;
        }
        return this.mediaType.build();
    }

    @Override
    public boolean retrySupported() {
        return true;
    }

    public AbstractHttpContent setMediaType(HttpMediaType httpMediaType) {
        this.mediaType = httpMediaType;
        return this;
    }
}

