/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.extensions.android.json;

import android.annotation.TargetApi;
import android.util.JsonReader;
import android.util.JsonToken;
import com.google.api.client.extensions.android.json.AndroidJsonFactory;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.JsonParser;
import com.google.api.client.util.Beta;
import com.google.api.client.util.Preconditions;
import java.io.EOFException;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

@TargetApi(value=11)
@Beta
class AndroidJsonParser
extends JsonParser {
    private List<String> currentNameStack = new ArrayList<String>();
    private String currentText;
    private com.google.api.client.json.JsonToken currentToken;
    private final AndroidJsonFactory factory;
    private final JsonReader reader;

    AndroidJsonParser(AndroidJsonFactory androidJsonFactory, JsonReader jsonReader) {
        this.factory = androidJsonFactory;
        this.reader = jsonReader;
        jsonReader.setLenient(true);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void checkNumber() {
        boolean bl2 = this.currentToken == com.google.api.client.json.JsonToken.VALUE_NUMBER_INT || this.currentToken == com.google.api.client.json.JsonToken.VALUE_NUMBER_FLOAT;
        Preconditions.checkArgument(bl2);
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    @Override
    public BigInteger getBigIntegerValue() {
        this.checkNumber();
        return new BigInteger(this.currentText);
    }

    @Override
    public byte getByteValue() {
        this.checkNumber();
        return Byte.valueOf(this.currentText);
    }

    @Override
    public String getCurrentName() {
        if (this.currentNameStack.isEmpty()) {
            return null;
        }
        return this.currentNameStack.get(-1 + this.currentNameStack.size());
    }

    @Override
    public com.google.api.client.json.JsonToken getCurrentToken() {
        return this.currentToken;
    }

    @Override
    public BigDecimal getDecimalValue() {
        this.checkNumber();
        return new BigDecimal(this.currentText);
    }

    @Override
    public double getDoubleValue() {
        this.checkNumber();
        return Double.valueOf(this.currentText);
    }

    @Override
    public JsonFactory getFactory() {
        return this.factory;
    }

    @Override
    public float getFloatValue() {
        this.checkNumber();
        return Float.valueOf(this.currentText).floatValue();
    }

    @Override
    public int getIntValue() {
        this.checkNumber();
        return Integer.valueOf(this.currentText);
    }

    @Override
    public long getLongValue() {
        this.checkNumber();
        return Long.valueOf(this.currentText);
    }

    @Override
    public short getShortValue() {
        this.checkNumber();
        return Short.valueOf(this.currentText);
    }

    @Override
    public String getText() {
        return this.currentText;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public com.google.api.client.json.JsonToken nextToken() throws IOException {
        JsonToken jsonToken;
        if (this.currentToken != null) {
            switch (1.$SwitchMap$com$google$api$client$json$JsonToken[this.currentToken.ordinal()]) {
                case 1: {
                    this.reader.beginArray();
                    this.currentNameStack.add(null);
                }
                default: {
                    break;
                }
                case 2: {
                    this.reader.beginObject();
                    this.currentNameStack.add(null);
                }
            }
        }
        try {
            JsonToken jsonToken2;
            jsonToken = jsonToken2 = this.reader.peek();
        }
        catch (EOFException eOFException) {
            jsonToken = JsonToken.END_DOCUMENT;
        }
        switch (jsonToken) {
            default: {
                this.currentText = null;
                this.currentToken = null;
                return this.currentToken;
            }
            case BEGIN_ARRAY: {
                this.currentText = "[";
                this.currentToken = com.google.api.client.json.JsonToken.START_ARRAY;
                return this.currentToken;
            }
            case END_ARRAY: {
                this.currentText = "]";
                this.currentToken = com.google.api.client.json.JsonToken.END_ARRAY;
                this.currentNameStack.remove(-1 + this.currentNameStack.size());
                this.reader.endArray();
                return this.currentToken;
            }
            case BEGIN_OBJECT: {
                this.currentText = "{";
                this.currentToken = com.google.api.client.json.JsonToken.START_OBJECT;
                return this.currentToken;
            }
            case END_OBJECT: {
                this.currentText = "}";
                this.currentToken = com.google.api.client.json.JsonToken.END_OBJECT;
                this.currentNameStack.remove(-1 + this.currentNameStack.size());
                this.reader.endObject();
                return this.currentToken;
            }
            case BOOLEAN: {
                if (this.reader.nextBoolean()) {
                    this.currentText = "true";
                    this.currentToken = com.google.api.client.json.JsonToken.VALUE_TRUE;
                    return this.currentToken;
                }
                this.currentText = "false";
                this.currentToken = com.google.api.client.json.JsonToken.VALUE_FALSE;
                return this.currentToken;
            }
            case NULL: {
                this.currentText = "null";
                this.currentToken = com.google.api.client.json.JsonToken.VALUE_NULL;
                this.reader.nextNull();
                return this.currentToken;
            }
            case STRING: {
                this.currentText = this.reader.nextString();
                this.currentToken = com.google.api.client.json.JsonToken.VALUE_STRING;
                return this.currentToken;
            }
            case NUMBER: {
                this.currentText = this.reader.nextString();
                com.google.api.client.json.JsonToken jsonToken3 = this.currentText.indexOf(46) == -1 ? com.google.api.client.json.JsonToken.VALUE_NUMBER_INT : com.google.api.client.json.JsonToken.VALUE_NUMBER_FLOAT;
                this.currentToken = jsonToken3;
                return this.currentToken;
            }
            case NAME: 
        }
        this.currentText = this.reader.nextName();
        this.currentToken = com.google.api.client.json.JsonToken.FIELD_NAME;
        this.currentNameStack.set(-1 + this.currentNameStack.size(), this.currentText);
        return this.currentToken;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public JsonParser skipChildren() throws IOException {
        if (this.currentToken == null) return this;
        switch (1.$SwitchMap$com$google$api$client$json$JsonToken[this.currentToken.ordinal()]) {
            default: {
                return this;
            }
            case 1: {
                this.reader.skipValue();
                this.currentText = "]";
                this.currentToken = com.google.api.client.json.JsonToken.END_ARRAY;
                return this;
            }
            case 2: 
        }
        this.reader.skipValue();
        this.currentText = "}";
        this.currentToken = com.google.api.client.json.JsonToken.END_OBJECT;
        return this;
    }
}

