/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.plus;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.internal.du;
import com.google.android.gms.internal.ha;
import com.google.android.gms.plus.PlusClient;
import com.google.android.gms.plus.model.people.Person;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class PlusShare {
    public static final String EXTRA_CALL_TO_ACTION = "com.google.android.apps.plus.CALL_TO_ACTION";
    public static final String EXTRA_CONTENT_DEEP_LINK_ID = "com.google.android.apps.plus.CONTENT_DEEP_LINK_ID";
    public static final String EXTRA_CONTENT_DEEP_LINK_METADATA = "com.google.android.apps.plus.CONTENT_DEEP_LINK_METADATA";
    public static final String EXTRA_CONTENT_URL = "com.google.android.apps.plus.CONTENT_URL";
    public static final String EXTRA_IS_INTERACTIVE_POST = "com.google.android.apps.plus.GOOGLE_INTERACTIVE_POST";
    public static final String EXTRA_SENDER_ID = "com.google.android.apps.plus.SENDER_ID";
    public static final String KEY_CALL_TO_ACTION_DEEP_LINK_ID = "deepLinkId";
    public static final String KEY_CALL_TO_ACTION_LABEL = "label";
    public static final String KEY_CALL_TO_ACTION_URL = "url";
    public static final String KEY_CONTENT_DEEP_LINK_METADATA_DESCRIPTION = "description";
    public static final String KEY_CONTENT_DEEP_LINK_METADATA_THUMBNAIL_URL = "thumbnailUrl";
    public static final String KEY_CONTENT_DEEP_LINK_METADATA_TITLE = "title";
    public static final String PARAM_CONTENT_DEEP_LINK_ID = "deep_link_id";

    @Deprecated
    protected PlusShare() {
        throw new AssertionError();
    }

    public static Bundle a(String string2, String string3, Uri uri) {
        Bundle bundle = new Bundle();
        bundle.putString(KEY_CONTENT_DEEP_LINK_METADATA_TITLE, string2);
        bundle.putString(KEY_CONTENT_DEEP_LINK_METADATA_DESCRIPTION, string3);
        if (uri != null) {
            bundle.putString(KEY_CONTENT_DEEP_LINK_METADATA_THUMBNAIL_URL, uri.toString());
        }
        return bundle;
    }

    protected static boolean ag(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            Log.e((String)"GooglePlusPlatform", (String)"The provided deep-link ID is empty.");
            return false;
        }
        if (string2.contains(" ")) {
            Log.e((String)"GooglePlusPlatform", (String)"Spaces are not allowed in deep-link IDs.");
            return false;
        }
        return true;
    }

    public static Person createPerson(String string2, String string3) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            throw new IllegalArgumentException("MinimalPerson ID must not be empty.");
        }
        if (TextUtils.isEmpty((CharSequence)string3)) {
            throw new IllegalArgumentException("Display name must not be empty.");
        }
        return new ha(string3, string2, null, 0, null);
    }

    public static String getDeepLinkId(Intent intent) {
        String string2 = null;
        if (intent != null) {
            Uri uri = intent.getData();
            string2 = null;
            if (uri != null) {
                string2 = intent.getData().getQueryParameter(PARAM_CONTENT_DEEP_LINK_ID);
            }
        }
        return string2;
    }

    public static class Builder {
        private final Context mContext;
        private final Intent mIntent;
        private boolean zv;
        private ArrayList<Uri> zw;

        public Builder(Activity activity) {
            this.mContext = activity;
            this.mIntent = new Intent().setAction("android.intent.action.SEND");
            this.mIntent.addFlags(524288);
            if (activity != null && activity.getComponentName() != null) {
                this.zv = true;
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        @Deprecated
        public Builder(Activity activity, PlusClient plusClient) {
            this(activity);
            boolean bl2 = plusClient != null;
            du.a(bl2, "PlusClient must not be null.");
            du.a(plusClient.isConnected(), "PlusClient must be connected to create an interactive post.");
            du.a(plusClient.ep().aj("https://www.googleapis.com/auth/plus.login"), "Must request PLUS_LOGIN scope in PlusClient to create an interactive post.");
            Person person = plusClient.getCurrentPerson();
            String string2 = person != null ? person.getId() : "0";
            this.mIntent.putExtra(PlusShare.EXTRA_SENDER_ID, string2);
        }

        public Builder(Context context) {
            this.mContext = context;
            this.mIntent = new Intent().setAction("android.intent.action.SEND");
        }

        /*
         * Enabled aggressive block sorting
         */
        public Builder addCallToAction(String string2, Uri uri, String string3) {
            du.a(this.zv, "Must include the launching activity with PlusShare.Builder constructor before setting call-to-action");
            boolean bl2 = uri != null && !TextUtils.isEmpty((CharSequence)uri.toString());
            du.b(bl2, "Must provide a call to action URL");
            Bundle bundle = new Bundle();
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                bundle.putString(PlusShare.KEY_CALL_TO_ACTION_LABEL, string2);
            }
            bundle.putString(PlusShare.KEY_CALL_TO_ACTION_URL, uri.toString());
            if (!TextUtils.isEmpty((CharSequence)string3)) {
                du.a(PlusShare.ag(string3), "The specified deep-link ID was malformed.");
                bundle.putString(PlusShare.KEY_CALL_TO_ACTION_DEEP_LINK_ID, string3);
            }
            this.mIntent.putExtra(PlusShare.EXTRA_CALL_TO_ACTION, bundle);
            this.mIntent.putExtra(PlusShare.EXTRA_IS_INTERACTIVE_POST, true);
            this.mIntent.setType("text/plain");
            return this;
        }

        public Builder addStream(Uri uri) {
            Uri uri2 = (Uri)this.mIntent.getParcelableExtra("android.intent.extra.STREAM");
            if (uri2 == null) {
                return this.setStream(uri);
            }
            if (this.zw == null) {
                this.zw = new ArrayList();
            }
            this.zw.add(uri2);
            this.zw.add(uri);
            return this;
        }

        /*
         * Enabled aggressive block sorting
         */
        public Intent getIntent() {
            int n2 = 1;
            int n3 = this.zw != null && this.zw.size() > n2 ? n2 : 0;
            boolean bl2 = "android.intent.action.SEND_MULTIPLE".equals(this.mIntent.getAction());
            boolean bl3 = this.mIntent.getBooleanExtra(PlusShare.EXTRA_IS_INTERACTIVE_POST, false);
            int n4 = n3 == 0 || !bl3 ? n2 : 0;
            du.a(n4 != 0, "Call-to-action buttons are only available for URLs.");
            int n5 = !bl3 || this.mIntent.hasExtra(PlusShare.EXTRA_CONTENT_URL) ? n2 : 0;
            du.a(n5 != 0, "The content URL is required for interactive posts.");
            if (bl3 && !this.mIntent.hasExtra(PlusShare.EXTRA_CONTENT_URL) && !this.mIntent.hasExtra(PlusShare.EXTRA_CONTENT_DEEP_LINK_ID)) {
                n2 = 0;
            }
            du.a(n2 != 0, "Must set content URL or content deep-link ID to use a call-to-action button.");
            if (this.mIntent.hasExtra(PlusShare.EXTRA_CONTENT_DEEP_LINK_ID)) {
                du.a(PlusShare.ag(this.mIntent.getStringExtra(PlusShare.EXTRA_CONTENT_DEEP_LINK_ID)), "The specified deep-link ID was malformed.");
            }
            if (n3 == 0 && bl2) {
                this.mIntent.setAction("android.intent.action.SEND");
                if (this.zw != null && !this.zw.isEmpty()) {
                    this.mIntent.putExtra("android.intent.extra.STREAM", (Parcelable)this.zw.get(0));
                } else {
                    this.mIntent.removeExtra("android.intent.extra.STREAM");
                }
                this.zw = null;
            }
            if (n3 != 0 && !bl2) {
                this.mIntent.setAction("android.intent.action.SEND_MULTIPLE");
                if (this.zw != null && !this.zw.isEmpty()) {
                    this.mIntent.putParcelableArrayListExtra("android.intent.extra.STREAM", this.zw);
                } else {
                    this.mIntent.removeExtra("android.intent.extra.STREAM");
                }
            }
            if ("com.google.android.gms.plus.action.SHARE_INTERNAL_GOOGLE".equals(this.mIntent.getAction())) {
                this.mIntent.setPackage("com.google.android.gms");
                return this.mIntent;
            }
            if (!this.mIntent.hasExtra("android.intent.extra.STREAM")) {
                this.mIntent.setAction("com.google.android.gms.plus.action.SHARE_GOOGLE");
                this.mIntent.setPackage("com.google.android.gms");
                return this.mIntent;
            }
            this.mIntent.setPackage("com.google.android.apps.plus");
            return this.mIntent;
        }

        public Builder setContentDeepLinkId(String string2) {
            return this.setContentDeepLinkId(string2, null, null, null);
        }

        /*
         * Enabled aggressive block sorting
         */
        public Builder setContentDeepLinkId(String string2, String string3, String string4, Uri uri) {
            du.b(this.zv, "Must include the launching activity with PlusShare.Builder constructor before setting deep links");
            boolean bl2 = !TextUtils.isEmpty((CharSequence)string2);
            du.b(bl2, "The deepLinkId parameter is required.");
            Bundle bundle = PlusShare.a(string3, string4, uri);
            this.mIntent.putExtra(PlusShare.EXTRA_CONTENT_DEEP_LINK_ID, string2);
            this.mIntent.putExtra(PlusShare.EXTRA_CONTENT_DEEP_LINK_METADATA, bundle);
            this.mIntent.setType("text/plain");
            return this;
        }

        public Builder setContentUrl(Uri uri) {
            String string2 = null;
            if (uri != null) {
                string2 = uri.toString();
            }
            if (TextUtils.isEmpty(string2)) {
                this.mIntent.removeExtra(PlusShare.EXTRA_CONTENT_URL);
                return this;
            }
            this.mIntent.putExtra(PlusShare.EXTRA_CONTENT_URL, string2);
            return this;
        }

        /*
         * Enabled aggressive block sorting
         */
        public Builder setRecipients(Person person, List<Person> list) {
            Intent intent = this.mIntent;
            String string2 = person != null ? person.getId() : "0";
            intent.putExtra(PlusShare.EXTRA_SENDER_ID, string2);
            return this.setRecipients(list);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Deprecated
        public Builder setRecipients(List<Person> list) {
            int n2 = list != null ? list.size() : 0;
            if (n2 == 0) {
                this.mIntent.removeExtra("com.google.android.apps.plus.RECIPIENT_IDS");
                this.mIntent.removeExtra("com.google.android.apps.plus.RECIPIENT_DISPLAY_NAMES");
                return this;
            }
            ArrayList<String> arrayList = new ArrayList<String>(n2);
            ArrayList<String> arrayList2 = new ArrayList<String>(n2);
            Iterator<Person> iterator = list.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    this.mIntent.putStringArrayListExtra("com.google.android.apps.plus.RECIPIENT_IDS", arrayList);
                    this.mIntent.putStringArrayListExtra("com.google.android.apps.plus.RECIPIENT_DISPLAY_NAMES", arrayList2);
                    return this;
                }
                Person person = iterator.next();
                arrayList.add(person.getId());
                arrayList2.add(person.getDisplayName());
            }
        }

        public Builder setStream(Uri uri) {
            this.zw = null;
            this.mIntent.putExtra("android.intent.extra.STREAM", (Parcelable)uri);
            return this;
        }

        public Builder setText(CharSequence charSequence) {
            this.mIntent.putExtra("android.intent.extra.TEXT", charSequence);
            return this;
        }

        public Builder setType(String string2) {
            this.mIntent.setType(string2);
            return this;
        }
    }
}

