/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.internal.ds;
import com.google.android.gms.internal.du;
import com.google.android.gms.maps.internal.r;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.LatLngBoundsCreator;
import com.google.android.gms.maps.model.d;

public final class LatLngBounds
implements SafeParcelable {
    public static final LatLngBoundsCreator CREATOR = new LatLngBoundsCreator();
    private final int kZ;
    public final LatLng northeast;
    public final LatLng southwest;

    /*
     * Enabled aggressive block sorting
     */
    LatLngBounds(int n2, LatLng latLng, LatLng latLng2) {
        du.c(latLng, "null southwest");
        du.c(latLng2, "null northeast");
        boolean bl2 = latLng2.latitude >= latLng.latitude;
        Object[] objectArray = new Object[]{latLng.latitude, latLng2.latitude};
        du.a(bl2, "southern latitude exceeds northern latitude (%s > %s)", objectArray);
        this.kZ = n2;
        this.southwest = latLng;
        this.northeast = latLng2;
    }

    public LatLngBounds(LatLng latLng, LatLng latLng2) {
        this(1, latLng, latLng2);
    }

    private boolean a(double d2) {
        return this.southwest.latitude <= d2 && d2 <= this.northeast.latitude;
    }

    private static double b(double d2, double d3) {
        return (360.0 + (d2 - d3)) % 360.0;
    }

    private boolean b(double d2) {
        boolean bl2;
        block5: {
            block4: {
                if (this.southwest.longitude <= this.northeast.longitude) {
                    return this.southwest.longitude <= d2 && d2 <= this.northeast.longitude;
                }
                if (this.southwest.longitude <= d2) break block4;
                double d3 = d2 - this.northeast.longitude;
                double d4 = d3 == 0.0 ? 0 : (d3 < 0.0 ? -1 : 1);
                bl2 = false;
                if (d4 > 0) break block5;
            }
            bl2 = true;
        }
        return bl2;
    }

    public static Builder builder() {
        return new Builder();
    }

    private static double c(double d2, double d3) {
        return (360.0 + (d3 - d2)) % 360.0;
    }

    public boolean contains(LatLng latLng) {
        return this.a(latLng.latitude) && this.b(latLng.longitude);
    }

    public int describeContents() {
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean equals(Object object) {
        block5: {
            block4: {
                if (this == object) break block4;
                if (!(object instanceof LatLngBounds)) {
                    return false;
                }
                LatLngBounds latLngBounds = (LatLngBounds)object;
                if (!this.southwest.equals(latLngBounds.southwest) || !this.northeast.equals(latLngBounds.northeast)) break block5;
            }
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public LatLng getCenter() {
        double d2;
        double d3 = (this.southwest.latitude + this.northeast.latitude) / 2.0;
        double d4 = this.southwest.longitude;
        double d5 = this.northeast.longitude;
        if (d4 <= d5) {
            d2 = (d5 + d4) / 2.0;
            return new LatLng(d3, d2);
        }
        d2 = (d4 + (d5 + 360.0)) / 2.0;
        return new LatLng(d3, d2);
    }

    int getVersionCode() {
        return this.kZ;
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.southwest, this.northeast};
        return ds.hashCode(objectArray);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public LatLngBounds including(LatLng latLng) {
        double d2;
        double d3 = Math.min(this.southwest.latitude, latLng.latitude);
        double d4 = Math.max(this.northeast.latitude, latLng.latitude);
        double d5 = this.northeast.longitude;
        double d6 = this.southwest.longitude;
        double d7 = latLng.longitude;
        if (!this.b(d7)) {
            if (LatLngBounds.b(d6, d7) < LatLngBounds.c(d5, d7)) {
                d2 = d5;
                return new LatLngBounds(new LatLng(d3, d7), new LatLng(d4, d2));
            }
            d2 = d7;
            d7 = d6;
            return new LatLngBounds(new LatLng(d3, d7), new LatLng(d4, d2));
        }
        d7 = d6;
        d2 = d5;
        return new LatLngBounds(new LatLng(d3, d7), new LatLng(d4, d2));
    }

    public String toString() {
        return ds.e(this).a("southwest", this.southwest).a("northeast", this.northeast).toString();
    }

    public void writeToParcel(Parcel parcel, int n2) {
        if (r.eh()) {
            d.a(this, parcel, n2);
            return;
        }
        LatLngBoundsCreator.a(this, parcel, n2);
    }

    public static final class Builder {
        private double yD = Double.POSITIVE_INFINITY;
        private double yE = Double.NEGATIVE_INFINITY;
        private double yF = Double.NaN;
        private double yG = Double.NaN;

        private boolean b(double d2) {
            boolean bl2;
            block5: {
                block4: {
                    if (this.yF <= this.yG) {
                        return this.yF <= d2 && d2 <= this.yG;
                    }
                    if (this.yF <= d2) break block4;
                    double d3 = d2 - this.yG;
                    double d4 = d3 == 0.0 ? 0 : (d3 < 0.0 ? -1 : 1);
                    bl2 = false;
                    if (d4 > 0) break block5;
                }
                bl2 = true;
            }
            return bl2;
        }

        /*
         * Enabled aggressive block sorting
         */
        public LatLngBounds build() {
            boolean bl2 = !Double.isNaN(this.yF);
            du.a(bl2, "no included points");
            return new LatLngBounds(new LatLng(this.yD, this.yF), new LatLng(this.yE, this.yG));
        }

        /*
         * Enabled aggressive block sorting
         */
        public Builder include(LatLng latLng) {
            this.yD = Math.min(this.yD, latLng.latitude);
            this.yE = Math.max(this.yE, latLng.latitude);
            double d2 = latLng.longitude;
            if (Double.isNaN(this.yF)) {
                this.yF = d2;
                this.yG = d2;
                return this;
            }
            if (this.b(d2)) return this;
            if (LatLngBounds.b(this.yF, d2) < LatLngBounds.c(this.yG, d2)) {
                this.yF = d2;
                return this;
            }
            this.yG = d2;
            return this;
        }
    }
}

