/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps;

import android.graphics.Point;
import android.os.RemoteException;
import com.google.android.gms.internal.du;
import com.google.android.gms.maps.CameraUpdate;
import com.google.android.gms.maps.internal.ICameraUpdateFactoryDelegate;
import com.google.android.gms.maps.model.CameraPosition;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.LatLngBounds;
import com.google.android.gms.maps.model.RuntimeRemoteException;

public final class CameraUpdateFactory {
    private static ICameraUpdateFactoryDelegate xm;

    private CameraUpdateFactory() {
    }

    static void a(ICameraUpdateFactoryDelegate iCameraUpdateFactoryDelegate) {
        if (xm != null) {
            return;
        }
        xm = du.f(iCameraUpdateFactoryDelegate);
    }

    private static ICameraUpdateFactoryDelegate dQ() {
        return du.c(xm, "CameraUpdateFactory is not initialized");
    }

    public static CameraUpdate newCameraPosition(CameraPosition cameraPosition) {
        try {
            CameraUpdate cameraUpdate = new CameraUpdate(CameraUpdateFactory.dQ().newCameraPosition(cameraPosition));
            return cameraUpdate;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public static CameraUpdate newLatLng(LatLng latLng) {
        try {
            CameraUpdate cameraUpdate = new CameraUpdate(CameraUpdateFactory.dQ().newLatLng(latLng));
            return cameraUpdate;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public static CameraUpdate newLatLngBounds(LatLngBounds latLngBounds, int n2) {
        try {
            CameraUpdate cameraUpdate = new CameraUpdate(CameraUpdateFactory.dQ().newLatLngBounds(latLngBounds, n2));
            return cameraUpdate;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public static CameraUpdate newLatLngBounds(LatLngBounds latLngBounds, int n2, int n3, int n4) {
        try {
            CameraUpdate cameraUpdate = new CameraUpdate(CameraUpdateFactory.dQ().newLatLngBoundsWithSize(latLngBounds, n2, n3, n4));
            return cameraUpdate;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public static CameraUpdate newLatLngZoom(LatLng latLng, float f2) {
        try {
            CameraUpdate cameraUpdate = new CameraUpdate(CameraUpdateFactory.dQ().newLatLngZoom(latLng, f2));
            return cameraUpdate;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public static CameraUpdate scrollBy(float f2, float f3) {
        try {
            CameraUpdate cameraUpdate = new CameraUpdate(CameraUpdateFactory.dQ().scrollBy(f2, f3));
            return cameraUpdate;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public static CameraUpdate zoomBy(float f2) {
        try {
            CameraUpdate cameraUpdate = new CameraUpdate(CameraUpdateFactory.dQ().zoomBy(f2));
            return cameraUpdate;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public static CameraUpdate zoomBy(float f2, Point point) {
        try {
            CameraUpdate cameraUpdate = new CameraUpdate(CameraUpdateFactory.dQ().zoomByWithFocus(f2, point.x, point.y));
            return cameraUpdate;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public static CameraUpdate zoomIn() {
        try {
            CameraUpdate cameraUpdate = new CameraUpdate(CameraUpdateFactory.dQ().zoomIn());
            return cameraUpdate;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public static CameraUpdate zoomOut() {
        try {
            CameraUpdate cameraUpdate = new CameraUpdate(CameraUpdateFactory.dQ().zoomOut());
            return cameraUpdate;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public static CameraUpdate zoomTo(float f2) {
        try {
            CameraUpdate cameraUpdate = new CameraUpdate(CameraUpdateFactory.dQ().zoomTo(f2));
            return cameraUpdate;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }
}

