/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.webkit.WebSettings;
import android.webkit.WebView;
import com.google.android.gms.internal.co;
import com.google.android.gms.internal.cp;
import com.google.android.gms.internal.cq;
import com.google.android.gms.internal.cr;
import com.google.android.gms.internal.cs;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.nio.CharBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class cn {
    private static final Object hA = new Object();
    private static String iA;
    private static boolean iB;
    private static boolean iz;

    static {
        iz = true;
        iB = false;
    }

    public static String a(Readable readable) throws IOException {
        int n2;
        StringBuilder stringBuilder = new StringBuilder();
        CharBuffer charBuffer = CharBuffer.allocate(2048);
        while ((n2 = readable.read(charBuffer)) != -1) {
            charBuffer.flip();
            stringBuilder.append(charBuffer, 0, n2);
        }
        return stringBuilder.toString();
    }

    private static JSONArray a(Collection<?> collection) throws JSONException {
        JSONArray jSONArray = new JSONArray();
        Iterator<?> iterator = collection.iterator();
        while (iterator.hasNext()) {
            cn.a(jSONArray, iterator.next());
        }
        return jSONArray;
    }

    private static JSONArray a(Object[] objectArray) throws JSONException {
        JSONArray jSONArray = new JSONArray();
        int n2 = objectArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            cn.a(jSONArray, objectArray[i2]);
        }
        return jSONArray;
    }

    private static JSONObject a(Bundle bundle) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        for (String string2 : bundle.keySet()) {
            cn.a(jSONObject, string2, bundle.get(string2));
        }
        return jSONObject;
    }

    public static void a(Context context, String string2, WebSettings webSettings) {
        webSettings.setUserAgentString(cn.b(context, string2));
    }

    public static void a(Context context, String string2, List<String> list) {
        Iterator<String> iterator = list.iterator();
        while (iterator.hasNext()) {
            new cq(context, string2, iterator.next()).start();
        }
    }

    public static void a(Context context, String string2, boolean bl2, HttpURLConnection httpURLConnection) {
        httpURLConnection.setConnectTimeout(60000);
        httpURLConnection.setInstanceFollowRedirects(bl2);
        httpURLConnection.setReadTimeout(60000);
        httpURLConnection.setRequestProperty("User-Agent", cn.b(context, string2));
        httpURLConnection.setUseCaches(false);
    }

    public static void a(WebView webView) {
        if (Build.VERSION.SDK_INT >= 11) {
            co.a(webView);
        }
    }

    private static void a(JSONArray jSONArray, Object object) throws JSONException {
        if (object instanceof Bundle) {
            jSONArray.put((Object)cn.a((Bundle)object));
            return;
        }
        if (object instanceof Map) {
            jSONArray.put((Object)cn.m((Map)object));
            return;
        }
        if (object instanceof Collection) {
            jSONArray.put((Object)cn.a((Collection)object));
            return;
        }
        if (object instanceof Object[]) {
            jSONArray.put((Object)cn.a((Object[])object));
            return;
        }
        jSONArray.put(object);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void a(JSONObject jSONObject, String string2, Object object) throws JSONException {
        if (object instanceof Bundle) {
            jSONObject.put(string2, (Object)cn.a((Bundle)object));
            return;
        }
        if (object instanceof Map) {
            jSONObject.put(string2, (Object)cn.m((Map)object));
            return;
        }
        if (object instanceof Collection) {
            if (string2 == null) {
                string2 = "null";
            }
            jSONObject.put(string2, (Object)cn.a((Collection)object));
            return;
        }
        if (object instanceof Object[]) {
            jSONObject.put(string2, (Object)cn.a(Arrays.asList((Object[])object)));
            return;
        }
        jSONObject.put(string2, object);
    }

    public static boolean a(PackageManager packageManager, String string2, String string3) {
        return packageManager.checkPermission(string3, string2) == 0;
    }

    public static boolean as() {
        return iz;
    }

    public static int at() {
        if (Build.VERSION.SDK_INT >= 9) {
            return 6;
        }
        return 0;
    }

    public static int au() {
        if (Build.VERSION.SDK_INT >= 9) {
            return 7;
        }
        return 1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String b(final Context context, String string2) {
        Object object = hA;
        synchronized (object) {
            String string3;
            if (iA != null) {
                return iA;
            }
            if (Build.VERSION.SDK_INT >= 17) {
                iA = cp.getDefaultUserAgent(context);
                return iA = iA + " (Mobile; " + string2 + ")";
            }
            if (cr.ax()) {
                iA = cn.j(context);
                return iA = iA + " (Mobile; " + string2 + ")";
            }
            cr.iE.post(new Runnable(){

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public void run() {
                    Object object = hA;
                    synchronized (object) {
                        cn.p(cn.j(context));
                        hA.notifyAll();
                        return;
                    }
                }
            });
            while ((string3 = iA) == null) {
                try {
                    hA.wait();
                }
                catch (InterruptedException interruptedException) {
                    return iA;
                }
            }
            return iA = iA + " (Mobile; " + string2 + ")";
        }
    }

    public static void b(WebView webView) {
        if (Build.VERSION.SDK_INT >= 11) {
            co.b(webView);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean h(Context context) {
        boolean bl2;
        Intent intent = new Intent();
        intent.setClassName(context, "com.google.android.gms.ads.AdActivity");
        ResolveInfo resolveInfo = context.getPackageManager().resolveActivity(intent, 65536);
        if (resolveInfo == null || resolveInfo.activityInfo == null) {
            cs.v("Could not find com.google.android.gms.ads.AdActivity, please make sure it is declared in AndroidManifest.xml.");
            return false;
        }
        if ((0x10 & resolveInfo.activityInfo.configChanges) == 0) {
            cs.v(String.format("com.google.android.gms.ads.AdActivity requires the android:configChanges value to contain \"%s\".", "keyboard"));
            bl2 = false;
        } else {
            bl2 = true;
        }
        if ((0x20 & resolveInfo.activityInfo.configChanges) == 0) {
            cs.v(String.format("com.google.android.gms.ads.AdActivity requires the android:configChanges value to contain \"%s\".", "keyboardHidden"));
            bl2 = false;
        }
        if ((0x80 & resolveInfo.activityInfo.configChanges) == 0) {
            cs.v(String.format("com.google.android.gms.ads.AdActivity requires the android:configChanges value to contain \"%s\".", "orientation"));
            bl2 = false;
        }
        if ((0x100 & resolveInfo.activityInfo.configChanges) == 0) {
            cs.v(String.format("com.google.android.gms.ads.AdActivity requires the android:configChanges value to contain \"%s\".", "screenLayout"));
            bl2 = false;
        }
        if ((0x200 & resolveInfo.activityInfo.configChanges) == 0) {
            cs.v(String.format("com.google.android.gms.ads.AdActivity requires the android:configChanges value to contain \"%s\".", "uiMode"));
            bl2 = false;
        }
        if ((0x400 & resolveInfo.activityInfo.configChanges) == 0) {
            cs.v(String.format("com.google.android.gms.ads.AdActivity requires the android:configChanges value to contain \"%s\".", "screenSize"));
            bl2 = false;
        }
        if ((0x800 & resolveInfo.activityInfo.configChanges) == 0) {
            cs.v(String.format("com.google.android.gms.ads.AdActivity requires the android:configChanges value to contain \"%s\".", "smallestScreenSize"));
            return false;
        }
        return bl2;
    }

    public static void i(Context context) {
        if (iB) {
            return;
        }
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.USER_PRESENT");
        intentFilter.addAction("android.intent.action.SCREEN_OFF");
        context.getApplicationContext().registerReceiver((BroadcastReceiver)new a(), intentFilter);
        iB = true;
    }

    private static String j(Context context) {
        return new WebView(context).getSettings().getUserAgentString();
    }

    static /* synthetic */ boolean k(boolean bl2) {
        iz = bl2;
        return bl2;
    }

    public static JSONObject m(Map<String, ?> map) throws JSONException {
        JSONObject jSONObject;
        try {
            jSONObject = new JSONObject();
            for (String string2 : map.keySet()) {
                cn.a(jSONObject, string2, map.get(string2));
            }
        }
        catch (ClassCastException classCastException) {
            throw new JSONException("Could not convert map to JSON: " + classCastException.getMessage());
        }
        return jSONObject;
    }

    public static String o(String string2) {
        return Uri.parse((String)string2).buildUpon().query(null).build().toString();
    }

    static /* synthetic */ String p(String string2) {
        iA = string2;
        return string2;
    }

    private static final class a
    extends BroadcastReceiver {
        private a() {
        }

        /*
         * Enabled aggressive block sorting
         */
        public void onReceive(Context context, Intent intent) {
            if ("android.intent.action.USER_PRESENT".equals(intent.getAction())) {
                cn.k(true);
                return;
            } else {
                if (!"android.intent.action.SCREEN_OFF".equals(intent.getAction())) return;
                cn.k(false);
                return;
            }
        }
    }
}

