/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.res.TypedArray;
import android.text.TextUtils;
import android.util.AttributeSet;
import com.google.android.gms.R;
import com.google.android.gms.ads.AdSize;

public final class aa {
    private final AdSize[] eJ;
    private final String eK;

    /*
     * Enabled aggressive block sorting
     */
    public aa(Context context, AttributeSet attributeSet) {
        int n2 = 1;
        TypedArray typedArray = context.getResources().obtainAttributes(attributeSet, R.styleable.AdsAttrs);
        String string2 = typedArray.getString(0);
        String string3 = typedArray.getString(n2);
        int n3 = !TextUtils.isEmpty((CharSequence)string2) ? n2 : 0;
        if (TextUtils.isEmpty((CharSequence)string3)) {
            n2 = 0;
        }
        if (n3 != 0 && n2 == 0) {
            this.eJ = aa.f(string2);
        } else {
            if (n3 != 0 || n2 == 0) {
                if (n3 == 0 || n2 == 0) throw new IllegalArgumentException("Required XML attribute \"adSize\" was missing.");
                throw new IllegalArgumentException("Either XML attribute \"adSize\" or XML attribute \"supportedAdSizes\" should be specified, but not both.");
            }
            this.eJ = aa.f(string3);
        }
        this.eK = typedArray.getString(2);
        if (!TextUtils.isEmpty((CharSequence)this.eK)) return;
        throw new IllegalArgumentException("Required XML attribute \"adUnitId\" was missing.");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static AdSize[] f(String string2) {
        String[] stringArray = string2.split("\\s*,\\s*");
        AdSize[] adSizeArray = new AdSize[stringArray.length];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String string3 = stringArray[i2].trim();
            if (string3.matches("^(\\d+|FULL_WIDTH)\\s*[xX]\\s*(\\d+|AUTO_HEIGHT)$")) {
                int n2;
                int n3;
                String[] stringArray2 = string3.split("[xX]");
                stringArray2[0] = stringArray2[0].trim();
                stringArray2[1] = stringArray2[1].trim();
                try {
                    n3 = "FULL_WIDTH".equals(stringArray2[0]) ? -1 : Integer.parseInt(stringArray2[0]);
                    boolean bl2 = "AUTO_HEIGHT".equals(stringArray2[1]);
                    if (!bl2) {
                        int n4;
                        n2 = n4 = Integer.parseInt(stringArray2[1]);
                    }
                    n2 = -2;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException("Could not parse XML attribute \"adSize\": " + string3);
                }
                adSizeArray[i2] = new AdSize(n3, n2);
                continue;
            }
            if ("BANNER".equals(string3)) {
                adSizeArray[i2] = AdSize.BANNER;
                continue;
            }
            if ("FULL_BANNER".equals(string3)) {
                adSizeArray[i2] = AdSize.FULL_BANNER;
                continue;
            }
            if ("LEADERBOARD".equals(string3)) {
                adSizeArray[i2] = AdSize.LEADERBOARD;
                continue;
            }
            if ("MEDIUM_RECTANGLE".equals(string3)) {
                adSizeArray[i2] = AdSize.MEDIUM_RECTANGLE;
                continue;
            }
            if ("SMART_BANNER".equals(string3)) {
                adSizeArray[i2] = AdSize.SMART_BANNER;
                continue;
            }
            if (!"WIDE_SKYSCRAPER".equals(string3)) {
                throw new IllegalArgumentException("Could not parse XML attribute \"adSize\": " + string3);
            }
            adSizeArray[i2] = AdSize.WIDE_SKYSCRAPER;
        }
        if (adSizeArray.length == 0) {
            throw new IllegalArgumentException("Could not parse XML attribute \"adSize\": " + string2);
        }
        return adSizeArray;
    }

    public AdSize[] c(boolean bl2) {
        if (!bl2 && this.eJ.length != 1) {
            throw new IllegalArgumentException("The adSizes XML attribute is only allowed on PublisherAdViews.");
        }
        return this.eJ;
    }

    public String getAdUnitId() {
        return this.eK;
    }
}

