/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer.turnbased;

import android.os.Bundle;
import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.multiplayer.Participant;
import com.google.android.gms.games.multiplayer.ParticipantEntity;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatch;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatchEntityCreator;
import com.google.android.gms.internal.ds;
import java.util.ArrayList;

public final class TurnBasedMatchEntity
implements SafeParcelable,
TurnBasedMatch {
    public static final TurnBasedMatchEntityCreator CREATOR = new TurnBasedMatchEntityCreator();
    private final int kZ;
    private final String ri;
    private final Bundle sO;
    private final String sS;
    private final GameEntity sq;
    private final long sr;
    private final ArrayList<ParticipantEntity> su;
    private final int sv;
    private final String tb;
    private final long tc;
    private final String td;
    private final int te;
    private final int tf;
    private final byte[] tg;
    private final String th;
    private final byte[] ti;
    private final int tj;
    private final int tk;
    private final boolean tl;

    TurnBasedMatchEntity(int n2, GameEntity gameEntity, String string2, String string3, long l2, String string4, long l3, String string5, int n3, int n4, int n5, byte[] byArray, ArrayList<ParticipantEntity> arrayList, String string6, byte[] byArray2, int n6, Bundle bundle, int n7, boolean bl2) {
        this.kZ = n2;
        this.sq = gameEntity;
        this.ri = string2;
        this.sS = string3;
        this.sr = l2;
        this.tb = string4;
        this.tc = l3;
        this.td = string5;
        this.te = n3;
        this.tk = n7;
        this.sv = n4;
        this.tf = n5;
        this.tg = byArray;
        this.su = arrayList;
        this.th = string6;
        this.ti = byArray2;
        this.tj = n6;
        this.sO = bundle;
        this.tl = bl2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public TurnBasedMatchEntity(TurnBasedMatch turnBasedMatch) {
        byte[] byArray;
        this.kZ = 2;
        this.sq = new GameEntity(turnBasedMatch.getGame());
        this.ri = turnBasedMatch.getMatchId();
        this.sS = turnBasedMatch.getCreatorId();
        this.sr = turnBasedMatch.getCreationTimestamp();
        this.tb = turnBasedMatch.getLastUpdaterId();
        this.tc = turnBasedMatch.getLastUpdatedTimestamp();
        this.td = turnBasedMatch.getPendingParticipantId();
        this.te = turnBasedMatch.getStatus();
        this.tk = turnBasedMatch.getTurnStatus();
        this.sv = turnBasedMatch.getVariant();
        this.tf = turnBasedMatch.getVersion();
        this.th = turnBasedMatch.getRematchId();
        this.tj = turnBasedMatch.getMatchNumber();
        this.sO = turnBasedMatch.getAutoMatchCriteria();
        this.tl = turnBasedMatch.isLocallyModified();
        byte[] byArray2 = turnBasedMatch.getData();
        if (byArray2 == null) {
            this.tg = null;
        } else {
            this.tg = new byte[byArray2.length];
            System.arraycopy(byArray2, 0, this.tg, 0, byArray2.length);
        }
        if ((byArray = turnBasedMatch.getPreviousMatchData()) == null) {
            this.ti = null;
        } else {
            this.ti = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.ti, 0, byArray.length);
        }
        ArrayList arrayList = turnBasedMatch.getParticipants();
        int n2 = arrayList.size();
        this.su = new ArrayList(n2);
        int n3 = 0;
        while (n3 < n2) {
            this.su.add((ParticipantEntity)((Participant)arrayList.get(n3)).freeze());
            ++n3;
        }
        return;
    }

    static int a(TurnBasedMatch turnBasedMatch) {
        Object[] objectArray = new Object[]{turnBasedMatch.getGame(), turnBasedMatch.getMatchId(), turnBasedMatch.getCreatorId(), turnBasedMatch.getCreationTimestamp(), turnBasedMatch.getLastUpdaterId(), turnBasedMatch.getLastUpdatedTimestamp(), turnBasedMatch.getPendingParticipantId(), turnBasedMatch.getStatus(), turnBasedMatch.getTurnStatus(), turnBasedMatch.getVariant(), turnBasedMatch.getVersion(), turnBasedMatch.getParticipants(), turnBasedMatch.getRematchId(), turnBasedMatch.getMatchNumber(), turnBasedMatch.getAutoMatchCriteria(), turnBasedMatch.getAvailableAutoMatchSlots(), turnBasedMatch.isLocallyModified()};
        return ds.hashCode(objectArray);
    }

    static int a(TurnBasedMatch turnBasedMatch, String string2) {
        ArrayList arrayList = turnBasedMatch.getParticipants();
        int n2 = arrayList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Participant participant = (Participant)arrayList.get(i2);
            if (!participant.getParticipantId().equals(string2)) continue;
            return participant.getStatus();
        }
        throw new IllegalStateException("Participant " + string2 + " is not in match " + turnBasedMatch.getMatchId());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static boolean a(TurnBasedMatch turnBasedMatch, Object object) {
        boolean bl2 = true;
        if (!(object instanceof TurnBasedMatch)) {
            return false;
        }
        if (turnBasedMatch == object) return bl2;
        TurnBasedMatch turnBasedMatch2 = (TurnBasedMatch)object;
        if (!ds.equal(turnBasedMatch2.getGame(), turnBasedMatch.getGame())) return false;
        if (!ds.equal(turnBasedMatch2.getMatchId(), turnBasedMatch.getMatchId())) return false;
        if (!ds.equal(turnBasedMatch2.getCreatorId(), turnBasedMatch.getCreatorId())) return false;
        if (!ds.equal(turnBasedMatch2.getCreationTimestamp(), turnBasedMatch.getCreationTimestamp())) return false;
        if (!ds.equal(turnBasedMatch2.getLastUpdaterId(), turnBasedMatch.getLastUpdaterId())) return false;
        if (!ds.equal(turnBasedMatch2.getLastUpdatedTimestamp(), turnBasedMatch.getLastUpdatedTimestamp())) return false;
        if (!ds.equal(turnBasedMatch2.getPendingParticipantId(), turnBasedMatch.getPendingParticipantId())) return false;
        if (!ds.equal(turnBasedMatch2.getStatus(), turnBasedMatch.getStatus())) return false;
        if (!ds.equal(turnBasedMatch2.getTurnStatus(), turnBasedMatch.getTurnStatus())) return false;
        if (!ds.equal(turnBasedMatch2.getVariant(), turnBasedMatch.getVariant())) return false;
        if (!ds.equal(turnBasedMatch2.getVersion(), turnBasedMatch.getVersion())) return false;
        if (!ds.equal(turnBasedMatch2.getParticipants(), turnBasedMatch.getParticipants())) return false;
        if (!ds.equal(turnBasedMatch2.getRematchId(), turnBasedMatch.getRematchId())) return false;
        if (!ds.equal(turnBasedMatch2.getMatchNumber(), turnBasedMatch.getMatchNumber())) return false;
        if (!ds.equal(turnBasedMatch2.getAutoMatchCriteria(), turnBasedMatch.getAutoMatchCriteria())) return false;
        if (!ds.equal(turnBasedMatch2.getAvailableAutoMatchSlots(), turnBasedMatch.getAvailableAutoMatchSlots())) return false;
        if (ds.equal(turnBasedMatch2.isLocallyModified(), turnBasedMatch.isLocallyModified())) return bl2;
        return false;
    }

    static String b(TurnBasedMatch turnBasedMatch) {
        return ds.e(turnBasedMatch).a("Game", turnBasedMatch.getGame()).a("MatchId", turnBasedMatch.getMatchId()).a("CreatorId", turnBasedMatch.getCreatorId()).a("CreationTimestamp", turnBasedMatch.getCreationTimestamp()).a("LastUpdaterId", turnBasedMatch.getLastUpdaterId()).a("LastUpdatedTimestamp", turnBasedMatch.getLastUpdatedTimestamp()).a("PendingParticipantId", turnBasedMatch.getPendingParticipantId()).a("MatchStatus", turnBasedMatch.getStatus()).a("TurnStatus", turnBasedMatch.getTurnStatus()).a("Variant", turnBasedMatch.getVariant()).a("Data", turnBasedMatch.getData()).a("Version", turnBasedMatch.getVersion()).a("Participants", turnBasedMatch.getParticipants()).a("RematchId", turnBasedMatch.getRematchId()).a("PreviousData", turnBasedMatch.getPreviousMatchData()).a("MatchNumber", turnBasedMatch.getMatchNumber()).a("AutoMatchCriteria", turnBasedMatch.getAutoMatchCriteria()).a("AvailableAutoMatchSlots", turnBasedMatch.getAvailableAutoMatchSlots()).a("LocallyModified", turnBasedMatch.isLocallyModified()).toString();
    }

    static String b(TurnBasedMatch turnBasedMatch, String string2) {
        ArrayList arrayList = turnBasedMatch.getParticipants();
        int n2 = arrayList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Participant participant = (Participant)arrayList.get(i2);
            Player player = participant.getPlayer();
            if (player == null || !player.getPlayerId().equals(string2)) continue;
            return participant.getParticipantId();
        }
        return null;
    }

    static Participant c(TurnBasedMatch turnBasedMatch, String string2) {
        ArrayList arrayList = turnBasedMatch.getParticipants();
        int n2 = arrayList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Participant participant = (Participant)arrayList.get(i2);
            if (!participant.getParticipantId().equals(string2)) continue;
            return participant;
        }
        throw new IllegalStateException("Participant " + string2 + " is not in match " + turnBasedMatch.getMatchId());
    }

    static ArrayList<String> c(TurnBasedMatch turnBasedMatch) {
        ArrayList arrayList = turnBasedMatch.getParticipants();
        int n2 = arrayList.size();
        ArrayList<String> arrayList2 = new ArrayList<String>(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            arrayList2.add(((Participant)arrayList.get(i2)).getParticipantId());
        }
        return arrayList2;
    }

    @Override
    public boolean canRematch() {
        return this.te == 2 && this.th == null;
    }

    public int describeContents() {
        return 0;
    }

    public boolean equals(Object object) {
        return TurnBasedMatchEntity.a((TurnBasedMatch)this, object);
    }

    @Override
    public TurnBasedMatch freeze() {
        return this;
    }

    @Override
    public Bundle getAutoMatchCriteria() {
        return this.sO;
    }

    @Override
    public int getAvailableAutoMatchSlots() {
        if (this.sO == null) {
            return 0;
        }
        return this.sO.getInt("max_automatch_players");
    }

    @Override
    public long getCreationTimestamp() {
        return this.sr;
    }

    @Override
    public String getCreatorId() {
        return this.sS;
    }

    @Override
    public byte[] getData() {
        return this.tg;
    }

    @Override
    public Game getGame() {
        return this.sq;
    }

    @Override
    public long getLastUpdatedTimestamp() {
        return this.tc;
    }

    @Override
    public String getLastUpdaterId() {
        return this.tb;
    }

    @Override
    public String getMatchId() {
        return this.ri;
    }

    @Override
    public int getMatchNumber() {
        return this.tj;
    }

    @Override
    public Participant getParticipant(String string2) {
        return TurnBasedMatchEntity.c(this, string2);
    }

    @Override
    public String getParticipantId(String string2) {
        return TurnBasedMatchEntity.b(this, string2);
    }

    @Override
    public ArrayList<String> getParticipantIds() {
        return TurnBasedMatchEntity.c(this);
    }

    @Override
    public int getParticipantStatus(String string2) {
        return TurnBasedMatchEntity.a((TurnBasedMatch)this, string2);
    }

    @Override
    public ArrayList<Participant> getParticipants() {
        return new ArrayList<Participant>(this.su);
    }

    @Override
    public String getPendingParticipantId() {
        return this.td;
    }

    @Override
    public byte[] getPreviousMatchData() {
        return this.ti;
    }

    @Override
    public String getRematchId() {
        return this.th;
    }

    @Override
    public int getStatus() {
        return this.te;
    }

    @Override
    public int getTurnStatus() {
        return this.tk;
    }

    @Override
    public int getVariant() {
        return this.sv;
    }

    @Override
    public int getVersion() {
        return this.tf;
    }

    public int getVersionCode() {
        return this.kZ;
    }

    public int hashCode() {
        return TurnBasedMatchEntity.a(this);
    }

    @Override
    public boolean isDataValid() {
        return true;
    }

    @Override
    public boolean isLocallyModified() {
        return this.tl;
    }

    public String toString() {
        return TurnBasedMatchEntity.b(this);
    }

    public void writeToParcel(Parcel parcel, int n2) {
        TurnBasedMatchEntityCreator.a(this, parcel, n2);
    }
}

