/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer.realtime;

import android.database.CharArrayBuffer;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.multiplayer.Participant;
import com.google.android.gms.games.multiplayer.ParticipantEntity;
import com.google.android.gms.games.multiplayer.realtime.Room;
import com.google.android.gms.games.multiplayer.realtime.c;
import com.google.android.gms.internal.ds;
import com.google.android.gms.internal.eo;
import com.google.android.gms.internal.ey;
import java.util.ArrayList;

public final class RoomEntity
extends ey
implements Room {
    public static final Parcelable.Creator<RoomEntity> CREATOR = new a();
    private final int kZ;
    private final String pZ;
    private final String rh;
    private final Bundle sO;
    private final String sS;
    private final int sT;
    private final int sU;
    private final long sr;
    private final ArrayList<ParticipantEntity> su;
    private final int sv;

    RoomEntity(int n2, String string2, String string3, long l2, int n3, String string4, int n4, Bundle bundle, ArrayList<ParticipantEntity> arrayList, int n5) {
        this.kZ = n2;
        this.rh = string2;
        this.sS = string3;
        this.sr = l2;
        this.sT = n3;
        this.pZ = string4;
        this.sv = n4;
        this.sO = bundle;
        this.su = arrayList;
        this.sU = n5;
    }

    public RoomEntity(Room room) {
        this.kZ = 2;
        this.rh = room.getRoomId();
        this.sS = room.getCreatorId();
        this.sr = room.getCreationTimestamp();
        this.sT = room.getStatus();
        this.pZ = room.getDescription();
        this.sv = room.getVariant();
        this.sO = room.getAutoMatchCriteria();
        ArrayList arrayList = room.getParticipants();
        int n2 = arrayList.size();
        this.su = new ArrayList(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            this.su.add((ParticipantEntity)((Participant)arrayList.get(i2)).freeze());
        }
        this.sU = room.getAutoMatchWaitEstimateSeconds();
    }

    static int a(Room room) {
        Object[] objectArray = new Object[]{room.getRoomId(), room.getCreatorId(), room.getCreationTimestamp(), room.getStatus(), room.getDescription(), room.getVariant(), room.getAutoMatchCriteria(), room.getParticipants(), room.getAutoMatchWaitEstimateSeconds()};
        return ds.hashCode(objectArray);
    }

    static int a(Room room, String string2) {
        ArrayList arrayList = room.getParticipants();
        int n2 = arrayList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Participant participant = (Participant)arrayList.get(i2);
            if (!participant.getParticipantId().equals(string2)) continue;
            return participant.getStatus();
        }
        throw new IllegalStateException("Participant " + string2 + " is not in room " + room.getRoomId());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static boolean a(Room room, Object object) {
        boolean bl2 = true;
        if (!(object instanceof Room)) {
            return false;
        }
        if (room == object) return bl2;
        Room room2 = (Room)object;
        if (!ds.equal(room2.getRoomId(), room.getRoomId())) return false;
        if (!ds.equal(room2.getCreatorId(), room.getCreatorId())) return false;
        if (!ds.equal(room2.getCreationTimestamp(), room.getCreationTimestamp())) return false;
        if (!ds.equal(room2.getStatus(), room.getStatus())) return false;
        if (!ds.equal(room2.getDescription(), room.getDescription())) return false;
        if (!ds.equal(room2.getVariant(), room.getVariant())) return false;
        if (!ds.equal(room2.getAutoMatchCriteria(), room.getAutoMatchCriteria())) return false;
        if (!ds.equal(room2.getParticipants(), room.getParticipants())) return false;
        if (ds.equal(room2.getAutoMatchWaitEstimateSeconds(), room.getAutoMatchWaitEstimateSeconds())) return bl2;
        return false;
    }

    static String b(Room room) {
        return ds.e(room).a("RoomId", room.getRoomId()).a("CreatorId", room.getCreatorId()).a("CreationTimestamp", room.getCreationTimestamp()).a("RoomStatus", room.getStatus()).a("Description", room.getDescription()).a("Variant", room.getVariant()).a("AutoMatchCriteria", room.getAutoMatchCriteria()).a("Participants", room.getParticipants()).a("AutoMatchWaitEstimateSeconds", room.getAutoMatchWaitEstimateSeconds()).toString();
    }

    static String b(Room room, String string2) {
        ArrayList arrayList = room.getParticipants();
        int n2 = arrayList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Participant participant = (Participant)arrayList.get(i2);
            Player player = participant.getPlayer();
            if (player == null || !player.getPlayerId().equals(string2)) continue;
            return participant.getParticipantId();
        }
        return null;
    }

    static Participant c(Room room, String string2) {
        ArrayList arrayList = room.getParticipants();
        int n2 = arrayList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Participant participant = (Participant)arrayList.get(i2);
            if (!participant.getParticipantId().equals(string2)) continue;
            return participant;
        }
        throw new IllegalStateException("Participant " + string2 + " is not in match " + room.getRoomId());
    }

    static ArrayList<String> c(Room room) {
        ArrayList arrayList = room.getParticipants();
        int n2 = arrayList.size();
        ArrayList<String> arrayList2 = new ArrayList<String>(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            arrayList2.add(((Participant)arrayList.get(i2)).getParticipantId());
        }
        return arrayList2;
    }

    public int describeContents() {
        return 0;
    }

    public boolean equals(Object object) {
        return RoomEntity.a((Room)this, object);
    }

    @Override
    public Room freeze() {
        return this;
    }

    @Override
    public Bundle getAutoMatchCriteria() {
        return this.sO;
    }

    @Override
    public int getAutoMatchWaitEstimateSeconds() {
        return this.sU;
    }

    @Override
    public long getCreationTimestamp() {
        return this.sr;
    }

    @Override
    public String getCreatorId() {
        return this.sS;
    }

    @Override
    public String getDescription() {
        return this.pZ;
    }

    @Override
    public void getDescription(CharArrayBuffer charArrayBuffer) {
        eo.b(this.pZ, charArrayBuffer);
    }

    @Override
    public Participant getParticipant(String string2) {
        return RoomEntity.c(this, string2);
    }

    @Override
    public String getParticipantId(String string2) {
        return RoomEntity.b(this, string2);
    }

    @Override
    public ArrayList<String> getParticipantIds() {
        return RoomEntity.c(this);
    }

    @Override
    public int getParticipantStatus(String string2) {
        return RoomEntity.a((Room)this, string2);
    }

    @Override
    public ArrayList<Participant> getParticipants() {
        return new ArrayList<Participant>(this.su);
    }

    @Override
    public String getRoomId() {
        return this.rh;
    }

    @Override
    public int getStatus() {
        return this.sT;
    }

    @Override
    public int getVariant() {
        return this.sv;
    }

    public int getVersionCode() {
        return this.kZ;
    }

    public int hashCode() {
        return RoomEntity.a(this);
    }

    @Override
    public boolean isDataValid() {
        return true;
    }

    public String toString() {
        return RoomEntity.b(this);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void writeToParcel(Parcel parcel, int n2) {
        if (!this.bz()) {
            c.a(this, parcel, n2);
            return;
        } else {
            parcel.writeString(this.rh);
            parcel.writeString(this.sS);
            parcel.writeLong(this.sr);
            parcel.writeInt(this.sT);
            parcel.writeString(this.pZ);
            parcel.writeInt(this.sv);
            parcel.writeBundle(this.sO);
            int n3 = this.su.size();
            parcel.writeInt(n3);
            for (int i2 = 0; i2 < n3; ++i2) {
                this.su.get(i2).writeToParcel(parcel, n2);
            }
        }
    }

    static final class a
    extends c {
        a() {
        }

        @Override
        public RoomEntity Z(Parcel parcel) {
            if (RoomEntity.c(RoomEntity.by()) || RoomEntity.D(RoomEntity.class.getCanonicalName())) {
                return super.Z(parcel);
            }
            String string2 = parcel.readString();
            String string3 = parcel.readString();
            long l2 = parcel.readLong();
            int n2 = parcel.readInt();
            String string4 = parcel.readString();
            int n3 = parcel.readInt();
            Bundle bundle = parcel.readBundle();
            int n4 = parcel.readInt();
            ArrayList<ParticipantEntity> arrayList = new ArrayList<ParticipantEntity>(n4);
            for (int i2 = 0; i2 < n4; ++i2) {
                arrayList.add((ParticipantEntity)ParticipantEntity.CREATOR.createFromParcel(parcel));
            }
            return new RoomEntity(2, string2, string3, l2, n2, string4, n3, bundle, arrayList, -1);
        }

        @Override
        public /* synthetic */ Object createFromParcel(Parcel parcel) {
            return this.Z(parcel);
        }
    }
}

