/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.multiplayer.Participant;
import com.google.android.gms.games.multiplayer.ParticipantResult;
import com.google.android.gms.games.multiplayer.d;
import com.google.android.gms.internal.ds;
import com.google.android.gms.internal.eo;
import com.google.android.gms.internal.ey;

public final class ParticipantEntity
extends ey
implements Participant {
    public static final Parcelable.Creator<ParticipantEntity> CREATOR = new a();
    private final int kZ;
    private final String pW;
    private final Uri qb;
    private final Uri qc;
    private final String rm;
    private final boolean sA;
    private final PlayerEntity sB;
    private final int sC;
    private final ParticipantResult sD;
    private final int sy;
    private final String sz;

    ParticipantEntity(int n2, String string2, String string3, Uri uri, Uri uri2, int n3, String string4, boolean bl2, PlayerEntity playerEntity, int n4, ParticipantResult participantResult) {
        this.kZ = n2;
        this.rm = string2;
        this.pW = string3;
        this.qb = uri;
        this.qc = uri2;
        this.sy = n3;
        this.sz = string4;
        this.sA = bl2;
        this.sB = playerEntity;
        this.sC = n4;
        this.sD = participantResult;
    }

    /*
     * Enabled aggressive block sorting
     */
    public ParticipantEntity(Participant participant) {
        this.kZ = 2;
        this.rm = participant.getParticipantId();
        this.pW = participant.getDisplayName();
        this.qb = participant.getIconImageUri();
        this.qc = participant.getHiResImageUri();
        this.sy = participant.getStatus();
        this.sz = participant.dm();
        this.sA = participant.isConnectedToRoom();
        Player player = participant.getPlayer();
        PlayerEntity playerEntity = player == null ? null : new PlayerEntity(player);
        this.sB = playerEntity;
        this.sC = participant.getCapabilities();
        this.sD = participant.getResult();
    }

    static int a(Participant participant) {
        Object[] objectArray = new Object[]{participant.getPlayer(), participant.getStatus(), participant.dm(), participant.isConnectedToRoom(), participant.getDisplayName(), participant.getIconImageUri(), participant.getHiResImageUri(), participant.getCapabilities(), participant.getResult()};
        return ds.hashCode(objectArray);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static boolean a(Participant participant, Object object) {
        boolean bl2 = true;
        if (!(object instanceof Participant)) {
            return false;
        }
        if (participant == object) return bl2;
        Participant participant2 = (Participant)object;
        if (!ds.equal(participant2.getPlayer(), participant.getPlayer())) return false;
        if (!ds.equal(participant2.getStatus(), participant.getStatus())) return false;
        if (!ds.equal(participant2.dm(), participant.dm())) return false;
        if (!ds.equal(participant2.isConnectedToRoom(), participant.isConnectedToRoom())) return false;
        if (!ds.equal(participant2.getDisplayName(), participant.getDisplayName())) return false;
        if (!ds.equal(participant2.getIconImageUri(), participant.getIconImageUri())) return false;
        if (!ds.equal(participant2.getHiResImageUri(), participant.getHiResImageUri())) return false;
        if (!ds.equal(participant2.getCapabilities(), participant.getCapabilities())) return false;
        if (ds.equal(participant2.getResult(), participant.getResult())) return bl2;
        return false;
    }

    static String b(Participant participant) {
        return ds.e(participant).a("Player", participant.getPlayer()).a("Status", participant.getStatus()).a("ClientAddress", participant.dm()).a("ConnectedToRoom", participant.isConnectedToRoom()).a("DisplayName", participant.getDisplayName()).a("IconImage", participant.getIconImageUri()).a("HiResImage", participant.getHiResImageUri()).a("Capabilities", participant.getCapabilities()).a("Result", participant.getResult()).toString();
    }

    public int describeContents() {
        return 0;
    }

    @Override
    public String dm() {
        return this.sz;
    }

    public boolean equals(Object object) {
        return ParticipantEntity.a(this, object);
    }

    @Override
    public Participant freeze() {
        return this;
    }

    @Override
    public int getCapabilities() {
        return this.sC;
    }

    @Override
    public String getDisplayName() {
        if (this.sB == null) {
            return this.pW;
        }
        return this.sB.getDisplayName();
    }

    @Override
    public void getDisplayName(CharArrayBuffer charArrayBuffer) {
        if (this.sB == null) {
            eo.b(this.pW, charArrayBuffer);
            return;
        }
        this.sB.getDisplayName(charArrayBuffer);
    }

    @Override
    public Uri getHiResImageUri() {
        if (this.sB == null) {
            return this.qc;
        }
        return this.sB.getHiResImageUri();
    }

    @Override
    public Uri getIconImageUri() {
        if (this.sB == null) {
            return this.qb;
        }
        return this.sB.getIconImageUri();
    }

    @Override
    public String getParticipantId() {
        return this.rm;
    }

    @Override
    public Player getPlayer() {
        return this.sB;
    }

    @Override
    public ParticipantResult getResult() {
        return this.sD;
    }

    @Override
    public int getStatus() {
        return this.sy;
    }

    public int getVersionCode() {
        return this.kZ;
    }

    public int hashCode() {
        return ParticipantEntity.a(this);
    }

    @Override
    public boolean isConnectedToRoom() {
        return this.sA;
    }

    @Override
    public boolean isDataValid() {
        return true;
    }

    public String toString() {
        return ParticipantEntity.b(this);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void writeToParcel(Parcel parcel, int n2) {
        if (!this.bz()) {
            d.a(this, parcel, n2);
            return;
        } else {
            parcel.writeString(this.rm);
            parcel.writeString(this.pW);
            String string2 = this.qb == null ? null : this.qb.toString();
            parcel.writeString(string2);
            Uri uri = this.qc;
            String string3 = null;
            if (uri != null) {
                string3 = this.qc.toString();
            }
            parcel.writeString(string3);
            parcel.writeInt(this.sy);
            parcel.writeString(this.sz);
            int n3 = this.sA ? 1 : 0;
            parcel.writeInt(n3);
            PlayerEntity playerEntity = this.sB;
            int n4 = 0;
            if (playerEntity != null) {
                n4 = 1;
            }
            parcel.writeInt(n4);
            if (this.sB == null) return;
            this.sB.writeToParcel(parcel, n2);
            return;
        }
    }

    static final class a
    extends d {
        a() {
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public ParticipantEntity X(Parcel parcel) {
            PlayerEntity playerEntity;
            boolean bl2 = true;
            if (ParticipantEntity.c(ParticipantEntity.by())) return super.X(parcel);
            if (ParticipantEntity.D(ParticipantEntity.class.getCanonicalName())) {
                return super.X(parcel);
            }
            String string2 = parcel.readString();
            String string3 = parcel.readString();
            String string4 = parcel.readString();
            Uri uri = string4 == null ? null : Uri.parse((String)string4);
            String string5 = parcel.readString();
            Uri uri2 = string5 == null ? null : Uri.parse((String)string5);
            int n2 = parcel.readInt();
            String string6 = parcel.readString();
            boolean bl3 = parcel.readInt() > 0 ? bl2 : false;
            if (parcel.readInt() <= 0) {
                bl2 = false;
            }
            if (bl2) {
                playerEntity = (PlayerEntity)PlayerEntity.CREATOR.createFromParcel(parcel);
                return new ParticipantEntity(2, string2, string3, uri, uri2, n2, string6, bl3, playerEntity, 7, null);
            }
            playerEntity = null;
            return new ParticipantEntity(2, string2, string3, uri, uri2, n2, string6, bl3, playerEntity, 7, null);
        }

        @Override
        public /* synthetic */ Object createFromParcel(Parcel parcel) {
            return this.X(parcel);
        }
    }
}

