/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.data;

import android.content.ContentValues;
import android.database.AbstractWindowedCursor;
import android.database.CharArrayBuffer;
import android.database.CursorIndexOutOfBoundsException;
import android.database.CursorWindow;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcel;
import android.util.Log;
import com.google.android.gms.common.data.DataHolderCreator;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.internal.dg;
import com.google.android.gms.internal.ds;
import com.google.android.gms.internal.du;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

public final class DataHolder
implements SafeParcelable {
    public static final DataHolderCreator CREATOR = new DataHolderCreator();
    private static final Builder lp = new Builder(new String[0], null){

        @Override
        public Builder withRow(ContentValues contentValues) {
            throw new UnsupportedOperationException("Cannot add data to empty builder");
        }

        @Override
        public Builder withRow(HashMap<String, Object> hashMap) {
            throw new UnsupportedOperationException("Cannot add data to empty builder");
        }
    };
    private final int kZ;
    private final int ka;
    private final String[] lh;
    Bundle li;
    private final CursorWindow[] lj;
    private final Bundle lk;
    int[] ll;
    int lm;
    private Object ln;
    private boolean lo = true;
    boolean mClosed = false;

    DataHolder(int n2, String[] stringArray, CursorWindow[] cursorWindowArray, int n3, Bundle bundle) {
        this.kZ = n2;
        this.lh = stringArray;
        this.lj = cursorWindowArray;
        this.ka = n3;
        this.lk = bundle;
    }

    public DataHolder(AbstractWindowedCursor abstractWindowedCursor, int n2, Bundle bundle) {
        this(abstractWindowedCursor.getColumnNames(), DataHolder.a(abstractWindowedCursor), n2, bundle);
    }

    private DataHolder(Builder builder, int n2, Bundle bundle) {
        this(builder.lh, DataHolder.a(builder), n2, bundle);
    }

    public DataHolder(String[] stringArray, CursorWindow[] cursorWindowArray, int n2, Bundle bundle) {
        this.kZ = 1;
        this.lh = du.f(stringArray);
        this.lj = du.f(cursorWindowArray);
        this.ka = n2;
        this.lk = bundle;
        this.validateContents();
    }

    private void a(String string2, int n2) {
        if (this.li == null || !this.li.containsKey(string2)) {
            throw new IllegalArgumentException("No such column: " + string2);
        }
        if (this.isClosed()) {
            throw new IllegalArgumentException("Buffer is closed.");
        }
        if (n2 < 0 || n2 >= this.lm) {
            throw new CursorIndexOutOfBoundsException(n2, this.lm);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static CursorWindow[] a(AbstractWindowedCursor abstractWindowedCursor) {
        ArrayList<CursorWindow> arrayList = new ArrayList<CursorWindow>();
        try {
            int n2;
            int n3 = abstractWindowedCursor.getCount();
            CursorWindow cursorWindow = abstractWindowedCursor.getWindow();
            if (cursorWindow != null && cursorWindow.getStartPosition() == 0) {
                cursorWindow.acquireReference();
                abstractWindowedCursor.setWindow(null);
                arrayList.add(cursorWindow);
                n2 = cursorWindow.getNumRows();
            } else {
                n2 = 0;
            }
            while (n2 < n3 && abstractWindowedCursor.moveToPosition(n2)) {
                int n4;
                CursorWindow cursorWindow2 = abstractWindowedCursor.getWindow();
                if (cursorWindow2 != null) {
                    cursorWindow2.acquireReference();
                    abstractWindowedCursor.setWindow(null);
                } else {
                    cursorWindow2 = new CursorWindow(false);
                    abstractWindowedCursor.fillWindow(n2, cursorWindow2);
                }
                if ((n4 = cursorWindow2.getNumRows()) == 0) return arrayList.toArray(new CursorWindow[arrayList.size()]);
                arrayList.add(cursorWindow2);
                int n5 = cursorWindow2.getStartPosition();
                int n6 = cursorWindow2.getNumRows();
                n2 = n6 + n5;
            }
            return arrayList.toArray(new CursorWindow[arrayList.size()]);
        }
        finally {
            abstractWindowedCursor.close();
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static CursorWindow[] a(Builder var0) {
        var1_1 = 0;
        if (Builder.b(var0).length == 0) {
            return new CursorWindow[0];
        }
        var2_2 = Builder.c(var0);
        var3_3 = var2_2.size();
        var4_4 = new CursorWindow(false);
        var5_5 = new ArrayList<CursorWindow>();
        var5_5.add(var4_4);
        var4_4.setNumColumns(Builder.b(var0).length);
        var8_6 = 0;
        var9_7 = 0;
        block3: while (true) {
            block20: {
                if (var8_6 >= var3_3) {
                    return var5_5.toArray(new CursorWindow[var5_5.size()]);
                }
                try {
                    if (var4_4.allocRow()) {
                        var12_8 = var9_7;
                    } else {
                        Log.d((String)"DataHolder", (String)("Allocating additional cursor window for large data set (row " + var8_6 + ")"));
                        var4_4 = new CursorWindow(false);
                        var4_4.setNumColumns(Builder.b(var0).length);
                        var5_5.add(var4_4);
                        if (!var4_4.allocRow()) {
                            Log.e((String)"DataHolder", (String)"Unable to allocate row to hold data.");
                            var5_5.remove(var4_4);
                            return var5_5.toArray(new CursorWindow[var5_5.size()]);
                        }
                        var12_8 = 0;
                    }
                    var13_9 = (Map)var2_2.get(var8_6);
                    var14_10 = true;
                    var15_11 = 0;
lbl38:
                    // 2 sources

                    while (true) {
                        if (var15_11 < Builder.b(var0).length && var14_10) {
                            var16_12 = Builder.b(var0)[var15_11];
                            var17_13 = var13_9.get(var16_12);
                            if (var17_13 == null) {
                                var14_10 = var4_4.putNull(var12_8, var15_11);
                                break block3;
                            }
                            if (var17_13 instanceof String) {
                                var14_10 = var4_4.putString((String)var17_13, var12_8, var15_11);
                                break block3;
                            }
                            if (var17_13 instanceof Long) {
                                var14_10 = var4_4.putLong(((Long)var17_13).longValue(), var12_8, var15_11);
                                break block3;
                            }
                            if (var17_13 instanceof Integer) {
                                var14_10 = var4_4.putLong((long)((Integer)var17_13).intValue(), var12_8, var15_11);
                                break block3;
                            }
                            if (var17_13 instanceof Boolean) {
                                var18_14 = (Boolean)var17_13 != false ? 1L : 0L;
                                var14_10 = var4_4.putLong(var18_14, var12_8, var15_11);
                            } else {
                                if (!(var17_13 instanceof byte[])) {
                                    throw new IllegalArgumentException("Unsupported object for column " + var16_12 + ": " + var17_13);
                                }
                                var14_10 = var4_4.putBlob((byte[])var17_13, var12_8, var15_11);
                            }
                            break block3;
                        }
                        if (var14_10) break;
                        Log.d((String)"DataHolder", (String)("Couldn't populate window data for row " + var8_6 + " - allocating new window."));
                        var4_4.freeLastRow();
                        var25_19 = new CursorWindow(false);
                        var25_19.setNumColumns(Builder.b(var0).length);
                        var5_5.add(var25_19);
                        var21_16 = var8_6 - 1;
                        var22_17 = var25_19;
                        var20_15 = 0;
                        break block20;
                        break;
                    }
                }
                catch (RuntimeException var10_20) {
                    var11_21 = var5_5.size();
                    while (var1_1 < var11_21) {
                        ((CursorWindow)var5_5.get(var1_1)).close();
                        ++var1_1;
                    }
                    throw var10_20;
                }
                var20_15 = var12_8 + 1;
                var21_16 = var8_6;
                var22_17 = var4_4;
            }
            var23_18 = var21_16 + 1;
            var4_4 = var22_17;
            var8_6 = var23_18;
            var9_7 = var20_15;
        }
        ++var15_11;
        ** while (true)
    }

    public static Builder builder(String[] stringArray) {
        return new Builder(stringArray, null);
    }

    public static Builder builder(String[] stringArray, String string2) {
        du.f(string2);
        return new Builder(stringArray, string2);
    }

    public static DataHolder empty(int n2) {
        return DataHolder.empty(n2, null);
    }

    public static DataHolder empty(int n2, Bundle bundle) {
        return new DataHolder(lp, n2, bundle);
    }

    String[] bi() {
        return this.lh;
    }

    CursorWindow[] bj() {
        return this.lj;
    }

    public void c(Object object) {
        this.ln = object;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() {
        synchronized (this) {
            if (!this.mClosed) {
                this.mClosed = true;
                for (int i2 = 0; i2 < this.lj.length; ++i2) {
                    this.lj[i2].close();
                }
            }
            return;
        }
    }

    public void copyToBuffer(String string2, int n2, int n3, CharArrayBuffer charArrayBuffer) {
        this.a(string2, n2);
        this.lj[n3].copyStringToBuffer(n2 - this.ll[n3], this.li.getInt(string2), charArrayBuffer);
    }

    public int describeContents() {
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void finalize() throws Throwable {
        try {
            if (this.lo && this.lj.length > 0 && !this.isClosed()) {
                String string2;
                String string3 = this.ln == null ? "internal object: " + this.toString() : (string2 = this.ln.toString());
                Log.e((String)"DataBuffer", (String)("Internal data leak within a DataBuffer object detected!  Be sure to explicitly call close() on all DataBuffer extending objects when you are done with them. (" + string3 + ")"));
                this.close();
            }
            return;
        }
        finally {
            super.finalize();
        }
    }

    public boolean getBoolean(String string2, int n2, int n3) {
        this.a(string2, n2);
        return Long.valueOf(this.lj[n3].getLong(n2 - this.ll[n3], this.li.getInt(string2))) == 1L;
    }

    public byte[] getByteArray(String string2, int n2, int n3) {
        this.a(string2, n2);
        return this.lj[n3].getBlob(n2 - this.ll[n3], this.li.getInt(string2));
    }

    public int getCount() {
        return this.lm;
    }

    public int getInteger(String string2, int n2, int n3) {
        this.a(string2, n2);
        return this.lj[n3].getInt(n2 - this.ll[n3], this.li.getInt(string2));
    }

    public long getLong(String string2, int n2, int n3) {
        this.a(string2, n2);
        return this.lj[n3].getLong(n2 - this.ll[n3], this.li.getInt(string2));
    }

    public Bundle getMetadata() {
        return this.lk;
    }

    public int getStatusCode() {
        return this.ka;
    }

    public String getString(String string2, int n2, int n3) {
        this.a(string2, n2);
        return this.lj[n3].getString(n2 - this.ll[n3], this.li.getInt(string2));
    }

    int getVersionCode() {
        return this.kZ;
    }

    public boolean hasNull(String string2, int n2, int n3) {
        this.a(string2, n2);
        return this.lj[n3].isNull(n2 - this.ll[n3], this.li.getInt(string2));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isClosed() {
        synchronized (this) {
            return this.mClosed;
        }
    }

    public Uri parseUri(String string2, int n2, int n3) {
        String string3 = this.getString(string2, n2, n3);
        if (string3 == null) {
            return null;
        }
        return Uri.parse((String)string3);
    }

    /*
     * Enabled aggressive block sorting
     */
    public int t(int n2) {
        int n3 = 0;
        boolean bl2 = n2 >= 0 && n2 < this.lm;
        du.n(bl2);
        while (true) {
            block6: {
                block5: {
                    if (n3 >= this.ll.length) break block5;
                    if (n2 >= this.ll[n3]) break block6;
                    --n3;
                }
                if (n3 == this.ll.length) {
                    --n3;
                }
                return n3;
            }
            ++n3;
        }
    }

    public void validateContents() {
        int n2 = 0;
        this.li = new Bundle();
        for (int i2 = 0; i2 < this.lh.length; ++i2) {
            this.li.putInt(this.lh[i2], i2);
        }
        this.ll = new int[this.lj.length];
        int n3 = 0;
        while (n2 < this.lj.length) {
            this.ll[n2] = n3;
            n3 += this.lj[n2].getNumRows();
            ++n2;
        }
        this.lm = n3;
    }

    public void writeToParcel(Parcel parcel, int n2) {
        DataHolderCreator.a(this, parcel, n2);
    }

    public static class Builder {
        private final String[] lh;
        private final ArrayList<HashMap<String, Object>> lq;
        private final String lr;
        private final HashMap<Object, Integer> ls;
        private boolean lt;
        private String lu;

        private Builder(String[] stringArray, String string2) {
            this.lh = du.f(stringArray);
            this.lq = new ArrayList();
            this.lr = string2;
            this.ls = new HashMap();
            this.lt = false;
            this.lu = null;
        }

        private void a(HashMap<String, Object> hashMap) {
            Object object = hashMap.get(this.lr);
            if (object == null) {
                return;
            }
            Integer n2 = this.ls.remove(object);
            if (n2 != null) {
                this.lq.remove(n2);
            }
            this.ls.put(object, this.lq.size());
        }

        private void bk() {
            if (this.lr != null) {
                this.ls.clear();
                int n2 = this.lq.size();
                for (int i2 = 0; i2 < n2; ++i2) {
                    Object object = this.lq.get(i2).get(this.lr);
                    if (object == null) continue;
                    this.ls.put(object, i2);
                }
            }
        }

        static /* synthetic */ ArrayList c(Builder builder) {
            return builder.lq;
        }

        public DataHolder build(int n2) {
            return new DataHolder(this, n2, null);
        }

        public DataHolder build(int n2, Bundle bundle) {
            return new DataHolder(this, n2, bundle);
        }

        public int getCount() {
            return this.lq.size();
        }

        public Builder removeRowsWithValue(String string2, Object object) {
            for (int i2 = -1 + this.lq.size(); i2 >= 0; --i2) {
                if (!ds.equal(this.lq.get(i2).get(string2), object)) continue;
                this.lq.remove(i2);
            }
            return this;
        }

        public Builder sort(String string2) {
            dg.d(string2);
            if (this.lt && string2.equals(this.lu)) {
                return this;
            }
            Collections.sort(this.lq, new a(string2));
            this.bk();
            this.lt = true;
            this.lu = string2;
            return this;
        }

        public Builder withRow(ContentValues contentValues) {
            dg.d(contentValues);
            HashMap<String, Object> hashMap = new HashMap<String, Object>(contentValues.size());
            for (Map.Entry entry : contentValues.valueSet()) {
                hashMap.put((String)entry.getKey(), entry.getValue());
            }
            return this.withRow(hashMap);
        }

        public Builder withRow(HashMap<String, Object> hashMap) {
            dg.d(hashMap);
            if (this.lr != null) {
                this.a(hashMap);
            }
            this.lq.add(hashMap);
            this.lt = false;
            return this;
        }
    }

    private static final class a
    implements Comparator<HashMap<String, Object>> {
        private final String lv;

        a(String string2) {
            this.lv = du.f(string2);
        }

        public int a(HashMap<String, Object> hashMap, HashMap<String, Object> hashMap2) {
            Object object;
            Object object2 = du.f(hashMap.get(this.lv));
            if (object2.equals(object = du.f(hashMap2.get(this.lv)))) {
                return 0;
            }
            if (object2 instanceof Boolean) {
                return ((Boolean)object2).compareTo((Boolean)object);
            }
            if (object2 instanceof Long) {
                return ((Long)object2).compareTo((Long)object);
            }
            if (object2 instanceof Integer) {
                return ((Integer)object2).compareTo((Integer)object);
            }
            if (object2 instanceof String) {
                return ((String)object2).compareTo((String)object);
            }
            throw new IllegalArgumentException("Unknown type for lValue " + object2);
        }

        @Override
        public /* synthetic */ int compare(Object object, Object object2) {
            return this.a((HashMap)object, (HashMap)object2);
        }
    }
}

