/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.content.Context;
import android.os.Bundle;
import android.view.View;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GooglePlayServicesClient;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.a;
import com.google.android.gms.internal.dh;
import com.google.android.gms.internal.dl;
import com.google.android.gms.internal.du;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;

public final class GoogleApiClient {
    private final dl kB;
    private final Queue<a<?>> kC;
    private ConnectionResult kD;
    private int kE;
    private int kF = 3;
    private int kG;
    private final Bundle kH;
    private final Map<Api.b<?>, Api.a> kI;
    private boolean kJ;
    private final ConnectionCallbacks kK;
    private final dl.b kL;
    private final Object kt = new Object();

    private GoogleApiClient(Context context, dh dh2, Map<Api, ApiOptions> map, Set<ConnectionCallbacks> set, Set<OnConnectionFailedListener> set2) {
        this.kC = new LinkedList();
        this.kH = new Bundle();
        this.kI = new HashMap();
        this.kK = new ConnectionCallbacks(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void onConnected(Bundle bundle) {
                Object object = GoogleApiClient.this.kt;
                synchronized (object) {
                    if (GoogleApiClient.this.kF == 1) {
                        if (bundle != null) {
                            GoogleApiClient.this.kH.putAll(bundle);
                        }
                        GoogleApiClient.this.aY();
                    }
                    return;
                }
            }

            @Override
            public void onDisconnected() {
                GoogleApiClient.this.ba();
            }
        };
        this.kL = new dl.b(){

            @Override
            public boolean bb() {
                return GoogleApiClient.this.kJ;
            }

            @Override
            public Bundle bc() {
                return null;
            }

            @Override
            public boolean isConnected() {
                return GoogleApiClient.this.isConnected();
            }
        };
        this.kB = new dl(context, this.kL);
        for (ConnectionCallbacks connectionCallbacks : set) {
            this.kB.registerConnectionCallbacks(connectionCallbacks);
        }
        for (OnConnectionFailedListener onConnectionFailedListener : set2) {
            this.kB.registerConnectionFailedListener(onConnectionFailedListener);
        }
        for (Api api : map.keySet()) {
            final Api.b<?> b2 = api.aV();
            ApiOptions apiOptions = map.get(api);
            this.kI.put(b2, (Api.a)b2.b(context, dh2, apiOptions, this.kK, new OnConnectionFailedListener(){

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public void onConnectionFailed(ConnectionResult connectionResult) {
                    Object object = GoogleApiClient.this.kt;
                    synchronized (object) {
                        if (GoogleApiClient.this.kD == null || b2.getPriority() < GoogleApiClient.this.kE) {
                            GoogleApiClient.a(GoogleApiClient.this, connectionResult);
                            GoogleApiClient.a(GoogleApiClient.this, b2.getPriority());
                        }
                        GoogleApiClient.this.aY();
                        return;
                    }
                }
            }));
        }
    }

    static /* synthetic */ int a(GoogleApiClient googleApiClient, int n2) {
        googleApiClient.kE = n2;
        return n2;
    }

    static /* synthetic */ ConnectionResult a(GoogleApiClient googleApiClient, ConnectionResult connectionResult) {
        googleApiClient.kD = connectionResult;
        return connectionResult;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <A extends Api.a> void a(a<A> a2) {
        Object object = this.kt;
        synchronized (object) {
            du.a(this.isConnected(), "GoogleApiClient is not connected yet.");
            boolean bl2 = a2.aV() != null;
            du.a(bl2, "This task can not be executed or enqueued (it's probably a Batch or malformed)");
            a2.a(this.a((a.a)((Object)a2.aV())));
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void aY() {
        Object object = this.kt;
        synchronized (object) {
            this.kG = -1 + this.kG;
            if (this.kG == 0) {
                if (this.kD != null) {
                    this.kF = 3;
                    Iterator<Api.a> iterator = this.kI.values().iterator();
                    while (iterator.hasNext()) {
                        iterator.next().disconnect();
                    }
                    this.kB.a(this.kD);
                } else {
                    this.kF = 2;
                    Bundle bundle = this.kH.isEmpty() ? null : this.kH;
                    this.kB.b(bundle);
                    this.aZ();
                }
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void aZ() {
        du.a(this.isConnected(), "GoogleApiClient is not connected yet.");
        Object object = this.kt;
        synchronized (object) {
            while (!this.kC.isEmpty()) {
                this.a((a.a)this.kC.remove());
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void ba() {
        Object object = this.kt;
        synchronized (object) {
            this.kJ = false;
            this.kC.clear();
            Iterator<Api.a> iterator = this.kI.values().iterator();
            while (iterator.hasNext()) {
                iterator.next().disconnect();
            }
            if (this.kF != 3) {
                this.kF = 3;
                this.kB.bG();
            }
            return;
        }
    }

    public <C extends Api.a> C a(Api.b<C> b2) {
        Api.a a2 = this.kI.get(b2);
        du.c(a2, "Appropriate Api was not requested.");
        return (C)a2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <A extends Api.a, T extends a.a<?, ?, A>> T a(T t2) {
        Object object = this.kt;
        synchronized (object) {
            if (this.isConnected()) {
                this.b(t2);
            } else {
                this.kC.add(t2);
            }
            return t2;
        }
    }

    public <A extends Api.a, T extends a.a<?, ?, A>> T b(T t2) {
        du.a(this.isConnected(), "GoogleApiClient is not connected yet.");
        this.aZ();
        this.a(t2);
        return t2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void connect() {
        Object object = this.kt;
        synchronized (object) {
            if (this.isConnected() || this.isConnecting()) {
                return;
            }
            this.kJ = true;
            this.kD = null;
            this.kF = 1;
            this.kH.clear();
            this.kG = this.kI.size();
            Iterator<Api.a> iterator = this.kI.values().iterator();
            while (iterator.hasNext()) {
                iterator.next().connect();
            }
            return;
        }
    }

    public void disconnect() {
        this.ba();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isConnected() {
        Object object = this.kt;
        synchronized (object) {
            if (this.kF != 2) return false;
            return true;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isConnecting() {
        int n2 = 1;
        Object object = this.kt;
        synchronized (object) {
            if (this.kF == n2) return n2 != 0;
            return 0 != 0;
        }
    }

    public boolean isConnectionCallbacksRegistered(ConnectionCallbacks connectionCallbacks) {
        return this.kB.isConnectionCallbacksRegistered(connectionCallbacks);
    }

    public boolean isConnectionFailedListenerRegistered(OnConnectionFailedListener onConnectionFailedListener) {
        return this.kB.isConnectionFailedListenerRegistered(onConnectionFailedListener);
    }

    public void reconnect() {
        this.disconnect();
        this.connect();
    }

    public void registerConnectionCallbacks(ConnectionCallbacks connectionCallbacks) {
        this.kB.registerConnectionCallbacks(connectionCallbacks);
    }

    public void registerConnectionFailedListener(OnConnectionFailedListener onConnectionFailedListener) {
        this.kB.registerConnectionFailedListener(onConnectionFailedListener);
    }

    public void unregisterConnectionCallbacks(ConnectionCallbacks connectionCallbacks) {
        this.kB.unregisterConnectionCallbacks(connectionCallbacks);
    }

    public void unregisterConnectionFailedListener(OnConnectionFailedListener onConnectionFailedListener) {
        this.kB.unregisterConnectionFailedListener(onConnectionFailedListener);
    }

    public static interface ApiOptions {
    }

    public static final class Builder {
        private String jD;
        private final Set<String> kO = new HashSet<String>();
        private int kP;
        private View kQ;
        private String kR;
        private final Map<Api, ApiOptions> kS = new HashMap<Api, ApiOptions>();
        private final Set<ConnectionCallbacks> kT = new HashSet<ConnectionCallbacks>();
        private final Set<OnConnectionFailedListener> kU = new HashSet<OnConnectionFailedListener>();
        private final Context mContext;

        public Builder(Context context) {
            this.mContext = context;
            this.kR = context.getPackageName();
        }

        public Builder(Context context, ConnectionCallbacks connectionCallbacks, OnConnectionFailedListener onConnectionFailedListener) {
            this(context);
            du.c(connectionCallbacks, "Must provide a connected listener");
            this.kT.add(connectionCallbacks);
            du.c(onConnectionFailedListener, "Must provide a connection failed listener");
            this.kU.add(onConnectionFailedListener);
        }

        public Builder addApi(Api api) {
            return this.addApi(api, null);
        }

        public Builder addApi(Api api, ApiOptions apiOptions) {
            this.kS.put(api, apiOptions);
            List<Scope> list = api.aW();
            int n2 = list.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                this.kO.add(list.get(i2).be());
            }
            return this;
        }

        public Builder addConnectionCallbacks(ConnectionCallbacks connectionCallbacks) {
            this.kT.add(connectionCallbacks);
            return this;
        }

        public Builder addOnConnectionFailedListener(OnConnectionFailedListener onConnectionFailedListener) {
            this.kU.add(onConnectionFailedListener);
            return this;
        }

        public Builder addScope(Scope scope) {
            this.kO.add(scope.be());
            return this;
        }

        public dh bd() {
            return new dh(this.jD, this.kO, this.kP, this.kQ, this.kR);
        }

        public GoogleApiClient build() {
            return new GoogleApiClient(this.mContext, this.bd(), this.kS, this.kT, this.kU);
        }

        public Builder setAccountName(String string2) {
            this.jD = string2;
            return this;
        }

        public Builder setGravityForPopups(int n2) {
            this.kP = n2;
            return this;
        }

        public Builder setViewForPopups(View view) {
            this.kQ = view;
            return this;
        }

        public Builder useDefaultAccount() {
            return this.setAccountName("<<default account>>");
        }
    }

    public static interface ConnectionCallbacks
    extends GooglePlayServicesClient.ConnectionCallbacks {
    }

    public static interface OnConnectionFailedListener
    extends GooglePlayServicesClient.OnConnectionFailedListener {
    }

    public static interface a<A extends Api.a> {
        public void a(A var1);

        public Api.b<A> aV();
    }
}

