/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth;

import android.accounts.AccountManager;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.os.RemoteException;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.R;
import com.google.android.gms.auth.GoogleAuthException;
import com.google.android.gms.auth.GooglePlayServicesAvailabilityException;
import com.google.android.gms.auth.UserRecoverableAuthException;
import com.google.android.gms.auth.UserRecoverableNotifiedException;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.common.a;
import com.google.android.gms.internal.du;
import com.google.android.gms.internal.o;
import java.io.IOException;
import java.net.URISyntaxException;

public final class GoogleAuthUtil {
    public static final String GOOGLE_ACCOUNT_TYPE = "com.google";
    public static final String KEY_ANDROID_PACKAGE_NAME;
    public static final String KEY_CALLER_UID;
    public static final String KEY_CLIENT_PACKAGE_NAME = "clientPackageName";
    public static final String KEY_REQUEST_ACTIONS = "request_visible_actions";
    @Deprecated
    public static final String KEY_REQUEST_VISIBLE_ACTIVITIES = "request_visible_actions";
    public static final String KEY_SUPPRESS_PROGRESS_SCREEN = "suppressProgressScreen";
    private static final ComponentName jS;
    private static final ComponentName jT;
    private static final Intent jU;
    private static final Intent jV;

    /*
     * Enabled aggressive block sorting
     */
    static {
        String string2 = Build.VERSION.SDK_INT >= 11 ? "callerUid" : "callerUid";
        KEY_CALLER_UID = string2;
        String string3 = Build.VERSION.SDK_INT >= 14 ? "androidPackageName" : "androidPackageName";
        KEY_ANDROID_PACKAGE_NAME = string3;
        jS = new ComponentName("com.google.android.gms", "com.google.android.gms.auth.GetToken");
        jT = new ComponentName("com.google.android.gms", "com.google.android.gms.recovery.RecoveryService");
        jU = new Intent().setPackage("com.google.android.gms").setComponent(jS);
        jV = new Intent().setPackage("com.google.android.gms").setComponent(jT);
    }

    private GoogleAuthUtil() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String a(Context context, String string2, String string3, Bundle bundle) throws IOException, UserRecoverableNotifiedException, GoogleAuthException {
        if (bundle == null) {
            bundle = new Bundle();
        }
        try {
            return GoogleAuthUtil.getToken(context, string2, string3, bundle);
        }
        catch (GooglePlayServicesAvailabilityException googlePlayServicesAvailabilityException) {
            int n2;
            PendingIntent pendingIntent = GooglePlayServicesUtil.getErrorPendingIntent(googlePlayServicesAvailabilityException.getConnectionStatusCode(), context, 0);
            Resources resources = context.getResources();
            Notification notification = new Notification(17301642, (CharSequence)resources.getString(R.string.auth_client_play_services_err_notification_msg), System.currentTimeMillis());
            notification.flags = 0x10 | notification.flags;
            String string4 = context.getApplicationInfo().name;
            if (TextUtils.isEmpty((CharSequence)string4)) {
                ApplicationInfo applicationInfo;
                string4 = context.getPackageName();
                PackageManager packageManager = context.getApplicationContext().getPackageManager();
                try {
                    ApplicationInfo applicationInfo2;
                    applicationInfo = applicationInfo2 = packageManager.getApplicationInfo(context.getPackageName(), 0);
                }
                catch (PackageManager.NameNotFoundException nameNotFoundException) {
                    applicationInfo = null;
                }
                if (applicationInfo != null) {
                    string4 = ((Object)packageManager.getApplicationLabel(applicationInfo)).toString();
                }
            }
            String string5 = resources.getString(R.string.auth_client_requested_by_msg, new Object[]{string4});
            switch (googlePlayServicesAvailabilityException.getConnectionStatusCode()) {
                default: {
                    n2 = R.string.auth_client_using_bad_version_title;
                    break;
                }
                case 1: {
                    n2 = R.string.auth_client_needs_installation_title;
                    break;
                }
                case 2: {
                    n2 = R.string.auth_client_needs_update_title;
                    break;
                }
                case 3: {
                    n2 = R.string.auth_client_needs_enabling_title;
                }
            }
            notification.setLatestEventInfo(context, (CharSequence)resources.getString(n2), (CharSequence)string5, pendingIntent);
            ((NotificationManager)context.getSystemService("notification")).notify(39789, notification);
            throw new UserRecoverableNotifiedException("User intervention required. Notification has been pushed.");
        }
        catch (UserRecoverableAuthException userRecoverableAuthException) {
            throw new UserRecoverableNotifiedException("User intervention required. Notification has been pushed.");
        }
    }

    private static void b(Intent intent) {
        if (intent == null) {
            throw new IllegalArgumentException("Callack cannot be null.");
        }
        String string2 = intent.toUri(1);
        try {
            Intent.parseUri((String)string2, (int)1);
            return;
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalArgumentException("Parameter callback contains invalid data. It must be serializable using toUri() and parseUri().");
        }
    }

    public static String getToken(Context context, String string2, String string3) throws IOException, UserRecoverableAuthException, GoogleAuthException {
        return GoogleAuthUtil.getToken(context, string2, string3, new Bundle());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getToken(Context var0, String var1_1, String var2_2, Bundle var3_3) throws IOException, UserRecoverableAuthException, GoogleAuthException {
        var4_4 = var0.getApplicationContext();
        du.C("Calling this from your main thread can lead to deadlock");
        GoogleAuthUtil.m(var4_4);
        var5_5 = var3_3 == null ? new Bundle() : new Bundle(var3_3);
        var6_6 = var0.getApplicationInfo().packageName;
        var5_5.putString("clientPackageName", var6_6);
        if (!var5_5.containsKey(GoogleAuthUtil.KEY_ANDROID_PACKAGE_NAME)) {
            var5_5.putString(GoogleAuthUtil.KEY_ANDROID_PACKAGE_NAME, var6_6);
        }
        if (!var4_4.bindService(GoogleAuthUtil.jU, (ServiceConnection)(var7_7 = new a()), 1)) {
            throw new IOException("Could not bind to service with the given context.");
        }
        try {
            var12_8 = o.a.a(var7_7.aS()).a(var1_1, var2_2, var5_5);
            var13_9 = var12_8.getString("authtoken");
            var14_10 = TextUtils.isEmpty((CharSequence)var13_9);
            if (var14_10) ** GOTO lbl-1000
            ** GOTO lbl23
        }
        catch (RemoteException var10_13) {
            Log.i((String)"GoogleAuthUtil", (String)"GMS remote exception ", (Throwable)var10_13);
            throw new IOException("remote exception");
            catch (InterruptedException var8_15) {
                throw new GoogleAuthException("Interrupted");
            }
lbl23:
            // 1 sources

            var4_4.unbindService((ServiceConnection)var7_7);
            return var13_9;
lbl-1000:
            // 1 sources

            {
                var15_11 = var12_8.getString("Error");
                var16_12 = (Intent)var12_8.getParcelable("userRecoveryIntent");
                if (GoogleAuthUtil.x(var15_11)) {
                    throw new UserRecoverableAuthException(var15_11, var16_12);
                }
            }
        }
        catch (Throwable var9_14) {
            var4_4.unbindService((ServiceConnection)var7_7);
            throw var9_14;
        }
        {
            if (!GoogleAuthUtil.w(var15_11)) ** GOTO lbl-1000
            throw new IOException(var15_11);
        }
lbl-1000:
        // 1 sources

        {
            throw new GoogleAuthException(var15_11);
        }
    }

    public static String getTokenWithNotification(Context context, String string2, String string3, Bundle bundle) throws IOException, UserRecoverableNotifiedException, GoogleAuthException {
        if (bundle == null) {
            bundle = new Bundle();
        }
        bundle.putBoolean("handle_notification", true);
        return GoogleAuthUtil.a(context, string2, string3, bundle);
    }

    public static String getTokenWithNotification(Context context, String string2, String string3, Bundle bundle, Intent intent) throws IOException, UserRecoverableNotifiedException, GoogleAuthException {
        GoogleAuthUtil.b(intent);
        if (bundle == null) {
            bundle = new Bundle();
        }
        bundle.putParcelable("callback_intent", (Parcelable)intent);
        bundle.putBoolean("handle_notification", true);
        return GoogleAuthUtil.a(context, string2, string3, bundle);
    }

    public static String getTokenWithNotification(Context context, String string2, String string3, Bundle bundle, String string4, Bundle bundle2) throws IOException, UserRecoverableNotifiedException, GoogleAuthException {
        if (TextUtils.isEmpty((CharSequence)string4)) {
            throw new IllegalArgumentException("Authority cannot be empty or null.");
        }
        if (bundle == null) {
            bundle = new Bundle();
        }
        if (bundle2 == null) {
            bundle2 = new Bundle();
        }
        ContentResolver.validateSyncExtrasBundle((Bundle)bundle2);
        bundle.putString("authority", string4);
        bundle.putBundle("sync_extras", bundle2);
        bundle.putBoolean("handle_notification", true);
        return GoogleAuthUtil.a(context, string2, string3, bundle);
    }

    public static void invalidateToken(Context context, String string2) {
        AccountManager.get((Context)context).invalidateAuthToken(GOOGLE_ACCOUNT_TYPE, string2);
    }

    private static void m(Context context) throws GooglePlayServicesAvailabilityException, GoogleAuthException {
        try {
            GooglePlayServicesUtil.m(context);
            return;
        }
        catch (GooglePlayServicesRepairableException googlePlayServicesRepairableException) {
            throw new GooglePlayServicesAvailabilityException(googlePlayServicesRepairableException.getConnectionStatusCode(), googlePlayServicesRepairableException.getMessage(), googlePlayServicesRepairableException.getIntent());
        }
        catch (GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException) {
            throw new GoogleAuthException(googlePlayServicesNotAvailableException.getMessage());
        }
    }

    private static boolean w(String string2) {
        return "NetworkError".equals(string2) || "ServiceUnavailable".equals(string2) || "Timeout".equals(string2);
    }

    private static boolean x(String string2) {
        return "BadAuthentication".equals(string2) || "CaptchaRequired".equals(string2) || "DeviceManagementRequiredOrSyncDisabled".equals(string2) || "NeedPermission".equals(string2) || "NeedsBrowser".equals(string2) || "UserCancel".equals(string2) || "AppDownloadRequired".equals(string2);
    }
}

