/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.internal.ag;

public final class AdView
extends ViewGroup {
    private final ag dZ;

    public AdView(Context context) {
        super(context);
        this.dZ = new ag(this);
    }

    public AdView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.dZ = new ag(this, attributeSet, false);
    }

    public AdView(Context context, AttributeSet attributeSet, int n2) {
        super(context, attributeSet, n2);
        this.dZ = new ag(this, attributeSet, false);
    }

    public void destroy() {
        this.dZ.destroy();
    }

    public AdListener getAdListener() {
        return this.dZ.getAdListener();
    }

    public AdSize getAdSize() {
        return this.dZ.getAdSize();
    }

    public String getAdUnitId() {
        return this.dZ.getAdUnitId();
    }

    public void loadAd(AdRequest adRequest) {
        this.dZ.a(adRequest.v());
    }

    protected void onLayout(boolean bl2, int n2, int n3, int n4, int n5) {
        View view = this.getChildAt(0);
        if (view != null && view.getVisibility() != 8) {
            int n6 = view.getMeasuredWidth();
            int n7 = view.getMeasuredHeight();
            int n8 = (n4 - n2 - n6) / 2;
            int n9 = (n5 - n3 - n7) / 2;
            view.layout(n8, n9, n6 + n8, n7 + n9);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void onMeasure(int n2, int n3) {
        int n4;
        int n5;
        View view = this.getChildAt(0);
        AdSize adSize = this.getAdSize();
        if (view != null && view.getVisibility() != 8) {
            this.measureChild(view, n2, n3);
            n5 = view.getMeasuredWidth();
            n4 = view.getMeasuredHeight();
        } else if (adSize != null) {
            Context context = this.getContext();
            n5 = adSize.getWidthInPixels(context);
            n4 = adSize.getHeightInPixels(context);
        } else {
            n4 = 0;
            n5 = 0;
        }
        int n6 = Math.max(n5, this.getSuggestedMinimumWidth());
        int n7 = Math.max(n4, this.getSuggestedMinimumHeight());
        this.setMeasuredDimension(View.resolveSize((int)n6, (int)n2), View.resolveSize((int)n7, (int)n3));
    }

    public void pause() {
        this.dZ.pause();
    }

    public void resume() {
        this.dZ.resume();
    }

    public void setAdListener(AdListener adListener) {
        this.dZ.setAdListener(adListener);
    }

    public void setAdSize(AdSize adSize) {
        this.dZ.setAdSizes(adSize);
    }

    public void setAdUnitId(String string2) {
        this.dZ.setAdUnitId(string2);
    }
}

