/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.util;

import com.fasterxml.jackson.core.Version;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.regex.Pattern;

public class VersionUtil {
    public static final String VERSION_FILE = "VERSION.txt";
    private static final Pattern VERSION_SEPARATOR = Pattern.compile("[-_./;:]");
    private final Version _version;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected VersionUtil() {
        Version version;
        try {
            Version version2;
            version = version2 = VersionUtil.versionFor(this.getClass());
        }
        catch (Exception exception) {
            System.err.println("ERROR: Failed to load Version information for bundle (via " + this.getClass().getName() + ").");
            version = null;
        }
        if (version == null) {
            version = Version.unknownVersion();
        }
        this._version = version;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Version mavenVersionFor(ClassLoader classLoader, String string2, String string3) {
        Version version;
        InputStream inputStream = classLoader.getResourceAsStream("META-INF/maven/" + string2.replaceAll("\\.", "/") + "/" + string3 + "/pom.properties");
        if (inputStream != null) {
            Properties properties = new Properties();
            properties.load(inputStream);
            String string4 = properties.getProperty("version");
            String string5 = properties.getProperty("artifactId");
            version = VersionUtil.parseVersion(string4, properties.getProperty("groupId"), string5);
            inputStream.close();
            return version;
            catch (IOException iOException) {
                inputStream.close();
            }
        }
        return Version.unknownVersion();
        catch (Throwable throwable) {
            inputStream.close();
            throw throwable;
        }
        catch (IOException iOException) {
            return version;
        }
        {
            catch (IOException iOException) {
                return Version.unknownVersion();
            }
        }
        {
            catch (IOException iOException) {
                throw throwable;
            }
        }
    }

    @Deprecated
    public static Version parseVersion(String string2) {
        return VersionUtil.parseVersion(string2, null, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static Version parseVersion(String string2, String string3, String string4) {
        String string5;
        if (string2 == null || (string5 = string2.trim()).length() == 0) {
            return null;
        }
        String[] stringArray = VERSION_SEPARATOR.split(string5);
        int n2 = VersionUtil.parseVersionPart(stringArray[0]);
        int n3 = stringArray.length > 1 ? VersionUtil.parseVersionPart(stringArray[1]) : 0;
        int n4 = stringArray.length > 2 ? VersionUtil.parseVersionPart(stringArray[2]) : 0;
        int n5 = stringArray.length;
        String string6 = null;
        if (n5 > 3) {
            string6 = stringArray[3];
        }
        return new Version(n2, n3, n4, string6, string3, string4);
    }

    protected static int parseVersionPart(String string2) {
        String string3 = string2.toString();
        int n2 = string3.length();
        int n3 = 0;
        int n4 = 0;
        char c2;
        while (n4 < n2 && (c2 = string3.charAt(n4)) <= '9' && c2 >= '0') {
            n3 = n3 * 10 + (c2 - 48);
            ++n4;
        }
        return n3;
    }

    /*
     * Exception decompiling
     */
    public static Version versionFor(Class<?> var0) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 8[TRYBLOCK] [9 : 143->146)] java.io.IOException
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Version version() {
        return this._version;
    }
}

