/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.util;

import com.fasterxml.jackson.core.io.NumberInput;
import com.fasterxml.jackson.core.util.BufferRecycler;
import java.math.BigDecimal;
import java.util.ArrayList;

public final class TextBuffer {
    static final int MAX_SEGMENT_LEN = 262144;
    static final int MIN_SEGMENT_LEN = 1000;
    static final char[] NO_CHARS = new char[0];
    private final BufferRecycler _allocator;
    private char[] _currentSegment;
    private int _currentSize;
    private boolean _hasSegments = false;
    private char[] _inputBuffer;
    private int _inputLen;
    private int _inputStart;
    private char[] _resultArray;
    private String _resultString;
    private int _segmentSize;
    private ArrayList<char[]> _segments;

    public TextBuffer(BufferRecycler bufferRecycler) {
        this._allocator = bufferRecycler;
    }

    private char[] _charArray(int n2) {
        return new char[n2];
    }

    private char[] buildResultArray() {
        if (this._resultString != null) {
            return this._resultString.toCharArray();
        }
        if (this._inputStart >= 0) {
            if (this._inputLen < 1) {
                return NO_CHARS;
            }
            char[] cArray = this._charArray(this._inputLen);
            System.arraycopy(this._inputBuffer, this._inputStart, cArray, 0, this._inputLen);
            return cArray;
        }
        int n2 = this.size();
        if (n2 < 1) {
            return NO_CHARS;
        }
        char[] cArray = this._charArray(n2);
        ArrayList<char[]> arrayList = this._segments;
        int n3 = 0;
        if (arrayList != null) {
            int n4 = this._segments.size();
            for (int i2 = 0; i2 < n4; ++i2) {
                char[] cArray2 = this._segments.get(i2);
                int n5 = cArray2.length;
                System.arraycopy(cArray2, 0, cArray, n3, n5);
                n3 += n5;
            }
        }
        System.arraycopy(this._currentSegment, 0, cArray, n3, this._currentSize);
        return cArray;
    }

    private void clearSegments() {
        this._hasSegments = false;
        this._segments.clear();
        this._segmentSize = 0;
        this._currentSize = 0;
    }

    private void expand(int n2) {
        if (this._segments == null) {
            this._segments = new ArrayList();
        }
        char[] cArray = this._currentSegment;
        this._hasSegments = true;
        this._segments.add(cArray);
        this._segmentSize += cArray.length;
        int n3 = cArray.length;
        int n4 = n3 >> 1;
        if (n4 < n2) {
            n4 = n2;
        }
        char[] cArray2 = this._charArray(Math.min(262144, n3 + n4));
        this._currentSize = 0;
        this._currentSegment = cArray2;
    }

    private char[] findBuffer(int n2) {
        if (this._allocator != null) {
            return this._allocator.allocCharBuffer(BufferRecycler.CharBufferType.TEXT_BUFFER, n2);
        }
        return new char[Math.max(n2, 1000)];
    }

    private void unshare(int n2) {
        int n3 = this._inputLen;
        this._inputLen = 0;
        char[] cArray = this._inputBuffer;
        this._inputBuffer = null;
        int n4 = this._inputStart;
        this._inputStart = -1;
        int n5 = n3 + n2;
        if (this._currentSegment == null || n5 > this._currentSegment.length) {
            this._currentSegment = this.findBuffer(n5);
        }
        if (n3 > 0) {
            System.arraycopy(cArray, n4, this._currentSegment, 0, n3);
        }
        this._segmentSize = 0;
        this._currentSize = n3;
    }

    public void append(char c2) {
        if (this._inputStart >= 0) {
            this.unshare(16);
        }
        this._resultString = null;
        this._resultArray = null;
        char[] cArray = this._currentSegment;
        if (this._currentSize >= cArray.length) {
            this.expand(1);
            cArray = this._currentSegment;
        }
        int n2 = this._currentSize;
        this._currentSize = n2 + 1;
        cArray[n2] = c2;
    }

    public void append(String string2, int n2, int n3) {
        int n4;
        if (this._inputStart >= 0) {
            this.unshare(n3);
        }
        this._resultString = null;
        this._resultArray = null;
        char[] cArray = this._currentSegment;
        int n5 = cArray.length - this._currentSize;
        if (n5 >= n3) {
            string2.getChars(n2, n2 + n3, cArray, this._currentSize);
            this._currentSize = n3 + this._currentSize;
            return;
        }
        if (n5 > 0) {
            string2.getChars(n2, n2 + n5, cArray, this._currentSize);
            n3 -= n5;
            n2 += n5;
        }
        do {
            this.expand(n3);
            n4 = Math.min(this._currentSegment.length, n3);
            string2.getChars(n2, n2 + n4, this._currentSegment, 0);
            this._currentSize = n4 + this._currentSize;
            n2 += n4;
        } while ((n3 -= n4) > 0);
    }

    public void append(char[] cArray, int n2, int n3) {
        int n4;
        if (this._inputStart >= 0) {
            this.unshare(n3);
        }
        this._resultString = null;
        this._resultArray = null;
        char[] cArray2 = this._currentSegment;
        int n5 = cArray2.length - this._currentSize;
        if (n5 >= n3) {
            System.arraycopy(cArray, n2, cArray2, this._currentSize, n3);
            this._currentSize = n3 + this._currentSize;
            return;
        }
        if (n5 > 0) {
            System.arraycopy(cArray, n2, cArray2, this._currentSize, n5);
            n2 += n5;
            n3 -= n5;
        }
        do {
            this.expand(n3);
            n4 = Math.min(this._currentSegment.length, n3);
            System.arraycopy(cArray, n2, this._currentSegment, 0, n4);
            this._currentSize = n4 + this._currentSize;
            n2 += n4;
        } while ((n3 -= n4) > 0);
    }

    public char[] contentsAsArray() {
        char[] cArray = this._resultArray;
        if (cArray == null) {
            this._resultArray = cArray = this.buildResultArray();
        }
        return cArray;
    }

    public BigDecimal contentsAsDecimal() throws NumberFormatException {
        if (this._resultArray != null) {
            return new BigDecimal(this._resultArray);
        }
        if (this._inputStart >= 0) {
            return new BigDecimal(this._inputBuffer, this._inputStart, this._inputLen);
        }
        if (this._segmentSize == 0) {
            return new BigDecimal(this._currentSegment, 0, this._currentSize);
        }
        return new BigDecimal(this.contentsAsArray());
    }

    public double contentsAsDouble() throws NumberFormatException {
        return NumberInput.parseDouble(this.contentsAsString());
    }

    /*
     * Enabled aggressive block sorting
     */
    public String contentsAsString() {
        if (this._resultString != null) return this._resultString;
        if (this._resultArray != null) {
            this._resultString = new String(this._resultArray);
            return this._resultString;
        }
        if (this._inputStart >= 0) {
            if (this._inputLen < 1) {
                this._resultString = "";
                return "";
            }
            this._resultString = new String(this._inputBuffer, this._inputStart, this._inputLen);
            return this._resultString;
        }
        int n2 = this._segmentSize;
        int n3 = this._currentSize;
        if (n2 == 0) {
            String string2 = n3 == 0 ? "" : new String(this._currentSegment, 0, n3);
            this._resultString = string2;
            return this._resultString;
        }
        StringBuilder stringBuilder = new StringBuilder(n2 + n3);
        if (this._segments != null) {
            int n4 = this._segments.size();
            for (int i2 = 0; i2 < n4; ++i2) {
                char[] cArray = this._segments.get(i2);
                stringBuilder.append(cArray, 0, cArray.length);
            }
        }
        stringBuilder.append(this._currentSegment, 0, this._currentSize);
        this._resultString = stringBuilder.toString();
        return this._resultString;
    }

    public char[] emptyAndGetCurrentSegment() {
        char[] cArray;
        this._inputStart = -1;
        this._currentSize = 0;
        this._inputLen = 0;
        this._inputBuffer = null;
        this._resultString = null;
        this._resultArray = null;
        if (this._hasSegments) {
            this.clearSegments();
        }
        if ((cArray = this._currentSegment) == null) {
            this._currentSegment = cArray = this.findBuffer(0);
        }
        return cArray;
    }

    public void ensureNotShared() {
        if (this._inputStart >= 0) {
            this.unshare(16);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public char[] expandCurrentSegment() {
        char[] cArray = this._currentSegment;
        int n2 = cArray.length;
        int n3 = n2 == 262144 ? 262145 : Math.min(262144, n2 + (n2 >> 1));
        this._currentSegment = this._charArray(n3);
        System.arraycopy(cArray, 0, this._currentSegment, 0, n2);
        return this._currentSegment;
    }

    public char[] finishCurrentSegment() {
        if (this._segments == null) {
            this._segments = new ArrayList();
        }
        this._hasSegments = true;
        this._segments.add(this._currentSegment);
        int n2 = this._currentSegment.length;
        this._segmentSize = n2 + this._segmentSize;
        char[] cArray = this._charArray(Math.min(n2 + (n2 >> 1), 262144));
        this._currentSize = 0;
        this._currentSegment = cArray;
        return cArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    public char[] getCurrentSegment() {
        if (this._inputStart >= 0) {
            this.unshare(1);
            return this._currentSegment;
        }
        char[] cArray = this._currentSegment;
        if (cArray == null) {
            this._currentSegment = this.findBuffer(0);
            return this._currentSegment;
        }
        if (this._currentSize < cArray.length) return this._currentSegment;
        this.expand(1);
        return this._currentSegment;
    }

    public int getCurrentSegmentSize() {
        return this._currentSize;
    }

    public char[] getTextBuffer() {
        if (this._inputStart >= 0) {
            return this._inputBuffer;
        }
        if (this._resultArray != null) {
            return this._resultArray;
        }
        if (this._resultString != null) {
            char[] cArray = this._resultString.toCharArray();
            this._resultArray = cArray;
            return cArray;
        }
        if (!this._hasSegments) {
            return this._currentSegment;
        }
        return this.contentsAsArray();
    }

    public int getTextOffset() {
        if (this._inputStart >= 0) {
            return this._inputStart;
        }
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean hasTextAsCharacters() {
        return this._inputStart >= 0 || this._resultArray != null || this._resultString == null;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void releaseBuffers() {
        if (this._allocator == null) {
            this.resetWithEmpty();
            return;
        } else {
            if (this._currentSegment == null) return;
            this.resetWithEmpty();
            char[] cArray = this._currentSegment;
            this._currentSegment = null;
            this._allocator.releaseCharBuffer(BufferRecycler.CharBufferType.TEXT_BUFFER, cArray);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void resetWithCopy(char[] cArray, int n2, int n3) {
        this._inputBuffer = null;
        this._inputStart = -1;
        this._inputLen = 0;
        this._resultString = null;
        this._resultArray = null;
        if (this._hasSegments) {
            this.clearSegments();
        } else if (this._currentSegment == null) {
            this._currentSegment = this.findBuffer(n3);
        }
        this._segmentSize = 0;
        this._currentSize = 0;
        this.append(cArray, n2, n3);
    }

    public void resetWithEmpty() {
        this._inputStart = -1;
        this._currentSize = 0;
        this._inputLen = 0;
        this._inputBuffer = null;
        this._resultString = null;
        this._resultArray = null;
        if (this._hasSegments) {
            this.clearSegments();
        }
    }

    public void resetWithShared(char[] cArray, int n2, int n3) {
        this._resultString = null;
        this._resultArray = null;
        this._inputBuffer = cArray;
        this._inputStart = n2;
        this._inputLen = n3;
        if (this._hasSegments) {
            this.clearSegments();
        }
    }

    public void resetWithString(String string2) {
        this._inputBuffer = null;
        this._inputStart = -1;
        this._inputLen = 0;
        this._resultString = string2;
        this._resultArray = null;
        if (this._hasSegments) {
            this.clearSegments();
        }
        this._currentSize = 0;
    }

    public void setCurrentLength(int n2) {
        this._currentSize = n2;
    }

    public int size() {
        if (this._inputStart >= 0) {
            return this._inputLen;
        }
        if (this._resultArray != null) {
            return this._resultArray.length;
        }
        if (this._resultString != null) {
            return this._resultString.length();
        }
        return this._segmentSize + this._currentSize;
    }

    public String toString() {
        return this.contentsAsString();
    }
}

