/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.util;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.io.SerializedString;
import com.fasterxml.jackson.core.util.Instantiatable;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;

public class DefaultPrettyPrinter
implements PrettyPrinter,
Instantiatable<DefaultPrettyPrinter>,
Serializable {
    public static final SerializedString DEFAULT_ROOT_VALUE_SEPARATOR = new SerializedString(" ");
    private static final long serialVersionUID = -5512586643324525213L;
    protected Indenter _arrayIndenter;
    protected transient int _nesting;
    protected Indenter _objectIndenter;
    protected final SerializableString _rootSeparator;
    protected boolean _spacesInObjectEntries;

    public DefaultPrettyPrinter() {
        this(DEFAULT_ROOT_VALUE_SEPARATOR);
    }

    public DefaultPrettyPrinter(SerializableString serializableString) {
        this._arrayIndenter = FixedSpaceIndenter.instance;
        this._objectIndenter = Lf2SpacesIndenter.instance;
        this._spacesInObjectEntries = true;
        this._nesting = 0;
        this._rootSeparator = serializableString;
    }

    public DefaultPrettyPrinter(DefaultPrettyPrinter defaultPrettyPrinter) {
        this(defaultPrettyPrinter, defaultPrettyPrinter._rootSeparator);
    }

    public DefaultPrettyPrinter(DefaultPrettyPrinter defaultPrettyPrinter, SerializableString serializableString) {
        this._arrayIndenter = FixedSpaceIndenter.instance;
        this._objectIndenter = Lf2SpacesIndenter.instance;
        this._spacesInObjectEntries = true;
        this._nesting = 0;
        this._arrayIndenter = defaultPrettyPrinter._arrayIndenter;
        this._objectIndenter = defaultPrettyPrinter._objectIndenter;
        this._spacesInObjectEntries = defaultPrettyPrinter._spacesInObjectEntries;
        this._nesting = defaultPrettyPrinter._nesting;
        this._rootSeparator = serializableString;
    }

    /*
     * Enabled aggressive block sorting
     */
    public DefaultPrettyPrinter(String string2) {
        SerializedString serializedString = string2 == null ? null : new SerializedString(string2);
        this(serializedString);
    }

    @Override
    public void beforeArrayValues(JsonGenerator jsonGenerator) throws IOException, JsonGenerationException {
        this._arrayIndenter.writeIndentation(jsonGenerator, this._nesting);
    }

    @Override
    public void beforeObjectEntries(JsonGenerator jsonGenerator) throws IOException, JsonGenerationException {
        this._objectIndenter.writeIndentation(jsonGenerator, this._nesting);
    }

    @Override
    public DefaultPrettyPrinter createInstance() {
        return new DefaultPrettyPrinter(this);
    }

    public void indentArraysWith(Indenter indenter) {
        if (indenter == null) {
            indenter = NopIndenter.instance;
        }
        this._arrayIndenter = indenter;
    }

    public void indentObjectsWith(Indenter indenter) {
        if (indenter == null) {
            indenter = NopIndenter.instance;
        }
        this._objectIndenter = indenter;
    }

    public void spacesInObjectEntries(boolean bl2) {
        this._spacesInObjectEntries = bl2;
    }

    public DefaultPrettyPrinter withRootSeparator(SerializableString serializableString) {
        if (this._rootSeparator == serializableString || serializableString != null && serializableString.equals(this._rootSeparator)) {
            return this;
        }
        return new DefaultPrettyPrinter(this, serializableString);
    }

    @Override
    public void writeArrayValueSeparator(JsonGenerator jsonGenerator) throws IOException, JsonGenerationException {
        jsonGenerator.writeRaw(',');
        this._arrayIndenter.writeIndentation(jsonGenerator, this._nesting);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void writeEndArray(JsonGenerator jsonGenerator, int n2) throws IOException, JsonGenerationException {
        if (!this._arrayIndenter.isInline()) {
            this._nesting = -1 + this._nesting;
        }
        if (n2 > 0) {
            this._arrayIndenter.writeIndentation(jsonGenerator, this._nesting);
        } else {
            jsonGenerator.writeRaw(' ');
        }
        jsonGenerator.writeRaw(']');
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void writeEndObject(JsonGenerator jsonGenerator, int n2) throws IOException, JsonGenerationException {
        if (!this._objectIndenter.isInline()) {
            this._nesting = -1 + this._nesting;
        }
        if (n2 > 0) {
            this._objectIndenter.writeIndentation(jsonGenerator, this._nesting);
        } else {
            jsonGenerator.writeRaw(' ');
        }
        jsonGenerator.writeRaw('}');
    }

    @Override
    public void writeObjectEntrySeparator(JsonGenerator jsonGenerator) throws IOException, JsonGenerationException {
        jsonGenerator.writeRaw(',');
        this._objectIndenter.writeIndentation(jsonGenerator, this._nesting);
    }

    @Override
    public void writeObjectFieldValueSeparator(JsonGenerator jsonGenerator) throws IOException, JsonGenerationException {
        if (this._spacesInObjectEntries) {
            jsonGenerator.writeRaw(" : ");
            return;
        }
        jsonGenerator.writeRaw(':');
    }

    @Override
    public void writeRootValueSeparator(JsonGenerator jsonGenerator) throws IOException, JsonGenerationException {
        if (this._rootSeparator != null) {
            jsonGenerator.writeRaw(this._rootSeparator);
        }
    }

    @Override
    public void writeStartArray(JsonGenerator jsonGenerator) throws IOException, JsonGenerationException {
        if (!this._arrayIndenter.isInline()) {
            this._nesting = 1 + this._nesting;
        }
        jsonGenerator.writeRaw('[');
    }

    @Override
    public void writeStartObject(JsonGenerator jsonGenerator) throws IOException, JsonGenerationException {
        jsonGenerator.writeRaw('{');
        if (!this._objectIndenter.isInline()) {
            this._nesting = 1 + this._nesting;
        }
    }

    public static class FixedSpaceIndenter
    implements Indenter,
    Serializable {
        public static FixedSpaceIndenter instance = new FixedSpaceIndenter();
        private static final long serialVersionUID = 1L;

        @Override
        public boolean isInline() {
            return true;
        }

        @Override
        public void writeIndentation(JsonGenerator jsonGenerator, int n2) throws IOException, JsonGenerationException {
            jsonGenerator.writeRaw(' ');
        }
    }

    public static interface Indenter {
        public boolean isInline();

        public void writeIndentation(JsonGenerator var1, int var2) throws IOException, JsonGenerationException;
    }

    public static class Lf2SpacesIndenter
    implements Indenter,
    Serializable {
        static final char[] SPACES;
        static final int SPACE_COUNT = 64;
        static final String SYSTEM_LINE_SEPARATOR;
        public static Lf2SpacesIndenter instance;
        private static final long serialVersionUID = 1L;

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        static {
            String string2;
            instance = new Lf2SpacesIndenter();
            try {
                String string3;
                string2 = string3 = System.getProperty("line.separator");
            }
            catch (Throwable throwable) {
                string2 = null;
            }
            if (string2 == null) {
                string2 = "\n";
            }
            SYSTEM_LINE_SEPARATOR = string2;
            SPACES = new char[64];
            Arrays.fill(SPACES, ' ');
        }

        @Override
        public boolean isInline() {
            return false;
        }

        @Override
        public void writeIndentation(JsonGenerator jsonGenerator, int n2) throws IOException, JsonGenerationException {
            jsonGenerator.writeRaw(SYSTEM_LINE_SEPARATOR);
            if (n2 > 0) {
                int n3;
                for (n3 = n2 + n2; n3 > 64; n3 -= SPACES.length) {
                    jsonGenerator.writeRaw(SPACES, 0, 64);
                }
                jsonGenerator.writeRaw(SPACES, 0, n3);
            }
        }
    }

    public static class NopIndenter
    implements Indenter,
    Serializable {
        public static NopIndenter instance = new NopIndenter();
        private static final long serialVersionUID = 1L;

        @Override
        public boolean isInline() {
            return true;
        }

        @Override
        public void writeIndentation(JsonGenerator jsonGenerator, int n2) {
        }
    }
}

