/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.util;

import com.fasterxml.jackson.core.util.BufferRecycler;
import java.io.OutputStream;
import java.util.LinkedList;

public final class ByteArrayBuilder
extends OutputStream {
    static final int DEFAULT_BLOCK_ARRAY_SIZE = 40;
    private static final int INITIAL_BLOCK_SIZE = 500;
    private static final int MAX_BLOCK_SIZE = 262144;
    private static final byte[] NO_BYTES = new byte[0];
    private final BufferRecycler _bufferRecycler;
    private byte[] _currBlock;
    private int _currBlockPtr;
    private final LinkedList<byte[]> _pastBlocks = new LinkedList();
    private int _pastLen;

    public ByteArrayBuilder() {
        this(null);
    }

    public ByteArrayBuilder(int n2) {
        this(null, n2);
    }

    public ByteArrayBuilder(BufferRecycler bufferRecycler) {
        this(bufferRecycler, 500);
    }

    public ByteArrayBuilder(BufferRecycler bufferRecycler, int n2) {
        this._bufferRecycler = bufferRecycler;
        if (bufferRecycler == null) {
            this._currBlock = new byte[n2];
            return;
        }
        this._currBlock = bufferRecycler.allocByteBuffer(BufferRecycler.ByteBufferType.WRITE_CONCAT_BUFFER);
    }

    private void _allocMore() {
        this._pastLen += this._currBlock.length;
        int n2 = Math.max(this._pastLen >> 1, 1000);
        if (n2 > 262144) {
            n2 = 262144;
        }
        this._pastBlocks.add(this._currBlock);
        this._currBlock = new byte[n2];
        this._currBlockPtr = 0;
    }

    public void append(int n2) {
        if (this._currBlockPtr >= this._currBlock.length) {
            this._allocMore();
        }
        byte[] byArray = this._currBlock;
        int n3 = this._currBlockPtr;
        this._currBlockPtr = n3 + 1;
        byArray[n3] = (byte)n2;
    }

    public void appendThreeBytes(int n2) {
        if (2 + this._currBlockPtr < this._currBlock.length) {
            byte[] byArray = this._currBlock;
            int n3 = this._currBlockPtr;
            this._currBlockPtr = n3 + 1;
            byArray[n3] = (byte)(n2 >> 16);
            byte[] byArray2 = this._currBlock;
            int n4 = this._currBlockPtr;
            this._currBlockPtr = n4 + 1;
            byArray2[n4] = (byte)(n2 >> 8);
            byte[] byArray3 = this._currBlock;
            int n5 = this._currBlockPtr;
            this._currBlockPtr = n5 + 1;
            byArray3[n5] = (byte)n2;
            return;
        }
        this.append(n2 >> 16);
        this.append(n2 >> 8);
        this.append(n2);
    }

    public void appendTwoBytes(int n2) {
        if (1 + this._currBlockPtr < this._currBlock.length) {
            byte[] byArray = this._currBlock;
            int n3 = this._currBlockPtr;
            this._currBlockPtr = n3 + 1;
            byArray[n3] = (byte)(n2 >> 8);
            byte[] byArray2 = this._currBlock;
            int n4 = this._currBlockPtr;
            this._currBlockPtr = n4 + 1;
            byArray2[n4] = (byte)n2;
            return;
        }
        this.append(n2 >> 8);
        this.append(n2);
    }

    @Override
    public void close() {
    }

    public byte[] completeAndCoalesce(int n2) {
        this._currBlockPtr = n2;
        return this.toByteArray();
    }

    public byte[] finishCurrentSegment() {
        this._allocMore();
        return this._currBlock;
    }

    @Override
    public void flush() {
    }

    public byte[] getCurrentSegment() {
        return this._currBlock;
    }

    public int getCurrentSegmentLength() {
        return this._currBlockPtr;
    }

    public void release() {
        this.reset();
        if (this._bufferRecycler != null && this._currBlock != null) {
            this._bufferRecycler.releaseByteBuffer(BufferRecycler.ByteBufferType.WRITE_CONCAT_BUFFER, this._currBlock);
            this._currBlock = null;
        }
    }

    public void reset() {
        this._pastLen = 0;
        this._currBlockPtr = 0;
        if (!this._pastBlocks.isEmpty()) {
            this._pastBlocks.clear();
        }
    }

    public byte[] resetAndGetFirstSegment() {
        this.reset();
        return this._currBlock;
    }

    public void setCurrentSegmentLength(int n2) {
        this._currBlockPtr = n2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public byte[] toByteArray() {
        int n2 = this._pastLen + this._currBlockPtr;
        if (n2 == 0) {
            return NO_BYTES;
        }
        byte[] byArray = new byte[n2];
        int n3 = 0;
        for (byte[] byArray2 : this._pastBlocks) {
            int n4 = byArray2.length;
            System.arraycopy(byArray2, 0, byArray, n3, n4);
            n3 += n4;
        }
        System.arraycopy(this._currBlock, 0, byArray, n3, this._currBlockPtr);
        int n5 = n3 + this._currBlockPtr;
        if (n5 != n2) {
            throw new RuntimeException("Internal error: total len assumed to be " + n2 + ", copied " + n5 + " bytes");
        }
        if (this._pastBlocks.isEmpty()) return byArray;
        this.reset();
        return byArray;
    }

    @Override
    public void write(int n2) {
        this.append(n2);
    }

    @Override
    public void write(byte[] byArray) {
        this.write(byArray, 0, byArray.length);
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) {
        while (true) {
            int n4;
            if ((n4 = Math.min(this._currBlock.length - this._currBlockPtr, n3)) > 0) {
                System.arraycopy(byArray, n2, this._currBlock, this._currBlockPtr, n4);
                n2 += n4;
                this._currBlockPtr = n4 + this._currBlockPtr;
                n3 -= n4;
            }
            if (n3 <= 0) {
                return;
            }
            this._allocMore();
        }
    }
}

