/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.util;

public class BufferRecycler {
    public static final int DEFAULT_WRITE_CONCAT_BUFFER_LEN = 2000;
    protected final byte[][] _byteBuffers = new byte[ByteBufferType.values().length][];
    protected final char[][] _charBuffers = new char[CharBufferType.values().length][];

    private byte[] balloc(int n2) {
        return new byte[n2];
    }

    private char[] calloc(int n2) {
        return new char[n2];
    }

    public final byte[] allocByteBuffer(ByteBufferType byteBufferType) {
        int n2 = byteBufferType.ordinal();
        byte[] byArray = this._byteBuffers[n2];
        if (byArray == null) {
            return this.balloc(byteBufferType.size);
        }
        this._byteBuffers[n2] = null;
        return byArray;
    }

    public final char[] allocCharBuffer(CharBufferType charBufferType) {
        return this.allocCharBuffer(charBufferType, 0);
    }

    public final char[] allocCharBuffer(CharBufferType charBufferType, int n2) {
        int n3;
        char[] cArray;
        if (charBufferType.size > n2) {
            n2 = charBufferType.size;
        }
        if ((cArray = this._charBuffers[n3 = charBufferType.ordinal()]) == null || cArray.length < n2) {
            return this.calloc(n2);
        }
        this._charBuffers[n3] = null;
        return cArray;
    }

    public final void releaseByteBuffer(ByteBufferType byteBufferType, byte[] byArray) {
        this._byteBuffers[byteBufferType.ordinal()] = byArray;
    }

    public final void releaseCharBuffer(CharBufferType charBufferType, char[] cArray) {
        this._charBuffers[charBufferType.ordinal()] = cArray;
    }

    public static final class ByteBufferType
    extends Enum<ByteBufferType> {
        private static final /* synthetic */ ByteBufferType[] $VALUES;
        public static final /* enum */ ByteBufferType BASE64_CODEC_BUFFER;
        public static final /* enum */ ByteBufferType READ_IO_BUFFER;
        public static final /* enum */ ByteBufferType WRITE_CONCAT_BUFFER;
        public static final /* enum */ ByteBufferType WRITE_ENCODING_BUFFER;
        protected final int size;

        static {
            READ_IO_BUFFER = new ByteBufferType(4000);
            WRITE_ENCODING_BUFFER = new ByteBufferType(4000);
            WRITE_CONCAT_BUFFER = new ByteBufferType(2000);
            BASE64_CODEC_BUFFER = new ByteBufferType(2000);
            ByteBufferType[] byteBufferTypeArray = new ByteBufferType[]{READ_IO_BUFFER, WRITE_ENCODING_BUFFER, WRITE_CONCAT_BUFFER, BASE64_CODEC_BUFFER};
            $VALUES = byteBufferTypeArray;
        }

        private ByteBufferType(int n3) {
            this.size = n3;
        }

        public static ByteBufferType valueOf(String string2) {
            return Enum.valueOf(ByteBufferType.class, string2);
        }

        public static ByteBufferType[] values() {
            return (ByteBufferType[])$VALUES.clone();
        }
    }

    public static final class CharBufferType
    extends Enum<CharBufferType> {
        private static final /* synthetic */ CharBufferType[] $VALUES;
        public static final /* enum */ CharBufferType CONCAT_BUFFER;
        public static final /* enum */ CharBufferType NAME_COPY_BUFFER;
        public static final /* enum */ CharBufferType TEXT_BUFFER;
        public static final /* enum */ CharBufferType TOKEN_BUFFER;
        protected final int size;

        static {
            TOKEN_BUFFER = new CharBufferType(2000);
            CONCAT_BUFFER = new CharBufferType(2000);
            TEXT_BUFFER = new CharBufferType(200);
            NAME_COPY_BUFFER = new CharBufferType(200);
            CharBufferType[] charBufferTypeArray = new CharBufferType[]{TOKEN_BUFFER, CONCAT_BUFFER, TEXT_BUFFER, NAME_COPY_BUFFER};
            $VALUES = charBufferTypeArray;
        }

        private CharBufferType(int n3) {
            this.size = n3;
        }

        public static CharBufferType valueOf(String string2) {
            return Enum.valueOf(CharBufferType.class, string2);
        }

        public static CharBufferType[] values() {
            return (CharBufferType[])$VALUES.clone();
        }
    }
}

