/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.sym;

import com.fasterxml.jackson.core.util.InternCache;
import java.util.Arrays;

public final class CharsToNameCanonicalizer {
    protected static final int DEFAULT_TABLE_SIZE = 64;
    public static final int HASH_MULT = 33;
    static final int MAX_COLL_CHAIN_FOR_REUSE = 63;
    static final int MAX_COLL_CHAIN_LENGTH = 255;
    static final int MAX_ENTRIES_FOR_REUSE = 12000;
    protected static final int MAX_TABLE_SIZE = 65536;
    static final CharsToNameCanonicalizer sBootstrapSymbolTable = new CharsToNameCanonicalizer();
    protected Bucket[] _buckets;
    protected final boolean _canonicalize;
    protected boolean _dirty;
    private final int _hashSeed;
    protected int _indexMask;
    protected final boolean _intern;
    protected int _longestCollisionList;
    protected CharsToNameCanonicalizer _parent;
    protected int _size;
    protected int _sizeThreshold;
    protected String[] _symbols;

    private CharsToNameCanonicalizer() {
        this._canonicalize = true;
        this._intern = true;
        this._dirty = true;
        this._hashSeed = 0;
        this._longestCollisionList = 0;
        this.initTables(64);
    }

    private CharsToNameCanonicalizer(CharsToNameCanonicalizer charsToNameCanonicalizer, boolean bl2, boolean bl3, String[] stringArray, Bucket[] bucketArray, int n2, int n3, int n4) {
        this._parent = charsToNameCanonicalizer;
        this._canonicalize = bl2;
        this._intern = bl3;
        this._symbols = stringArray;
        this._buckets = bucketArray;
        this._size = n2;
        this._hashSeed = n3;
        int n5 = stringArray.length;
        this._sizeThreshold = CharsToNameCanonicalizer._thresholdSize(n5);
        this._indexMask = n5 - 1;
        this._longestCollisionList = n4;
        this._dirty = false;
    }

    private static int _thresholdSize(int n2) {
        return n2 - (n2 >> 2);
    }

    private void copyArrays() {
        String[] stringArray = this._symbols;
        int n2 = stringArray.length;
        this._symbols = new String[n2];
        System.arraycopy(stringArray, 0, this._symbols, 0, n2);
        Bucket[] bucketArray = this._buckets;
        int n3 = bucketArray.length;
        this._buckets = new Bucket[n3];
        System.arraycopy(bucketArray, 0, this._buckets, 0, n3);
    }

    public static CharsToNameCanonicalizer createRoot() {
        long l2 = System.currentTimeMillis();
        return CharsToNameCanonicalizer.createRoot(1 | (int)l2 + (int)(l2 >>> 32));
    }

    protected static CharsToNameCanonicalizer createRoot(int n2) {
        return sBootstrapSymbolTable.makeOrphan(n2);
    }

    private void initTables(int n2) {
        this._symbols = new String[n2];
        this._buckets = new Bucket[n2 >> 1];
        this._indexMask = n2 - 1;
        this._size = 0;
        this._longestCollisionList = 0;
        this._sizeThreshold = CharsToNameCanonicalizer._thresholdSize(n2);
    }

    private CharsToNameCanonicalizer makeOrphan(int n2) {
        return new CharsToNameCanonicalizer(null, true, true, this._symbols, this._buckets, this._size, n2, this._longestCollisionList);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void mergeChild(CharsToNameCanonicalizer charsToNameCanonicalizer) {
        if (charsToNameCanonicalizer.size() > 12000 || charsToNameCanonicalizer._longestCollisionList > 63) {
            synchronized (this) {
                this.initTables(64);
                this._dirty = false;
                return;
            }
        }
        if (charsToNameCanonicalizer.size() > this.size()) {
            synchronized (this) {
                this._symbols = charsToNameCanonicalizer._symbols;
                this._buckets = charsToNameCanonicalizer._buckets;
                this._size = charsToNameCanonicalizer._size;
                this._sizeThreshold = charsToNameCanonicalizer._sizeThreshold;
                this._indexMask = charsToNameCanonicalizer._indexMask;
                this._longestCollisionList = charsToNameCanonicalizer._longestCollisionList;
                this._dirty = false;
                return;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    private void rehash() {
        int n2 = this._symbols.length;
        int n3 = n2 + n2;
        if (n3 > 65536) {
            this._size = 0;
            Arrays.fill(this._symbols, null);
            Arrays.fill(this._buckets, null);
            this._dirty = true;
            return;
        }
        String[] stringArray = this._symbols;
        Bucket[] bucketArray = this._buckets;
        this._symbols = new String[n3];
        this._buckets = new Bucket[n3 >> 1];
        this._indexMask = n3 - 1;
        this._sizeThreshold = CharsToNameCanonicalizer._thresholdSize(n3);
        int n4 = 0;
        int n5 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            Bucket bucket;
            String string2 = stringArray[i2];
            if (string2 == null) continue;
            ++n4;
            int n6 = this._hashToIndex(this.calcHash(string2));
            if (this._symbols[n6] == null) {
                this._symbols[n6] = string2;
                continue;
            }
            int n7 = n6 >> 1;
            this._buckets[n7] = bucket = new Bucket(string2, this._buckets[n7]);
            n5 = Math.max(n5, bucket.length());
        }
        int n8 = n2 >> 1;
        int n9 = 0;
        while (true) {
            if (n9 >= n8) {
                this._longestCollisionList = n5;
                if (n4 == this._size) return;
                throw new Error("Internal error on SymbolTable.rehash(): had " + this._size + " entries; now have " + n4 + ".");
            }
            for (Bucket bucket = bucketArray[n9]; bucket != null; bucket = bucket.getNext()) {
                Bucket bucket2;
                ++n4;
                String string3 = bucket.getSymbol();
                int n10 = this._hashToIndex(this.calcHash(string3));
                if (this._symbols[n10] == null) {
                    this._symbols[n10] = string3;
                    continue;
                }
                int n11 = n10 >> 1;
                this._buckets[n11] = bucket2 = new Bucket(string3, this._buckets[n11]);
                n5 = Math.max(n5, bucket2.length());
            }
            ++n9;
        }
    }

    public int _hashToIndex(int n2) {
        return n2 + (n2 >>> 15) & this._indexMask;
    }

    public int bucketCount() {
        return this._symbols.length;
    }

    public int calcHash(String string2) {
        int n2 = string2.length();
        int n3 = this._hashSeed;
        for (int i2 = 0; i2 < n2; ++i2) {
            n3 = n3 * 33 + string2.charAt(i2);
        }
        if (n3 == 0) {
            n3 = 1;
        }
        return n3;
    }

    public int calcHash(char[] cArray, int n2, int n3) {
        int n4 = this._hashSeed;
        for (int i2 = 0; i2 < n3; ++i2) {
            n4 = n4 * 33 + cArray[i2];
        }
        if (n4 == 0) {
            n4 = 1;
        }
        return n4;
    }

    public int collisionCount() {
        int n2 = 0;
        for (Bucket bucket : this._buckets) {
            if (bucket == null) continue;
            n2 += bucket.length();
        }
        return n2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public String findSymbol(char[] cArray, int n2, int n3, int n4) {
        Bucket bucket;
        if (n3 < 1) {
            return "";
        }
        if (!this._canonicalize) {
            return new String(cArray, n2, n3);
        }
        int n5 = this._hashToIndex(n4);
        String string2 = this._symbols[n5];
        if (string2 != null) {
            Bucket bucket2;
            if (string2.length() == n3) {
                int n6 = 0;
                while (string2.charAt(n6) == cArray[n2 + n6] && ++n6 < n3) {
                }
                if (n6 == n3) return string2;
            }
            if ((bucket2 = this._buckets[n5 >> 1]) != null) {
                string2 = bucket2.find(cArray, n2, n3);
                if (string2 != null) return string2;
            }
        }
        if (!this._dirty) {
            this.copyArrays();
            this._dirty = true;
        } else if (this._size >= this._sizeThreshold) {
            this.rehash();
            n5 = this._hashToIndex(this.calcHash(cArray, n2, n3));
        }
        String string3 = new String(cArray, n2, n3);
        if (this._intern) {
            string3 = InternCache.instance.intern(string3);
        }
        this._size = 1 + this._size;
        if (this._symbols[n5] == null) {
            this._symbols[n5] = string3;
            return string3;
        }
        int n7 = n5 >> 1;
        this._buckets[n7] = bucket = new Bucket(string3, this._buckets[n7]);
        this._longestCollisionList = Math.max(bucket.length(), this._longestCollisionList);
        if (this._longestCollisionList <= 255) return string3;
        this.reportTooManyCollisions(255);
        return string3;
    }

    public int hashSeed() {
        return this._hashSeed;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CharsToNameCanonicalizer makeChild(boolean bl2, boolean bl3) {
        synchronized (this) {
            String[] stringArray = this._symbols;
            Bucket[] bucketArray = this._buckets;
            int n2 = this._size;
            int n3 = this._hashSeed;
            int n4 = this._longestCollisionList;
            return new CharsToNameCanonicalizer(this, bl2, bl3, stringArray, bucketArray, n2, n3, n4);
        }
    }

    public int maxCollisionLength() {
        return this._longestCollisionList;
    }

    public boolean maybeDirty() {
        return this._dirty;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void release() {
        if (!this.maybeDirty() || this._parent == null) {
            return;
        }
        this._parent.mergeChild(this);
        this._dirty = false;
    }

    protected void reportTooManyCollisions(int n2) {
        throw new IllegalStateException("Longest collision chain in symbol table (of size " + this._size + ") now exceeds maximum, " + n2 + " -- suspect a DoS attack based on hash collisions");
    }

    public int size() {
        return this._size;
    }

    static final class Bucket {
        private final int _length;
        private final Bucket _next;
        private final String _symbol;

        /*
         * Enabled aggressive block sorting
         */
        public Bucket(String string2, Bucket bucket) {
            this._symbol = string2;
            this._next = bucket;
            int n2 = bucket == null ? 1 : 1 + bucket._length;
            this._length = n2;
        }

        /*
         * Enabled aggressive block sorting
         */
        public String find(char[] cArray, int n2, int n3) {
            String string2 = this._symbol;
            Bucket bucket = this._next;
            while (true) {
                if (string2.length() == n3) {
                    int n4 = 0;
                    while (string2.charAt(n4) == cArray[n2 + n4] && ++n4 < n3) {
                    }
                    if (n4 == n3) {
                        return string2;
                    }
                }
                if (bucket == null) {
                    return null;
                }
                string2 = bucket.getSymbol();
                bucket = bucket.getNext();
            }
        }

        public Bucket getNext() {
            return this._next;
        }

        public String getSymbol() {
            return this._symbol;
        }

        public int length() {
            return this._length;
        }
    }
}

