/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.sym;

import com.fasterxml.jackson.core.sym.Name;
import com.fasterxml.jackson.core.sym.Name1;
import com.fasterxml.jackson.core.sym.Name2;
import com.fasterxml.jackson.core.sym.Name3;
import com.fasterxml.jackson.core.sym.NameN;
import com.fasterxml.jackson.core.util.InternCache;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReference;

public final class BytesToNameCanonicalizer {
    protected static final int DEFAULT_TABLE_SIZE = 64;
    static final int INITIAL_COLLISION_LEN = 32;
    static final int LAST_VALID_BUCKET = 254;
    static final int MAX_COLL_CHAIN_FOR_REUSE = 63;
    static final int MAX_COLL_CHAIN_LENGTH = 255;
    static final int MAX_ENTRIES_FOR_REUSE = 6000;
    protected static final int MAX_TABLE_SIZE = 65536;
    static final int MIN_HASH_SIZE = 16;
    private static final int MULT = 33;
    private static final int MULT2 = 65599;
    private static final int MULT3 = 31;
    protected int _collCount;
    protected int _collEnd;
    protected Bucket[] _collList;
    private boolean _collListShared;
    protected int _count;
    private final int _hashSeed;
    protected final boolean _intern;
    protected int _longestCollisionList;
    protected int[] _mainHash;
    protected int _mainHashMask;
    private boolean _mainHashShared;
    protected Name[] _mainNames;
    private boolean _mainNamesShared;
    private transient boolean _needRehash;
    protected final BytesToNameCanonicalizer _parent;
    protected final AtomicReference<TableInfo> _tableInfo;

    /*
     * Enabled aggressive block sorting
     */
    private BytesToNameCanonicalizer(int n2, boolean bl2, int n3) {
        this._parent = null;
        this._hashSeed = n3;
        this._intern = bl2;
        if (n2 < 16) {
            n2 = 16;
        } else if ((n2 & n2 - 1) != 0) {
            int n4;
            for (n4 = 16; n4 < n2; n4 += n4) {
            }
            n2 = n4;
        }
        this._tableInfo = new AtomicReference<TableInfo>(this.initTableInfo(n2));
    }

    private BytesToNameCanonicalizer(BytesToNameCanonicalizer bytesToNameCanonicalizer, boolean bl2, int n2, TableInfo tableInfo) {
        this._parent = bytesToNameCanonicalizer;
        this._hashSeed = n2;
        this._intern = bl2;
        this._tableInfo = null;
        this._count = tableInfo.count;
        this._mainHashMask = tableInfo.mainHashMask;
        this._mainHash = tableInfo.mainHash;
        this._mainNames = tableInfo.mainNames;
        this._collList = tableInfo.collList;
        this._collCount = tableInfo.collCount;
        this._collEnd = tableInfo.collEnd;
        this._longestCollisionList = tableInfo.longestCollisionList;
        this._needRehash = false;
        this._mainHashShared = true;
        this._mainNamesShared = true;
        this._collListShared = true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void _addSymbol(int n2, Name name) {
        int n3;
        if (this._mainHashShared) {
            this.unshareMain();
        }
        if (this._needRehash) {
            this.rehash();
        }
        this._count = 1 + this._count;
        int n4 = n2 & this._mainHashMask;
        if (this._mainNames[n4] == null) {
            this._mainHash[n4] = n2 << 8;
            if (this._mainNamesShared) {
                this.unshareNames();
            }
            this._mainNames[n4] = name;
        } else {
            Bucket bucket;
            int n5;
            if (this._collListShared) {
                this.unshareCollision();
            }
            this._collCount = 1 + this._collCount;
            int n6 = this._mainHash[n4];
            int n7 = n6 & 0xFF;
            if (n7 == 0) {
                if (this._collEnd <= 254) {
                    n5 = this._collEnd;
                    this._collEnd = 1 + this._collEnd;
                    if (n5 >= this._collList.length) {
                        this.expandCollision();
                    }
                } else {
                    n5 = this.findBestBucket();
                }
                this._mainHash[n4] = n6 & 0xFFFFFF00 | n5 + 1;
            } else {
                n5 = n7 - 1;
            }
            this._collList[n5] = bucket = new Bucket(name, this._collList[n5]);
            this._longestCollisionList = Math.max(bucket.length(), this._longestCollisionList);
            if (this._longestCollisionList > 255) {
                this.reportTooManyCollisions(255);
            }
        }
        if (this._count <= (n3 = this._mainHash.length) >> 1) return;
        int n8 = n3 >> 2;
        if (this._count > n3 - n8) {
            this._needRehash = true;
            return;
        } else {
            if (this._collCount < n8) return;
            this._needRehash = true;
            return;
        }
    }

    protected static int[] calcQuads(byte[] byArray) {
        int n2 = byArray.length;
        int[] nArray = new int[(n2 + 3) / 4];
        int n3 = 0;
        while (n3 < n2) {
            int n4 = 0xFF & byArray[n3];
            int n5 = n3 + 1;
            if (n5 < n2) {
                n4 = n4 << 8 | 0xFF & byArray[n5];
                if (++n5 < n2) {
                    n4 = n4 << 8 | 0xFF & byArray[n5];
                    if (++n5 < n2) {
                        n4 = n4 << 8 | 0xFF & byArray[n5];
                    }
                }
            }
            nArray[n5 >> 2] = n4;
            n3 = n5 + 1;
        }
        return nArray;
    }

    private static Name constructName(int n2, String string2, int n3, int n4) {
        if (n4 == 0) {
            return new Name1(string2, n2, n3);
        }
        return new Name2(string2, n2, n3, n4);
    }

    /*
     * Unable to fully structure code
     */
    private static Name constructName(int var0, String var1_1, int[] var2_2, int var3_3) {
        if (var3_3 >= 4) ** GOTO lbl-1000
        switch (var3_3) {
            default: lbl-1000:
            // 2 sources

            {
                var4_4 = new int[var3_3];
                for (var5_5 = 0; var5_5 < var3_3; ++var5_5) {
                    var4_4[var5_5] = var2_2[var5_5];
                }
                break;
            }
            case 1: {
                return new Name1(var1_1, var0, var2_2[0]);
            }
            case 2: {
                return new Name2(var1_1, var0, var2_2[0], var2_2[1]);
            }
            case 3: {
                return new Name3(var1_1, var0, var2_2[0], var2_2[1], var2_2[2]);
            }
        }
        return new NameN(var1_1, var0, var4_4, var3_3);
    }

    public static BytesToNameCanonicalizer createRoot() {
        long l2 = System.currentTimeMillis();
        return BytesToNameCanonicalizer.createRoot(1 | (int)l2 + (int)(l2 >>> 32));
    }

    protected static BytesToNameCanonicalizer createRoot(int n2) {
        return new BytesToNameCanonicalizer(64, true, n2);
    }

    private void expandCollision() {
        Bucket[] bucketArray = this._collList;
        int n2 = bucketArray.length;
        this._collList = new Bucket[n2 + n2];
        System.arraycopy(bucketArray, 0, this._collList, 0, n2);
    }

    private int findBestBucket() {
        Bucket[] bucketArray = this._collList;
        int n2 = Integer.MAX_VALUE;
        int n3 = -1;
        int n4 = this._collEnd;
        for (int i2 = 0; i2 < n4; ++i2) {
            int n5 = bucketArray[i2].length();
            if (n5 >= n2) continue;
            if (n5 == 1) {
                return i2;
            }
            n2 = n5;
            n3 = i2;
        }
        return n3;
    }

    public static Name getEmptyName() {
        return Name1.getEmptyName();
    }

    private TableInfo initTableInfo(int n2) {
        return new TableInfo(0, n2 - 1, new int[n2], new Name[n2], null, 0, 0, 0);
    }

    private void mergeChild(TableInfo tableInfo) {
        int n2 = tableInfo.count;
        TableInfo tableInfo2 = this._tableInfo.get();
        if (n2 <= tableInfo2.count) {
            return;
        }
        if (n2 > 6000 || tableInfo.longestCollisionList > 63) {
            tableInfo = this.initTableInfo(64);
        }
        this._tableInfo.compareAndSet(tableInfo2, tableInfo);
    }

    private void nukeSymbols() {
        this._count = 0;
        this._longestCollisionList = 0;
        Arrays.fill(this._mainHash, 0);
        Arrays.fill(this._mainNames, null);
        Arrays.fill(this._collList, null);
        this._collCount = 0;
        this._collEnd = 0;
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    private void rehash() {
        this._needRehash = false;
        this._mainNamesShared = false;
        int n2 = this._mainHash.length;
        int n3 = n2 + n2;
        if (n3 > 65536) {
            this.nukeSymbols();
            return;
        }
        this._mainHash = new int[n3];
        this._mainHashMask = n3 - 1;
        Name[] nameArray = this._mainNames;
        this._mainNames = new Name[n3];
        int n4 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            Name name = nameArray[i2];
            if (name == null) continue;
            ++n4;
            int n5 = name.hashCode();
            int n6 = n5 & this._mainHashMask;
            this._mainNames[n6] = name;
            this._mainHash[n6] = n5 << 8;
        }
        int n7 = this._collEnd;
        if (n7 == 0) {
            this._longestCollisionList = 0;
            return;
        }
        this._collCount = 0;
        this._collEnd = 0;
        this._collListShared = false;
        int n8 = 0;
        Bucket[] bucketArray = this._collList;
        this._collList = new Bucket[bucketArray.length];
        int n9 = 0;
        while (true) {
            if (n9 >= n7) {
                this._longestCollisionList = n8;
                int n10 = this._count;
                if (n4 == n10) return;
                throw new RuntimeException("Internal error: count after rehash " + n4 + "; should be " + this._count);
            }
            Bucket bucket = bucketArray[n9];
            while (bucket != null) {
                ++n4;
                Name name = bucket._name;
                int n11 = name.hashCode();
                int n12 = n11 & this._mainHashMask;
                int n13 = this._mainHash[n12];
                if (this._mainNames[n12] == null) {
                    this._mainHash[n12] = n11 << 8;
                    this._mainNames[n12] = name;
                } else {
                    Bucket bucket2;
                    int n14;
                    this._collCount = 1 + this._collCount;
                    int n15 = n13 & 0xFF;
                    if (n15 == 0) {
                        if (this._collEnd <= 254) {
                            n14 = this._collEnd;
                            this._collEnd = 1 + this._collEnd;
                            if (n14 >= this._collList.length) {
                                this.expandCollision();
                            }
                        } else {
                            n14 = this.findBestBucket();
                        }
                        this._mainHash[n12] = n13 & 0xFFFFFF00 | n14 + 1;
                    } else {
                        n14 = n15 - 1;
                    }
                    this._collList[n14] = bucket2 = new Bucket(name, this._collList[n14]);
                    n8 = Math.max(n8, bucket2.length());
                }
                bucket = bucket._next;
            }
            ++n9;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void unshareCollision() {
        Bucket[] bucketArray = this._collList;
        if (bucketArray == null) {
            this._collList = new Bucket[32];
        } else {
            int n2 = bucketArray.length;
            this._collList = new Bucket[n2];
            System.arraycopy(bucketArray, 0, this._collList, 0, n2);
        }
        this._collListShared = false;
    }

    private void unshareMain() {
        int[] nArray = this._mainHash;
        int n2 = this._mainHash.length;
        this._mainHash = new int[n2];
        System.arraycopy(nArray, 0, this._mainHash, 0, n2);
        this._mainHashShared = false;
    }

    private void unshareNames() {
        Name[] nameArray = this._mainNames;
        int n2 = nameArray.length;
        this._mainNames = new Name[n2];
        System.arraycopy(nameArray, 0, this._mainNames, 0, n2);
        this._mainNamesShared = false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public Name addName(String string2, int n2, int n3) {
        if (this._intern) {
            string2 = InternCache.instance.intern(string2);
        }
        int n4 = n3 == 0 ? this.calcHash(n2) : this.calcHash(n2, n3);
        Name name = BytesToNameCanonicalizer.constructName(n4, string2, n2, n3);
        this._addSymbol(n4, name);
        return name;
    }

    /*
     * Enabled aggressive block sorting
     */
    public Name addName(String string2, int[] nArray, int n2) {
        if (this._intern) {
            string2 = InternCache.instance.intern(string2);
        }
        int n3 = n2 < 3 ? (n2 == 1 ? this.calcHash(nArray[0]) : this.calcHash(nArray[0], nArray[1])) : this.calcHash(nArray, n2);
        Name name = BytesToNameCanonicalizer.constructName(n3, string2, nArray, n2);
        this._addSymbol(n3, name);
        return name;
    }

    public int bucketCount() {
        return this._mainHash.length;
    }

    public int calcHash(int n2) {
        int n3 = n2 ^ this._hashSeed;
        int n4 = n3 + (n3 >>> 15);
        return n4 ^ n4 >>> 9;
    }

    public int calcHash(int n2, int n3) {
        int n4 = (n2 ^ n2 >>> 15) + n3 * 33 ^ this._hashSeed;
        return n4 + (n4 >>> 7);
    }

    public int calcHash(int[] nArray, int n2) {
        if (n2 < 3) {
            throw new IllegalArgumentException();
        }
        int n3 = nArray[0] ^ this._hashSeed;
        int n4 = 65599 * (33 * (n3 + (n3 >>> 9)) + nArray[1]);
        int n5 = n4 + (n4 >>> 15) ^ nArray[2];
        int n6 = n5 + (n5 >>> 17);
        for (int i2 = 3; i2 < n2; ++i2) {
            int n7 = n6 * 31 ^ nArray[i2];
            int n8 = n7 + (n7 >>> 3);
            n6 = n8 ^ n8 << 7;
        }
        int n9 = n6 + (n6 >>> 15);
        return n9 ^ n9 << 9;
    }

    public int collisionCount() {
        return this._collCount;
    }

    /*
     * Enabled aggressive block sorting
     */
    public Name findName(int n2) {
        int n3;
        int n4;
        int n5;
        int n6 = this.calcHash(n2);
        if ((n6 ^ (n5 = this._mainHash[n4 = n6 & this._mainHashMask]) >> 8) << 8 == 0) {
            Name name = this._mainNames[n4];
            if (name == null) {
                return null;
            }
            if (name.equals(n2)) {
                return name;
            }
        } else if (n5 == 0) {
            return null;
        }
        if ((n3 = n5 & 0xFF) <= 0) return null;
        int n7 = n3 - 1;
        Bucket bucket = this._collList[n7];
        if (bucket == null) return null;
        return bucket.find(n6, n2, 0);
    }

    /*
     * Enabled aggressive block sorting
     */
    public Name findName(int n2, int n3) {
        int n4;
        int n5;
        int n6;
        int n7 = n3 == 0 ? this.calcHash(n2) : this.calcHash(n2, n3);
        if ((n7 ^ (n6 = this._mainHash[n5 = n7 & this._mainHashMask]) >> 8) << 8 == 0) {
            Name name = this._mainNames[n5];
            if (name == null) {
                return null;
            }
            if (name.equals(n2, n3)) {
                return name;
            }
        } else if (n6 == 0) {
            return null;
        }
        if ((n4 = n6 & 0xFF) <= 0) return null;
        int n8 = n4 - 1;
        Bucket bucket = this._collList[n8];
        if (bucket == null) return null;
        return bucket.find(n7, n2, n3);
    }

    /*
     * Enabled aggressive block sorting
     */
    public Name findName(int[] nArray, int n2) {
        int n3;
        int n4;
        int n5;
        if (n2 < 3) {
            int n6 = nArray[0];
            int n7 = 0;
            if (n2 < 2) return this.findName(n6, n7);
            n7 = nArray[1];
            return this.findName(n6, n7);
        }
        int n8 = this.calcHash(nArray, n2);
        if ((n8 ^ (n5 = this._mainHash[n4 = n8 & this._mainHashMask]) >> 8) << 8 == 0) {
            Name name = this._mainNames[n4];
            if (name == null) return name;
            if (name.equals(nArray, n2)) {
                return name;
            }
        } else if (n5 == 0) {
            return null;
        }
        if ((n3 = n5 & 0xFF) <= 0) return null;
        int n9 = n3 - 1;
        Bucket bucket = this._collList[n9];
        if (bucket == null) return null;
        return bucket.find(n8, nArray, n2);
    }

    public int hashSeed() {
        return this._hashSeed;
    }

    public BytesToNameCanonicalizer makeChild(boolean bl2, boolean bl3) {
        return new BytesToNameCanonicalizer(this, bl3, this._hashSeed, this._tableInfo.get());
    }

    public int maxCollisionLength() {
        return this._longestCollisionList;
    }

    public boolean maybeDirty() {
        return !this._mainHashShared;
    }

    public void release() {
        if (this._parent != null && this.maybeDirty()) {
            this._parent.mergeChild(new TableInfo(this));
            this._mainHashShared = true;
            this._mainNamesShared = true;
            this._collListShared = true;
        }
    }

    protected void reportTooManyCollisions(int n2) {
        throw new IllegalStateException("Longest collision chain in symbol table (of size " + this._count + ") now exceeds maximum, " + n2 + " -- suspect a DoS attack based on hash collisions");
    }

    public int size() {
        if (this._tableInfo != null) {
            return this._tableInfo.get().count;
        }
        return this._count;
    }

    static final class Bucket {
        private final int _length;
        protected final Name _name;
        protected final Bucket _next;

        /*
         * Enabled aggressive block sorting
         */
        Bucket(Name name, Bucket bucket) {
            this._name = name;
            this._next = bucket;
            int n2 = bucket == null ? 1 : 1 + bucket._length;
            this._length = n2;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Name find(int n2, int n3, int n4) {
            if (this._name.hashCode() == n2 && this._name.equals(n3, n4)) {
                return this._name;
            }
            Bucket bucket = this._next;
            while (bucket != null) {
                Name name = bucket._name;
                if (name.hashCode() == n2) {
                    if (name.equals(n3, n4)) return name;
                }
                bucket = bucket._next;
            }
            return null;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Name find(int n2, int[] nArray, int n3) {
            if (this._name.hashCode() == n2 && this._name.equals(nArray, n3)) {
                return this._name;
            }
            Bucket bucket = this._next;
            while (bucket != null) {
                Name name = bucket._name;
                if (name.hashCode() == n2) {
                    if (name.equals(nArray, n3)) return name;
                }
                bucket = bucket._next;
            }
            return null;
        }

        public int length() {
            return this._length;
        }
    }

    private static final class TableInfo {
        public final int collCount;
        public final int collEnd;
        public final Bucket[] collList;
        public final int count;
        public final int longestCollisionList;
        public final int[] mainHash;
        public final int mainHashMask;
        public final Name[] mainNames;

        public TableInfo(int n2, int n3, int[] nArray, Name[] nameArray, Bucket[] bucketArray, int n4, int n5, int n6) {
            this.count = n2;
            this.mainHashMask = n3;
            this.mainHash = nArray;
            this.mainNames = nameArray;
            this.collList = bucketArray;
            this.collCount = n4;
            this.collEnd = n5;
            this.longestCollisionList = n6;
        }

        public TableInfo(BytesToNameCanonicalizer bytesToNameCanonicalizer) {
            this.count = bytesToNameCanonicalizer._count;
            this.mainHashMask = bytesToNameCanonicalizer._mainHashMask;
            this.mainHash = bytesToNameCanonicalizer._mainHash;
            this.mainNames = bytesToNameCanonicalizer._mainNames;
            this.collList = bytesToNameCanonicalizer._collList;
            this.collCount = bytesToNameCanonicalizer._collCount;
            this.collEnd = bytesToNameCanonicalizer._collEnd;
            this.longestCollisionList = bytesToNameCanonicalizer._longestCollisionList;
        }
    }
}

