/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.json;

import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonStreamContext;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.io.CharTypes;
import com.fasterxml.jackson.core.io.CharacterEscapes;
import com.fasterxml.jackson.core.io.IOContext;
import com.fasterxml.jackson.core.io.NumberOutput;
import com.fasterxml.jackson.core.json.JsonGeneratorImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;

public final class WriterBasedJsonGenerator
extends JsonGeneratorImpl {
    protected static final char[] HEX_CHARS = CharTypes.copyHexChars();
    protected static final int SHORT_WRITE = 32;
    protected SerializableString _currentEscape;
    protected char[] _entityBuffer;
    protected char[] _outputBuffer;
    protected int _outputEnd;
    protected int _outputHead = 0;
    protected int _outputTail = 0;
    protected final Writer _writer;

    public WriterBasedJsonGenerator(IOContext iOContext, int n2, ObjectCodec objectCodec, Writer writer) {
        super(iOContext, n2, objectCodec);
        this._writer = writer;
        this._outputBuffer = iOContext.allocConcatBuffer();
        this._outputEnd = this._outputBuffer.length;
    }

    private char[] _allocateEntityBuffer() {
        char[] cArray = new char[14];
        cArray[0] = 92;
        cArray[2] = 92;
        cArray[3] = 117;
        cArray[4] = 48;
        cArray[5] = 48;
        cArray[8] = 92;
        cArray[9] = 117;
        this._entityBuffer = cArray;
        return cArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void _appendCharacterEscape(char c2, int n2) throws IOException, JsonGenerationException {
        int n3;
        String string2;
        if (n2 >= 0) {
            if (2 + this._outputTail > this._outputEnd) {
                this._flushBuffer();
            }
            char[] cArray = this._outputBuffer;
            int n4 = this._outputTail;
            this._outputTail = n4 + 1;
            cArray[n4] = 92;
            char[] cArray2 = this._outputBuffer;
            int n5 = this._outputTail;
            this._outputTail = n5 + 1;
            cArray2[n5] = (char)n2;
            return;
        }
        if (n2 != -2) {
            int n6;
            if (2 + this._outputTail > this._outputEnd) {
                this._flushBuffer();
            }
            int n7 = this._outputTail;
            char[] cArray = this._outputBuffer;
            int n8 = n7 + 1;
            cArray[n7] = 92;
            int n9 = n8 + 1;
            cArray[n8] = 117;
            if (c2 > '\u00ff') {
                int n10 = 0xFF & c2 >> 8;
                int n11 = n9 + 1;
                cArray[n9] = HEX_CHARS[n10 >> 4];
                n6 = n11 + 1;
                cArray[n11] = HEX_CHARS[n10 & 0xF];
                c2 = (char)(c2 & 0xFF);
            } else {
                int n12 = n9 + 1;
                cArray[n9] = 48;
                n6 = n12 + 1;
                cArray[n12] = 48;
            }
            int n13 = n6 + 1;
            cArray[n6] = HEX_CHARS[c2 >> 4];
            cArray[n13] = HEX_CHARS[c2 & 0xF];
            this._outputTail = n13;
            return;
        }
        if (this._currentEscape == null) {
            string2 = this._characterEscapes.getEscapeSequence(c2).getValue();
        } else {
            string2 = this._currentEscape.getValue();
            this._currentEscape = null;
        }
        if ((n3 = string2.length()) + this._outputTail > this._outputEnd) {
            this._flushBuffer();
            if (n3 > this._outputEnd) {
                this._writer.write(string2);
                return;
            }
        }
        string2.getChars(0, n3, this._outputBuffer, this._outputTail);
        this._outputTail = n3 + this._outputTail;
    }

    /*
     * Enabled aggressive block sorting
     */
    private int _prependOrWriteCharacterEscape(char[] cArray, int n2, int n3, char c2, int n4) throws IOException, JsonGenerationException {
        int n5;
        String string2;
        if (n4 >= 0) {
            if (n2 > 1 && n2 < n3) {
                cArray[n2 -= 2] = 92;
                cArray[n2 + 1] = (char)n4;
                return n2;
            }
            char[] cArray2 = this._entityBuffer;
            if (cArray2 == null) {
                cArray2 = this._allocateEntityBuffer();
            }
            cArray2[1] = (char)n4;
            this._writer.write(cArray2, 0, 2);
            return n2;
        }
        if (n4 != -2) {
            if (n2 > 5 && n2 < n3) {
                int n6;
                int n7 = n2 - 6;
                int n8 = n7 + 1;
                cArray[n7] = 92;
                int n9 = n8 + 1;
                cArray[n8] = 117;
                if (c2 > '\u00ff') {
                    int n10 = 0xFF & c2 >> 8;
                    int n11 = n9 + 1;
                    cArray[n9] = HEX_CHARS[n10 >> 4];
                    n6 = n11 + 1;
                    cArray[n11] = HEX_CHARS[n10 & 0xF];
                    c2 = (char)(c2 & 0xFF);
                } else {
                    int n12 = n9 + 1;
                    cArray[n9] = 48;
                    n6 = n12 + 1;
                    cArray[n12] = 48;
                }
                int n13 = n6 + 1;
                cArray[n6] = HEX_CHARS[c2 >> 4];
                cArray[n13] = HEX_CHARS[c2 & 0xF];
                return n13 - 5;
            }
            char[] cArray3 = this._entityBuffer;
            if (cArray3 == null) {
                cArray3 = this._allocateEntityBuffer();
            }
            this._outputHead = this._outputTail;
            if (c2 > '\u00ff') {
                int n14 = 0xFF & c2 >> 8;
                int n15 = c2 & 0xFF;
                cArray3[10] = HEX_CHARS[n14 >> 4];
                cArray3[11] = HEX_CHARS[n14 & 0xF];
                cArray3[12] = HEX_CHARS[n15 >> 4];
                cArray3[13] = HEX_CHARS[n15 & 0xF];
                this._writer.write(cArray3, 8, 6);
                return n2;
            }
            cArray3[6] = HEX_CHARS[c2 >> 4];
            cArray3[7] = HEX_CHARS[c2 & 0xF];
            this._writer.write(cArray3, 2, 6);
            return n2;
        }
        if (this._currentEscape == null) {
            string2 = this._characterEscapes.getEscapeSequence(c2).getValue();
        } else {
            string2 = this._currentEscape.getValue();
            this._currentEscape = null;
        }
        if (n2 >= (n5 = string2.length()) && n2 < n3) {
            string2.getChars(0, n5, cArray, n2 -= n5);
            return n2;
        }
        this._writer.write(string2);
        return n2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void _prependOrWriteCharacterEscape(char c2, int n2) throws IOException, JsonGenerationException {
        int n3;
        String string2;
        if (n2 >= 0) {
            if (this._outputTail >= 2) {
                int n4;
                this._outputHead = n4 = -2 + this._outputTail;
                char[] cArray = this._outputBuffer;
                int n5 = n4 + 1;
                cArray[n4] = 92;
                this._outputBuffer[n5] = (char)n2;
                return;
            }
            char[] cArray = this._entityBuffer;
            if (cArray == null) {
                cArray = this._allocateEntityBuffer();
            }
            this._outputHead = this._outputTail;
            cArray[1] = (char)n2;
            this._writer.write(cArray, 0, 2);
            return;
        }
        if (n2 != -2) {
            if (this._outputTail >= 6) {
                int n6;
                int n7;
                char[] cArray = this._outputBuffer;
                this._outputHead = n7 = -6 + this._outputTail;
                cArray[n7] = 92;
                int n8 = n7 + 1;
                cArray[n8] = 117;
                if (c2 > '\u00ff') {
                    int n9 = 0xFF & c2 >> 8;
                    int n10 = n8 + 1;
                    cArray[n10] = HEX_CHARS[n9 >> 4];
                    n6 = n10 + 1;
                    cArray[n6] = HEX_CHARS[n9 & 0xF];
                    c2 = (char)(c2 & 0xFF);
                } else {
                    int n11 = n8 + 1;
                    cArray[n11] = 48;
                    n6 = n11 + 1;
                    cArray[n6] = 48;
                }
                int n12 = n6 + 1;
                cArray[n12] = HEX_CHARS[c2 >> 4];
                cArray[n12 + 1] = HEX_CHARS[c2 & 0xF];
                return;
            }
            char[] cArray = this._entityBuffer;
            if (cArray == null) {
                cArray = this._allocateEntityBuffer();
            }
            this._outputHead = this._outputTail;
            if (c2 > '\u00ff') {
                int n13 = 0xFF & c2 >> 8;
                int n14 = c2 & 0xFF;
                cArray[10] = HEX_CHARS[n13 >> 4];
                cArray[11] = HEX_CHARS[n13 & 0xF];
                cArray[12] = HEX_CHARS[n14 >> 4];
                cArray[13] = HEX_CHARS[n14 & 0xF];
                this._writer.write(cArray, 8, 6);
                return;
            }
            cArray[6] = HEX_CHARS[c2 >> 4];
            cArray[7] = HEX_CHARS[c2 & 0xF];
            this._writer.write(cArray, 2, 6);
            return;
        }
        if (this._currentEscape == null) {
            string2 = this._characterEscapes.getEscapeSequence(c2).getValue();
        } else {
            string2 = this._currentEscape.getValue();
            this._currentEscape = null;
        }
        if (this._outputTail >= (n3 = string2.length())) {
            int n15;
            this._outputHead = n15 = this._outputTail - n3;
            string2.getChars(0, n3, this._outputBuffer, n15);
            return;
        }
        this._outputHead = this._outputTail;
        this._writer.write(string2);
    }

    private int _readMore(InputStream inputStream, byte[] byArray, int n2, int n3, int n4) throws IOException {
        int n5;
        int n6 = 0;
        int n7 = n2;
        while (n7 < n3) {
            int n8 = n6 + 1;
            int n9 = n7 + 1;
            byArray[n6] = byArray[n7];
            n6 = n8;
            n7 = n9;
        }
        int n10 = n6;
        int n11 = Math.min(n4, byArray.length);
        do {
            if ((n5 = inputStream.read(byArray, n10, n11 - n10)) >= 0) continue;
            return n10;
        } while ((n10 += n5) < 3);
        return n10;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void _writeLongString(String string2) throws IOException, JsonGenerationException {
        int n2;
        this._flushBuffer();
        int n3 = string2.length();
        int n4 = 0;
        do {
            int n5;
            n2 = n4 + (n5 = this._outputEnd) > n3 ? n3 - n4 : n5;
            string2.getChars(n4, n4 + n2, this._outputBuffer, 0);
            if (this._characterEscapes != null) {
                this._writeSegmentCustom(n2);
                continue;
            }
            if (this._maximumNonEscapedChar != 0) {
                this._writeSegmentASCII(n2, this._maximumNonEscapedChar);
                continue;
            }
            this._writeSegment(n2);
        } while ((n4 += n2) < n3);
    }

    private void _writeNull() throws IOException {
        if (4 + this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        int n2 = this._outputTail;
        char[] cArray = this._outputBuffer;
        cArray[n2] = 110;
        int n3 = n2 + 1;
        cArray[n3] = 117;
        int n4 = n3 + 1;
        cArray[n4] = 108;
        int n5 = n4 + 1;
        cArray[n5] = 108;
        this._outputTail = n5 + 1;
    }

    private void _writeQuotedInt(int n2) throws IOException {
        if (13 + this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        char[] cArray = this._outputBuffer;
        int n3 = this._outputTail;
        this._outputTail = n3 + 1;
        cArray[n3] = 34;
        this._outputTail = NumberOutput.outputInt(n2, this._outputBuffer, this._outputTail);
        char[] cArray2 = this._outputBuffer;
        int n4 = this._outputTail;
        this._outputTail = n4 + 1;
        cArray2[n4] = 34;
    }

    private void _writeQuotedLong(long l2) throws IOException {
        if (23 + this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        char[] cArray = this._outputBuffer;
        int n2 = this._outputTail;
        this._outputTail = n2 + 1;
        cArray[n2] = 34;
        this._outputTail = NumberOutput.outputLong(l2, this._outputBuffer, this._outputTail);
        char[] cArray2 = this._outputBuffer;
        int n3 = this._outputTail;
        this._outputTail = n3 + 1;
        cArray2[n3] = 34;
    }

    private void _writeQuotedRaw(Object object) throws IOException {
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        char[] cArray = this._outputBuffer;
        int n2 = this._outputTail;
        this._outputTail = n2 + 1;
        cArray[n2] = 34;
        this.writeRaw(object.toString());
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        char[] cArray2 = this._outputBuffer;
        int n3 = this._outputTail;
        this._outputTail = n3 + 1;
        cArray2[n3] = 34;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void _writeSegment(int n2) throws IOException, JsonGenerationException {
        int[] nArray = this._outputEscapes;
        int n3 = nArray.length;
        int n4 = 0;
        int n5 = 0;
        while (n4 < n2) {
            char c2;
            while (((c2 = this._outputBuffer[n4]) >= n3 || nArray[c2] == 0) && ++n4 < n2) {
            }
            int n6 = n4 - n5;
            if (n6 > 0) {
                this._writer.write(this._outputBuffer, n5, n6);
                if (n4 >= n2) break;
            }
            n5 = this._prependOrWriteCharacterEscape(this._outputBuffer, ++n4, n2, c2, nArray[c2]);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void _writeSegmentASCII(int n2, int n3) throws IOException, JsonGenerationException {
        int[] nArray = this._outputEscapes;
        int n4 = Math.min(nArray.length, n3 + 1);
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        while (n5 < n2) {
            int n8;
            char c2;
            do {
                if ((c2 = this._outputBuffer[n5]) < n4) {
                    n6 = nArray[c2];
                    if (n6 == 0) continue;
                    break;
                }
                if (c2 <= n3) continue;
                n6 = -1;
                break;
            } while (++n5 < n2);
            if ((n8 = n5 - n7) > 0) {
                this._writer.write(this._outputBuffer, n7, n8);
                if (n5 >= n2) break;
            }
            n7 = this._prependOrWriteCharacterEscape(this._outputBuffer, ++n5, n2, c2, n6);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void _writeSegmentCustom(int n2) throws IOException, JsonGenerationException {
        int[] nArray = this._outputEscapes;
        char c2 = this._maximumNonEscapedChar < 1 ? (char)'\uffff' : this._maximumNonEscapedChar;
        int n3 = Math.min(nArray.length, c2 + 1);
        CharacterEscapes characterEscapes = this._characterEscapes;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        while (n4 < n2) {
            int n7;
            char c3;
            do {
                SerializableString serializableString;
                if ((c3 = this._outputBuffer[n4]) < n3) {
                    n5 = nArray[c3];
                    if (n5 == 0) continue;
                    break;
                }
                if (c3 > c2) {
                    n5 = -1;
                    break;
                }
                this._currentEscape = serializableString = characterEscapes.getEscapeSequence(c3);
                if (serializableString == null) continue;
                n5 = -2;
                break;
            } while (++n4 < n2);
            if ((n7 = n4 - n6) > 0) {
                this._writer.write(this._outputBuffer, n6, n7);
                if (n4 >= n2) break;
            }
            n6 = this._prependOrWriteCharacterEscape(this._outputBuffer, ++n4, n2, c3, n5);
        }
    }

    private void _writeString(String string2) throws IOException, JsonGenerationException {
        int n2 = string2.length();
        if (n2 > this._outputEnd) {
            this._writeLongString(string2);
            return;
        }
        if (n2 + this._outputTail > this._outputEnd) {
            this._flushBuffer();
        }
        string2.getChars(0, n2, this._outputBuffer, this._outputTail);
        if (this._characterEscapes != null) {
            this._writeStringCustom(n2);
            return;
        }
        if (this._maximumNonEscapedChar != 0) {
            this._writeStringASCII(n2, this._maximumNonEscapedChar);
            return;
        }
        this._writeString2(n2);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void _writeString(char[] cArray, int n2, int n3) throws IOException, JsonGenerationException {
        if (this._characterEscapes != null) {
            this._writeStringCustom(cArray, n2, n3);
            return;
        }
        if (this._maximumNonEscapedChar != 0) {
            this._writeStringASCII(cArray, n2, n3, this._maximumNonEscapedChar);
            return;
        }
        int n4 = n3 + n2;
        int[] nArray = this._outputEscapes;
        int n5 = nArray.length;
        while (true) {
            int n6;
            int n7;
            int n8;
            block13: {
                if (n2 >= n4) {
                    return;
                }
                n8 = n2;
                do {
                    char c2;
                    if ((c2 = cArray[n2]) >= n5 || nArray[c2] == 0) continue;
                    n7 = n2;
                    break block13;
                } while (++n2 < n4);
                n7 = n2;
            }
            if ((n6 = n7 - n8) < 32) {
                if (n6 + this._outputTail > this._outputEnd) {
                    this._flushBuffer();
                }
                if (n6 > 0) {
                    System.arraycopy(cArray, n8, this._outputBuffer, this._outputTail, n6);
                    this._outputTail = n6 + this._outputTail;
                }
            } else {
                this._flushBuffer();
                this._writer.write(cArray, n8, n6);
            }
            if (n7 >= n4) {
                return;
            }
            n2 = n7 + 1;
            char c3 = cArray[n7];
            this._appendCharacterEscape(c3, nArray[c3]);
        }
    }

    private void _writeString2(int n2) throws IOException, JsonGenerationException {
        int n3 = n2 + this._outputTail;
        int[] nArray = this._outputEscapes;
        int n4 = nArray.length;
        block0: while (this._outputTail < n3) {
            int n5;
            do {
                char c2;
                if ((c2 = this._outputBuffer[this._outputTail]) < n4 && nArray[c2] != 0) {
                    int n6 = this._outputTail - this._outputHead;
                    if (n6 > 0) {
                        this._writer.write(this._outputBuffer, this._outputHead, n6);
                    }
                    char[] cArray = this._outputBuffer;
                    int n7 = this._outputTail;
                    this._outputTail = n7 + 1;
                    char c3 = cArray[n7];
                    this._prependOrWriteCharacterEscape(c3, nArray[c3]);
                    continue block0;
                }
                this._outputTail = n5 = 1 + this._outputTail;
            } while (n5 < n3);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void _writeStringASCII(int n2, int n3) throws IOException, JsonGenerationException {
        int n4 = n2 + this._outputTail;
        int[] nArray = this._outputEscapes;
        int n5 = Math.min(nArray.length, n3 + 1);
        block0: while (this._outputTail < n4) {
            int n6;
            do {
                block7: {
                    int n7;
                    int n8;
                    char c2;
                    block8: {
                        block6: {
                            if ((c2 = this._outputBuffer[this._outputTail]) >= n5) break block6;
                            n8 = nArray[c2];
                            if (n8 == 0) break block7;
                            break block8;
                        }
                        if (c2 <= n3) break block7;
                        n8 = -1;
                    }
                    if ((n7 = this._outputTail - this._outputHead) > 0) {
                        this._writer.write(this._outputBuffer, this._outputHead, n7);
                    }
                    this._outputTail = 1 + this._outputTail;
                    this._prependOrWriteCharacterEscape(c2, n8);
                    continue block0;
                }
                this._outputTail = n6 = 1 + this._outputTail;
            } while (n6 < n4);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void _writeStringASCII(char[] cArray, int n2, int n3, int n4) throws IOException, JsonGenerationException {
        int n5 = n3 + n2;
        int[] nArray = this._outputEscapes;
        int n6 = Math.min(nArray.length, n4 + 1);
        int n7 = 0;
        while (n2 < n5) {
            int n8;
            char c2;
            int n9 = n2;
            do {
                if ((c2 = cArray[n2]) < n6) {
                    n7 = nArray[c2];
                    if (n7 == 0) continue;
                    break;
                }
                if (c2 <= n4) continue;
                n7 = -1;
                break;
            } while (++n2 < n5);
            if ((n8 = n2 - n9) < 32) {
                if (n8 + this._outputTail > this._outputEnd) {
                    this._flushBuffer();
                }
                if (n8 > 0) {
                    System.arraycopy(cArray, n9, this._outputBuffer, this._outputTail, n8);
                    this._outputTail = n8 + this._outputTail;
                }
            } else {
                this._flushBuffer();
                this._writer.write(cArray, n9, n8);
            }
            if (n2 >= n5) break;
            ++n2;
            this._appendCharacterEscape(c2, n7);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void _writeStringCustom(int n2) throws IOException, JsonGenerationException {
        int n3 = n2 + this._outputTail;
        int[] nArray = this._outputEscapes;
        char c2 = this._maximumNonEscapedChar < 1 ? (char)'\uffff' : this._maximumNonEscapedChar;
        int n4 = Math.min(nArray.length, c2 + 1);
        CharacterEscapes characterEscapes = this._characterEscapes;
        block0: while (this._outputTail < n3) {
            int n5;
            do {
                block7: {
                    int n6;
                    int n7;
                    char c3;
                    block8: {
                        SerializableString serializableString;
                        block9: {
                            block6: {
                                if ((c3 = this._outputBuffer[this._outputTail]) >= n4) break block6;
                                n7 = nArray[c3];
                                if (n7 == 0) break block7;
                                break block8;
                            }
                            if (c3 <= c2) break block9;
                            n7 = -1;
                            break block8;
                        }
                        this._currentEscape = serializableString = characterEscapes.getEscapeSequence(c3);
                        if (serializableString == null) break block7;
                        n7 = -2;
                    }
                    if ((n6 = this._outputTail - this._outputHead) > 0) {
                        this._writer.write(this._outputBuffer, this._outputHead, n6);
                    }
                    this._outputTail = 1 + this._outputTail;
                    this._prependOrWriteCharacterEscape(c3, n7);
                    continue block0;
                }
                this._outputTail = n5 = 1 + this._outputTail;
            } while (n5 < n3);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void _writeStringCustom(char[] cArray, int n2, int n3) throws IOException, JsonGenerationException {
        int n4 = n3 + n2;
        int[] nArray = this._outputEscapes;
        char c2 = this._maximumNonEscapedChar < 1 ? (char)'\uffff' : this._maximumNonEscapedChar;
        int n5 = Math.min(nArray.length, c2 + 1);
        CharacterEscapes characterEscapes = this._characterEscapes;
        int n6 = 0;
        while (n2 < n4) {
            int n7;
            char c3;
            int n8 = n2;
            do {
                SerializableString serializableString;
                if ((c3 = cArray[n2]) < n5) {
                    n6 = nArray[c3];
                    if (n6 == 0) continue;
                    break;
                }
                if (c3 > c2) {
                    n6 = -1;
                    break;
                }
                this._currentEscape = serializableString = characterEscapes.getEscapeSequence(c3);
                if (serializableString == null) continue;
                n6 = -2;
                break;
            } while (++n2 < n4);
            if ((n7 = n2 - n8) < 32) {
                if (n7 + this._outputTail > this._outputEnd) {
                    this._flushBuffer();
                }
                if (n7 > 0) {
                    System.arraycopy(cArray, n8, this._outputBuffer, this._outputTail, n7);
                    this._outputTail = n7 + this._outputTail;
                }
            } else {
                this._flushBuffer();
                this._writer.write(cArray, n8, n7);
            }
            if (n2 >= n4) break;
            ++n2;
            this._appendCharacterEscape(c3, n6);
        }
    }

    private void writeRawLong(String string2) throws IOException, JsonGenerationException {
        int n2;
        int n3;
        int n4 = this._outputEnd - this._outputTail;
        string2.getChars(0, n4, this._outputBuffer, this._outputTail);
        this._outputTail = n4 + this._outputTail;
        this._flushBuffer();
        int n5 = n4;
        for (n2 = string2.length() - n4; n2 > this._outputEnd; n2 -= n3) {
            n3 = this._outputEnd;
            string2.getChars(n5, n5 + n3, this._outputBuffer, 0);
            this._outputHead = 0;
            this._outputTail = n3;
            this._flushBuffer();
            n5 += n3;
        }
        string2.getChars(n5, n5 + n2, this._outputBuffer, 0);
        this._outputHead = 0;
        this._outputTail = n2;
    }

    protected void _flushBuffer() throws IOException {
        int n2 = this._outputTail - this._outputHead;
        if (n2 > 0) {
            int n3 = this._outputHead;
            this._outputHead = 0;
            this._outputTail = 0;
            this._writer.write(this._outputBuffer, n3, n2);
        }
    }

    @Override
    protected void _releaseBuffers() {
        char[] cArray = this._outputBuffer;
        if (cArray != null) {
            this._outputBuffer = null;
            this._ioContext.releaseConcatBuffer(cArray);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void _verifyPrettyValueWrite(String string2, int n2) throws IOException, JsonGenerationException {
        switch (n2) {
            default: {
                this._cantHappen();
                return;
            }
            case 1: {
                this._cfgPrettyPrinter.writeArrayValueSeparator(this);
                return;
            }
            case 2: {
                this._cfgPrettyPrinter.writeObjectFieldValueSeparator(this);
                return;
            }
            case 3: {
                this._cfgPrettyPrinter.writeRootValueSeparator(this);
                return;
            }
            case 0: {
                if (this._writeContext.inArray()) {
                    this._cfgPrettyPrinter.beforeArrayValues(this);
                    return;
                }
                if (!this._writeContext.inObject()) return;
                this._cfgPrettyPrinter.beforeObjectEntries(this);
                return;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected void _verifyValueWrite(String var1_1) throws IOException, JsonGenerationException {
        var2_2 = this._writeContext.writeValue();
        if (var2_2 == 5) {
            this._reportError("Can not " + var1_1 + ", expecting field name");
        }
        if (this._cfgPrettyPrinter == null) {
            switch (var2_2) {
                default: {
                    return;
                }
                case 1: {
                    var3_3 = 44;
lbl11:
                    // 2 sources

                    while (true) {
                        if (this._outputTail >= this._outputEnd) {
                            this._flushBuffer();
                        }
                        this._outputBuffer[this._outputTail] = var3_3;
                        this._outputTail = 1 + this._outputTail;
                        return;
                    }
                }
                case 2: {
                    var3_3 = 58;
                    ** continue;
                }
                case 3: 
            }
            if (this._rootValueSeparator == null) ** continue;
            this.writeRaw(this._rootValueSeparator.getValue());
            return;
        }
        this._verifyPrettyValueWrite(var1_1, var2_2);
    }

    protected int _writeBinary(Base64Variant base64Variant, InputStream inputStream, byte[] byArray) throws IOException, JsonGenerationException {
        int n2 = 0;
        int n3 = 0;
        int n4 = -3;
        int n5 = 0;
        int n6 = -6 + this._outputEnd;
        int n7 = base64Variant.getMaxLineLength() >> 2;
        while (true) {
            if (n2 > n4) {
                n3 = this._readMore(inputStream, byArray, n2, n3, byArray.length);
                n2 = 0;
                if (n3 < 3) {
                    if (n3 < 0) {
                        if (this._outputTail > n6) {
                            this._flushBuffer();
                        }
                        int n8 = 0 + 1;
                        int n9 = byArray[0] << 16;
                        int n10 = 1;
                        if (n8 < n3) {
                            n9 |= (0xFF & byArray[n8]) << 8;
                            n10 = 2;
                        }
                        n5 += n10;
                        this._outputTail = base64Variant.encodeBase64Partial(n9, n10, this._outputBuffer, this._outputTail);
                    }
                    return n5;
                }
                n4 = n3 - 3;
            }
            if (this._outputTail > n6) {
                this._flushBuffer();
            }
            int n11 = n2 + 1;
            int n12 = byArray[n2] << 8;
            int n13 = n11 + 1;
            int n14 = (n12 | 0xFF & byArray[n11]) << 8;
            int n15 = n13 + 1;
            int n16 = n14 | 0xFF & byArray[n13];
            n5 += 3;
            this._outputTail = base64Variant.encodeBase64Chunk(n16, this._outputBuffer, this._outputTail);
            if (--n7 <= 0) {
                char[] cArray = this._outputBuffer;
                int n17 = this._outputTail;
                this._outputTail = n17 + 1;
                cArray[n17] = 92;
                char[] cArray2 = this._outputBuffer;
                int n18 = this._outputTail;
                this._outputTail = n18 + 1;
                cArray2[n18] = 110;
                n7 = base64Variant.getMaxLineLength() >> 2;
            }
            n2 = n15;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected int _writeBinary(Base64Variant base64Variant, InputStream inputStream, byte[] byArray, int n2) throws IOException, JsonGenerationException {
        int n3 = 0;
        int n4 = 0;
        int n5 = -3;
        int n6 = -6 + this._outputEnd;
        int n7 = base64Variant.getMaxLineLength() >> 2;
        while (true) {
            block11: {
                block12: {
                    int n8;
                    block10: {
                        if (n2 <= 2) break block10;
                        if (n3 <= n5) break block11;
                        n4 = this._readMore(inputStream, byArray, n3, n4, n2);
                        n3 = 0;
                        if (n4 >= 3) break block12;
                    }
                    if (n2 > 0 && (n8 = this._readMore(inputStream, byArray, n3, n4, n2)) > 0) {
                        int n9;
                        if (this._outputTail > n6) {
                            this._flushBuffer();
                        }
                        int n10 = 0 + 1;
                        int n11 = byArray[0] << 16;
                        if (n10 < n8) {
                            n11 |= (0xFF & byArray[n10]) << 8;
                            n9 = 2;
                        } else {
                            n9 = 1;
                        }
                        this._outputTail = base64Variant.encodeBase64Partial(n11, n9, this._outputBuffer, this._outputTail);
                        n2 -= n9;
                    }
                    return n2;
                }
                n5 = n4 - 3;
            }
            if (this._outputTail > n6) {
                this._flushBuffer();
            }
            int n12 = n3 + 1;
            int n13 = byArray[n3] << 8;
            int n14 = n12 + 1;
            int n15 = (n13 | 0xFF & byArray[n12]) << 8;
            int n16 = n14 + 1;
            int n17 = n15 | 0xFF & byArray[n14];
            n2 -= 3;
            this._outputTail = base64Variant.encodeBase64Chunk(n17, this._outputBuffer, this._outputTail);
            if (--n7 <= 0) {
                char[] cArray = this._outputBuffer;
                int n18 = this._outputTail;
                this._outputTail = n18 + 1;
                cArray[n18] = 92;
                char[] cArray2 = this._outputBuffer;
                int n19 = this._outputTail;
                this._outputTail = n19 + 1;
                cArray2[n19] = 110;
                n7 = base64Variant.getMaxLineLength() >> 2;
            }
            n3 = n16;
        }
    }

    protected void _writeBinary(Base64Variant base64Variant, byte[] byArray, int n2, int n3) throws IOException, JsonGenerationException {
        int n4 = n3 - 3;
        int n5 = -6 + this._outputEnd;
        int n6 = base64Variant.getMaxLineLength() >> 2;
        int n7 = n2;
        while (n7 <= n4) {
            if (this._outputTail > n5) {
                this._flushBuffer();
            }
            int n8 = n7 + 1;
            int n9 = byArray[n7] << 8;
            int n10 = n8 + 1;
            int n11 = (n9 | 0xFF & byArray[n8]) << 8;
            int n12 = n10 + 1;
            this._outputTail = base64Variant.encodeBase64Chunk(n11 | 0xFF & byArray[n10], this._outputBuffer, this._outputTail);
            if (--n6 <= 0) {
                char[] cArray = this._outputBuffer;
                int n13 = this._outputTail;
                this._outputTail = n13 + 1;
                cArray[n13] = 92;
                char[] cArray2 = this._outputBuffer;
                int n14 = this._outputTail;
                this._outputTail = n14 + 1;
                cArray2[n14] = 110;
                n6 = base64Variant.getMaxLineLength() >> 2;
            }
            n7 = n12;
        }
        int n15 = n3 - n7;
        if (n15 > 0) {
            if (this._outputTail > n5) {
                this._flushBuffer();
            }
            int n16 = n7 + 1;
            int n17 = byArray[n7] << 16;
            if (n15 == 2) {
                int cfr_ignored_0 = n16 + 1;
                n17 |= (0xFF & byArray[n16]) << 8;
            }
            this._outputTail = base64Variant.encodeBase64Partial(n17, n15, this._outputBuffer, this._outputTail);
            return;
        }
    }

    public void _writeFieldName(SerializableString serializableString, boolean bl2) throws IOException, JsonGenerationException {
        if (this._cfgPrettyPrinter != null) {
            this._writePPFieldName(serializableString, bl2);
            return;
        }
        if (1 + this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        if (bl2) {
            char[] cArray = this._outputBuffer;
            int n2 = this._outputTail;
            this._outputTail = n2 + 1;
            cArray[n2] = 44;
        }
        char[] cArray = serializableString.asQuotedChars();
        if (!this.isEnabled(JsonGenerator.Feature.QUOTE_FIELD_NAMES)) {
            this.writeRaw(cArray, 0, cArray.length);
            return;
        }
        char[] cArray2 = this._outputBuffer;
        int n3 = this._outputTail;
        this._outputTail = n3 + 1;
        cArray2[n3] = 34;
        int n4 = cArray.length;
        if (1 + (n4 + this._outputTail) >= this._outputEnd) {
            this.writeRaw(cArray, 0, n4);
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            char[] cArray3 = this._outputBuffer;
            int n5 = this._outputTail;
            this._outputTail = n5 + 1;
            cArray3[n5] = 34;
            return;
        }
        System.arraycopy(cArray, 0, this._outputBuffer, this._outputTail, n4);
        this._outputTail = n4 + this._outputTail;
        char[] cArray4 = this._outputBuffer;
        int n6 = this._outputTail;
        this._outputTail = n6 + 1;
        cArray4[n6] = 34;
    }

    protected void _writeFieldName(String string2, boolean bl2) throws IOException, JsonGenerationException {
        if (this._cfgPrettyPrinter != null) {
            this._writePPFieldName(string2, bl2);
            return;
        }
        if (1 + this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        if (bl2) {
            char[] cArray = this._outputBuffer;
            int n2 = this._outputTail;
            this._outputTail = n2 + 1;
            cArray[n2] = 44;
        }
        if (!this.isEnabled(JsonGenerator.Feature.QUOTE_FIELD_NAMES)) {
            this._writeString(string2);
            return;
        }
        char[] cArray = this._outputBuffer;
        int n3 = this._outputTail;
        this._outputTail = n3 + 1;
        cArray[n3] = 34;
        this._writeString(string2);
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        char[] cArray2 = this._outputBuffer;
        int n4 = this._outputTail;
        this._outputTail = n4 + 1;
        cArray2[n4] = 34;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void _writePPFieldName(SerializableString serializableString, boolean bl2) throws IOException, JsonGenerationException {
        if (bl2) {
            this._cfgPrettyPrinter.writeObjectEntrySeparator(this);
        } else {
            this._cfgPrettyPrinter.beforeObjectEntries(this);
        }
        char[] cArray = serializableString.asQuotedChars();
        if (!this.isEnabled(JsonGenerator.Feature.QUOTE_FIELD_NAMES)) {
            this.writeRaw(cArray, 0, cArray.length);
            return;
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        char[] cArray2 = this._outputBuffer;
        int n2 = this._outputTail;
        this._outputTail = n2 + 1;
        cArray2[n2] = 34;
        this.writeRaw(cArray, 0, cArray.length);
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        char[] cArray3 = this._outputBuffer;
        int n3 = this._outputTail;
        this._outputTail = n3 + 1;
        cArray3[n3] = 34;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void _writePPFieldName(String string2, boolean bl2) throws IOException, JsonGenerationException {
        if (bl2) {
            this._cfgPrettyPrinter.writeObjectEntrySeparator(this);
        } else {
            this._cfgPrettyPrinter.beforeObjectEntries(this);
        }
        if (!this.isEnabled(JsonGenerator.Feature.QUOTE_FIELD_NAMES)) {
            this._writeString(string2);
            return;
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        char[] cArray = this._outputBuffer;
        int n2 = this._outputTail;
        this._outputTail = n2 + 1;
        cArray[n2] = 34;
        this._writeString(string2);
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        char[] cArray2 = this._outputBuffer;
        int n3 = this._outputTail;
        this._outputTail = n3 + 1;
        cArray2[n3] = 34;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void close() throws IOException {
        super.close();
        if (this._outputBuffer != null && this.isEnabled(JsonGenerator.Feature.AUTO_CLOSE_JSON_CONTENT)) {
            while (true) {
                JsonStreamContext jsonStreamContext;
                if ((jsonStreamContext = this.getOutputContext()).inArray()) {
                    this.writeEndArray();
                    continue;
                }
                if (!jsonStreamContext.inObject()) break;
                this.writeEndObject();
            }
        }
        this._flushBuffer();
        if (this._writer != null) {
            if (this._ioContext.isResourceManaged() || this.isEnabled(JsonGenerator.Feature.AUTO_CLOSE_TARGET)) {
                this._writer.close();
            } else if (this.isEnabled(JsonGenerator.Feature.FLUSH_PASSED_TO_STREAM)) {
                this._writer.flush();
            }
        }
        this._releaseBuffers();
    }

    @Override
    public void flush() throws IOException {
        this._flushBuffer();
        if (this._writer != null && this.isEnabled(JsonGenerator.Feature.FLUSH_PASSED_TO_STREAM)) {
            this._writer.flush();
        }
    }

    @Override
    public Object getOutputTarget() {
        return this._writer;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public int writeBinary(Base64Variant var1_1, InputStream var2_2, int var3_3) throws IOException, JsonGenerationException {
        block8: {
            this._verifyValueWrite("write binary value");
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            var4_4 = this._outputBuffer;
            var5_5 = this._outputTail;
            this._outputTail = var5_5 + 1;
            var4_4[var5_5] = 34;
            var6_6 = this._ioContext.allocBase64Buffer();
            if (var3_3 < 0) {
                var9_8 = var12_7 = this._writeBinary(var1_1, var2_2, var6_6);
lbl12:
                // 2 sources

                while (true) {
                    this._ioContext.releaseBase64Buffer(var6_6);
                    if (this._outputTail >= this._outputEnd) {
                        this._flushBuffer();
                    }
                    var10_9 = this._outputBuffer;
                    var11_10 = this._outputTail;
                    this._outputTail = var11_10 + 1;
                    var10_9[var11_10] = 34;
                    return var9_8;
                }
            }
            try {
                var8_11 = this._writeBinary(var1_1, var2_2, var6_6, var3_3);
                if (var8_11 <= 0) break block8;
            }
            catch (Throwable var7_12) {
                this._ioContext.releaseBase64Buffer(var6_6);
                throw var7_12;
            }
            this._reportError("Too few bytes available: missing " + var8_11 + " bytes (out of " + var3_3 + ")");
        }
        var9_8 = var3_3;
        ** while (true)
    }

    @Override
    public void writeBinary(Base64Variant base64Variant, byte[] byArray, int n2, int n3) throws IOException, JsonGenerationException {
        this._verifyValueWrite("write binary value");
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        char[] cArray = this._outputBuffer;
        int n4 = this._outputTail;
        this._outputTail = n4 + 1;
        cArray[n4] = 34;
        this._writeBinary(base64Variant, byArray, n2, n2 + n3);
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        char[] cArray2 = this._outputBuffer;
        int n5 = this._outputTail;
        this._outputTail = n5 + 1;
        cArray2[n5] = 34;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void writeBoolean(boolean bl2) throws IOException, JsonGenerationException {
        int n2;
        this._verifyValueWrite("write boolean value");
        if (5 + this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        int n3 = this._outputTail;
        char[] cArray = this._outputBuffer;
        if (bl2) {
            cArray[n3] = 116;
            int n4 = n3 + 1;
            cArray[n4] = 114;
            int n5 = n4 + 1;
            cArray[n5] = 117;
            n2 = n5 + 1;
            cArray[n2] = 101;
        } else {
            cArray[n3] = 102;
            int n6 = n3 + 1;
            cArray[n6] = 97;
            int n7 = n6 + 1;
            cArray[n7] = 108;
            int n8 = n7 + 1;
            cArray[n8] = 115;
            n2 = n8 + 1;
            cArray[n2] = 101;
        }
        this._outputTail = n2 + 1;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void writeEndArray() throws IOException, JsonGenerationException {
        if (!this._writeContext.inArray()) {
            this._reportError("Current context not an ARRAY but " + this._writeContext.getTypeDesc());
        }
        if (this._cfgPrettyPrinter != null) {
            this._cfgPrettyPrinter.writeEndArray(this, this._writeContext.getEntryCount());
        } else {
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            char[] cArray = this._outputBuffer;
            int n2 = this._outputTail;
            this._outputTail = n2 + 1;
            cArray[n2] = 93;
        }
        this._writeContext = this._writeContext.getParent();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void writeEndObject() throws IOException, JsonGenerationException {
        if (!this._writeContext.inObject()) {
            this._reportError("Current context not an object but " + this._writeContext.getTypeDesc());
        }
        if (this._cfgPrettyPrinter != null) {
            this._cfgPrettyPrinter.writeEndObject(this, this._writeContext.getEntryCount());
        } else {
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            char[] cArray = this._outputBuffer;
            int n2 = this._outputTail;
            this._outputTail = n2 + 1;
            cArray[n2] = 125;
        }
        this._writeContext = this._writeContext.getParent();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void writeFieldName(SerializableString serializableString) throws IOException, JsonGenerationException {
        int n2 = 1;
        int n3 = this._writeContext.writeFieldName(serializableString.getValue());
        if (n3 == 4) {
            this._reportError("Can not write a field name, expecting a value");
        }
        if (n3 != n2) {
            n2 = 0;
        }
        this._writeFieldName(serializableString, n2 != 0);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void writeFieldName(String string2) throws IOException, JsonGenerationException {
        int n2 = 1;
        int n3 = this._writeContext.writeFieldName(string2);
        if (n3 == 4) {
            this._reportError("Can not write a field name, expecting a value");
        }
        if (n3 != n2) {
            n2 = 0;
        }
        this._writeFieldName(string2, n2 != 0);
    }

    @Override
    public void writeNull() throws IOException, JsonGenerationException {
        this._verifyValueWrite("write null value");
        this._writeNull();
    }

    @Override
    public void writeNumber(double d2) throws IOException, JsonGenerationException {
        if (this._cfgNumbersAsStrings || (Double.isNaN(d2) || Double.isInfinite(d2)) && this.isEnabled(JsonGenerator.Feature.QUOTE_NON_NUMERIC_NUMBERS)) {
            this.writeString(String.valueOf(d2));
            return;
        }
        this._verifyValueWrite("write number");
        this.writeRaw(String.valueOf(d2));
    }

    @Override
    public void writeNumber(float f2) throws IOException, JsonGenerationException {
        if (this._cfgNumbersAsStrings || (Float.isNaN(f2) || Float.isInfinite(f2)) && this.isEnabled(JsonGenerator.Feature.QUOTE_NON_NUMERIC_NUMBERS)) {
            this.writeString(String.valueOf(f2));
            return;
        }
        this._verifyValueWrite("write number");
        this.writeRaw(String.valueOf(f2));
    }

    @Override
    public void writeNumber(int n2) throws IOException, JsonGenerationException {
        this._verifyValueWrite("write number");
        if (this._cfgNumbersAsStrings) {
            this._writeQuotedInt(n2);
            return;
        }
        if (11 + this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputTail = NumberOutput.outputInt(n2, this._outputBuffer, this._outputTail);
    }

    @Override
    public void writeNumber(long l2) throws IOException, JsonGenerationException {
        this._verifyValueWrite("write number");
        if (this._cfgNumbersAsStrings) {
            this._writeQuotedLong(l2);
            return;
        }
        if (21 + this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputTail = NumberOutput.outputLong(l2, this._outputBuffer, this._outputTail);
    }

    @Override
    public void writeNumber(String string2) throws IOException, JsonGenerationException {
        this._verifyValueWrite("write number");
        if (this._cfgNumbersAsStrings) {
            this._writeQuotedRaw(string2);
            return;
        }
        this.writeRaw(string2);
    }

    @Override
    public void writeNumber(BigDecimal bigDecimal) throws IOException, JsonGenerationException {
        this._verifyValueWrite("write number");
        if (bigDecimal == null) {
            this._writeNull();
            return;
        }
        if (this._cfgNumbersAsStrings) {
            this._writeQuotedRaw(bigDecimal);
            return;
        }
        this.writeRaw(bigDecimal.toString());
    }

    @Override
    public void writeNumber(BigInteger bigInteger) throws IOException, JsonGenerationException {
        this._verifyValueWrite("write number");
        if (bigInteger == null) {
            this._writeNull();
            return;
        }
        if (this._cfgNumbersAsStrings) {
            this._writeQuotedRaw(bigInteger);
            return;
        }
        this.writeRaw(bigInteger.toString());
    }

    @Override
    public void writeRaw(char c2) throws IOException, JsonGenerationException {
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        char[] cArray = this._outputBuffer;
        int n2 = this._outputTail;
        this._outputTail = n2 + 1;
        cArray[n2] = c2;
    }

    @Override
    public void writeRaw(SerializableString serializableString) throws IOException, JsonGenerationException {
        this.writeRaw(serializableString.getValue());
    }

    @Override
    public void writeRaw(String string2) throws IOException, JsonGenerationException {
        int n2 = string2.length();
        int n3 = this._outputEnd - this._outputTail;
        if (n3 == 0) {
            this._flushBuffer();
            n3 = this._outputEnd - this._outputTail;
        }
        if (n3 >= n2) {
            string2.getChars(0, n2, this._outputBuffer, this._outputTail);
            this._outputTail = n2 + this._outputTail;
            return;
        }
        this.writeRawLong(string2);
    }

    @Override
    public void writeRaw(String string2, int n2, int n3) throws IOException, JsonGenerationException {
        int n4 = this._outputEnd - this._outputTail;
        if (n4 < n3) {
            this._flushBuffer();
            n4 = this._outputEnd - this._outputTail;
        }
        if (n4 >= n3) {
            string2.getChars(n2, n2 + n3, this._outputBuffer, this._outputTail);
            this._outputTail = n3 + this._outputTail;
            return;
        }
        this.writeRawLong(string2.substring(n2, n2 + n3));
    }

    @Override
    public void writeRaw(char[] cArray, int n2, int n3) throws IOException, JsonGenerationException {
        if (n3 < 32) {
            if (n3 > this._outputEnd - this._outputTail) {
                this._flushBuffer();
            }
            System.arraycopy(cArray, n2, this._outputBuffer, this._outputTail, n3);
            this._outputTail = n3 + this._outputTail;
            return;
        }
        this._flushBuffer();
        this._writer.write(cArray, n2, n3);
    }

    @Override
    public void writeRawUTF8String(byte[] byArray, int n2, int n3) throws IOException, JsonGenerationException {
        this._reportUnsupportedOperation();
    }

    @Override
    public void writeStartArray() throws IOException, JsonGenerationException {
        this._verifyValueWrite("start an array");
        this._writeContext = this._writeContext.createChildArrayContext();
        if (this._cfgPrettyPrinter != null) {
            this._cfgPrettyPrinter.writeStartArray(this);
            return;
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        char[] cArray = this._outputBuffer;
        int n2 = this._outputTail;
        this._outputTail = n2 + 1;
        cArray[n2] = 91;
    }

    @Override
    public void writeStartObject() throws IOException, JsonGenerationException {
        this._verifyValueWrite("start an object");
        this._writeContext = this._writeContext.createChildObjectContext();
        if (this._cfgPrettyPrinter != null) {
            this._cfgPrettyPrinter.writeStartObject(this);
            return;
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        char[] cArray = this._outputBuffer;
        int n2 = this._outputTail;
        this._outputTail = n2 + 1;
        cArray[n2] = 123;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void writeString(SerializableString serializableString) throws IOException, JsonGenerationException {
        this._verifyValueWrite("write text value");
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        char[] cArray = this._outputBuffer;
        int n2 = this._outputTail;
        this._outputTail = n2 + 1;
        cArray[n2] = 34;
        char[] cArray2 = serializableString.asQuotedChars();
        int n3 = cArray2.length;
        if (n3 < 32) {
            if (n3 > this._outputEnd - this._outputTail) {
                this._flushBuffer();
            }
            System.arraycopy(cArray2, 0, this._outputBuffer, this._outputTail, n3);
            this._outputTail = n3 + this._outputTail;
        } else {
            this._flushBuffer();
            this._writer.write(cArray2, 0, n3);
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        char[] cArray3 = this._outputBuffer;
        int n4 = this._outputTail;
        this._outputTail = n4 + 1;
        cArray3[n4] = 34;
    }

    @Override
    public void writeString(String string2) throws IOException, JsonGenerationException {
        this._verifyValueWrite("write text value");
        if (string2 == null) {
            this._writeNull();
            return;
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        char[] cArray = this._outputBuffer;
        int n2 = this._outputTail;
        this._outputTail = n2 + 1;
        cArray[n2] = 34;
        this._writeString(string2);
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        char[] cArray2 = this._outputBuffer;
        int n3 = this._outputTail;
        this._outputTail = n3 + 1;
        cArray2[n3] = 34;
    }

    @Override
    public void writeString(char[] cArray, int n2, int n3) throws IOException, JsonGenerationException {
        this._verifyValueWrite("write text value");
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        char[] cArray2 = this._outputBuffer;
        int n4 = this._outputTail;
        this._outputTail = n4 + 1;
        cArray2[n4] = 34;
        this._writeString(cArray, n2, n3);
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        char[] cArray3 = this._outputBuffer;
        int n5 = this._outputTail;
        this._outputTail = n5 + 1;
        cArray3[n5] = 34;
    }

    @Override
    public void writeUTF8String(byte[] byArray, int n2, int n3) throws IOException, JsonGenerationException {
        this._reportUnsupportedOperation();
    }
}

