/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.json;

import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.base.ParserBase;
import com.fasterxml.jackson.core.io.CharTypes;
import com.fasterxml.jackson.core.io.IOContext;
import com.fasterxml.jackson.core.json.CoreVersion;
import com.fasterxml.jackson.core.sym.BytesToNameCanonicalizer;
import com.fasterxml.jackson.core.sym.Name;
import com.fasterxml.jackson.core.util.ByteArrayBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class UTF8StreamJsonParser
extends ParserBase {
    static final byte BYTE_LF = 10;
    private static final int[] sInputCodesLatin1;
    private static final int[] sInputCodesUtf8;
    protected boolean _bufferRecyclable;
    protected byte[] _inputBuffer;
    protected InputStream _inputStream;
    protected ObjectCodec _objectCodec;
    private int _quad1;
    protected int[] _quadBuffer = new int[16];
    protected final BytesToNameCanonicalizer _symbols;
    protected boolean _tokenIncomplete = false;

    static {
        sInputCodesUtf8 = CharTypes.getInputCodeUtf8();
        sInputCodesLatin1 = CharTypes.getInputCodeLatin1();
    }

    public UTF8StreamJsonParser(IOContext iOContext, int n2, InputStream inputStream, ObjectCodec objectCodec, BytesToNameCanonicalizer bytesToNameCanonicalizer, byte[] byArray, int n3, int n4, boolean bl2) {
        super(iOContext, n2);
        this._inputStream = inputStream;
        this._objectCodec = objectCodec;
        this._symbols = bytesToNameCanonicalizer;
        this._inputBuffer = byArray;
        this._inputPtr = n3;
        this._inputEnd = n4;
        this._bufferRecyclable = bl2;
    }

    private int _decodeUtf8_2(int n2) throws IOException, JsonParseException {
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        byte[] byArray = this._inputBuffer;
        int n3 = this._inputPtr;
        this._inputPtr = n3 + 1;
        byte by2 = byArray[n3];
        if ((by2 & 0xC0) != 128) {
            this._reportInvalidOther(by2 & 0xFF, this._inputPtr);
        }
        return (n2 & 0x1F) << 6 | by2 & 0x3F;
    }

    private int _decodeUtf8_3(int n2) throws IOException, JsonParseException {
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        int n3 = n2 & 0xF;
        byte[] byArray = this._inputBuffer;
        int n4 = this._inputPtr;
        this._inputPtr = n4 + 1;
        byte by2 = byArray[n4];
        if ((by2 & 0xC0) != 128) {
            this._reportInvalidOther(by2 & 0xFF, this._inputPtr);
        }
        int n5 = n3 << 6 | by2 & 0x3F;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        byte[] byArray2 = this._inputBuffer;
        int n6 = this._inputPtr;
        this._inputPtr = n6 + 1;
        byte by3 = byArray2[n6];
        if ((by3 & 0xC0) != 128) {
            this._reportInvalidOther(by3 & 0xFF, this._inputPtr);
        }
        return n5 << 6 | by3 & 0x3F;
    }

    private int _decodeUtf8_3fast(int n2) throws IOException, JsonParseException {
        int n3 = n2 & 0xF;
        byte[] byArray = this._inputBuffer;
        int n4 = this._inputPtr;
        this._inputPtr = n4 + 1;
        byte by2 = byArray[n4];
        if ((by2 & 0xC0) != 128) {
            this._reportInvalidOther(by2 & 0xFF, this._inputPtr);
        }
        int n5 = n3 << 6 | by2 & 0x3F;
        byte[] byArray2 = this._inputBuffer;
        int n6 = this._inputPtr;
        this._inputPtr = n6 + 1;
        byte by3 = byArray2[n6];
        if ((by3 & 0xC0) != 128) {
            this._reportInvalidOther(by3 & 0xFF, this._inputPtr);
        }
        return n5 << 6 | by3 & 0x3F;
    }

    private int _decodeUtf8_4(int n2) throws IOException, JsonParseException {
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        byte[] byArray = this._inputBuffer;
        int n3 = this._inputPtr;
        this._inputPtr = n3 + 1;
        byte by2 = byArray[n3];
        if ((by2 & 0xC0) != 128) {
            this._reportInvalidOther(by2 & 0xFF, this._inputPtr);
        }
        int n4 = (n2 & 7) << 6 | by2 & 0x3F;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        byte[] byArray2 = this._inputBuffer;
        int n5 = this._inputPtr;
        this._inputPtr = n5 + 1;
        byte by3 = byArray2[n5];
        if ((by3 & 0xC0) != 128) {
            this._reportInvalidOther(by3 & 0xFF, this._inputPtr);
        }
        int n6 = n4 << 6 | by3 & 0x3F;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        byte[] byArray3 = this._inputBuffer;
        int n7 = this._inputPtr;
        this._inputPtr = n7 + 1;
        byte by4 = byArray3[n7];
        if ((by4 & 0xC0) != 128) {
            this._reportInvalidOther(by4 & 0xFF, this._inputPtr);
        }
        return (n6 << 6 | by4 & 0x3F) - 65536;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void _finishString2(char[] cArray, int n2) throws IOException, JsonParseException {
        int[] nArray = sInputCodesUtf8;
        byte[] byArray = this._inputBuffer;
        while (true) {
            int n3;
            int n4;
            block17: {
                int n5;
                block16: {
                    int n6;
                    if ((n6 = this._inputPtr) >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                        n6 = this._inputPtr;
                    }
                    if (n2 >= cArray.length) {
                        cArray = this._textBuffer.finishCurrentSegment();
                        n2 = 0;
                    }
                    int n7 = Math.min(this._inputEnd, n6 + (cArray.length - n2));
                    int n8 = n6;
                    n5 = n2;
                    while (n8 < n7) {
                        int n9 = n8 + 1;
                        n4 = 0xFF & byArray[n8];
                        if (nArray[n4] != 0) {
                            this._inputPtr = n9;
                            if (n4 == 34) {
                                this._textBuffer.setCurrentLength(n5);
                                return;
                            }
                            break block16;
                        }
                        int n10 = n5 + 1;
                        cArray[n5] = (char)n4;
                        n8 = n9;
                        n5 = n10;
                    }
                    this._inputPtr = n8;
                    n2 = n5;
                    continue;
                }
                switch (nArray[n4]) {
                    default: {
                        if (n4 >= 32) break;
                        this._throwUnquotedSpace(n4, "string value");
                        n3 = n5;
                        break block17;
                    }
                    case 1: {
                        n4 = this._decodeEscaped();
                        n3 = n5;
                        break block17;
                    }
                    case 2: {
                        n4 = this._decodeUtf8_2(n4);
                        n3 = n5;
                        break block17;
                    }
                    case 3: {
                        if (this._inputEnd - this._inputPtr >= 2) {
                            n4 = this._decodeUtf8_3fast(n4);
                            n3 = n5;
                            break block17;
                        } else {
                            n4 = this._decodeUtf8_3(n4);
                            n3 = n5;
                        }
                        break block17;
                    }
                    case 4: {
                        int n11 = this._decodeUtf8_4(n4);
                        n3 = n5 + 1;
                        cArray[n5] = (char)(0xD800 | n11 >> 10);
                        if (n3 >= cArray.length) {
                            cArray = this._textBuffer.finishCurrentSegment();
                            n3 = 0;
                        }
                        n4 = 0xDC00 | n11 & 0x3FF;
                        break block17;
                    }
                }
                this._reportInvalidChar(n4);
                n3 = n5;
            }
            if (n3 >= cArray.length) {
                cArray = this._textBuffer.finishCurrentSegment();
                n3 = 0;
            }
            int n12 = n3 + 1;
            cArray[n3] = (char)n4;
            n2 = n12;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean _isNextTokenNameMaybe(int n2, SerializableString serializableString) throws IOException, JsonParseException {
        JsonToken jsonToken;
        int n3;
        String string2 = this._parseFieldName(n2).getName();
        this._parsingContext.setCurrentName(string2);
        boolean bl2 = string2.equals(serializableString.getValue());
        this._currToken = JsonToken.FIELD_NAME;
        int n4 = this._skipWS();
        if (n4 != 58) {
            this._reportUnexpectedChar(n4, "was expecting a colon to separate field name and value");
        }
        if ((n3 = this._skipWS()) == 34) {
            this._tokenIncomplete = true;
            this._nextToken = JsonToken.VALUE_STRING;
            return bl2;
        }
        switch (n3) {
            default: {
                jsonToken = this._handleUnexpectedValue(n3);
                break;
            }
            case 91: {
                jsonToken = JsonToken.START_ARRAY;
                break;
            }
            case 123: {
                jsonToken = JsonToken.START_OBJECT;
                break;
            }
            case 93: 
            case 125: {
                this._reportUnexpectedChar(n3, "expected a value");
            }
            case 116: {
                this._matchToken("true", 1);
                jsonToken = JsonToken.VALUE_TRUE;
                break;
            }
            case 102: {
                this._matchToken("false", 1);
                jsonToken = JsonToken.VALUE_FALSE;
                break;
            }
            case 110: {
                this._matchToken("null", 1);
                jsonToken = JsonToken.VALUE_NULL;
                break;
            }
            case 45: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                jsonToken = this.parseNumberText(n3);
            }
        }
        this._nextToken = jsonToken;
        return bl2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void _isNextTokenNameYes() throws IOException, JsonParseException {
        int n2;
        if (this._inputPtr < this._inputEnd && this._inputBuffer[this._inputPtr] == 58) {
            this._inputPtr = 1 + this._inputPtr;
            byte[] byArray = this._inputBuffer;
            int n3 = this._inputPtr;
            this._inputPtr = n3 + 1;
            byte by2 = byArray[n3];
            if (by2 == 34) {
                this._tokenIncomplete = true;
                this._nextToken = JsonToken.VALUE_STRING;
                return;
            }
            if (by2 == 123) {
                this._nextToken = JsonToken.START_OBJECT;
                return;
            }
            if (by2 == 91) {
                this._nextToken = JsonToken.START_ARRAY;
                return;
            }
            n2 = by2 & 0xFF;
            if (n2 <= 32 || n2 == 47) {
                this._inputPtr = -1 + this._inputPtr;
                n2 = this._skipWS();
            }
        } else {
            n2 = this._skipColon();
        }
        switch (n2) {
            default: {
                this._nextToken = this._handleUnexpectedValue(n2);
                return;
            }
            case 34: {
                this._tokenIncomplete = true;
                this._nextToken = JsonToken.VALUE_STRING;
                return;
            }
            case 91: {
                this._nextToken = JsonToken.START_ARRAY;
                return;
            }
            case 123: {
                this._nextToken = JsonToken.START_OBJECT;
                return;
            }
            case 93: 
            case 125: {
                this._reportUnexpectedChar(n2, "expected a value");
            }
            case 116: {
                this._matchToken("true", 1);
                this._nextToken = JsonToken.VALUE_TRUE;
                return;
            }
            case 102: {
                this._matchToken("false", 1);
                this._nextToken = JsonToken.VALUE_FALSE;
                return;
            }
            case 110: {
                this._matchToken("null", 1);
                this._nextToken = JsonToken.VALUE_NULL;
                return;
            }
            case 45: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
        }
        this._nextToken = this.parseNumberText(n2);
    }

    /*
     * Enabled aggressive block sorting
     */
    private JsonToken _nextAfterName() {
        this._nameCopied = false;
        JsonToken jsonToken = this._nextToken;
        this._nextToken = null;
        if (jsonToken == JsonToken.START_ARRAY) {
            this._parsingContext = this._parsingContext.createChildArrayContext(this._tokenInputRow, this._tokenInputCol);
        } else if (jsonToken == JsonToken.START_OBJECT) {
            this._parsingContext = this._parsingContext.createChildObjectContext(this._tokenInputRow, this._tokenInputCol);
        }
        this._currToken = jsonToken;
        return jsonToken;
    }

    private JsonToken _nextTokenNotInObject(int n2) throws IOException, JsonParseException {
        JsonToken jsonToken;
        if (n2 == 34) {
            JsonToken jsonToken2;
            this._tokenIncomplete = true;
            this._currToken = jsonToken2 = JsonToken.VALUE_STRING;
            return jsonToken2;
        }
        switch (n2) {
            default: {
                JsonToken jsonToken3;
                this._currToken = jsonToken3 = this._handleUnexpectedValue(n2);
                return jsonToken3;
            }
            case 91: {
                JsonToken jsonToken4;
                this._parsingContext = this._parsingContext.createChildArrayContext(this._tokenInputRow, this._tokenInputCol);
                this._currToken = jsonToken4 = JsonToken.START_ARRAY;
                return jsonToken4;
            }
            case 123: {
                JsonToken jsonToken5;
                this._parsingContext = this._parsingContext.createChildObjectContext(this._tokenInputRow, this._tokenInputCol);
                this._currToken = jsonToken5 = JsonToken.START_OBJECT;
                return jsonToken5;
            }
            case 93: 
            case 125: {
                this._reportUnexpectedChar(n2, "expected a value");
            }
            case 116: {
                JsonToken jsonToken6;
                this._matchToken("true", 1);
                this._currToken = jsonToken6 = JsonToken.VALUE_TRUE;
                return jsonToken6;
            }
            case 102: {
                JsonToken jsonToken7;
                this._matchToken("false", 1);
                this._currToken = jsonToken7 = JsonToken.VALUE_FALSE;
                return jsonToken7;
            }
            case 110: {
                JsonToken jsonToken8;
                this._matchToken("null", 1);
                this._currToken = jsonToken8 = JsonToken.VALUE_NULL;
                return jsonToken8;
            }
            case 45: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
        }
        this._currToken = jsonToken = this.parseNumberText(n2);
        return jsonToken;
    }

    /*
     * Enabled aggressive block sorting
     */
    private JsonToken _parseFloatText(char[] cArray, int n2, int n3, boolean bl2, int n4) throws IOException, JsonParseException {
        int n5;
        int n6;
        boolean bl3;
        block19: {
            block18: {
                bl3 = false;
                n6 = 0;
                if (n3 == 46) {
                    int n7 = n2 + 1;
                    cArray[n2] = (char)n3;
                    n2 = n7;
                    while (true) {
                        if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                            bl3 = true;
                            break;
                        }
                        byte[] byArray = this._inputBuffer;
                        int n8 = this._inputPtr;
                        this._inputPtr = n8 + 1;
                        n3 = 0xFF & byArray[n8];
                        bl3 = false;
                        if (n3 < 48) break;
                        bl3 = false;
                        if (n3 > 57) break;
                        ++n6;
                        if (n2 >= cArray.length) {
                            cArray = this._textBuffer.finishCurrentSegment();
                            n2 = 0;
                        }
                        int n9 = n2 + 1;
                        cArray[n2] = (char)n3;
                        n2 = n9;
                    }
                    if (n6 == 0) {
                        this.reportUnexpectedNumberChar(n3, "Decimal point not followed by a digit");
                    }
                }
                n5 = 0;
                if (n3 == 101) break block18;
                n5 = 0;
                if (n3 != 69) break block19;
            }
            if (n2 >= cArray.length) {
                cArray = this._textBuffer.finishCurrentSegment();
                n2 = 0;
            }
            int n10 = n2 + 1;
            cArray[n2] = (char)n3;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            byte[] byArray = this._inputBuffer;
            int n11 = this._inputPtr;
            this._inputPtr = n11 + 1;
            int n12 = 0xFF & byArray[n11];
            if (n12 == 45 || n12 == 43) {
                int n13;
                if (n10 >= cArray.length) {
                    cArray = this._textBuffer.finishCurrentSegment();
                    n13 = 0;
                } else {
                    n13 = n10;
                }
                int n14 = n13 + 1;
                cArray[n13] = (char)n12;
                if (this._inputPtr >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                }
                byte[] byArray2 = this._inputBuffer;
                int n15 = this._inputPtr;
                this._inputPtr = n15 + 1;
                n12 = 0xFF & byArray2[n15];
                n2 = n14;
            } else {
                n2 = n10;
                n5 = 0;
            }
            while (true) {
                int n16;
                block21: {
                    block20: {
                        if (n12 > 57 || n12 < 48) break block20;
                        ++n5;
                        if (n2 >= cArray.length) {
                            cArray = this._textBuffer.finishCurrentSegment();
                            n2 = 0;
                        }
                        n16 = n2 + 1;
                        cArray[n2] = (char)n12;
                        if (this._inputPtr < this._inputEnd || this.loadMore()) break block21;
                        bl3 = true;
                        n2 = n16;
                    }
                    if (n5 != 0) break;
                    this.reportUnexpectedNumberChar(n12, "Exponent indicator not followed by a digit");
                    break;
                }
                byte[] byArray3 = this._inputBuffer;
                int n17 = this._inputPtr;
                this._inputPtr = n17 + 1;
                n12 = 0xFF & byArray3[n17];
                n2 = n16;
            }
        }
        if (!bl3) {
            this._inputPtr = -1 + this._inputPtr;
        }
        this._textBuffer.setCurrentLength(n2);
        return this.resetFloat(bl2, n4, n6, n5);
    }

    private JsonToken _parserNumber2(char[] cArray, int n2, boolean bl2, int n3) throws IOException, JsonParseException {
        while (true) {
            if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                this._textBuffer.setCurrentLength(n2);
                return this.resetInt(bl2, n3);
            }
            byte[] byArray = this._inputBuffer;
            int n4 = this._inputPtr;
            this._inputPtr = n4 + 1;
            int n5 = 0xFF & byArray[n4];
            if (n5 > 57 || n5 < 48) {
                if (n5 != 46 && n5 != 101 && n5 != 69) break;
                return this._parseFloatText(cArray, n2, n5, bl2, n3);
            }
            if (n2 >= cArray.length) {
                cArray = this._textBuffer.finishCurrentSegment();
                n2 = 0;
            }
            int n6 = n2 + 1;
            cArray[n2] = (char)n5;
            ++n3;
            n2 = n6;
        }
        this._inputPtr = -1 + this._inputPtr;
        this._textBuffer.setCurrentLength(n2);
        return this.resetInt(bl2, n3);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void _skipCComment() throws IOException, JsonParseException {
        int[] nArray = CharTypes.getInputCodeComment();
        block8: while (this._inputPtr < this._inputEnd || this.loadMore()) {
            byte[] byArray = this._inputBuffer;
            int n2 = this._inputPtr;
            this._inputPtr = n2 + 1;
            int n3 = 0xFF & byArray[n2];
            int n4 = nArray[n3];
            if (n4 == 0) continue;
            switch (n4) {
                default: {
                    this._reportInvalidChar(n3);
                    continue block8;
                }
                case 42: {
                    if (this._inputPtr >= this._inputEnd && !this.loadMore()) break block8;
                    if (this._inputBuffer[this._inputPtr] != 47) continue block8;
                    this._inputPtr = 1 + this._inputPtr;
                    return;
                }
                case 10: {
                    this._skipLF();
                    continue block8;
                }
                case 13: {
                    this._skipCR();
                    continue block8;
                }
                case 2: {
                    this._skipUtf8_2(n3);
                    continue block8;
                }
                case 3: {
                    this._skipUtf8_3(n3);
                    continue block8;
                }
                case 4: {
                    this._skipUtf8_4(n3);
                    continue block8;
                }
            }
        }
        this._reportInvalidEOF(" in a comment");
    }

    /*
     * Handled duff style switch with additional control
     * Enabled aggressive block sorting
     */
    private int _skipColon() throws IOException, JsonParseException {
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        byte[] byArray = this._inputBuffer;
        int n2 = this._inputPtr;
        this._inputPtr = n2 + 1;
        byte by2 = byArray[n2];
        if (by2 == 58) {
            int n3;
            if (this._inputPtr < this._inputEnd && (n3 = 0xFF & this._inputBuffer[this._inputPtr]) > 32 && n3 != 47) {
                this._inputPtr = 1 + this._inputPtr;
                return n3;
            }
        } else {
            int n4 = by2 & 0xFF;
            block6: while (true) {
                int n5 = 0;
                block7: do {
                    switch (n5 == 0 ? n4 : n5) {
                        default: {
                            if (n4 < 32) {
                                this._throwInvalidSpace(n4);
                            }
                            if (n4 == 58) break;
                            this._reportUnexpectedChar(n4, "was expecting a colon to separate field name and value");
                            break;
                        }
                        case 13: {
                            this._skipCR();
                            n5 = 9;
                            continue block7;
                        }
                        case 10: {
                            this._skipLF();
                            n5 = 9;
                            continue block7;
                        }
                        case 47: {
                            this._skipComment();
                        }
                        case 9: 
                        case 32: {
                            if (this._inputPtr >= this._inputEnd) {
                                this.loadMoreGuaranteed();
                            }
                            byte[] byArray2 = this._inputBuffer;
                            int n6 = this._inputPtr;
                            this._inputPtr = n6 + 1;
                            n4 = 0xFF & byArray2[n6];
                            continue block6;
                        }
                    }
                    break block6;
                } while (true);
                break;
            }
        }
        while (this._inputPtr < this._inputEnd || this.loadMore()) {
            byte[] byArray3 = this._inputBuffer;
            int n7 = this._inputPtr;
            this._inputPtr = n7 + 1;
            int n8 = 0xFF & byArray3[n7];
            if (n8 > 32) {
                if (n8 != 47) {
                    return n8;
                }
                this._skipComment();
                continue;
            }
            if (n8 == 32) continue;
            if (n8 == 10) {
                this._skipLF();
                continue;
            }
            if (n8 == 13) {
                this._skipCR();
                continue;
            }
            if (n8 == 9) continue;
            this._throwInvalidSpace(n8);
        }
        throw this._constructError("Unexpected end-of-input within/between " + this._parsingContext.getTypeDesc() + " entries");
    }

    private void _skipComment() throws IOException, JsonParseException {
        if (!this.isEnabled(JsonParser.Feature.ALLOW_COMMENTS)) {
            this._reportUnexpectedChar(47, "maybe a (non-standard) comment? (not recognized as one since Feature 'ALLOW_COMMENTS' not enabled for parser)");
        }
        if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
            this._reportInvalidEOF(" in a comment");
        }
        byte[] byArray = this._inputBuffer;
        int n2 = this._inputPtr;
        this._inputPtr = n2 + 1;
        int n3 = 0xFF & byArray[n2];
        if (n3 == 47) {
            this._skipCppComment();
            return;
        }
        if (n3 == 42) {
            this._skipCComment();
            return;
        }
        this._reportUnexpectedChar(n3, "was expecting either '*' or '/' for a comment");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void _skipCppComment() throws IOException, JsonParseException {
        int[] nArray = CharTypes.getInputCodeComment();
        block8: while (!(this._inputPtr >= this._inputEnd && !this.loadMore())) {
            byte[] byArray = this._inputBuffer;
            int n2 = this._inputPtr;
            this._inputPtr = n2 + 1;
            int n3 = 0xFF & byArray[n2];
            int n4 = nArray[n3];
            if (n4 == 0) continue;
            switch (n4) {
                case 42: {
                    continue block8;
                }
                default: {
                    this._reportInvalidChar(n3);
                    continue block8;
                }
                case 10: {
                    this._skipLF();
                    return;
                }
                case 13: {
                    this._skipCR();
                    return;
                }
                case 2: {
                    this._skipUtf8_2(n3);
                    continue block8;
                }
                case 3: {
                    this._skipUtf8_3(n3);
                    continue block8;
                }
                case 4: 
            }
            this._skipUtf8_4(n3);
        }
    }

    private void _skipUtf8_2(int n2) throws IOException, JsonParseException {
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        byte[] byArray = this._inputBuffer;
        int n3 = this._inputPtr;
        this._inputPtr = n3 + 1;
        byte by2 = byArray[n3];
        if ((by2 & 0xC0) != 128) {
            this._reportInvalidOther(by2 & 0xFF, this._inputPtr);
        }
    }

    private void _skipUtf8_3(int n2) throws IOException, JsonParseException {
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        byte[] byArray = this._inputBuffer;
        int n3 = this._inputPtr;
        this._inputPtr = n3 + 1;
        byte by2 = byArray[n3];
        if ((by2 & 0xC0) != 128) {
            this._reportInvalidOther(by2 & 0xFF, this._inputPtr);
        }
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        byte[] byArray2 = this._inputBuffer;
        int n4 = this._inputPtr;
        this._inputPtr = n4 + 1;
        byte by3 = byArray2[n4];
        if ((by3 & 0xC0) != 128) {
            this._reportInvalidOther(by3 & 0xFF, this._inputPtr);
        }
    }

    private void _skipUtf8_4(int n2) throws IOException, JsonParseException {
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        byte[] byArray = this._inputBuffer;
        int n3 = this._inputPtr;
        this._inputPtr = n3 + 1;
        byte by2 = byArray[n3];
        if ((by2 & 0xC0) != 128) {
            this._reportInvalidOther(by2 & 0xFF, this._inputPtr);
        }
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        byte[] byArray2 = this._inputBuffer;
        int n4 = this._inputPtr;
        this._inputPtr = n4 + 1;
        byte by3 = byArray2[n4];
        if ((by3 & 0xC0) != 128) {
            this._reportInvalidOther(by3 & 0xFF, this._inputPtr);
        }
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        byte[] byArray3 = this._inputBuffer;
        int n5 = this._inputPtr;
        this._inputPtr = n5 + 1;
        byte by4 = byArray3[n5];
        if ((by4 & 0xC0) != 128) {
            this._reportInvalidOther(by4 & 0xFF, this._inputPtr);
        }
    }

    private int _skipWS() throws IOException, JsonParseException {
        while (this._inputPtr < this._inputEnd || this.loadMore()) {
            byte[] byArray = this._inputBuffer;
            int n2 = this._inputPtr;
            this._inputPtr = n2 + 1;
            int n3 = 0xFF & byArray[n2];
            if (n3 > 32) {
                if (n3 != 47) {
                    return n3;
                }
                this._skipComment();
                continue;
            }
            if (n3 == 32) continue;
            if (n3 == 10) {
                this._skipLF();
                continue;
            }
            if (n3 == 13) {
                this._skipCR();
                continue;
            }
            if (n3 == 9) continue;
            this._throwInvalidSpace(n3);
        }
        throw this._constructError("Unexpected end-of-input within/between " + this._parsingContext.getTypeDesc() + " entries");
    }

    private int _skipWSOrEnd() throws IOException, JsonParseException {
        while (this._inputPtr < this._inputEnd || this.loadMore()) {
            byte[] byArray = this._inputBuffer;
            int n2 = this._inputPtr;
            this._inputPtr = n2 + 1;
            int n3 = 0xFF & byArray[n2];
            if (n3 > 32) {
                if (n3 != 47) {
                    return n3;
                }
                this._skipComment();
                continue;
            }
            if (n3 == 32) continue;
            if (n3 == 10) {
                this._skipLF();
                continue;
            }
            if (n3 == 13) {
                this._skipCR();
                continue;
            }
            if (n3 == 9) continue;
            this._throwInvalidSpace(n3);
        }
        this._handleEOF();
        return -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int _verifyNoLeadingZeroes() throws IOException, JsonParseException {
        if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
            return 48;
        }
        int n2 = 0xFF & this._inputBuffer[this._inputPtr];
        if (n2 < 48) return 48;
        if (n2 > 57) {
            return 48;
        }
        if (!this.isEnabled(JsonParser.Feature.ALLOW_NUMERIC_LEADING_ZEROS)) {
            this.reportInvalidNumber("Leading zeroes not allowed");
        }
        this._inputPtr = 1 + this._inputPtr;
        if (n2 != 48) return n2;
        do {
            if (this._inputPtr >= this._inputEnd) {
                if (!this.loadMore()) return n2;
            }
            if ((n2 = 0xFF & this._inputBuffer[this._inputPtr]) < 48) return 48;
            if (n2 > 57) {
                return 48;
            }
            this._inputPtr = 1 + this._inputPtr;
        } while (n2 == 48);
        return n2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private Name addName(int[] nArray, int n2, int n3) throws JsonParseException {
        int n4;
        int n5 = n3 + (-4 + (n2 << 2));
        if (n3 < 4) {
            n4 = nArray[n2 - 1];
            nArray[n2 - 1] = n4 << (4 - n3 << 3);
        } else {
            n4 = 0;
        }
        char[] cArray = this._textBuffer.emptyAndGetCurrentSegment();
        int n6 = 0;
        int n7 = 0;
        while (true) {
            int n8;
            int n9;
            block20: {
                block19: {
                    block18: {
                        int n10;
                        int n11;
                        if (n6 >= n5) break block18;
                        n9 = 0xFF & nArray[n6 >> 2] >> (3 - (n6 & 3) << 3);
                        ++n6;
                        if (n9 <= 127) break block19;
                        if ((n9 & 0xE0) == 192) {
                            n11 = n9 & 0x1F;
                            n10 = 1;
                        } else if ((n9 & 0xF0) == 224) {
                            n11 = n9 & 0xF;
                            n10 = 2;
                        } else if ((n9 & 0xF8) == 240) {
                            n11 = n9 & 7;
                            n10 = 3;
                        } else {
                            this._reportInvalidInitial(n9);
                            n10 = n11 = 1;
                        }
                        if (n6 + n10 > n5) {
                            this._reportInvalidEOF(" in field name");
                        }
                        int n12 = nArray[n6 >> 2] >> (3 - (n6 & 3) << 3);
                        ++n6;
                        if ((n12 & 0xC0) != 128) {
                            this._reportInvalidOther(n12);
                        }
                        n9 = n11 << 6 | n12 & 0x3F;
                        if (n10 > 1) {
                            int n13 = nArray[n6 >> 2] >> (3 - (n6 & 3) << 3);
                            ++n6;
                            if ((n13 & 0xC0) != 128) {
                                this._reportInvalidOther(n13);
                            }
                            n9 = n9 << 6 | n13 & 0x3F;
                            if (n10 > 2) {
                                int n14 = nArray[n6 >> 2] >> (3 - (n6 & 3) << 3);
                                ++n6;
                                if ((n14 & 0xC0) != 128) {
                                    this._reportInvalidOther(n14 & 0xFF);
                                }
                                n9 = n9 << 6 | n14 & 0x3F;
                            }
                        }
                        if (n10 <= 2) break block19;
                        int n15 = n9 - 65536;
                        if (n7 >= cArray.length) {
                            cArray = this._textBuffer.expandCurrentSegment();
                        }
                        n8 = n7 + 1;
                        cArray[n7] = (char)(55296 + (n15 >> 10));
                        n9 = 0xDC00 | n15 & 0x3FF;
                        break block20;
                    }
                    String string2 = new String(cArray, 0, n7);
                    if (n3 < 4) {
                        nArray[n2 - 1] = n4;
                    }
                    return this._symbols.addName(string2, nArray, n2);
                }
                n8 = n7;
            }
            if (n8 >= cArray.length) {
                cArray = this._textBuffer.expandCurrentSegment();
            }
            n7 = n8 + 1;
            cArray[n8] = (char)n9;
        }
    }

    private Name findName(int n2, int n3) throws JsonParseException {
        Name name = this._symbols.findName(n2);
        if (name != null) {
            return name;
        }
        this._quadBuffer[0] = n2;
        return this.addName(this._quadBuffer, 1, n3);
    }

    private Name findName(int n2, int n3, int n4) throws JsonParseException {
        Name name = this._symbols.findName(n2, n3);
        if (name != null) {
            return name;
        }
        this._quadBuffer[0] = n2;
        this._quadBuffer[1] = n3;
        return this.addName(this._quadBuffer, 2, n4);
    }

    private Name findName(int[] nArray, int n2, int n3, int n4) throws JsonParseException {
        if (n2 >= nArray.length) {
            nArray = UTF8StreamJsonParser.growArrayBy(nArray, nArray.length);
            this._quadBuffer = nArray;
        }
        int n5 = n2 + 1;
        nArray[n2] = n3;
        Name name = this._symbols.findName(nArray, n5);
        if (name == null) {
            name = this.addName(nArray, n5, n4);
        }
        return name;
    }

    public static int[] growArrayBy(int[] nArray, int n2) {
        if (nArray == null) {
            return new int[n2];
        }
        int n3 = nArray.length;
        int[] nArray2 = new int[n3 + n2];
        System.arraycopy(nArray, 0, nArray2, 0, n3);
        return nArray2;
    }

    private int nextByte() throws IOException, JsonParseException {
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        byte[] byArray = this._inputBuffer;
        int n2 = this._inputPtr;
        this._inputPtr = n2 + 1;
        return 0xFF & byArray[n2];
    }

    private Name parseFieldName(int n2, int n3, int n4) throws IOException, JsonParseException {
        return this.parseEscapedFieldName(this._quadBuffer, 0, n2, n3, n4);
    }

    private Name parseFieldName(int n2, int n3, int n4, int n5) throws IOException, JsonParseException {
        this._quadBuffer[0] = n2;
        return this.parseEscapedFieldName(this._quadBuffer, 1, n3, n4, n5);
    }

    @Override
    protected void _closeInput() throws IOException {
        if (this._inputStream != null) {
            if (this._ioContext.isResourceManaged() || this.isEnabled(JsonParser.Feature.AUTO_CLOSE_SOURCE)) {
                this._inputStream.close();
            }
            this._inputStream = null;
        }
    }

    protected byte[] _decodeBase64(Base64Variant base64Variant) throws IOException, JsonParseException {
        ByteArrayBuilder byteArrayBuilder = this._getByteArrayBuilder();
        while (true) {
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            byte[] byArray = this._inputBuffer;
            int n2 = this._inputPtr;
            this._inputPtr = n2 + 1;
            int n3 = 0xFF & byArray[n2];
            if (n3 <= 32) continue;
            int n4 = base64Variant.decodeBase64Char(n3);
            if (n4 < 0) {
                if (n3 == 34) {
                    return byteArrayBuilder.toByteArray();
                }
                n4 = this._decodeBase64Escape(base64Variant, n3, 0);
                if (n4 < 0) continue;
            }
            int n5 = n4;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            byte[] byArray2 = this._inputBuffer;
            int n6 = this._inputPtr;
            this._inputPtr = n6 + 1;
            int n7 = 0xFF & byArray2[n6];
            int n8 = base64Variant.decodeBase64Char(n7);
            if (n8 < 0) {
                n8 = this._decodeBase64Escape(base64Variant, n7, 1);
            }
            int n9 = n8 | n5 << 6;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            byte[] byArray3 = this._inputBuffer;
            int n10 = this._inputPtr;
            this._inputPtr = n10 + 1;
            int n11 = 0xFF & byArray3[n10];
            int n12 = base64Variant.decodeBase64Char(n11);
            if (n12 < 0) {
                if (n12 != -2) {
                    if (n11 == 34 && !base64Variant.usesPadding()) {
                        byteArrayBuilder.append(n9 >> 4);
                        return byteArrayBuilder.toByteArray();
                    }
                    n12 = this._decodeBase64Escape(base64Variant, n11, 2);
                }
                if (n12 == -2) {
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    byte[] byArray4 = this._inputBuffer;
                    int n13 = this._inputPtr;
                    this._inputPtr = n13 + 1;
                    int n14 = 0xFF & byArray4[n13];
                    if (!base64Variant.usesPaddingChar(n14)) {
                        throw this.reportInvalidBase64Char(base64Variant, n14, 3, "expected padding character '" + base64Variant.getPaddingChar() + "'");
                    }
                    byteArrayBuilder.append(n9 >> 4);
                    continue;
                }
            }
            int n15 = n12 | n9 << 6;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            byte[] byArray5 = this._inputBuffer;
            int n16 = this._inputPtr;
            this._inputPtr = n16 + 1;
            int n17 = 0xFF & byArray5[n16];
            int n18 = base64Variant.decodeBase64Char(n17);
            if (n18 < 0) {
                if (n18 != -2) {
                    if (n17 == 34 && !base64Variant.usesPadding()) {
                        byteArrayBuilder.appendTwoBytes(n15 >> 2);
                        return byteArrayBuilder.toByteArray();
                    }
                    n18 = this._decodeBase64Escape(base64Variant, n17, 3);
                }
                if (n18 == -2) {
                    byteArrayBuilder.appendTwoBytes(n15 >> 2);
                    continue;
                }
            }
            byteArrayBuilder.appendThreeBytes(n18 | n15 << 6);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected int _decodeCharForError(int n2) throws IOException, JsonParseException {
        int n3;
        int n4;
        int n5 = n2;
        if (n5 >= 0) return n5;
        if ((n5 & 0xE0) == 192) {
            n5 &= 0x1F;
            n4 = 1;
        } else if ((n5 & 0xF0) == 224) {
            n5 &= 0xF;
            n4 = 2;
        } else if ((n5 & 0xF8) == 240) {
            n5 &= 7;
            n4 = 3;
        } else {
            this._reportInvalidInitial(n5 & 0xFF);
            n4 = 1;
        }
        if (((n3 = this.nextByte()) & 0xC0) != 128) {
            this._reportInvalidOther(n3 & 0xFF);
        }
        n5 = n5 << 6 | n3 & 0x3F;
        if (n4 <= 1) return n5;
        int n6 = this.nextByte();
        if ((n6 & 0xC0) != 128) {
            this._reportInvalidOther(n6 & 0xFF);
        }
        n5 = n5 << 6 | n6 & 0x3F;
        if (n4 <= 2) return n5;
        int n7 = this.nextByte();
        if ((n7 & 0xC0) == 128) return n5 << 6 | n7 & 0x3F;
        this._reportInvalidOther(n7 & 0xFF);
        return n5 << 6 | n7 & 0x3F;
    }

    @Override
    protected char _decodeEscaped() throws IOException, JsonParseException {
        if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
            this._reportInvalidEOF(" in character escape sequence");
        }
        byte[] byArray = this._inputBuffer;
        int n2 = this._inputPtr;
        this._inputPtr = n2 + 1;
        byte by2 = byArray[n2];
        switch (by2) {
            default: {
                return this._handleUnrecognizedCharacterEscape((char)this._decodeCharForError(by2));
            }
            case 98: {
                return '\b';
            }
            case 116: {
                return '\t';
            }
            case 110: {
                return '\n';
            }
            case 102: {
                return '\f';
            }
            case 114: {
                return '\r';
            }
            case 34: 
            case 47: 
            case 92: {
                return (char)by2;
            }
            case 117: 
        }
        int n3 = 0;
        for (int i2 = 0; i2 < 4; ++i2) {
            if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                this._reportInvalidEOF(" in character escape sequence");
            }
            byte[] byArray2 = this._inputBuffer;
            int n4 = this._inputPtr;
            this._inputPtr = n4 + 1;
            byte by3 = byArray2[n4];
            int n5 = CharTypes.charToHex(by3);
            if (n5 < 0) {
                this._reportUnexpectedChar(by3, "expected a hex-digit for character escape sequence");
            }
            n3 = n5 | n3 << 4;
        }
        return (char)n3;
    }

    @Override
    protected void _finishString() throws IOException, JsonParseException {
        int n2 = this._inputPtr;
        if (n2 >= this._inputEnd) {
            this.loadMoreGuaranteed();
            n2 = this._inputPtr;
        }
        char[] cArray = this._textBuffer.emptyAndGetCurrentSegment();
        int[] nArray = sInputCodesUtf8;
        int n3 = Math.min(this._inputEnd, n2 + cArray.length);
        byte[] byArray = this._inputBuffer;
        int n4 = 0;
        while (n2 < n3) {
            int n5 = 0xFF & byArray[n2];
            if (nArray[n5] != 0) {
                if (n5 != 34) break;
                this._inputPtr = n2 + 1;
                this._textBuffer.setCurrentLength(n4);
                return;
            }
            ++n2;
            int n6 = n4 + 1;
            cArray[n4] = (char)n5;
            n4 = n6;
        }
        this._inputPtr = n2;
        this._finishString2(cArray, n4);
    }

    protected String _getText2(JsonToken jsonToken) {
        if (jsonToken == null) {
            return null;
        }
        switch (jsonToken) {
            default: {
                return jsonToken.asString();
            }
            case FIELD_NAME: {
                return this._parsingContext.getCurrentName();
            }
            case VALUE_STRING: 
            case VALUE_NUMBER_INT: 
            case VALUE_NUMBER_FLOAT: 
        }
        return this._textBuffer.contentsAsString();
    }

    /*
     * Enabled aggressive block sorting
     */
    protected JsonToken _handleApostropheValue() throws IOException, JsonParseException {
        int n2 = 0;
        char[] cArray = this._textBuffer.emptyAndGetCurrentSegment();
        int[] nArray = sInputCodesUtf8;
        byte[] byArray = this._inputBuffer;
        block6: while (true) {
            int n3;
            int n4;
            int n5;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if (n2 >= cArray.length) {
                cArray = this._textBuffer.finishCurrentSegment();
                n2 = 0;
            }
            if ((n5 = this._inputPtr + (cArray.length - n2)) < (n4 = this._inputEnd)) {
                n4 = n5;
            }
            while (true) {
                if (this._inputPtr >= n4) continue block6;
                int n6 = this._inputPtr;
                this._inputPtr = n6 + 1;
                n3 = 0xFF & byArray[n6];
                if (n3 == 39 || nArray[n3] != 0) {
                    if (n3 != 39) break;
                    this._textBuffer.setCurrentLength(n2);
                    return JsonToken.VALUE_STRING;
                }
                int n7 = n2 + 1;
                cArray[n2] = (char)n3;
                n2 = n7;
            }
            switch (nArray[n3]) {
                default: {
                    if (n3 < 32) {
                        this._throwUnquotedSpace(n3, "string value");
                    }
                    this._reportInvalidChar(n3);
                    break;
                }
                case 1: {
                    if (n3 == 34) break;
                    n3 = this._decodeEscaped();
                    break;
                }
                case 2: {
                    n3 = this._decodeUtf8_2(n3);
                    break;
                }
                case 3: {
                    if (this._inputEnd - this._inputPtr >= 2) {
                        n3 = this._decodeUtf8_3fast(n3);
                        break;
                    }
                    n3 = this._decodeUtf8_3(n3);
                    break;
                }
                case 4: {
                    int n8 = this._decodeUtf8_4(n3);
                    int n9 = n2 + 1;
                    cArray[n2] = (char)(0xD800 | n8 >> 10);
                    if (n9 >= cArray.length) {
                        cArray = this._textBuffer.finishCurrentSegment();
                        n2 = 0;
                    } else {
                        n2 = n9;
                    }
                    n3 = 0xDC00 | n8 & 0x3FF;
                }
            }
            if (n2 >= cArray.length) {
                cArray = this._textBuffer.finishCurrentSegment();
                n2 = 0;
            }
            int n10 = n2 + 1;
            cArray[n2] = (char)n3;
            n2 = n10;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected JsonToken _handleInvalidNumberStart(int n2, boolean bl2) throws IOException, JsonParseException {
        double d2 = Double.NEGATIVE_INFINITY;
        if (n2 == 73) {
            if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                this._reportInvalidEOFInValue();
            }
            byte[] byArray = this._inputBuffer;
            int n3 = this._inputPtr;
            this._inputPtr = n3 + 1;
            n2 = byArray[n3];
            if (n2 == 78) {
                String string2 = bl2 ? "-INF" : "+INF";
                this._matchToken(string2, 3);
                if (this.isEnabled(JsonParser.Feature.ALLOW_NON_NUMERIC_NUMBERS)) {
                    if (bl2) {
                        return this.resetAsNaN(string2, d2);
                    }
                    d2 = Double.POSITIVE_INFINITY;
                    return this.resetAsNaN(string2, d2);
                }
                this._reportError("Non-standard token '" + string2 + "': enable JsonParser.Feature.ALLOW_NON_NUMERIC_NUMBERS to allow");
            } else if (n2 == 110) {
                String string3 = bl2 ? "-Infinity" : "+Infinity";
                this._matchToken(string3, 3);
                if (this.isEnabled(JsonParser.Feature.ALLOW_NON_NUMERIC_NUMBERS)) {
                    if (bl2) {
                        return this.resetAsNaN(string3, d2);
                    }
                    d2 = Double.POSITIVE_INFINITY;
                    return this.resetAsNaN(string3, d2);
                }
                this._reportError("Non-standard token '" + string3 + "': enable JsonParser.Feature.ALLOW_NON_NUMERIC_NUMBERS to allow");
            }
        }
        this.reportUnexpectedNumberChar(n2, "expected digit (0-9) to follow minus sign, for valid numeric value");
        return null;
    }

    /*
     * Unable to fully structure code
     */
    protected JsonToken _handleUnexpectedValue(int var1_1) throws IOException, JsonParseException {
        switch (var1_1) lbl-1000:
        // 3 sources

        {
            default: {
                this._reportUnexpectedChar(var1_1, "expected a valid value (number, String, array, object, 'true', 'false' or 'null')");
                return null;
            }
            case 39: {
                if (!this.isEnabled(JsonParser.Feature.ALLOW_SINGLE_QUOTES)) ** GOTO lbl-1000
                return this._handleApostropheValue();
            }
            case 78: {
                this._matchToken("NaN", 1);
                if (this.isEnabled(JsonParser.Feature.ALLOW_NON_NUMERIC_NUMBERS)) {
                    return this.resetAsNaN("NaN", NaN);
                }
                this._reportError("Non-standard token 'NaN': enable JsonParser.Feature.ALLOW_NON_NUMERIC_NUMBERS to allow");
                ** GOTO lbl-1000
            }
            case 43: 
        }
        if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
            this._reportInvalidEOFInValue();
        }
        var2_2 = this._inputBuffer;
        var3_3 = this._inputPtr;
        this._inputPtr = var3_3 + 1;
        return this._handleInvalidNumberStart(255 & var2_2[var3_3], false);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected Name _handleUnusualFieldName(int n2) throws IOException, JsonParseException {
        int[] nArray;
        if (n2 == 39 && this.isEnabled(JsonParser.Feature.ALLOW_SINGLE_QUOTES)) {
            return this._parseApostropheFieldName();
        }
        if (!this.isEnabled(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES)) {
            this._reportUnexpectedChar(n2, "was expecting double-quote to start field name");
        }
        if ((nArray = CharTypes.getInputCodeUtf8JsNames())[n2] != 0) {
            this._reportUnexpectedChar(n2, "was expecting either valid name character (for unquoted name) or double-quote (for quoted) to start field name");
        }
        int[] nArray2 = this._quadBuffer;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (true) {
            int n6;
            if (n4 < 4) {
                ++n4;
                n3 = n2 | n3 << 8;
                n6 = n5;
            } else {
                if (n5 >= nArray2.length) {
                    this._quadBuffer = nArray2 = UTF8StreamJsonParser.growArrayBy(nArray2, nArray2.length);
                }
                n6 = n5 + 1;
                nArray2[n5] = n3;
                n3 = n2;
                n4 = 1;
            }
            if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                this._reportInvalidEOF(" in field name");
            }
            if (nArray[n2 = 0xFF & this._inputBuffer[this._inputPtr]] != 0) {
                Name name;
                if (n4 > 0) {
                    if (n6 >= nArray2.length) {
                        this._quadBuffer = nArray2 = UTF8StreamJsonParser.growArrayBy(nArray2, nArray2.length);
                    }
                    int n7 = n6 + 1;
                    nArray2[n6] = n3;
                    n6 = n7;
                }
                if ((name = this._symbols.findName(nArray2, n6)) != null) return name;
                return this.addName(nArray2, n6, n4);
            }
            this._inputPtr = 1 + this._inputPtr;
            n5 = n6;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected boolean _loadToHaveAtLeast(int n2) throws IOException {
        if (this._inputStream == null) return false;
        int n3 = this._inputEnd - this._inputPtr;
        if (n3 > 0 && this._inputPtr > 0) {
            this._currInputProcessed += (long)this._inputPtr;
            this._currInputRowStart -= this._inputPtr;
            System.arraycopy(this._inputBuffer, this._inputPtr, this._inputBuffer, 0, n3);
            this._inputEnd = n3;
        } else {
            this._inputEnd = 0;
        }
        this._inputPtr = 0;
        while (this._inputEnd < n2) {
            int n4 = this._inputStream.read(this._inputBuffer, this._inputEnd, this._inputBuffer.length - this._inputEnd);
            if (n4 < 1) {
                this._closeInput();
                if (n4 != 0) return false;
                throw new IOException("InputStream.read() returned 0 characters when trying to read " + n3 + " bytes");
            }
            this._inputEnd = n4 + this._inputEnd;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void _matchToken(String string2, int n2) throws IOException, JsonParseException {
        int n3;
        int n4 = string2.length();
        do {
            if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                this._reportInvalidEOF(" in a value");
            }
            if (this._inputBuffer[this._inputPtr] != string2.charAt(n2)) {
                this._reportInvalidToken(string2.substring(0, n2), "'null', 'true', 'false' or NaN");
            }
            this._inputPtr = 1 + this._inputPtr;
        } while (++n2 < n4);
        if (this._inputPtr >= this._inputEnd && !this.loadMore() || (n3 = 0xFF & this._inputBuffer[this._inputPtr]) < 48 || n3 == 93 || n3 == 125 || !Character.isJavaIdentifierPart((char)this._decodeCharForError(n3))) {
            return;
        }
        this._inputPtr = 1 + this._inputPtr;
        this._reportInvalidToken(string2.substring(0, n2), "'null', 'true', 'false' or NaN");
    }

    /*
     * Enabled aggressive block sorting
     */
    protected Name _parseApostropheFieldName() throws IOException, JsonParseException {
        if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
            this._reportInvalidEOF(": was expecting closing ''' for name");
        }
        byte[] byArray = this._inputBuffer;
        int n2 = this._inputPtr;
        this._inputPtr = n2 + 1;
        int n3 = 0xFF & byArray[n2];
        if (n3 == 39) {
            return BytesToNameCanonicalizer.getEmptyName();
        }
        int[] nArray = this._quadBuffer;
        int n4 = 0;
        int n5 = 0;
        int[] nArray2 = sInputCodesLatin1;
        int n6 = 0;
        while (true) {
            int n7;
            block16: {
                int n8;
                block18: {
                    int n9;
                    int n10;
                    block20: {
                        block19: {
                            Name name;
                            int n11;
                            block15: {
                                block14: {
                                    block17: {
                                        block13: {
                                            if (n3 != 39) break block13;
                                            if (n5 <= 0) break block14;
                                            if (n6 >= nArray.length) {
                                                this._quadBuffer = nArray = UTF8StreamJsonParser.growArrayBy(nArray, nArray.length);
                                            }
                                            n11 = n6 + 1;
                                            nArray[n6] = n4;
                                            break block15;
                                        }
                                        if (n3 == 34 || nArray2[n3] == 0) break block16;
                                        if (n3 != 92) {
                                            this._throwUnquotedSpace(n3, "name");
                                        } else {
                                            n3 = this._decodeEscaped();
                                        }
                                        if (n3 <= 127) break block16;
                                        if (n5 >= 4) {
                                            if (n6 >= nArray.length) {
                                                this._quadBuffer = nArray = UTF8StreamJsonParser.growArrayBy(nArray, nArray.length);
                                            }
                                            int n12 = n6 + 1;
                                            nArray[n6] = n4;
                                            n4 = 0;
                                            n5 = 0;
                                            n6 = n12;
                                        }
                                        if (n3 >= 2048) break block17;
                                        n4 = n4 << 8 | (0xC0 | n3 >> 6);
                                        ++n5;
                                        n8 = n6;
                                        break block18;
                                    }
                                    n10 = n4 << 8 | (0xE0 | n3 >> 12);
                                    n9 = n5 + 1;
                                    if (n9 < 4) break block19;
                                    if (n6 >= nArray.length) {
                                        this._quadBuffer = nArray = UTF8StreamJsonParser.growArrayBy(nArray, nArray.length);
                                    }
                                    n8 = n6 + 1;
                                    nArray[n6] = n10;
                                    n10 = 0;
                                    n9 = 0;
                                    break block20;
                                }
                                n11 = n6;
                            }
                            if ((name = this._symbols.findName(nArray, n11)) != null) return name;
                            return this.addName(nArray, n11, n5);
                        }
                        n8 = n6;
                    }
                    n4 = n10 << 8 | (0x80 | 0x3F & n3 >> 6);
                    n5 = n9 + 1;
                }
                n3 = 0x80 | n3 & 0x3F;
                n6 = n8;
            }
            if (n5 < 4) {
                ++n5;
                n4 = n3 | n4 << 8;
                n7 = n6;
            } else {
                if (n6 >= nArray.length) {
                    this._quadBuffer = nArray = UTF8StreamJsonParser.growArrayBy(nArray, nArray.length);
                }
                n7 = n6 + 1;
                nArray[n6] = n4;
                n4 = n3;
                n5 = 1;
            }
            if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                this._reportInvalidEOF(" in field name");
            }
            byte[] byArray2 = this._inputBuffer;
            int n13 = this._inputPtr;
            this._inputPtr = n13 + 1;
            n3 = 0xFF & byArray2[n13];
            n6 = n7;
        }
    }

    protected Name _parseFieldName(int n2) throws IOException, JsonParseException {
        if (n2 != 34) {
            return this._handleUnusualFieldName(n2);
        }
        if (9 + this._inputPtr > this._inputEnd) {
            return this.slowParseFieldName();
        }
        byte[] byArray = this._inputBuffer;
        int[] nArray = sInputCodesLatin1;
        int n3 = this._inputPtr;
        this._inputPtr = n3 + 1;
        int n4 = 0xFF & byArray[n3];
        if (nArray[n4] == 0) {
            int n5 = this._inputPtr;
            this._inputPtr = n5 + 1;
            int n6 = 0xFF & byArray[n5];
            if (nArray[n6] == 0) {
                int n7 = n6 | n4 << 8;
                int n8 = this._inputPtr;
                this._inputPtr = n8 + 1;
                int n9 = 0xFF & byArray[n8];
                if (nArray[n9] == 0) {
                    int n10 = n9 | n7 << 8;
                    int n11 = this._inputPtr;
                    this._inputPtr = n11 + 1;
                    int n12 = 0xFF & byArray[n11];
                    if (nArray[n12] == 0) {
                        int n13 = n12 | n10 << 8;
                        int n14 = this._inputPtr;
                        this._inputPtr = n14 + 1;
                        int n15 = 0xFF & byArray[n14];
                        if (nArray[n15] == 0) {
                            this._quad1 = n13;
                            return this.parseMediumFieldName(n15, nArray);
                        }
                        if (n15 == 34) {
                            return this.findName(n13, 4);
                        }
                        return this.parseFieldName(n13, n15, 4);
                    }
                    if (n12 == 34) {
                        return this.findName(n10, 3);
                    }
                    return this.parseFieldName(n10, n12, 3);
                }
                if (n9 == 34) {
                    return this.findName(n7, 2);
                }
                return this.parseFieldName(n7, n9, 2);
            }
            if (n6 == 34) {
                return this.findName(n4, 1);
            }
            return this.parseFieldName(n4, n6, 1);
        }
        if (n4 == 34) {
            return BytesToNameCanonicalizer.getEmptyName();
        }
        return this.parseFieldName(0, n4, 0);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected int _readBinary(Base64Variant base64Variant, OutputStream outputStream, byte[] byArray) throws IOException, JsonParseException {
        int n2 = 0;
        int n3 = -3 + byArray.length;
        int n4 = 0;
        while (true) {
            int n5;
            int n6;
            block22: {
                block23: {
                    int n7;
                    block24: {
                        block18: {
                            int n8;
                            int n9;
                            block19: {
                                block20: {
                                    int n10;
                                    block21: {
                                        int n11;
                                        block17: {
                                            if (this._inputPtr >= this._inputEnd) {
                                                this.loadMoreGuaranteed();
                                            }
                                            byte[] byArray2 = this._inputBuffer;
                                            int n12 = this._inputPtr;
                                            this._inputPtr = n12 + 1;
                                            int n13 = 0xFF & byArray2[n12];
                                            if (n13 <= 32) continue;
                                            n11 = base64Variant.decodeBase64Char(n13);
                                            if (n11 >= 0) break block17;
                                            if (n13 != 34) {
                                                n11 = this._decodeBase64Escape(base64Variant, n13, 0);
                                                if (n11 < 0) continue;
                                            }
                                            break block18;
                                        }
                                        if (n2 > n3) {
                                            n4 += n2;
                                            outputStream.write(byArray, 0, n2);
                                            n2 = 0;
                                        }
                                        int n14 = n11;
                                        if (this._inputPtr >= this._inputEnd) {
                                            this.loadMoreGuaranteed();
                                        }
                                        byte[] byArray3 = this._inputBuffer;
                                        int n15 = this._inputPtr;
                                        this._inputPtr = n15 + 1;
                                        int n16 = 0xFF & byArray3[n15];
                                        int n17 = base64Variant.decodeBase64Char(n16);
                                        if (n17 < 0) {
                                            n17 = this._decodeBase64Escape(base64Variant, n16, 1);
                                        }
                                        n9 = n17 | n14 << 6;
                                        if (this._inputPtr >= this._inputEnd) {
                                            this.loadMoreGuaranteed();
                                        }
                                        byte[] byArray4 = this._inputBuffer;
                                        int n18 = this._inputPtr;
                                        this._inputPtr = n18 + 1;
                                        n10 = 0xFF & byArray4[n18];
                                        n8 = base64Variant.decodeBase64Char(n10);
                                        if (n8 >= 0) break block19;
                                        if (n8 == -2) break block20;
                                        if (n10 != 34 || base64Variant.usesPadding()) break block21;
                                        int n19 = n9 >> 4;
                                        int n20 = n2 + 1;
                                        byArray[n2] = (byte)n19;
                                        n2 = n20;
                                        break block18;
                                    }
                                    n8 = this._decodeBase64Escape(base64Variant, n10, 2);
                                }
                                if (n8 == -2) {
                                    if (this._inputPtr >= this._inputEnd) {
                                        this.loadMoreGuaranteed();
                                    }
                                    byte[] byArray5 = this._inputBuffer;
                                    int n21 = this._inputPtr;
                                    this._inputPtr = n21 + 1;
                                    int n22 = 0xFF & byArray5[n21];
                                    if (!base64Variant.usesPaddingChar(n22)) {
                                        throw this.reportInvalidBase64Char(base64Variant, n22, 3, "expected padding character '" + base64Variant.getPaddingChar() + "'");
                                    }
                                    int n23 = n9 >> 4;
                                    int n24 = n2 + 1;
                                    byArray[n2] = (byte)n23;
                                    n2 = n24;
                                    continue;
                                }
                            }
                            n6 = n8 | n9 << 6;
                            if (this._inputPtr >= this._inputEnd) {
                                this.loadMoreGuaranteed();
                            }
                            byte[] byArray6 = this._inputBuffer;
                            int n25 = this._inputPtr;
                            this._inputPtr = n25 + 1;
                            n7 = 0xFF & byArray6[n25];
                            n5 = base64Variant.decodeBase64Char(n7);
                            if (n5 >= 0) break block22;
                            if (n5 == -2) break block23;
                            if (n7 != 34 || base64Variant.usesPadding()) break block24;
                            int n26 = n6 >> 2;
                            int n27 = n2 + 1;
                            byArray[n2] = (byte)(n26 >> 8);
                            n2 = n27 + 1;
                            byArray[n27] = (byte)n26;
                        }
                        this._tokenIncomplete = false;
                        if (n2 > 0) {
                            n4 += n2;
                            outputStream.write(byArray, 0, n2);
                        }
                        return n4;
                    }
                    n5 = this._decodeBase64Escape(base64Variant, n7, 3);
                }
                if (n5 == -2) {
                    int n28 = n6 >> 2;
                    int n29 = n2 + 1;
                    byArray[n2] = (byte)(n28 >> 8);
                    n2 = n29 + 1;
                    byArray[n29] = (byte)n28;
                    continue;
                }
            }
            int n30 = n5 | n6 << 6;
            int n31 = n2 + 1;
            byArray[n2] = (byte)(n30 >> 16);
            int n32 = n31 + 1;
            byArray[n31] = (byte)(n30 >> 8);
            int n33 = n32 + 1;
            byArray[n32] = (byte)n30;
            n2 = n33;
        }
    }

    @Override
    protected void _releaseBuffers() throws IOException {
        byte[] byArray;
        super._releaseBuffers();
        if (this._bufferRecyclable && (byArray = this._inputBuffer) != null) {
            this._inputBuffer = null;
            this._ioContext.releaseReadIOBuffer(byArray);
        }
    }

    protected void _reportInvalidChar(int n2) throws JsonParseException {
        if (n2 < 32) {
            this._throwInvalidSpace(n2);
        }
        this._reportInvalidInitial(n2);
    }

    protected void _reportInvalidInitial(int n2) throws JsonParseException {
        this._reportError("Invalid UTF-8 start byte 0x" + Integer.toHexString(n2));
    }

    protected void _reportInvalidOther(int n2) throws JsonParseException {
        this._reportError("Invalid UTF-8 middle byte 0x" + Integer.toHexString(n2));
    }

    protected void _reportInvalidOther(int n2, int n3) throws JsonParseException {
        this._inputPtr = n3;
        this._reportInvalidOther(n2);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void _reportInvalidToken(String string2, String string3) throws IOException, JsonParseException {
        StringBuilder stringBuilder = new StringBuilder(string2);
        while (true) {
            char c2;
            block4: {
                block3: {
                    if (this._inputPtr >= this._inputEnd && !this.loadMore()) break block3;
                    byte[] byArray = this._inputBuffer;
                    int n2 = this._inputPtr;
                    this._inputPtr = n2 + 1;
                    c2 = (char)this._decodeCharForError(byArray[n2]);
                    if (Character.isJavaIdentifierPart(c2)) break block4;
                }
                this._reportError("Unrecognized token '" + stringBuilder.toString() + "': was expecting " + string3);
                return;
            }
            stringBuilder.append(c2);
        }
    }

    protected void _skipCR() throws IOException {
        if ((this._inputPtr < this._inputEnd || this.loadMore()) && this._inputBuffer[this._inputPtr] == 10) {
            this._inputPtr = 1 + this._inputPtr;
        }
        this._currInputRow = 1 + this._currInputRow;
        this._currInputRowStart = this._inputPtr;
    }

    protected void _skipLF() throws IOException {
        this._currInputRow = 1 + this._currInputRow;
        this._currInputRowStart = this._inputPtr;
    }

    protected void _skipString() throws IOException, JsonParseException {
        int n2;
        int n3;
        this._tokenIncomplete = false;
        int[] nArray = sInputCodesUtf8;
        byte[] byArray = this._inputBuffer;
        block6: while ((n3 = this._inputPtr) >= (n2 = this._inputEnd)) {
            this.loadMoreGuaranteed();
            int n4 = this._inputPtr;
            n2 = this._inputEnd;
            int n5 = n4;
            while (true) {
                block10: {
                    int n6;
                    block11: {
                        block9: {
                            if (n5 >= n2) break block9;
                            n3 = n5 + 1;
                            n6 = 0xFF & byArray[n5];
                            if (nArray[n6] == 0) break block10;
                            this._inputPtr = n3;
                            if (n6 == 34) {
                                return;
                            }
                            break block11;
                        }
                        this._inputPtr = n5;
                        continue block6;
                    }
                    switch (nArray[n6]) {
                        default: {
                            if (n6 >= 32) break;
                            this._throwUnquotedSpace(n6, "string value");
                            continue block6;
                        }
                        case 1: {
                            this._decodeEscaped();
                            continue block6;
                        }
                        case 2: {
                            this._skipUtf8_2(n6);
                            continue block6;
                        }
                        case 3: {
                            this._skipUtf8_3(n6);
                            continue block6;
                        }
                        case 4: {
                            this._skipUtf8_4(n6);
                            continue block6;
                        }
                    }
                    this._reportInvalidChar(n6);
                    continue block6;
                }
                n5 = n3;
            }
        }
    }

    @Override
    public void close() throws IOException {
        super.close();
        this._symbols.release();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] getBinaryValue(Base64Variant base64Variant) throws IOException, JsonParseException {
        if (this._currToken != JsonToken.VALUE_STRING && (this._currToken != JsonToken.VALUE_EMBEDDED_OBJECT || this._binaryValue == null)) {
            this._reportError("Current token (" + (Object)((Object)this._currToken) + ") not VALUE_STRING or VALUE_EMBEDDED_OBJECT, can not access as binary");
        }
        if (!this._tokenIncomplete) {
            if (this._binaryValue != null) return this._binaryValue;
            ByteArrayBuilder byteArrayBuilder = this._getByteArrayBuilder();
            this._decodeBase64(this.getText(), byteArrayBuilder, base64Variant);
            this._binaryValue = byteArrayBuilder.toByteArray();
            return this._binaryValue;
        }
        try {
            this._binaryValue = this._decodeBase64(base64Variant);
            this._tokenIncomplete = false;
            return this._binaryValue;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw this._constructError("Failed to decode VALUE_STRING as base64 (" + base64Variant + "): " + illegalArgumentException.getMessage());
        }
    }

    @Override
    public ObjectCodec getCodec() {
        return this._objectCodec;
    }

    @Override
    public Object getEmbeddedObject() throws IOException, JsonParseException {
        return null;
    }

    @Override
    public Object getInputSource() {
        return this._inputStream;
    }

    @Override
    public String getText() throws IOException, JsonParseException {
        if (this._currToken == JsonToken.VALUE_STRING) {
            if (this._tokenIncomplete) {
                this._tokenIncomplete = false;
                this._finishString();
            }
            return this._textBuffer.contentsAsString();
        }
        return this._getText2(this._currToken);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public char[] getTextCharacters() throws IOException, JsonParseException {
        if (this._currToken == null) {
            return null;
        }
        switch (this._currToken) {
            default: {
                return this._currToken.asCharArray();
            }
            case FIELD_NAME: {
                if (this._nameCopied) return this._nameCopyBuffer;
                String string2 = this._parsingContext.getCurrentName();
                int n2 = string2.length();
                if (this._nameCopyBuffer == null) {
                    this._nameCopyBuffer = this._ioContext.allocNameCopyBuffer(n2);
                } else if (this._nameCopyBuffer.length < n2) {
                    this._nameCopyBuffer = new char[n2];
                }
                string2.getChars(0, n2, this._nameCopyBuffer, 0);
                this._nameCopied = true;
                return this._nameCopyBuffer;
            }
            case VALUE_STRING: {
                if (!this._tokenIncomplete) return this._textBuffer.getTextBuffer();
                this._tokenIncomplete = false;
                this._finishString();
                return this._textBuffer.getTextBuffer();
            }
            case VALUE_NUMBER_INT: 
            case VALUE_NUMBER_FLOAT: 
        }
        return this._textBuffer.getTextBuffer();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int getTextLength() throws IOException, JsonParseException {
        JsonToken jsonToken = this._currToken;
        int n2 = 0;
        if (jsonToken == null) return n2;
        switch (this._currToken) {
            default: {
                return this._currToken.asCharArray().length;
            }
            case FIELD_NAME: {
                return this._parsingContext.getCurrentName().length();
            }
            case VALUE_STRING: {
                if (!this._tokenIncomplete) return this._textBuffer.size();
                this._tokenIncomplete = false;
                this._finishString();
            }
            case VALUE_NUMBER_INT: 
            case VALUE_NUMBER_FLOAT: 
        }
        return this._textBuffer.size();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int getTextOffset() throws IOException, JsonParseException {
        if (this._currToken == null) return 0;
        switch (this._currToken) {
            default: {
                return 0;
            }
            case VALUE_STRING: {
                if (!this._tokenIncomplete) return this._textBuffer.getTextOffset();
                this._tokenIncomplete = false;
                this._finishString();
            }
            case VALUE_NUMBER_INT: 
            case VALUE_NUMBER_FLOAT: 
        }
        return this._textBuffer.getTextOffset();
    }

    @Override
    public String getValueAsString() throws IOException, JsonParseException {
        if (this._currToken == JsonToken.VALUE_STRING) {
            if (this._tokenIncomplete) {
                this._tokenIncomplete = false;
                this._finishString();
            }
            return this._textBuffer.contentsAsString();
        }
        return super.getValueAsString(null);
    }

    @Override
    public String getValueAsString(String string2) throws IOException, JsonParseException {
        if (this._currToken == JsonToken.VALUE_STRING) {
            if (this._tokenIncomplete) {
                this._tokenIncomplete = false;
                this._finishString();
            }
            return this._textBuffer.contentsAsString();
        }
        return super.getValueAsString(string2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean loadMore() throws IOException {
        this._currInputProcessed += (long)this._inputEnd;
        this._currInputRowStart -= this._inputEnd;
        InputStream inputStream = this._inputStream;
        boolean bl2 = false;
        if (inputStream == null) return bl2;
        int n2 = this._inputStream.read(this._inputBuffer, 0, this._inputBuffer.length);
        if (n2 > 0) {
            this._inputPtr = 0;
            this._inputEnd = n2;
            return true;
        }
        this._closeInput();
        bl2 = false;
        if (n2 != 0) return bl2;
        throw new IOException("InputStream.read() returned 0 characters when trying to read " + this._inputBuffer.length + " bytes");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Boolean nextBooleanValue() throws IOException, JsonParseException {
        if (this._currToken == JsonToken.FIELD_NAME) {
            this._nameCopied = false;
            JsonToken jsonToken = this._nextToken;
            this._nextToken = null;
            this._currToken = jsonToken;
            if (jsonToken == JsonToken.VALUE_TRUE) {
                return Boolean.TRUE;
            }
            if (jsonToken == JsonToken.VALUE_FALSE) {
                return Boolean.FALSE;
            }
            if (jsonToken == JsonToken.START_ARRAY) {
                this._parsingContext = this._parsingContext.createChildArrayContext(this._tokenInputRow, this._tokenInputCol);
                return null;
            }
            JsonToken jsonToken2 = JsonToken.START_OBJECT;
            Boolean bl2 = null;
            if (jsonToken != jsonToken2) return bl2;
            this._parsingContext = this._parsingContext.createChildObjectContext(this._tokenInputRow, this._tokenInputCol);
            return null;
        }
        switch (1.$SwitchMap$com$fasterxml$jackson$core$JsonToken[this.nextToken().ordinal()]) {
            default: {
                return null;
            }
            case 5: {
                return Boolean.TRUE;
            }
            case 6: 
        }
        return Boolean.FALSE;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean nextFieldName(SerializableString serializableString) throws IOException, JsonParseException {
        int n2;
        byte[] byArray;
        int n3;
        int n4;
        this._numTypesValid = 0;
        if (this._currToken == JsonToken.FIELD_NAME) {
            this._nextAfterName();
            return false;
        }
        if (this._tokenIncomplete) {
            this._skipString();
        }
        if ((n4 = this._skipWSOrEnd()) < 0) {
            this.close();
            this._currToken = null;
            return false;
        }
        this._tokenInputTotal = this._currInputProcessed + (long)this._inputPtr - 1L;
        this._tokenInputRow = this._currInputRow;
        this._tokenInputCol = -1 + (this._inputPtr - this._currInputRowStart);
        this._binaryValue = null;
        if (n4 == 93) {
            if (!this._parsingContext.inArray()) {
                this._reportMismatchedEndMarker(n4, '}');
            }
            this._parsingContext = this._parsingContext.getParent();
            this._currToken = JsonToken.END_ARRAY;
            return false;
        }
        if (n4 == 125) {
            if (!this._parsingContext.inObject()) {
                this._reportMismatchedEndMarker(n4, ']');
            }
            this._parsingContext = this._parsingContext.getParent();
            this._currToken = JsonToken.END_OBJECT;
            return false;
        }
        if (this._parsingContext.expectComma()) {
            if (n4 != 44) {
                this._reportUnexpectedChar(n4, "was expecting comma to separate " + this._parsingContext.getTypeDesc() + " entries");
            }
            n4 = this._skipWS();
        }
        if (!this._parsingContext.inObject()) {
            this._nextTokenNotInObject(n4);
            return false;
        }
        if (n4 != 34 || (n3 = (byArray = serializableString.asQuotedUTF8()).length) + this._inputPtr >= this._inputEnd || this._inputBuffer[n2 = n3 + this._inputPtr] != 34) return this._isNextTokenNameMaybe(n4, serializableString);
        int n5 = 0;
        int n6 = this._inputPtr;
        while (true) {
            if (n5 == n3) {
                this._inputPtr = n2 + 1;
                this._parsingContext.setCurrentName(serializableString.getValue());
                this._currToken = JsonToken.FIELD_NAME;
                this._isNextTokenNameYes();
                return true;
            }
            if (byArray[n5] != this._inputBuffer[n6 + n5]) {
                return this._isNextTokenNameMaybe(n4, serializableString);
            }
            ++n5;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int nextIntValue(int n2) throws IOException, JsonParseException {
        if (this._currToken == JsonToken.FIELD_NAME) {
            this._nameCopied = false;
            JsonToken jsonToken = this._nextToken;
            this._nextToken = null;
            this._currToken = jsonToken;
            if (jsonToken == JsonToken.VALUE_NUMBER_INT) {
                return this.getIntValue();
            }
            if (jsonToken == JsonToken.START_ARRAY) {
                this._parsingContext = this._parsingContext.createChildArrayContext(this._tokenInputRow, this._tokenInputCol);
                return n2;
            }
            if (jsonToken != JsonToken.START_OBJECT) return n2;
            this._parsingContext = this._parsingContext.createChildObjectContext(this._tokenInputRow, this._tokenInputCol);
            return n2;
        }
        if (this.nextToken() != JsonToken.VALUE_NUMBER_INT) return n2;
        return this.getIntValue();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public long nextLongValue(long l2) throws IOException, JsonParseException {
        if (this._currToken == JsonToken.FIELD_NAME) {
            this._nameCopied = false;
            JsonToken jsonToken = this._nextToken;
            this._nextToken = null;
            this._currToken = jsonToken;
            if (jsonToken == JsonToken.VALUE_NUMBER_INT) {
                return this.getLongValue();
            }
            if (jsonToken == JsonToken.START_ARRAY) {
                this._parsingContext = this._parsingContext.createChildArrayContext(this._tokenInputRow, this._tokenInputCol);
                return l2;
            }
            if (jsonToken != JsonToken.START_OBJECT) return l2;
            this._parsingContext = this._parsingContext.createChildObjectContext(this._tokenInputRow, this._tokenInputCol);
            return l2;
        }
        if (this.nextToken() != JsonToken.VALUE_NUMBER_INT) return l2;
        return this.getLongValue();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String nextTextValue() throws IOException, JsonParseException {
        String string2;
        if (this._currToken == JsonToken.FIELD_NAME) {
            this._nameCopied = false;
            JsonToken jsonToken = this._nextToken;
            this._nextToken = null;
            this._currToken = jsonToken;
            if (jsonToken == JsonToken.VALUE_STRING) {
                if (!this._tokenIncomplete) return this._textBuffer.contentsAsString();
                this._tokenIncomplete = false;
                this._finishString();
                return this._textBuffer.contentsAsString();
            }
            if (jsonToken == JsonToken.START_ARRAY) {
                this._parsingContext = this._parsingContext.createChildArrayContext(this._tokenInputRow, this._tokenInputCol);
                return null;
            }
            JsonToken jsonToken2 = JsonToken.START_OBJECT;
            string2 = null;
            if (jsonToken != jsonToken2) return string2;
            this._parsingContext = this._parsingContext.createChildObjectContext(this._tokenInputRow, this._tokenInputCol);
            return null;
        }
        JsonToken jsonToken = this.nextToken();
        JsonToken jsonToken3 = JsonToken.VALUE_STRING;
        string2 = null;
        if (jsonToken != jsonToken3) return string2;
        return this.getText();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public JsonToken nextToken() throws IOException, JsonParseException {
        JsonToken jsonToken;
        int n2;
        int n3;
        this._numTypesValid = 0;
        if (this._currToken == JsonToken.FIELD_NAME) {
            return this._nextAfterName();
        }
        if (this._tokenIncomplete) {
            this._skipString();
        }
        if ((n3 = this._skipWSOrEnd()) < 0) {
            this.close();
            this._currToken = null;
            return null;
        }
        this._tokenInputTotal = this._currInputProcessed + (long)this._inputPtr - 1L;
        this._tokenInputRow = this._currInputRow;
        this._tokenInputCol = -1 + (this._inputPtr - this._currInputRowStart);
        this._binaryValue = null;
        if (n3 == 93) {
            JsonToken jsonToken2;
            if (!this._parsingContext.inArray()) {
                this._reportMismatchedEndMarker(n3, '}');
            }
            this._parsingContext = this._parsingContext.getParent();
            this._currToken = jsonToken2 = JsonToken.END_ARRAY;
            return jsonToken2;
        }
        if (n3 == 125) {
            JsonToken jsonToken3;
            if (!this._parsingContext.inObject()) {
                this._reportMismatchedEndMarker(n3, ']');
            }
            this._parsingContext = this._parsingContext.getParent();
            this._currToken = jsonToken3 = JsonToken.END_OBJECT;
            return jsonToken3;
        }
        if (this._parsingContext.expectComma()) {
            if (n3 != 44) {
                this._reportUnexpectedChar(n3, "was expecting comma to separate " + this._parsingContext.getTypeDesc() + " entries");
            }
            n3 = this._skipWS();
        }
        if (!this._parsingContext.inObject()) {
            return this._nextTokenNotInObject(n3);
        }
        Name name = this._parseFieldName(n3);
        this._parsingContext.setCurrentName(name.getName());
        this._currToken = JsonToken.FIELD_NAME;
        int n4 = this._skipWS();
        if (n4 != 58) {
            this._reportUnexpectedChar(n4, "was expecting a colon to separate field name and value");
        }
        if ((n2 = this._skipWS()) == 34) {
            this._tokenIncomplete = true;
            this._nextToken = JsonToken.VALUE_STRING;
            return this._currToken;
        }
        switch (n2) {
            default: {
                jsonToken = this._handleUnexpectedValue(n2);
                break;
            }
            case 91: {
                jsonToken = JsonToken.START_ARRAY;
                break;
            }
            case 123: {
                jsonToken = JsonToken.START_OBJECT;
                break;
            }
            case 93: 
            case 125: {
                this._reportUnexpectedChar(n2, "expected a value");
            }
            case 116: {
                this._matchToken("true", 1);
                jsonToken = JsonToken.VALUE_TRUE;
                break;
            }
            case 102: {
                this._matchToken("false", 1);
                jsonToken = JsonToken.VALUE_FALSE;
                break;
            }
            case 110: {
                this._matchToken("null", 1);
                jsonToken = JsonToken.VALUE_NULL;
                break;
            }
            case 45: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                jsonToken = this.parseNumberText(n2);
            }
        }
        this._nextToken = jsonToken;
        return this._currToken;
    }

    /*
     * Unable to fully structure code
     */
    protected Name parseEscapedFieldName(int[] var1_1, int var2_2, int var3_3, int var4_4, int var5_5) throws IOException, JsonParseException {
        var6_6 = UTF8StreamJsonParser.sInputCodesLatin1;
        block0: while (var6_6[var4_4] != 0) {
            block18: {
                block21: {
                    block20: {
                        block19: {
                            if (var4_4 == 34) {
                                if (var5_5 > 0) {
                                    if (var2_2 >= var1_1.length) {
                                        var1_1 = UTF8StreamJsonParser.growArrayBy(var1_1, var1_1.length);
                                        this._quadBuffer = var1_1;
                                    }
                                    var15_14 = var2_2 + 1;
                                    var1_1[var2_2] = var3_3;
                                    var2_2 = var15_14;
                                }
                                if ((var14_15 = this._symbols.findName(var1_1, var2_2)) == null) {
                                    var14_15 = this.addName(var1_1, var2_2, var5_5);
                                }
                                return var14_15;
                            }
                            if (var4_4 != 92) {
                                this._throwUnquotedSpace(var4_4, "name");
lbl16:
                                // 2 sources

                                while (var4_4 > 127) {
                                    if (var5_5 < 4) break block18;
                                    if (var2_2 >= var1_1.length) {
                                        var1_1 = UTF8StreamJsonParser.growArrayBy(var1_1, var1_1.length);
                                        this._quadBuffer = var1_1;
                                    }
                                    var10_10 = var2_2 + 1;
                                    var1_1[var2_2] = var3_3;
                                    var3_3 = 0;
                                    var5_5 = 0;
lbl25:
                                    // 2 sources

                                    while (true) {
                                        if (var4_4 >= 2048) break block19;
                                        var3_3 = var3_3 << 8 | (192 | var4_4 >> 6);
                                        ++var5_5;
                                        var13_13 = var10_10;
lbl30:
                                        // 2 sources

                                        while (true) {
                                            var4_4 = 128 | var4_4 & 63;
                                            var7_7 = var13_13;
lbl33:
                                            // 2 sources

                                            while (true) {
                                                if (var5_5 < 4) {
                                                    ++var5_5;
                                                    var3_3 = var4_4 | var3_3 << 8;
                                                    var2_2 = var7_7;
lbl38:
                                                    // 2 sources

                                                    while (true) {
                                                        if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                                                            this._reportInvalidEOF(" in field name");
                                                        }
                                                        var8_8 = this._inputBuffer;
                                                        var9_9 = this._inputPtr;
                                                        this._inputPtr = var9_9 + 1;
                                                        var4_4 = 255 & var8_8[var9_9];
                                                        continue block0;
                                                        break;
                                                    }
                                                }
                                                break block20;
                                                break;
                                            }
                                            break;
                                        }
                                        break;
                                    }
                                }
                                break;
                            }
                            var4_4 = this._decodeEscaped();
                            ** GOTO lbl16
                        }
                        var11_11 = var3_3 << 8 | (224 | var4_4 >> 12);
                        var12_12 = var5_5 + 1;
                        if (var12_12 >= 4) {
                            if (var10_10 >= var1_1.length) {
                                var1_1 = UTF8StreamJsonParser.growArrayBy(var1_1, var1_1.length);
                                this._quadBuffer = var1_1;
                            }
                            var13_13 = var10_10 + 1;
                            var1_1[var10_10] = var11_11;
                            var11_11 = 0;
                            var12_12 = 0;
lbl61:
                            // 2 sources

                            while (true) {
                                var3_3 = var11_11 << 8 | (128 | 63 & var4_4 >> 6);
                                var5_5 = var12_12 + 1;
                                ** continue;
                                break;
                            }
                        }
                        break block21;
                    }
                    if (var7_7 >= var1_1.length) {
                        var1_1 = UTF8StreamJsonParser.growArrayBy(var1_1, var1_1.length);
                        this._quadBuffer = var1_1;
                    }
                    var2_2 = var7_7 + 1;
                    var1_1[var7_7] = var3_3;
                    var3_3 = var4_4;
                    var5_5 = 1;
                    ** continue;
                }
                var13_13 = var10_10;
                ** continue;
            }
            var10_10 = var2_2;
            ** continue;
        }
        var7_7 = var2_2;
        ** while (true)
    }

    protected Name parseLongFieldName(int n2) throws IOException, JsonParseException {
        int[] nArray = sInputCodesLatin1;
        int n3 = 2;
        while (this._inputEnd - this._inputPtr >= 4) {
            byte[] byArray = this._inputBuffer;
            int n4 = this._inputPtr;
            this._inputPtr = n4 + 1;
            int n5 = 0xFF & byArray[n4];
            if (nArray[n5] != 0) {
                if (n5 == 34) {
                    return this.findName(this._quadBuffer, n3, n2, 1);
                }
                return this.parseEscapedFieldName(this._quadBuffer, n3, n2, n5, 1);
            }
            int n6 = n5 | n2 << 8;
            byte[] byArray2 = this._inputBuffer;
            int n7 = this._inputPtr;
            this._inputPtr = n7 + 1;
            int n8 = 0xFF & byArray2[n7];
            if (nArray[n8] != 0) {
                if (n8 == 34) {
                    return this.findName(this._quadBuffer, n3, n6, 2);
                }
                return this.parseEscapedFieldName(this._quadBuffer, n3, n6, n8, 2);
            }
            int n9 = n8 | n6 << 8;
            byte[] byArray3 = this._inputBuffer;
            int n10 = this._inputPtr;
            this._inputPtr = n10 + 1;
            int n11 = 0xFF & byArray3[n10];
            if (nArray[n11] != 0) {
                if (n11 == 34) {
                    return this.findName(this._quadBuffer, n3, n9, 3);
                }
                return this.parseEscapedFieldName(this._quadBuffer, n3, n9, n11, 3);
            }
            int n12 = n11 | n9 << 8;
            byte[] byArray4 = this._inputBuffer;
            int n13 = this._inputPtr;
            this._inputPtr = n13 + 1;
            int n14 = 0xFF & byArray4[n13];
            if (nArray[n14] != 0) {
                if (n14 == 34) {
                    return this.findName(this._quadBuffer, n3, n12, 4);
                }
                return this.parseEscapedFieldName(this._quadBuffer, n3, n12, n14, 4);
            }
            if (n3 >= this._quadBuffer.length) {
                this._quadBuffer = UTF8StreamJsonParser.growArrayBy(this._quadBuffer, n3);
            }
            int[] nArray2 = this._quadBuffer;
            int n15 = n3 + 1;
            nArray2[n3] = n12;
            n2 = n14;
            n3 = n15;
        }
        return this.parseEscapedFieldName(this._quadBuffer, n3, 0, n2, 0);
    }

    protected Name parseMediumFieldName(int n2, int[] nArray) throws IOException, JsonParseException {
        byte[] byArray = this._inputBuffer;
        int n3 = this._inputPtr;
        this._inputPtr = n3 + 1;
        int n4 = 0xFF & byArray[n3];
        if (nArray[n4] != 0) {
            if (n4 == 34) {
                return this.findName(this._quad1, n2, 1);
            }
            return this.parseFieldName(this._quad1, n2, n4, 1);
        }
        int n5 = n4 | n2 << 8;
        byte[] byArray2 = this._inputBuffer;
        int n6 = this._inputPtr;
        this._inputPtr = n6 + 1;
        int n7 = 0xFF & byArray2[n6];
        if (nArray[n7] != 0) {
            if (n7 == 34) {
                return this.findName(this._quad1, n5, 2);
            }
            return this.parseFieldName(this._quad1, n5, n7, 2);
        }
        int n8 = n7 | n5 << 8;
        byte[] byArray3 = this._inputBuffer;
        int n9 = this._inputPtr;
        this._inputPtr = n9 + 1;
        int n10 = 0xFF & byArray3[n9];
        if (nArray[n10] != 0) {
            if (n10 == 34) {
                return this.findName(this._quad1, n8, 3);
            }
            return this.parseFieldName(this._quad1, n8, n10, 3);
        }
        int n11 = n10 | n8 << 8;
        byte[] byArray4 = this._inputBuffer;
        int n12 = this._inputPtr;
        this._inputPtr = n12 + 1;
        int n13 = 0xFF & byArray4[n12];
        if (nArray[n13] != 0) {
            if (n13 == 34) {
                return this.findName(this._quad1, n11, 4);
            }
            return this.parseFieldName(this._quad1, n11, n13, 4);
        }
        this._quadBuffer[0] = this._quad1;
        this._quadBuffer[1] = n11;
        return this.parseLongFieldName(n13);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected JsonToken parseNumberText(int n2) throws IOException, JsonParseException {
        int n3;
        char[] cArray = this._textBuffer.emptyAndGetCurrentSegment();
        boolean bl2 = n2 == 45;
        if (bl2) {
            n3 = 0 + 1;
            cArray[0] = 45;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            byte[] byArray = this._inputBuffer;
            int n4 = this._inputPtr;
            this._inputPtr = n4 + 1;
            n2 = 0xFF & byArray[n4];
            if (n2 < 48) return this._handleInvalidNumberStart(n2, true);
            if (n2 > 57) {
                return this._handleInvalidNumberStart(n2, true);
            }
        } else {
            n3 = 0;
        }
        if (n2 == 48) {
            n2 = this._verifyNoLeadingZeroes();
        }
        int n5 = n3 + 1;
        cArray[n3] = (char)n2;
        int n6 = 1;
        int n7 = this._inputPtr + cArray.length;
        if (n7 > this._inputEnd) {
            n7 = this._inputEnd;
        }
        while (this._inputPtr < n7) {
            byte[] byArray = this._inputBuffer;
            int n8 = this._inputPtr;
            this._inputPtr = n8 + 1;
            int n9 = 0xFF & byArray[n8];
            if (n9 < 48 || n9 > 57) {
                if (n9 == 46) return this._parseFloatText(cArray, n5, n9, bl2, n6);
                if (n9 == 101) return this._parseFloatText(cArray, n5, n9, bl2, n6);
                if (n9 == 69) return this._parseFloatText(cArray, n5, n9, bl2, n6);
                this._inputPtr = -1 + this._inputPtr;
                this._textBuffer.setCurrentLength(n5);
                return this.resetInt(bl2, n6);
            }
            ++n6;
            int n10 = n5 + 1;
            cArray[n5] = (char)n9;
            n5 = n10;
        }
        return this._parserNumber2(cArray, n5, bl2, n6);
    }

    @Override
    public int readBinaryValue(Base64Variant base64Variant, OutputStream outputStream) throws IOException, JsonParseException {
        if (!this._tokenIncomplete || this._currToken != JsonToken.VALUE_STRING) {
            byte[] byArray = this.getBinaryValue(base64Variant);
            outputStream.write(byArray);
            return byArray.length;
        }
        byte[] byArray = this._ioContext.allocBase64Buffer();
        try {
            int n2 = this._readBinary(base64Variant, outputStream, byArray);
            return n2;
        }
        finally {
            this._ioContext.releaseBase64Buffer(byArray);
        }
    }

    @Override
    public int releaseBuffered(OutputStream outputStream) throws IOException {
        int n2 = this._inputEnd - this._inputPtr;
        if (n2 < 1) {
            return 0;
        }
        int n3 = this._inputPtr;
        outputStream.write(this._inputBuffer, n3, n2);
        return n2;
    }

    @Override
    public void setCodec(ObjectCodec objectCodec) {
        this._objectCodec = objectCodec;
    }

    protected Name slowParseFieldName() throws IOException, JsonParseException {
        if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
            this._reportInvalidEOF(": was expecting closing '\"' for name");
        }
        byte[] byArray = this._inputBuffer;
        int n2 = this._inputPtr;
        this._inputPtr = n2 + 1;
        int n3 = 0xFF & byArray[n2];
        if (n3 == 34) {
            return BytesToNameCanonicalizer.getEmptyName();
        }
        return this.parseEscapedFieldName(this._quadBuffer, 0, 0, n3, 0);
    }

    @Override
    public Version version() {
        return CoreVersion.instance.version();
    }
}

