/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.json;

import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonStreamContext;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.io.CharTypes;
import com.fasterxml.jackson.core.io.CharacterEscapes;
import com.fasterxml.jackson.core.io.IOContext;
import com.fasterxml.jackson.core.io.NumberOutput;
import com.fasterxml.jackson.core.json.JsonGeneratorImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;

public class UTF8JsonGenerator
extends JsonGeneratorImpl {
    private static final byte BYTE_0 = 48;
    private static final byte BYTE_BACKSLASH = 92;
    private static final byte BYTE_COLON = 58;
    private static final byte BYTE_COMMA = 44;
    private static final byte BYTE_LBRACKET = 91;
    private static final byte BYTE_LCURLY = 123;
    private static final byte BYTE_QUOTE = 34;
    private static final byte BYTE_RBRACKET = 93;
    private static final byte BYTE_RCURLY = 125;
    private static final byte BYTE_u = 117;
    private static final byte[] FALSE_BYTES;
    static final byte[] HEX_CHARS;
    private static final int MAX_BYTES_TO_BUFFER = 512;
    private static final byte[] NULL_BYTES;
    protected static final int SURR1_FIRST = 55296;
    protected static final int SURR1_LAST = 56319;
    protected static final int SURR2_FIRST = 56320;
    protected static final int SURR2_LAST = 57343;
    private static final byte[] TRUE_BYTES;
    protected boolean _bufferRecyclable;
    protected char[] _charBuffer;
    protected final int _charBufferLength;
    protected byte[] _entityBuffer;
    protected byte[] _outputBuffer;
    protected final int _outputEnd;
    protected final int _outputMaxContiguous;
    protected final OutputStream _outputStream;
    protected int _outputTail = 0;

    static {
        HEX_CHARS = CharTypes.copyHexBytes();
        NULL_BYTES = new byte[]{110, 117, 108, 108};
        TRUE_BYTES = new byte[]{116, 114, 117, 101};
        FALSE_BYTES = new byte[]{102, 97, 108, 115, 101};
    }

    public UTF8JsonGenerator(IOContext iOContext, int n2, ObjectCodec objectCodec, OutputStream outputStream) {
        super(iOContext, n2, objectCodec);
        this._outputStream = outputStream;
        this._bufferRecyclable = true;
        this._outputBuffer = iOContext.allocWriteEncodingBuffer();
        this._outputEnd = this._outputBuffer.length;
        this._outputMaxContiguous = this._outputEnd >> 3;
        this._charBuffer = iOContext.allocConcatBuffer();
        this._charBufferLength = this._charBuffer.length;
        if (this.isEnabled(JsonGenerator.Feature.ESCAPE_NON_ASCII)) {
            this.setHighestNonEscapedChar(127);
        }
    }

    public UTF8JsonGenerator(IOContext iOContext, int n2, ObjectCodec objectCodec, OutputStream outputStream, byte[] byArray, int n3, boolean bl2) {
        super(iOContext, n2, objectCodec);
        this._outputStream = outputStream;
        this._bufferRecyclable = bl2;
        this._outputTail = n3;
        this._outputBuffer = byArray;
        this._outputEnd = this._outputBuffer.length;
        this._outputMaxContiguous = this._outputEnd >> 3;
        this._charBuffer = iOContext.allocConcatBuffer();
        this._charBufferLength = this._charBuffer.length;
    }

    private int _handleLongCustomEscape(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) throws IOException, JsonGenerationException {
        int n5 = byArray2.length;
        if (n2 + n5 > n3) {
            this._outputTail = n2;
            this._flushBuffer();
            int n6 = this._outputTail;
            if (n5 > byArray.length) {
                this._outputStream.write(byArray2, 0, n5);
                return n6;
            }
            System.arraycopy(byArray2, 0, byArray, n6, n5);
            n2 = n6 + n5;
        }
        if (n2 + n4 * 6 > n3) {
            this._flushBuffer();
            return this._outputTail;
        }
        return n2;
    }

    private int _outputMultiByteChar(int n2, int n3) throws IOException {
        byte[] byArray = this._outputBuffer;
        if (n2 >= 55296 && n2 <= 57343) {
            int n4 = n3 + 1;
            byArray[n3] = 92;
            int n5 = n4 + 1;
            byArray[n4] = 117;
            int n6 = n5 + 1;
            byArray[n5] = HEX_CHARS[0xF & n2 >> 12];
            int n7 = n6 + 1;
            byArray[n6] = HEX_CHARS[0xF & n2 >> 8];
            int n8 = n7 + 1;
            byArray[n7] = HEX_CHARS[0xF & n2 >> 4];
            int n9 = n8 + 1;
            byArray[n8] = HEX_CHARS[n2 & 0xF];
            return n9;
        }
        int n10 = n3 + 1;
        byArray[n3] = (byte)(0xE0 | n2 >> 12);
        int n11 = n10 + 1;
        byArray[n10] = (byte)(0x80 | 0x3F & n2 >> 6);
        int n12 = n11 + 1;
        byArray[n11] = (byte)(0x80 | n2 & 0x3F);
        return n12;
    }

    private int _outputRawMultiByteChar(int n2, char[] cArray, int n3, int n4) throws IOException {
        if (n2 >= 55296 && n2 <= 57343) {
            if (n3 >= n4) {
                this._reportError("Split surrogate on writeRaw() input (last character)");
            }
            this._outputSurrogates(n2, cArray[n3]);
            return n3 + 1;
        }
        byte[] byArray = this._outputBuffer;
        int n5 = this._outputTail;
        this._outputTail = n5 + 1;
        byArray[n5] = (byte)(0xE0 | n2 >> 12);
        int n6 = this._outputTail;
        this._outputTail = n6 + 1;
        byArray[n6] = (byte)(0x80 | 0x3F & n2 >> 6);
        int n7 = this._outputTail;
        this._outputTail = n7 + 1;
        byArray[n7] = (byte)(0x80 | n2 & 0x3F);
        return n3;
    }

    private int _readMore(InputStream inputStream, byte[] byArray, int n2, int n3, int n4) throws IOException {
        int n5;
        int n6 = 0;
        int n7 = n2;
        while (n7 < n3) {
            int n8 = n6 + 1;
            int n9 = n7 + 1;
            byArray[n6] = byArray[n7];
            n6 = n8;
            n7 = n9;
        }
        int n10 = n6;
        int n11 = Math.min(n4, byArray.length);
        do {
            if ((n5 = inputStream.read(byArray, n10, n11 - n10)) >= 0) continue;
            return n10;
        } while ((n10 += n5) < 3);
        return n10;
    }

    private final void _writeBytes(byte[] byArray) throws IOException {
        int n2 = byArray.length;
        if (n2 + this._outputTail > this._outputEnd) {
            this._flushBuffer();
            if (n2 > 512) {
                this._outputStream.write(byArray, 0, n2);
                return;
            }
        }
        System.arraycopy(byArray, 0, this._outputBuffer, this._outputTail, n2);
        this._outputTail = n2 + this._outputTail;
    }

    private final void _writeBytes(byte[] byArray, int n2, int n3) throws IOException {
        if (n3 + this._outputTail > this._outputEnd) {
            this._flushBuffer();
            if (n3 > 512) {
                this._outputStream.write(byArray, n2, n3);
                return;
            }
        }
        System.arraycopy(byArray, n2, this._outputBuffer, this._outputTail, n3);
        this._outputTail = n3 + this._outputTail;
    }

    private int _writeCustomEscape(byte[] byArray, int n2, SerializableString serializableString, int n3) throws IOException, JsonGenerationException {
        byte[] byArray2 = serializableString.asUnquotedUTF8();
        int n4 = byArray2.length;
        if (n4 > 6) {
            return this._handleLongCustomEscape(byArray, n2, this._outputEnd, byArray2, n3);
        }
        System.arraycopy(byArray2, 0, byArray, n2, n4);
        return n2 + n4;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void _writeCustomStringSegment2(char[] cArray, int n2, int n3) throws IOException, JsonGenerationException {
        if (this._outputTail + 6 * (n3 - n2) > this._outputEnd) {
            this._flushBuffer();
        }
        int n4 = this._outputTail;
        byte[] byArray = this._outputBuffer;
        int[] nArray = this._outputEscapes;
        char c2 = this._maximumNonEscapedChar <= 0 ? (char)'\uffff' : this._maximumNonEscapedChar;
        CharacterEscapes characterEscapes = this._characterEscapes;
        int n5 = n4;
        int n6 = n2;
        while (true) {
            int n7;
            if (n6 >= n3) {
                this._outputTail = n5;
                return;
            }
            int n8 = n6 + 1;
            char c3 = cArray[n6];
            if (c3 <= '\u007f') {
                if (nArray[c3] == 0) {
                    int n9 = n5 + 1;
                    byArray[n5] = (byte)c3;
                    n5 = n9;
                    n6 = n8;
                    continue;
                }
                int n10 = nArray[c3];
                if (n10 > 0) {
                    int n11 = n5 + 1;
                    byArray[n5] = 92;
                    n5 = n11 + 1;
                    byArray[n11] = (byte)n10;
                    n6 = n8;
                    continue;
                }
                if (n10 == -2) {
                    SerializableString serializableString = characterEscapes.getEscapeSequence(c3);
                    if (serializableString == null) {
                        this._reportError("Invalid custom escape definitions; custom escape not found for character code 0x" + Integer.toHexString(c3) + ", although was supposed to have one");
                    }
                    n5 = this._writeCustomEscape(byArray, n5, serializableString, n3 - n8);
                    n6 = n8;
                    continue;
                }
                n5 = this._writeGenericEscape(c3, n5);
                n6 = n8;
                continue;
            }
            if (c3 > c2) {
                n5 = this._writeGenericEscape(c3, n5);
                n6 = n8;
                continue;
            }
            SerializableString serializableString = characterEscapes.getEscapeSequence(c3);
            if (serializableString != null) {
                n5 = this._writeCustomEscape(byArray, n5, serializableString, n3 - n8);
                n6 = n8;
                continue;
            }
            if (c3 <= '\u07ff') {
                int n12 = n5 + 1;
                byArray[n5] = (byte)(0xC0 | c3 >> 6);
                int n13 = n12 + 1;
                byArray[n12] = (byte)(0x80 | c3 & 0x3F);
                n7 = n13;
            } else {
                n7 = this._outputMultiByteChar(c3, n5);
            }
            n5 = n7;
            n6 = n8;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private int _writeGenericEscape(int n2, int n3) throws IOException {
        int n4;
        byte[] byArray = this._outputBuffer;
        int n5 = n3 + 1;
        byArray[n3] = 92;
        int n6 = n5 + 1;
        byArray[n5] = 117;
        if (n2 > 255) {
            int n7 = 0xFF & n2 >> 8;
            int n8 = n6 + 1;
            byArray[n6] = HEX_CHARS[n7 >> 4];
            n4 = n8 + 1;
            byArray[n8] = HEX_CHARS[n7 & 0xF];
            n2 &= 0xFF;
        } else {
            int n9 = n6 + 1;
            byArray[n6] = 48;
            n4 = n9 + 1;
            byArray[n9] = 48;
        }
        int n10 = n4 + 1;
        byArray[n4] = HEX_CHARS[n2 >> 4];
        int n11 = n10 + 1;
        byArray[n10] = HEX_CHARS[n2 & 0xF];
        return n11;
    }

    private void _writeLongString(String string2) throws IOException, JsonGenerationException {
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        byte[] byArray = this._outputBuffer;
        int n2 = this._outputTail;
        this._outputTail = n2 + 1;
        byArray[n2] = 34;
        this._writeStringSegments(string2);
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        byte[] byArray2 = this._outputBuffer;
        int n3 = this._outputTail;
        this._outputTail = n3 + 1;
        byArray2[n3] = 34;
    }

    private void _writeLongString(char[] cArray, int n2, int n3) throws IOException, JsonGenerationException {
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        byte[] byArray = this._outputBuffer;
        int n4 = this._outputTail;
        this._outputTail = n4 + 1;
        byArray[n4] = 34;
        this._writeStringSegments(this._charBuffer, 0, n3);
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        byte[] byArray2 = this._outputBuffer;
        int n5 = this._outputTail;
        this._outputTail = n5 + 1;
        byArray2[n5] = 34;
    }

    private void _writeNull() throws IOException {
        if (4 + this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        System.arraycopy(NULL_BYTES, 0, this._outputBuffer, this._outputTail, 4);
        this._outputTail = 4 + this._outputTail;
    }

    private void _writeQuotedInt(int n2) throws IOException {
        if (13 + this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        byte[] byArray = this._outputBuffer;
        int n3 = this._outputTail;
        this._outputTail = n3 + 1;
        byArray[n3] = 34;
        this._outputTail = NumberOutput.outputInt(n2, this._outputBuffer, this._outputTail);
        byte[] byArray2 = this._outputBuffer;
        int n4 = this._outputTail;
        this._outputTail = n4 + 1;
        byArray2[n4] = 34;
    }

    private void _writeQuotedLong(long l2) throws IOException {
        if (23 + this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        byte[] byArray = this._outputBuffer;
        int n2 = this._outputTail;
        this._outputTail = n2 + 1;
        byArray[n2] = 34;
        this._outputTail = NumberOutput.outputLong(l2, this._outputBuffer, this._outputTail);
        byte[] byArray2 = this._outputBuffer;
        int n3 = this._outputTail;
        this._outputTail = n3 + 1;
        byArray2[n3] = 34;
    }

    private void _writeQuotedRaw(Object object) throws IOException {
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        byte[] byArray = this._outputBuffer;
        int n2 = this._outputTail;
        this._outputTail = n2 + 1;
        byArray[n2] = 34;
        this.writeRaw(object.toString());
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        byte[] byArray2 = this._outputBuffer;
        int n3 = this._outputTail;
        this._outputTail = n3 + 1;
        byArray2[n3] = 34;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void _writeSegmentedRaw(char[] cArray, int n2, int n3) throws IOException, JsonGenerationException {
        int n4 = this._outputEnd;
        byte[] byArray = this._outputBuffer;
        block0: while (n2 < n3) {
            do {
                char c2;
                if ((c2 = cArray[n2]) >= '\u0080') {
                    if (3 + this._outputTail >= this._outputEnd) {
                        this._flushBuffer();
                    }
                    int n5 = n2 + 1;
                    char c3 = cArray[n2];
                    if (c3 < '\u0800') {
                        int n6 = this._outputTail;
                        this._outputTail = n6 + 1;
                        byArray[n6] = (byte)(0xC0 | c3 >> 6);
                        int n7 = this._outputTail;
                        this._outputTail = n7 + 1;
                        byArray[n7] = (byte)(0x80 | c3 & 0x3F);
                    } else {
                        this._outputRawMultiByteChar(c3, cArray, n5, n3);
                    }
                    n2 = n5;
                    continue block0;
                }
                if (this._outputTail >= n4) {
                    this._flushBuffer();
                }
                int n8 = this._outputTail;
                this._outputTail = n8 + 1;
                byArray[n8] = (byte)c2;
            } while (++n2 < n3);
        }
    }

    private final void _writeStringSegment(char[] cArray, int n2, int n3) throws IOException, JsonGenerationException {
        int n4 = n3 + n2;
        int n5 = this._outputTail;
        byte[] byArray = this._outputBuffer;
        int[] nArray = this._outputEscapes;
        int n6 = n5;
        while (true) {
            char c2;
            if (n2 >= n4 || (c2 = cArray[n2]) > '\u007f' || nArray[c2] != 0) {
                this._outputTail = n6;
                if (n2 < n4) {
                    if (this._characterEscapes == null) break;
                    this._writeCustomStringSegment2(cArray, n2, n4);
                }
                return;
            }
            int n7 = n6 + 1;
            byArray[n6] = (byte)c2;
            ++n2;
            n6 = n7;
        }
        if (this._maximumNonEscapedChar == 0) {
            this._writeStringSegment2(cArray, n2, n4);
            return;
        }
        this._writeStringSegmentASCII2(cArray, n2, n4);
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void _writeStringSegment2(char[] cArray, int n2, int n3) throws IOException, JsonGenerationException {
        if (this._outputTail + 6 * (n3 - n2) > this._outputEnd) {
            this._flushBuffer();
        }
        int n4 = this._outputTail;
        byte[] byArray = this._outputBuffer;
        int[] nArray = this._outputEscapes;
        int n5 = n4;
        int n6 = n2;
        while (true) {
            int n7;
            if (n6 >= n3) {
                this._outputTail = n5;
                return;
            }
            int n8 = n6 + 1;
            char c2 = cArray[n6];
            if (c2 <= '\u007f') {
                if (nArray[c2] == 0) {
                    int n9 = n5 + 1;
                    byArray[n5] = (byte)c2;
                    n5 = n9;
                    n6 = n8;
                    continue;
                }
                int n10 = nArray[c2];
                if (n10 > 0) {
                    int n11 = n5 + 1;
                    byArray[n5] = 92;
                    n5 = n11 + 1;
                    byArray[n11] = (byte)n10;
                    n6 = n8;
                    continue;
                }
                n5 = this._writeGenericEscape(c2, n5);
                n6 = n8;
                continue;
            }
            if (c2 <= '\u07ff') {
                int n12 = n5 + 1;
                byArray[n5] = (byte)(0xC0 | c2 >> 6);
                int n13 = n12 + 1;
                byArray[n12] = (byte)(0x80 | c2 & 0x3F);
                n7 = n13;
            } else {
                n7 = this._outputMultiByteChar(c2, n5);
            }
            n5 = n7;
            n6 = n8;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void _writeStringSegmentASCII2(char[] cArray, int n2, int n3) throws IOException, JsonGenerationException {
        if (this._outputTail + 6 * (n3 - n2) > this._outputEnd) {
            this._flushBuffer();
        }
        int n4 = this._outputTail;
        byte[] byArray = this._outputBuffer;
        int[] nArray = this._outputEscapes;
        int n5 = this._maximumNonEscapedChar;
        int n6 = n4;
        int n7 = n2;
        while (true) {
            int n8;
            if (n7 >= n3) {
                this._outputTail = n6;
                return;
            }
            int n9 = n7 + 1;
            char c2 = cArray[n7];
            if (c2 <= '\u007f') {
                if (nArray[c2] == 0) {
                    int n10 = n6 + 1;
                    byArray[n6] = (byte)c2;
                    n6 = n10;
                    n7 = n9;
                    continue;
                }
                int n11 = nArray[c2];
                if (n11 > 0) {
                    int n12 = n6 + 1;
                    byArray[n6] = 92;
                    n6 = n12 + 1;
                    byArray[n12] = (byte)n11;
                    n7 = n9;
                    continue;
                }
                n6 = this._writeGenericEscape(c2, n6);
                n7 = n9;
                continue;
            }
            if (c2 > n5) {
                n6 = this._writeGenericEscape(c2, n6);
                n7 = n9;
                continue;
            }
            if (c2 <= '\u07ff') {
                int n13 = n6 + 1;
                byArray[n6] = (byte)(0xC0 | c2 >> 6);
                int n14 = n13 + 1;
                byArray[n13] = (byte)(0x80 | c2 & 0x3F);
                n8 = n14;
            } else {
                n8 = this._outputMultiByteChar(c2, n6);
            }
            n6 = n8;
            n7 = n9;
        }
    }

    private final void _writeStringSegments(String string2) throws IOException, JsonGenerationException {
        int n2;
        int n3 = 0;
        char[] cArray = this._charBuffer;
        for (int i2 = string2.length(); i2 > 0; i2 -= n2) {
            n2 = Math.min(this._outputMaxContiguous, i2);
            string2.getChars(n3, n3 + n2, cArray, 0);
            if (n2 + this._outputTail > this._outputEnd) {
                this._flushBuffer();
            }
            this._writeStringSegment(cArray, 0, n2);
            n3 += n2;
        }
    }

    private final void _writeStringSegments(char[] cArray, int n2, int n3) throws IOException, JsonGenerationException {
        int n4;
        do {
            if ((n4 = Math.min(this._outputMaxContiguous, n3)) + this._outputTail > this._outputEnd) {
                this._flushBuffer();
            }
            this._writeStringSegment(cArray, n2, n4);
            n2 += n4;
        } while ((n3 -= n4) > 0);
    }

    private void _writeUTF8Segment(byte[] byArray, int n2, int n3) throws IOException, JsonGenerationException {
        int[] nArray = this._outputEscapes;
        int n4 = n2 + n3;
        int n5 = n2;
        while (n5 < n4) {
            int n6 = n5 + 1;
            byte by2 = byArray[n5];
            if (by2 >= 0 && nArray[by2] != 0) {
                this._writeUTF8Segment2(byArray, n2, n3);
                return;
            }
            n5 = n6;
        }
        if (n3 + this._outputTail > this._outputEnd) {
            this._flushBuffer();
        }
        System.arraycopy(byArray, n2, this._outputBuffer, this._outputTail, n3);
        this._outputTail = n3 + this._outputTail;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void _writeUTF8Segment2(byte[] byArray, int n2, int n3) throws IOException, JsonGenerationException {
        int n4 = this._outputTail;
        if (n4 + n3 * 6 > this._outputEnd) {
            this._flushBuffer();
            n4 = this._outputTail;
        }
        byte[] byArray2 = this._outputBuffer;
        int[] nArray = this._outputEscapes;
        int n5 = n3 + n2;
        int n6 = n4;
        int n7 = n2;
        while (true) {
            int n8;
            if (n7 >= n5) {
                this._outputTail = n6;
                return;
            }
            int n9 = n7 + 1;
            byte by2 = byArray[n7];
            if (by2 < 0 || nArray[by2] == 0) {
                int n10 = n6 + 1;
                byArray2[n6] = by2;
                n6 = n10;
                n7 = n9;
                continue;
            }
            int n11 = nArray[by2];
            if (n11 > 0) {
                int n12 = n6 + 1;
                byArray2[n6] = 92;
                int n13 = n12 + 1;
                byArray2[n12] = (byte)n11;
                n8 = n13;
            } else {
                n8 = this._writeGenericEscape(by2, n6);
            }
            n6 = n8;
            n7 = n9;
        }
    }

    private void _writeUTF8Segments(byte[] byArray, int n2, int n3) throws IOException, JsonGenerationException {
        int n4;
        do {
            n4 = Math.min(this._outputMaxContiguous, n3);
            this._writeUTF8Segment(byArray, n2, n4);
            n2 += n4;
        } while ((n3 -= n4) > 0);
    }

    protected final int _decodeSurrogate(int n2, int n3) throws IOException {
        if (n3 < 56320 || n3 > 57343) {
            this._reportError("Incomplete surrogate pair: first char 0x" + Integer.toHexString(n2) + ", second 0x" + Integer.toHexString(n3));
        }
        return 65536 + (n2 - 55296 << 10) + (n3 - 56320);
    }

    protected final void _flushBuffer() throws IOException {
        int n2 = this._outputTail;
        if (n2 > 0) {
            this._outputTail = 0;
            this._outputStream.write(this._outputBuffer, 0, n2);
        }
    }

    protected final void _outputSurrogates(int n2, int n3) throws IOException {
        int n4 = this._decodeSurrogate(n2, n3);
        if (4 + this._outputTail > this._outputEnd) {
            this._flushBuffer();
        }
        byte[] byArray = this._outputBuffer;
        int n5 = this._outputTail;
        this._outputTail = n5 + 1;
        byArray[n5] = (byte)(0xF0 | n4 >> 18);
        int n6 = this._outputTail;
        this._outputTail = n6 + 1;
        byArray[n6] = (byte)(0x80 | 0x3F & n4 >> 12);
        int n7 = this._outputTail;
        this._outputTail = n7 + 1;
        byArray[n7] = (byte)(0x80 | 0x3F & n4 >> 6);
        int n8 = this._outputTail;
        this._outputTail = n8 + 1;
        byArray[n8] = (byte)(0x80 | n4 & 0x3F);
    }

    @Override
    protected void _releaseBuffers() {
        char[] cArray;
        byte[] byArray = this._outputBuffer;
        if (byArray != null && this._bufferRecyclable) {
            this._outputBuffer = null;
            this._ioContext.releaseWriteEncodingBuffer(byArray);
        }
        if ((cArray = this._charBuffer) != null) {
            this._charBuffer = null;
            this._ioContext.releaseConcatBuffer(cArray);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected final void _verifyPrettyValueWrite(String string2, int n2) throws IOException, JsonGenerationException {
        switch (n2) {
            default: {
                this._cantHappen();
                return;
            }
            case 1: {
                this._cfgPrettyPrinter.writeArrayValueSeparator(this);
                return;
            }
            case 2: {
                this._cfgPrettyPrinter.writeObjectFieldValueSeparator(this);
                return;
            }
            case 3: {
                this._cfgPrettyPrinter.writeRootValueSeparator(this);
                return;
            }
            case 0: {
                if (this._writeContext.inArray()) {
                    this._cfgPrettyPrinter.beforeArrayValues(this);
                    return;
                }
                if (!this._writeContext.inObject()) return;
                this._cfgPrettyPrinter.beforeObjectEntries(this);
                return;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected final void _verifyValueWrite(String var1_1) throws IOException, JsonGenerationException {
        var2_2 = this._writeContext.writeValue();
        if (var2_2 == 5) {
            this._reportError("Can not " + var1_1 + ", expecting field name");
        }
        if (this._cfgPrettyPrinter == null) {
            switch (var2_2) {
                default: {
                    return;
                }
                case 1: {
                    var4_3 = 44;
lbl11:
                    // 2 sources

                    while (true) {
                        if (this._outputTail >= this._outputEnd) {
                            this._flushBuffer();
                        }
                        this._outputBuffer[this._outputTail] = var4_3;
                        this._outputTail = 1 + this._outputTail;
                        return;
                    }
                }
                case 2: {
                    var4_3 = 58;
                    ** continue;
                }
                case 3: 
            }
            if (this._rootValueSeparator == null || (var3_4 = this._rootValueSeparator.asUnquotedUTF8()).length <= 0) ** continue;
            this._writeBytes(var3_4);
            return;
        }
        this._verifyPrettyValueWrite(var1_1, var2_2);
    }

    protected int _writeBinary(Base64Variant base64Variant, InputStream inputStream, byte[] byArray) throws IOException, JsonGenerationException {
        int n2 = 0;
        int n3 = 0;
        int n4 = -3;
        int n5 = 0;
        int n6 = -6 + this._outputEnd;
        int n7 = base64Variant.getMaxLineLength() >> 2;
        while (true) {
            if (n2 > n4) {
                n3 = this._readMore(inputStream, byArray, n2, n3, byArray.length);
                n2 = 0;
                if (n3 < 3) {
                    if (n3 < 0) {
                        if (this._outputTail > n6) {
                            this._flushBuffer();
                        }
                        int n8 = 0 + 1;
                        int n9 = byArray[0] << 16;
                        int n10 = 1;
                        if (n8 < n3) {
                            n9 |= (0xFF & byArray[n8]) << 8;
                            n10 = 2;
                        }
                        n5 += n10;
                        this._outputTail = base64Variant.encodeBase64Partial(n9, n10, this._outputBuffer, this._outputTail);
                    }
                    return n5;
                }
                n4 = n3 - 3;
            }
            if (this._outputTail > n6) {
                this._flushBuffer();
            }
            int n11 = n2 + 1;
            int n12 = byArray[n2] << 8;
            int n13 = n11 + 1;
            int n14 = (n12 | 0xFF & byArray[n11]) << 8;
            int n15 = n13 + 1;
            int n16 = n14 | 0xFF & byArray[n13];
            n5 += 3;
            this._outputTail = base64Variant.encodeBase64Chunk(n16, this._outputBuffer, this._outputTail);
            if (--n7 <= 0) {
                byte[] byArray2 = this._outputBuffer;
                int n17 = this._outputTail;
                this._outputTail = n17 + 1;
                byArray2[n17] = 92;
                byte[] byArray3 = this._outputBuffer;
                int n18 = this._outputTail;
                this._outputTail = n18 + 1;
                byArray3[n18] = 110;
                n7 = base64Variant.getMaxLineLength() >> 2;
            }
            n2 = n15;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected int _writeBinary(Base64Variant base64Variant, InputStream inputStream, byte[] byArray, int n2) throws IOException, JsonGenerationException {
        int n3 = 0;
        int n4 = 0;
        int n5 = -3;
        int n6 = -6 + this._outputEnd;
        int n7 = base64Variant.getMaxLineLength() >> 2;
        while (true) {
            block11: {
                block12: {
                    int n8;
                    block10: {
                        if (n2 <= 2) break block10;
                        if (n3 <= n5) break block11;
                        n4 = this._readMore(inputStream, byArray, n3, n4, n2);
                        n3 = 0;
                        if (n4 >= 3) break block12;
                    }
                    if (n2 > 0 && (n8 = this._readMore(inputStream, byArray, n3, n4, n2)) > 0) {
                        int n9;
                        if (this._outputTail > n6) {
                            this._flushBuffer();
                        }
                        int n10 = 0 + 1;
                        int n11 = byArray[0] << 16;
                        if (n10 < n8) {
                            n11 |= (0xFF & byArray[n10]) << 8;
                            n9 = 2;
                        } else {
                            n9 = 1;
                        }
                        this._outputTail = base64Variant.encodeBase64Partial(n11, n9, this._outputBuffer, this._outputTail);
                        n2 -= n9;
                    }
                    return n2;
                }
                n5 = n4 - 3;
            }
            if (this._outputTail > n6) {
                this._flushBuffer();
            }
            int n12 = n3 + 1;
            int n13 = byArray[n3] << 8;
            int n14 = n12 + 1;
            int n15 = (n13 | 0xFF & byArray[n12]) << 8;
            int n16 = n14 + 1;
            int n17 = n15 | 0xFF & byArray[n14];
            n2 -= 3;
            this._outputTail = base64Variant.encodeBase64Chunk(n17, this._outputBuffer, this._outputTail);
            if (--n7 <= 0) {
                byte[] byArray2 = this._outputBuffer;
                int n18 = this._outputTail;
                this._outputTail = n18 + 1;
                byArray2[n18] = 92;
                byte[] byArray3 = this._outputBuffer;
                int n19 = this._outputTail;
                this._outputTail = n19 + 1;
                byArray3[n19] = 110;
                n7 = base64Variant.getMaxLineLength() >> 2;
            }
            n3 = n16;
        }
    }

    protected void _writeBinary(Base64Variant base64Variant, byte[] byArray, int n2, int n3) throws IOException, JsonGenerationException {
        int n4 = n3 - 3;
        int n5 = -6 + this._outputEnd;
        int n6 = base64Variant.getMaxLineLength() >> 2;
        int n7 = n2;
        while (n7 <= n4) {
            if (this._outputTail > n5) {
                this._flushBuffer();
            }
            int n8 = n7 + 1;
            int n9 = byArray[n7] << 8;
            int n10 = n8 + 1;
            int n11 = (n9 | 0xFF & byArray[n8]) << 8;
            int n12 = n10 + 1;
            this._outputTail = base64Variant.encodeBase64Chunk(n11 | 0xFF & byArray[n10], this._outputBuffer, this._outputTail);
            if (--n6 <= 0) {
                byte[] byArray2 = this._outputBuffer;
                int n13 = this._outputTail;
                this._outputTail = n13 + 1;
                byArray2[n13] = 92;
                byte[] byArray3 = this._outputBuffer;
                int n14 = this._outputTail;
                this._outputTail = n14 + 1;
                byArray3[n14] = 110;
                n6 = base64Variant.getMaxLineLength() >> 2;
            }
            n7 = n12;
        }
        int n15 = n3 - n7;
        if (n15 > 0) {
            if (this._outputTail > n5) {
                this._flushBuffer();
            }
            int n16 = n7 + 1;
            int n17 = byArray[n7] << 16;
            if (n15 == 2) {
                int cfr_ignored_0 = n16 + 1;
                n17 |= (0xFF & byArray[n16]) << 8;
            }
            this._outputTail = base64Variant.encodeBase64Partial(n17, n15, this._outputBuffer, this._outputTail);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected final void _writeFieldName(SerializableString serializableString) throws IOException, JsonGenerationException {
        if (!this.isEnabled(JsonGenerator.Feature.QUOTE_FIELD_NAMES)) {
            int n2 = serializableString.appendQuotedUTF8(this._outputBuffer, this._outputTail);
            if (n2 < 0) {
                this._writeBytes(serializableString.asQuotedUTF8());
                return;
            }
            this._outputTail = n2 + this._outputTail;
            return;
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        byte[] byArray = this._outputBuffer;
        int n3 = this._outputTail;
        this._outputTail = n3 + 1;
        byArray[n3] = 34;
        int n4 = serializableString.appendQuotedUTF8(this._outputBuffer, this._outputTail);
        if (n4 < 0) {
            this._writeBytes(serializableString.asQuotedUTF8());
        } else {
            this._outputTail = n4 + this._outputTail;
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        byte[] byArray2 = this._outputBuffer;
        int n5 = this._outputTail;
        this._outputTail = n5 + 1;
        byArray2[n5] = 34;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected final void _writeFieldName(String string2) throws IOException, JsonGenerationException {
        if (!this.isEnabled(JsonGenerator.Feature.QUOTE_FIELD_NAMES)) {
            this._writeStringSegments(string2);
            return;
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        byte[] byArray = this._outputBuffer;
        int n2 = this._outputTail;
        this._outputTail = n2 + 1;
        byArray[n2] = 34;
        int n3 = string2.length();
        if (n3 <= this._charBufferLength) {
            string2.getChars(0, n3, this._charBuffer, 0);
            if (n3 <= this._outputMaxContiguous) {
                if (n3 + this._outputTail > this._outputEnd) {
                    this._flushBuffer();
                }
                this._writeStringSegment(this._charBuffer, 0, n3);
            } else {
                this._writeStringSegments(this._charBuffer, 0, n3);
            }
        } else {
            this._writeStringSegments(string2);
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        byte[] byArray2 = this._outputBuffer;
        int n4 = this._outputTail;
        this._outputTail = n4 + 1;
        byArray2[n4] = 34;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected final void _writePPFieldName(SerializableString serializableString, boolean bl2) throws IOException, JsonGenerationException {
        boolean bl3;
        if (bl2) {
            this._cfgPrettyPrinter.writeObjectEntrySeparator(this);
        } else {
            this._cfgPrettyPrinter.beforeObjectEntries(this);
        }
        if (bl3 = this.isEnabled(JsonGenerator.Feature.QUOTE_FIELD_NAMES)) {
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            byte[] byArray = this._outputBuffer;
            int n2 = this._outputTail;
            this._outputTail = n2 + 1;
            byArray[n2] = 34;
        }
        this._writeBytes(serializableString.asQuotedUTF8());
        if (bl3) {
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            byte[] byArray = this._outputBuffer;
            int n3 = this._outputTail;
            this._outputTail = n3 + 1;
            byArray[n3] = 34;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected final void _writePPFieldName(String string2, boolean bl2) throws IOException, JsonGenerationException {
        if (bl2) {
            this._cfgPrettyPrinter.writeObjectEntrySeparator(this);
        } else {
            this._cfgPrettyPrinter.beforeObjectEntries(this);
        }
        if (!this.isEnabled(JsonGenerator.Feature.QUOTE_FIELD_NAMES)) {
            this._writeStringSegments(string2);
            return;
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        byte[] byArray = this._outputBuffer;
        int n2 = this._outputTail;
        this._outputTail = n2 + 1;
        byArray[n2] = 34;
        int n3 = string2.length();
        if (n3 <= this._charBufferLength) {
            string2.getChars(0, n3, this._charBuffer, 0);
            if (n3 <= this._outputMaxContiguous) {
                if (n3 + this._outputTail > this._outputEnd) {
                    this._flushBuffer();
                }
                this._writeStringSegment(this._charBuffer, 0, n3);
            } else {
                this._writeStringSegments(this._charBuffer, 0, n3);
            }
        } else {
            this._writeStringSegments(string2);
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        byte[] byArray2 = this._outputBuffer;
        int n4 = this._outputTail;
        this._outputTail = n4 + 1;
        byArray2[n4] = 34;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void close() throws IOException {
        super.close();
        if (this._outputBuffer != null && this.isEnabled(JsonGenerator.Feature.AUTO_CLOSE_JSON_CONTENT)) {
            while (true) {
                JsonStreamContext jsonStreamContext;
                if ((jsonStreamContext = this.getOutputContext()).inArray()) {
                    this.writeEndArray();
                    continue;
                }
                if (!jsonStreamContext.inObject()) break;
                this.writeEndObject();
            }
        }
        this._flushBuffer();
        if (this._outputStream != null) {
            if (this._ioContext.isResourceManaged() || this.isEnabled(JsonGenerator.Feature.AUTO_CLOSE_TARGET)) {
                this._outputStream.close();
            } else if (this.isEnabled(JsonGenerator.Feature.FLUSH_PASSED_TO_STREAM)) {
                this._outputStream.flush();
            }
        }
        this._releaseBuffers();
    }

    @Override
    public final void flush() throws IOException {
        this._flushBuffer();
        if (this._outputStream != null && this.isEnabled(JsonGenerator.Feature.FLUSH_PASSED_TO_STREAM)) {
            this._outputStream.flush();
        }
    }

    @Override
    public Object getOutputTarget() {
        return this._outputStream;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public int writeBinary(Base64Variant var1_1, InputStream var2_2, int var3_3) throws IOException, JsonGenerationException {
        block8: {
            this._verifyValueWrite("write binary value");
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            var4_4 = this._outputBuffer;
            var5_5 = this._outputTail;
            this._outputTail = var5_5 + 1;
            var4_4[var5_5] = 34;
            var6_6 = this._ioContext.allocBase64Buffer();
            if (var3_3 < 0) {
                var9_8 = var12_7 = this._writeBinary(var1_1, var2_2, var6_6);
lbl12:
                // 2 sources

                while (true) {
                    this._ioContext.releaseBase64Buffer(var6_6);
                    if (this._outputTail >= this._outputEnd) {
                        this._flushBuffer();
                    }
                    var10_9 = this._outputBuffer;
                    var11_10 = this._outputTail;
                    this._outputTail = var11_10 + 1;
                    var10_9[var11_10] = 34;
                    return var9_8;
                }
            }
            try {
                var8_11 = this._writeBinary(var1_1, var2_2, var6_6, var3_3);
                if (var8_11 <= 0) break block8;
            }
            catch (Throwable var7_12) {
                this._ioContext.releaseBase64Buffer(var6_6);
                throw var7_12;
            }
            this._reportError("Too few bytes available: missing " + var8_11 + " bytes (out of " + var3_3 + ")");
        }
        var9_8 = var3_3;
        ** while (true)
    }

    @Override
    public void writeBinary(Base64Variant base64Variant, byte[] byArray, int n2, int n3) throws IOException, JsonGenerationException {
        this._verifyValueWrite("write binary value");
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        byte[] byArray2 = this._outputBuffer;
        int n4 = this._outputTail;
        this._outputTail = n4 + 1;
        byArray2[n4] = 34;
        this._writeBinary(base64Variant, byArray, n2, n2 + n3);
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        byte[] byArray3 = this._outputBuffer;
        int n5 = this._outputTail;
        this._outputTail = n5 + 1;
        byArray3[n5] = 34;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void writeBoolean(boolean bl2) throws IOException, JsonGenerationException {
        this._verifyValueWrite("write boolean value");
        if (5 + this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        byte[] byArray = bl2 ? TRUE_BYTES : FALSE_BYTES;
        int n2 = byArray.length;
        System.arraycopy(byArray, 0, this._outputBuffer, this._outputTail, n2);
        this._outputTail = n2 + this._outputTail;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public final void writeEndArray() throws IOException, JsonGenerationException {
        if (!this._writeContext.inArray()) {
            this._reportError("Current context not an ARRAY but " + this._writeContext.getTypeDesc());
        }
        if (this._cfgPrettyPrinter != null) {
            this._cfgPrettyPrinter.writeEndArray(this, this._writeContext.getEntryCount());
        } else {
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            byte[] byArray = this._outputBuffer;
            int n2 = this._outputTail;
            this._outputTail = n2 + 1;
            byArray[n2] = 93;
        }
        this._writeContext = this._writeContext.getParent();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public final void writeEndObject() throws IOException, JsonGenerationException {
        if (!this._writeContext.inObject()) {
            this._reportError("Current context not an object but " + this._writeContext.getTypeDesc());
        }
        if (this._cfgPrettyPrinter != null) {
            this._cfgPrettyPrinter.writeEndObject(this, this._writeContext.getEntryCount());
        } else {
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            byte[] byArray = this._outputBuffer;
            int n2 = this._outputTail;
            this._outputTail = n2 + 1;
            byArray[n2] = 125;
        }
        this._writeContext = this._writeContext.getParent();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public final void writeFieldName(SerializableString serializableString) throws IOException, JsonGenerationException {
        int n2 = 1;
        int n3 = this._writeContext.writeFieldName(serializableString.getValue());
        if (n3 == 4) {
            this._reportError("Can not write a field name, expecting a value");
        }
        if (this._cfgPrettyPrinter != null) {
            if (n3 != n2) {
                n2 = 0;
            }
            this._writePPFieldName(serializableString, n2 != 0);
            return;
        }
        if (n3 == n2) {
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            byte[] byArray = this._outputBuffer;
            int n4 = this._outputTail;
            this._outputTail = n4 + 1;
            byArray[n4] = 44;
        }
        this._writeFieldName(serializableString);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public final void writeFieldName(String string2) throws IOException, JsonGenerationException {
        int n2 = 1;
        int n3 = this._writeContext.writeFieldName(string2);
        if (n3 == 4) {
            this._reportError("Can not write a field name, expecting a value");
        }
        if (this._cfgPrettyPrinter != null) {
            if (n3 != n2) {
                n2 = 0;
            }
            this._writePPFieldName(string2, n2 != 0);
            return;
        }
        if (n3 == n2) {
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            byte[] byArray = this._outputBuffer;
            int n4 = this._outputTail;
            this._outputTail = n4 + 1;
            byArray[n4] = 44;
        }
        this._writeFieldName(string2);
    }

    @Override
    public void writeNull() throws IOException, JsonGenerationException {
        this._verifyValueWrite("write null value");
        this._writeNull();
    }

    @Override
    public void writeNumber(double d2) throws IOException, JsonGenerationException {
        if (this._cfgNumbersAsStrings || (Double.isNaN(d2) || Double.isInfinite(d2)) && this.isEnabled(JsonGenerator.Feature.QUOTE_NON_NUMERIC_NUMBERS)) {
            this.writeString(String.valueOf(d2));
            return;
        }
        this._verifyValueWrite("write number");
        this.writeRaw(String.valueOf(d2));
    }

    @Override
    public void writeNumber(float f2) throws IOException, JsonGenerationException {
        if (this._cfgNumbersAsStrings || (Float.isNaN(f2) || Float.isInfinite(f2)) && this.isEnabled(JsonGenerator.Feature.QUOTE_NON_NUMERIC_NUMBERS)) {
            this.writeString(String.valueOf(f2));
            return;
        }
        this._verifyValueWrite("write number");
        this.writeRaw(String.valueOf(f2));
    }

    @Override
    public void writeNumber(int n2) throws IOException, JsonGenerationException {
        this._verifyValueWrite("write number");
        if (11 + this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        if (this._cfgNumbersAsStrings) {
            this._writeQuotedInt(n2);
            return;
        }
        this._outputTail = NumberOutput.outputInt(n2, this._outputBuffer, this._outputTail);
    }

    @Override
    public void writeNumber(long l2) throws IOException, JsonGenerationException {
        this._verifyValueWrite("write number");
        if (this._cfgNumbersAsStrings) {
            this._writeQuotedLong(l2);
            return;
        }
        if (21 + this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputTail = NumberOutput.outputLong(l2, this._outputBuffer, this._outputTail);
    }

    @Override
    public void writeNumber(String string2) throws IOException, JsonGenerationException {
        this._verifyValueWrite("write number");
        if (this._cfgNumbersAsStrings) {
            this._writeQuotedRaw(string2);
            return;
        }
        this.writeRaw(string2);
    }

    @Override
    public void writeNumber(BigDecimal bigDecimal) throws IOException, JsonGenerationException {
        this._verifyValueWrite("write number");
        if (bigDecimal == null) {
            this._writeNull();
            return;
        }
        if (this._cfgNumbersAsStrings) {
            this._writeQuotedRaw(bigDecimal);
            return;
        }
        this.writeRaw(bigDecimal.toString());
    }

    @Override
    public void writeNumber(BigInteger bigInteger) throws IOException, JsonGenerationException {
        this._verifyValueWrite("write number");
        if (bigInteger == null) {
            this._writeNull();
            return;
        }
        if (this._cfgNumbersAsStrings) {
            this._writeQuotedRaw(bigInteger);
            return;
        }
        this.writeRaw(bigInteger.toString());
    }

    @Override
    public void writeRaw(char c2) throws IOException, JsonGenerationException {
        if (3 + this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        byte[] byArray = this._outputBuffer;
        if (c2 <= '\u007f') {
            int n2 = this._outputTail;
            this._outputTail = n2 + 1;
            byArray[n2] = (byte)c2;
            return;
        }
        if (c2 < '\u0800') {
            int n3 = this._outputTail;
            this._outputTail = n3 + 1;
            byArray[n3] = (byte)(0xC0 | c2 >> 6);
            int n4 = this._outputTail;
            this._outputTail = n4 + 1;
            byArray[n4] = (byte)(0x80 | c2 & 0x3F);
            return;
        }
        this._outputRawMultiByteChar(c2, null, 0, 0);
    }

    @Override
    public void writeRaw(SerializableString serializableString) throws IOException, JsonGenerationException {
        byte[] byArray = serializableString.asUnquotedUTF8();
        if (byArray.length > 0) {
            this._writeBytes(byArray);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void writeRaw(String string2) throws IOException, JsonGenerationException {
        int n2 = 0;
        int n3 = string2.length();
        while (n3 > 0) {
            char[] cArray = this._charBuffer;
            int n4 = cArray.length;
            int n5 = n3 < n4 ? n3 : n4;
            string2.getChars(n2, n2 + n5, cArray, 0);
            this.writeRaw(cArray, 0, n5);
            n2 += n5;
            n3 -= n5;
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void writeRaw(String string2, int n2, int n3) throws IOException, JsonGenerationException {
        while (n3 > 0) {
            char[] cArray = this._charBuffer;
            int n4 = cArray.length;
            int n5 = n3 < n4 ? n3 : n4;
            string2.getChars(n2, n2 + n5, cArray, 0);
            this.writeRaw(cArray, 0, n5);
            n2 += n5;
            n3 -= n5;
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public final void writeRaw(char[] cArray, int n2, int n3) throws IOException, JsonGenerationException {
        int n4 = n3 + (n3 + n3);
        if (n4 + this._outputTail > this._outputEnd) {
            if (this._outputEnd < n4) {
                this._writeSegmentedRaw(cArray, n2, n3);
                return;
            }
            this._flushBuffer();
        }
        int n5 = n3 + n2;
        block0: while (true) {
            if (n2 >= n5) {
                return;
            }
            do {
                char c2;
                if ((c2 = cArray[n2]) > '\u007f') {
                    int n6 = n2 + 1;
                    char c3 = cArray[n2];
                    if (c3 < '\u0800') {
                        byte[] byArray = this._outputBuffer;
                        int n7 = this._outputTail;
                        this._outputTail = n7 + 1;
                        byArray[n7] = (byte)(0xC0 | c3 >> 6);
                        byte[] byArray2 = this._outputBuffer;
                        int n8 = this._outputTail;
                        this._outputTail = n8 + 1;
                        byArray2[n8] = (byte)(0x80 | c3 & 0x3F);
                    } else {
                        this._outputRawMultiByteChar(c3, cArray, n6, n5);
                    }
                    n2 = n6;
                    continue block0;
                }
                byte[] byArray = this._outputBuffer;
                int n9 = this._outputTail;
                this._outputTail = n9 + 1;
                byArray[n9] = (byte)c2;
            } while (++n2 < n5);
            break;
        }
    }

    @Override
    public void writeRawUTF8String(byte[] byArray, int n2, int n3) throws IOException, JsonGenerationException {
        this._verifyValueWrite("write text value");
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        byte[] byArray2 = this._outputBuffer;
        int n4 = this._outputTail;
        this._outputTail = n4 + 1;
        byArray2[n4] = 34;
        this._writeBytes(byArray, n2, n3);
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        byte[] byArray3 = this._outputBuffer;
        int n5 = this._outputTail;
        this._outputTail = n5 + 1;
        byArray3[n5] = 34;
    }

    @Override
    public final void writeStartArray() throws IOException, JsonGenerationException {
        this._verifyValueWrite("start an array");
        this._writeContext = this._writeContext.createChildArrayContext();
        if (this._cfgPrettyPrinter != null) {
            this._cfgPrettyPrinter.writeStartArray(this);
            return;
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        byte[] byArray = this._outputBuffer;
        int n2 = this._outputTail;
        this._outputTail = n2 + 1;
        byArray[n2] = 91;
    }

    @Override
    public final void writeStartObject() throws IOException, JsonGenerationException {
        this._verifyValueWrite("start an object");
        this._writeContext = this._writeContext.createChildObjectContext();
        if (this._cfgPrettyPrinter != null) {
            this._cfgPrettyPrinter.writeStartObject(this);
            return;
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        byte[] byArray = this._outputBuffer;
        int n2 = this._outputTail;
        this._outputTail = n2 + 1;
        byArray[n2] = 123;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public final void writeString(SerializableString serializableString) throws IOException, JsonGenerationException {
        this._verifyValueWrite("write text value");
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        byte[] byArray = this._outputBuffer;
        int n2 = this._outputTail;
        this._outputTail = n2 + 1;
        byArray[n2] = 34;
        int n3 = serializableString.appendQuotedUTF8(this._outputBuffer, this._outputTail);
        if (n3 < 0) {
            this._writeBytes(serializableString.asQuotedUTF8());
        } else {
            this._outputTail = n3 + this._outputTail;
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        byte[] byArray2 = this._outputBuffer;
        int n4 = this._outputTail;
        this._outputTail = n4 + 1;
        byArray2[n4] = 34;
    }

    @Override
    public void writeString(String string2) throws IOException, JsonGenerationException {
        this._verifyValueWrite("write text value");
        if (string2 == null) {
            this._writeNull();
            return;
        }
        int n2 = string2.length();
        if (n2 > this._charBufferLength) {
            this._writeLongString(string2);
            return;
        }
        string2.getChars(0, n2, this._charBuffer, 0);
        if (n2 > this._outputMaxContiguous) {
            this._writeLongString(this._charBuffer, 0, n2);
            return;
        }
        if (n2 + this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        byte[] byArray = this._outputBuffer;
        int n3 = this._outputTail;
        this._outputTail = n3 + 1;
        byArray[n3] = 34;
        this._writeStringSegment(this._charBuffer, 0, n2);
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        byte[] byArray2 = this._outputBuffer;
        int n4 = this._outputTail;
        this._outputTail = n4 + 1;
        byArray2[n4] = 34;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void writeString(char[] cArray, int n2, int n3) throws IOException, JsonGenerationException {
        this._verifyValueWrite("write text value");
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        byte[] byArray = this._outputBuffer;
        int n4 = this._outputTail;
        this._outputTail = n4 + 1;
        byArray[n4] = 34;
        if (n3 <= this._outputMaxContiguous) {
            if (n3 + this._outputTail > this._outputEnd) {
                this._flushBuffer();
            }
            this._writeStringSegment(cArray, n2, n3);
        } else {
            this._writeStringSegments(cArray, n2, n3);
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        byte[] byArray2 = this._outputBuffer;
        int n5 = this._outputTail;
        this._outputTail = n5 + 1;
        byArray2[n5] = 34;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void writeUTF8String(byte[] byArray, int n2, int n3) throws IOException, JsonGenerationException {
        this._verifyValueWrite("write text value");
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        byte[] byArray2 = this._outputBuffer;
        int n4 = this._outputTail;
        this._outputTail = n4 + 1;
        byArray2[n4] = 34;
        if (n3 <= this._outputMaxContiguous) {
            this._writeUTF8Segment(byArray, n2, n3);
        } else {
            this._writeUTF8Segments(byArray, n2, n3);
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        byte[] byArray3 = this._outputBuffer;
        int n5 = this._outputTail;
        this._outputTail = n5 + 1;
        byArray3[n5] = 34;
    }
}

