/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.json;

import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.base.ParserBase;
import com.fasterxml.jackson.core.io.CharTypes;
import com.fasterxml.jackson.core.io.IOContext;
import com.fasterxml.jackson.core.json.CoreVersion;
import com.fasterxml.jackson.core.sym.CharsToNameCanonicalizer;
import com.fasterxml.jackson.core.util.ByteArrayBuilder;
import com.fasterxml.jackson.core.util.TextBuffer;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;

public final class ReaderBasedJsonParser
extends ParserBase {
    protected final int _hashSeed;
    protected char[] _inputBuffer;
    protected ObjectCodec _objectCodec;
    protected Reader _reader;
    protected final CharsToNameCanonicalizer _symbols;
    protected boolean _tokenIncomplete = false;

    public ReaderBasedJsonParser(IOContext iOContext, int n2, Reader reader, ObjectCodec objectCodec, CharsToNameCanonicalizer charsToNameCanonicalizer) {
        super(iOContext, n2);
        this._reader = reader;
        this._inputBuffer = iOContext.allocTokenBuffer();
        this._objectCodec = objectCodec;
        this._symbols = charsToNameCanonicalizer;
        this._hashSeed = charsToNameCanonicalizer.hashSeed();
    }

    /*
     * Enabled aggressive block sorting
     */
    private JsonToken _nextAfterName() {
        this._nameCopied = false;
        JsonToken jsonToken = this._nextToken;
        this._nextToken = null;
        if (jsonToken == JsonToken.START_ARRAY) {
            this._parsingContext = this._parsingContext.createChildArrayContext(this._tokenInputRow, this._tokenInputCol);
        } else if (jsonToken == JsonToken.START_OBJECT) {
            this._parsingContext = this._parsingContext.createChildObjectContext(this._tokenInputRow, this._tokenInputCol);
        }
        this._currToken = jsonToken;
        return jsonToken;
    }

    /*
     * Enabled aggressive block sorting
     */
    private String _parseFieldName2(int n2, int n3, int n4) throws IOException, JsonParseException {
        this._textBuffer.resetWithShared(this._inputBuffer, n2, this._inputPtr - n2);
        char[] cArray = this._textBuffer.getCurrentSegment();
        int n5 = this._textBuffer.getCurrentSegmentSize();
        while (true) {
            if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                this._reportInvalidEOF(": was expecting closing '" + (char)n4 + "' for name");
            }
            char[] cArray2 = this._inputBuffer;
            int n6 = this._inputPtr;
            this._inputPtr = n6 + 1;
            char c2 = cArray2[n6];
            char c3 = c2;
            if (c3 <= '\\') {
                if (c3 == '\\') {
                    c2 = this._decodeEscaped();
                } else if (c3 <= n4) {
                    if (c3 == n4) {
                        this._textBuffer.setCurrentLength(n5);
                        TextBuffer textBuffer = this._textBuffer;
                        char[] cArray3 = textBuffer.getTextBuffer();
                        int n7 = textBuffer.getTextOffset();
                        int n8 = textBuffer.size();
                        return this._symbols.findSymbol(cArray3, n7, n8, n3);
                    }
                    if (c3 < ' ') {
                        this._throwUnquotedSpace(c3, "name");
                    }
                }
            }
            n3 = c3 + n3 * 33;
            int n9 = n5 + 1;
            cArray[n5] = c2;
            if (n9 >= cArray.length) {
                cArray = this._textBuffer.finishCurrentSegment();
                n5 = 0;
                continue;
            }
            n5 = n9;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private String _parseUnusualFieldName2(int n2, int n3, int[] nArray) throws IOException, JsonParseException {
        this._textBuffer.resetWithShared(this._inputBuffer, n2, this._inputPtr - n2);
        char[] cArray = this._textBuffer.getCurrentSegment();
        int n4 = this._textBuffer.getCurrentSegmentSize();
        int n5 = nArray.length;
        while (this._inputPtr < this._inputEnd || this.loadMore()) {
            char c2 = this._inputBuffer[this._inputPtr];
            if (c2 <= n5) {
                if (nArray[c2] != 0) break;
            } else if (!Character.isJavaIdentifierPart(c2)) break;
            this._inputPtr = 1 + this._inputPtr;
            n3 = c2 + n3 * 33;
            int n6 = n4 + 1;
            cArray[n4] = c2;
            if (n6 >= cArray.length) {
                cArray = this._textBuffer.finishCurrentSegment();
                n4 = 0;
                continue;
            }
            n4 = n6;
        }
        this._textBuffer.setCurrentLength(n4);
        TextBuffer textBuffer = this._textBuffer;
        char[] cArray2 = textBuffer.getTextBuffer();
        int n7 = textBuffer.getTextOffset();
        int n8 = textBuffer.size();
        return this._symbols.findSymbol(cArray2, n7, n8, n3);
    }

    private void _skipCComment() throws IOException, JsonParseException {
        while (true) {
            char c2;
            block7: {
                block8: {
                    block6: {
                        if (this._inputPtr >= this._inputEnd && !this.loadMore()) break block6;
                        char[] cArray = this._inputBuffer;
                        int n2 = this._inputPtr;
                        this._inputPtr = n2 + 1;
                        c2 = cArray[n2];
                        if (c2 > '*') continue;
                        if (c2 != '*') break block7;
                        if (this._inputPtr < this._inputEnd || this.loadMore()) break block8;
                    }
                    this._reportInvalidEOF(" in a comment");
                    return;
                }
                if (this._inputBuffer[this._inputPtr] != '/') continue;
                this._inputPtr = 1 + this._inputPtr;
                return;
            }
            if (c2 >= ' ') continue;
            if (c2 == '\n') {
                this._skipLF();
                continue;
            }
            if (c2 == '\r') {
                this._skipCR();
                continue;
            }
            if (c2 == '\t') continue;
            this._throwInvalidSpace(c2);
        }
    }

    private void _skipComment() throws IOException, JsonParseException {
        if (!this.isEnabled(JsonParser.Feature.ALLOW_COMMENTS)) {
            this._reportUnexpectedChar(47, "maybe a (non-standard) comment? (not recognized as one since Feature 'ALLOW_COMMENTS' not enabled for parser)");
        }
        if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
            this._reportInvalidEOF(" in a comment");
        }
        char[] cArray = this._inputBuffer;
        int n2 = this._inputPtr;
        this._inputPtr = n2 + 1;
        char c2 = cArray[n2];
        if (c2 == '/') {
            this._skipCppComment();
            return;
        }
        if (c2 == '*') {
            this._skipCComment();
            return;
        }
        this._reportUnexpectedChar(c2, "was expecting either '*' or '/' for a comment");
    }

    private void _skipCppComment() throws IOException, JsonParseException {
        while (true) {
            char c2;
            block6: {
                block5: {
                    if (this._inputPtr >= this._inputEnd && !this.loadMore()) break block5;
                    char[] cArray = this._inputBuffer;
                    int n2 = this._inputPtr;
                    this._inputPtr = n2 + 1;
                    c2 = cArray[n2];
                    if (c2 >= ' ') continue;
                    if (c2 != '\n') break block6;
                    this._skipLF();
                }
                return;
            }
            if (c2 == '\r') {
                this._skipCR();
                return;
            }
            if (c2 == '\t') continue;
            this._throwInvalidSpace(c2);
        }
    }

    private int _skipWS() throws IOException, JsonParseException {
        while (this._inputPtr < this._inputEnd || this.loadMore()) {
            char[] cArray = this._inputBuffer;
            int n2 = this._inputPtr;
            this._inputPtr = n2 + 1;
            char c2 = cArray[n2];
            if (c2 > ' ') {
                if (c2 != '/') {
                    return c2;
                }
                this._skipComment();
                continue;
            }
            if (c2 == ' ') continue;
            if (c2 == '\n') {
                this._skipLF();
                continue;
            }
            if (c2 == '\r') {
                this._skipCR();
                continue;
            }
            if (c2 == '\t') continue;
            this._throwInvalidSpace(c2);
        }
        throw this._constructError("Unexpected end-of-input within/between " + this._parsingContext.getTypeDesc() + " entries");
    }

    private int _skipWSOrEnd() throws IOException, JsonParseException {
        int n2;
        block5: {
            while (this._inputPtr < this._inputEnd || this.loadMore()) {
                char[] cArray = this._inputBuffer;
                int n3 = this._inputPtr;
                this._inputPtr = n3 + 1;
                n2 = cArray[n3];
                if (n2 > 32) {
                    if (n2 == 47) {
                        this._skipComment();
                        continue;
                    }
                    break block5;
                }
                if (n2 == 32) continue;
                if (n2 == 10) {
                    this._skipLF();
                    continue;
                }
                if (n2 == 13) {
                    this._skipCR();
                    continue;
                }
                if (n2 == 9) continue;
                this._throwInvalidSpace(n2);
            }
            this._handleEOF();
            n2 = -1;
        }
        return n2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private char _verifyNoLeadingZeroes() throws IOException, JsonParseException {
        if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
            return '0';
        }
        char c2 = this._inputBuffer[this._inputPtr];
        if (c2 < 48) return '0';
        if (c2 > '9') {
            return '0';
        }
        if (!this.isEnabled(JsonParser.Feature.ALLOW_NUMERIC_LEADING_ZEROS)) {
            this.reportInvalidNumber("Leading zeroes not allowed");
        }
        this._inputPtr = 1 + this._inputPtr;
        if (c2 != 48) return c2;
        do {
            if (this._inputPtr >= this._inputEnd) {
                if (!this.loadMore()) return c2;
            }
            if ((c2 = this._inputBuffer[this._inputPtr]) < 48) return '0';
            if (c2 > '9') {
                return '0';
            }
            this._inputPtr = 1 + this._inputPtr;
        } while (c2 == 48);
        return c2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private JsonToken parseNumberText2(boolean bl2) throws IOException, JsonParseException {
        int n2;
        int n3;
        int n4;
        boolean bl3;
        int n5;
        block32: {
            char c2;
            char c3;
            char[] cArray;
            block31: {
                int n6;
                block30: {
                    cArray = this._textBuffer.emptyAndGetCurrentSegment();
                    int n7 = 0;
                    if (bl2) {
                        int n8 = 0 + 1;
                        cArray[0] = 45;
                        n7 = n8;
                    }
                    n5 = 0;
                    if (this._inputPtr < this._inputEnd) {
                        char[] cArray2 = this._inputBuffer;
                        int n9 = this._inputPtr;
                        this._inputPtr = n9 + 1;
                        c3 = cArray2[n9];
                    } else {
                        c3 = this.getNextChar("No digit following minus sign");
                    }
                    if (c3 == '0') {
                        c3 = this._verifyNoLeadingZeroes();
                    }
                    while (c3 >= '0' && c3 <= '9') {
                        ++n5;
                        if (n7 >= cArray.length) {
                            cArray = this._textBuffer.finishCurrentSegment();
                            n7 = 0;
                        }
                        n6 = n7 + 1;
                        cArray[n7] = c3;
                        if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                            c3 = '\u0000';
                            bl3 = true;
                            break block30;
                        }
                        char[] cArray3 = this._inputBuffer;
                        int n10 = this._inputPtr;
                        this._inputPtr = n10 + 1;
                        c3 = cArray3[n10];
                        n7 = n6;
                    }
                    n6 = n7;
                    bl3 = false;
                }
                if (n5 == 0) {
                    this.reportInvalidNumber("Missing integer part (next char " + ReaderBasedJsonParser._getCharDesc(c3) + ")");
                }
                n4 = 0;
                if (c3 != '.') {
                    n3 = n6;
                    n4 = 0;
                } else {
                    n3 = n6 + 1;
                    cArray[n6] = c3;
                    while (true) {
                        if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                            bl3 = true;
                            break;
                        }
                        char[] cArray4 = this._inputBuffer;
                        int n11 = this._inputPtr;
                        this._inputPtr = n11 + 1;
                        c3 = cArray4[n11];
                        if (c3 < '0' || c3 > '9') break;
                        ++n4;
                        if (n3 >= cArray.length) {
                            cArray = this._textBuffer.finishCurrentSegment();
                            n3 = 0;
                        }
                        int n12 = n3 + 1;
                        cArray[n3] = c3;
                        n3 = n12;
                    }
                    if (n4 == 0) {
                        this.reportUnexpectedNumberChar(c3, "Decimal point not followed by a digit");
                    }
                }
                n2 = 0;
                if (c3 == 'e') break block31;
                n2 = 0;
                if (c3 != 'E') break block32;
            }
            if (n3 >= cArray.length) {
                cArray = this._textBuffer.finishCurrentSegment();
                n3 = 0;
            }
            int n13 = n3 + 1;
            cArray[n3] = c3;
            if (this._inputPtr < this._inputEnd) {
                char[] cArray5 = this._inputBuffer;
                int n14 = this._inputPtr;
                this._inputPtr = n14 + 1;
                c2 = cArray5[n14];
            } else {
                c2 = this.getNextChar("expected a digit for number exponent");
            }
            if (c2 == '-' || c2 == '+') {
                int n15;
                if (n13 >= cArray.length) {
                    cArray = this._textBuffer.finishCurrentSegment();
                    n15 = 0;
                } else {
                    n15 = n13;
                }
                int n16 = n15 + 1;
                cArray[n15] = c2;
                if (this._inputPtr < this._inputEnd) {
                    char[] cArray6 = this._inputBuffer;
                    int n17 = this._inputPtr;
                    this._inputPtr = n17 + 1;
                    c2 = cArray6[n17];
                } else {
                    c2 = this.getNextChar("expected a digit for number exponent");
                }
                n3 = n16;
            } else {
                n3 = n13;
                n2 = 0;
            }
            while (true) {
                int n18;
                block34: {
                    block33: {
                        if (c2 > '9' || c2 < '0') break block33;
                        ++n2;
                        if (n3 >= cArray.length) {
                            cArray = this._textBuffer.finishCurrentSegment();
                            n3 = 0;
                        }
                        n18 = n3 + 1;
                        cArray[n3] = c2;
                        if (this._inputPtr < this._inputEnd || this.loadMore()) break block34;
                        bl3 = true;
                        n3 = n18;
                    }
                    if (n2 != 0) break;
                    this.reportUnexpectedNumberChar(c2, "Exponent indicator not followed by a digit");
                    break;
                }
                char[] cArray7 = this._inputBuffer;
                int n19 = this._inputPtr;
                this._inputPtr = n19 + 1;
                c2 = cArray7[n19];
                n3 = n18;
            }
        }
        if (!bl3) {
            this._inputPtr = -1 + this._inputPtr;
        }
        this._textBuffer.setCurrentLength(n3);
        return this.reset(bl2, n5, n4, n2);
    }

    @Override
    protected void _closeInput() throws IOException {
        if (this._reader != null) {
            if (this._ioContext.isResourceManaged() || this.isEnabled(JsonParser.Feature.AUTO_CLOSE_SOURCE)) {
                this._reader.close();
            }
            this._reader = null;
        }
    }

    protected byte[] _decodeBase64(Base64Variant base64Variant) throws IOException, JsonParseException {
        ByteArrayBuilder byteArrayBuilder = this._getByteArrayBuilder();
        while (true) {
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            char[] cArray = this._inputBuffer;
            int n2 = this._inputPtr;
            this._inputPtr = n2 + 1;
            char c2 = cArray[n2];
            if (c2 <= ' ') continue;
            int n3 = base64Variant.decodeBase64Char(c2);
            if (n3 < 0) {
                if (c2 == '\"') {
                    return byteArrayBuilder.toByteArray();
                }
                n3 = this._decodeBase64Escape(base64Variant, c2, 0);
                if (n3 < 0) continue;
            }
            int n4 = n3;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            char[] cArray2 = this._inputBuffer;
            int n5 = this._inputPtr;
            this._inputPtr = n5 + 1;
            char c3 = cArray2[n5];
            int n6 = base64Variant.decodeBase64Char(c3);
            if (n6 < 0) {
                n6 = this._decodeBase64Escape(base64Variant, c3, 1);
            }
            int n7 = n6 | n4 << 6;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            char[] cArray3 = this._inputBuffer;
            int n8 = this._inputPtr;
            this._inputPtr = n8 + 1;
            char c4 = cArray3[n8];
            int n9 = base64Variant.decodeBase64Char(c4);
            if (n9 < 0) {
                if (n9 != -2) {
                    if (c4 == '\"' && !base64Variant.usesPadding()) {
                        byteArrayBuilder.append(n7 >> 4);
                        return byteArrayBuilder.toByteArray();
                    }
                    n9 = this._decodeBase64Escape(base64Variant, c4, 2);
                }
                if (n9 == -2) {
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    char[] cArray4 = this._inputBuffer;
                    int n10 = this._inputPtr;
                    this._inputPtr = n10 + 1;
                    char c5 = cArray4[n10];
                    if (!base64Variant.usesPaddingChar(c5)) {
                        throw this.reportInvalidBase64Char(base64Variant, c5, 3, "expected padding character '" + base64Variant.getPaddingChar() + "'");
                    }
                    byteArrayBuilder.append(n7 >> 4);
                    continue;
                }
            }
            int n11 = n9 | n7 << 6;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            char[] cArray5 = this._inputBuffer;
            int n12 = this._inputPtr;
            this._inputPtr = n12 + 1;
            char c6 = cArray5[n12];
            int n13 = base64Variant.decodeBase64Char(c6);
            if (n13 < 0) {
                if (n13 != -2) {
                    if (c6 == '\"' && !base64Variant.usesPadding()) {
                        byteArrayBuilder.appendTwoBytes(n11 >> 2);
                        return byteArrayBuilder.toByteArray();
                    }
                    n13 = this._decodeBase64Escape(base64Variant, c6, 3);
                }
                if (n13 == -2) {
                    byteArrayBuilder.appendTwoBytes(n11 >> 2);
                    continue;
                }
            }
            byteArrayBuilder.appendThreeBytes(n13 | n11 << 6);
        }
    }

    @Override
    protected char _decodeEscaped() throws IOException, JsonParseException {
        if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
            this._reportInvalidEOF(" in character escape sequence");
        }
        char[] cArray = this._inputBuffer;
        int n2 = this._inputPtr;
        this._inputPtr = n2 + 1;
        char c2 = cArray[n2];
        switch (c2) {
            default: {
                c2 = this._handleUnrecognizedCharacterEscape(c2);
            }
            case '\"': 
            case '/': 
            case '\\': {
                return c2;
            }
            case 'b': {
                return '\b';
            }
            case 't': {
                return '\t';
            }
            case 'n': {
                return '\n';
            }
            case 'f': {
                return '\f';
            }
            case 'r': {
                return '\r';
            }
            case 'u': 
        }
        int n3 = 0;
        for (int i2 = 0; i2 < 4; ++i2) {
            if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                this._reportInvalidEOF(" in character escape sequence");
            }
            char[] cArray2 = this._inputBuffer;
            int n4 = this._inputPtr;
            this._inputPtr = n4 + 1;
            char c3 = cArray2[n4];
            int n5 = CharTypes.charToHex(c3);
            if (n5 < 0) {
                this._reportUnexpectedChar(c3, "expected a hex-digit for character escape sequence");
            }
            n3 = n5 | n3 << 4;
        }
        return (char)n3;
    }

    @Override
    protected void _finishString() throws IOException, JsonParseException {
        int n2 = this._inputPtr;
        int n3 = this._inputEnd;
        if (n2 < n3) {
            int[] nArray = CharTypes.getInputCodeLatin1();
            int n4 = nArray.length;
            do {
                char c2;
                if ((c2 = this._inputBuffer[n2]) >= n4 || nArray[c2] == 0) continue;
                if (c2 != '\"') break;
                this._textBuffer.resetWithShared(this._inputBuffer, this._inputPtr, n2 - this._inputPtr);
                this._inputPtr = n2 + 1;
                return;
            } while (++n2 < n3);
        }
        this._textBuffer.resetWithCopy(this._inputBuffer, this._inputPtr, n2 - this._inputPtr);
        this._inputPtr = n2;
        this._finishString2();
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void _finishString2() throws IOException, JsonParseException {
        char[] cArray = this._textBuffer.getCurrentSegment();
        int n2 = this._textBuffer.getCurrentSegmentSize();
        while (true) {
            if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                this._reportInvalidEOF(": was expecting closing quote for a string value");
            }
            char[] cArray2 = this._inputBuffer;
            int n3 = this._inputPtr;
            this._inputPtr = n3 + 1;
            char c2 = cArray2[n3];
            char c3 = c2;
            if (c3 <= '\\') {
                if (c3 == '\\') {
                    c2 = this._decodeEscaped();
                } else if (c3 <= '\"') {
                    if (c3 == '\"') {
                        this._textBuffer.setCurrentLength(n2);
                        return;
                    }
                    if (c3 < ' ') {
                        this._throwUnquotedSpace(c3, "string value");
                    }
                }
            }
            if (n2 >= cArray.length) {
                cArray = this._textBuffer.finishCurrentSegment();
                n2 = 0;
            }
            int n4 = n2 + 1;
            cArray[n2] = c2;
            n2 = n4;
        }
    }

    protected String _getText2(JsonToken jsonToken) {
        if (jsonToken == null) {
            return null;
        }
        switch (jsonToken) {
            default: {
                return jsonToken.asString();
            }
            case FIELD_NAME: {
                return this._parsingContext.getCurrentName();
            }
            case VALUE_STRING: 
            case VALUE_NUMBER_INT: 
            case VALUE_NUMBER_FLOAT: 
        }
        return this._textBuffer.contentsAsString();
    }

    /*
     * Enabled aggressive block sorting
     */
    protected JsonToken _handleApostropheValue() throws IOException, JsonParseException {
        char[] cArray = this._textBuffer.emptyAndGetCurrentSegment();
        int n2 = this._textBuffer.getCurrentSegmentSize();
        while (true) {
            if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                this._reportInvalidEOF(": was expecting closing quote for a string value");
            }
            char[] cArray2 = this._inputBuffer;
            int n3 = this._inputPtr;
            this._inputPtr = n3 + 1;
            char c2 = cArray2[n3];
            char c3 = c2;
            if (c3 <= '\\') {
                if (c3 == '\\') {
                    c2 = this._decodeEscaped();
                } else if (c3 <= '\'') {
                    if (c3 == '\'') {
                        this._textBuffer.setCurrentLength(n2);
                        return JsonToken.VALUE_STRING;
                    }
                    if (c3 < ' ') {
                        this._throwUnquotedSpace(c3, "string value");
                    }
                }
            }
            if (n2 >= cArray.length) {
                cArray = this._textBuffer.finishCurrentSegment();
                n2 = 0;
            }
            int n4 = n2 + 1;
            cArray[n2] = c2;
            n2 = n4;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected JsonToken _handleInvalidNumberStart(int n2, boolean bl2) throws IOException, JsonParseException {
        double d2 = Double.NEGATIVE_INFINITY;
        if (n2 == 73) {
            if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                this._reportInvalidEOFInValue();
            }
            char[] cArray = this._inputBuffer;
            int n3 = this._inputPtr;
            this._inputPtr = n3 + 1;
            n2 = cArray[n3];
            if (n2 == 78) {
                String string2 = bl2 ? "-INF" : "+INF";
                this._matchToken(string2, 3);
                if (this.isEnabled(JsonParser.Feature.ALLOW_NON_NUMERIC_NUMBERS)) {
                    if (bl2) {
                        return this.resetAsNaN(string2, d2);
                    }
                    d2 = Double.POSITIVE_INFINITY;
                    return this.resetAsNaN(string2, d2);
                }
                this._reportError("Non-standard token '" + string2 + "': enable JsonParser.Feature.ALLOW_NON_NUMERIC_NUMBERS to allow");
            } else if (n2 == 110) {
                String string3 = bl2 ? "-Infinity" : "+Infinity";
                this._matchToken(string3, 3);
                if (this.isEnabled(JsonParser.Feature.ALLOW_NON_NUMERIC_NUMBERS)) {
                    if (bl2) {
                        return this.resetAsNaN(string3, d2);
                    }
                    d2 = Double.POSITIVE_INFINITY;
                    return this.resetAsNaN(string3, d2);
                }
                this._reportError("Non-standard token '" + string3 + "': enable JsonParser.Feature.ALLOW_NON_NUMERIC_NUMBERS to allow");
            }
        }
        this.reportUnexpectedNumberChar(n2, "expected digit (0-9) to follow minus sign, for valid numeric value");
        return null;
    }

    /*
     * Unable to fully structure code
     */
    protected JsonToken _handleUnexpectedValue(int var1_1) throws IOException, JsonParseException {
        switch (var1_1) lbl-1000:
        // 3 sources

        {
            default: {
                this._reportUnexpectedChar(var1_1, "expected a valid value (number, String, array, object, 'true', 'false' or 'null')");
                return null;
            }
            case 39: {
                if (!this.isEnabled(JsonParser.Feature.ALLOW_SINGLE_QUOTES)) ** GOTO lbl-1000
                return this._handleApostropheValue();
            }
            case 78: {
                this._matchToken("NaN", 1);
                if (this.isEnabled(JsonParser.Feature.ALLOW_NON_NUMERIC_NUMBERS)) {
                    return this.resetAsNaN("NaN", NaN);
                }
                this._reportError("Non-standard token 'NaN': enable JsonParser.Feature.ALLOW_NON_NUMERIC_NUMBERS to allow");
                ** GOTO lbl-1000
            }
            case 43: 
        }
        if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
            this._reportInvalidEOFInValue();
        }
        var2_2 = this._inputBuffer;
        var3_3 = this._inputPtr;
        this._inputPtr = var3_3 + 1;
        return this._handleInvalidNumberStart(var2_2[var3_3], false);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected String _handleUnusualFieldName(int n2) throws IOException, JsonParseException {
        int[] nArray;
        int n3;
        if (n2 == 39 && this.isEnabled(JsonParser.Feature.ALLOW_SINGLE_QUOTES)) {
            return this._parseApostropheFieldName();
        }
        if (!this.isEnabled(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES)) {
            this._reportUnexpectedChar(n2, "was expecting double-quote to start field name");
        }
        boolean bl2 = n2 < (n3 = (nArray = CharTypes.getInputCodeLatin1JsNames()).length) ? nArray[n2] == 0 && (n2 < 48 || n2 > 57) : Character.isJavaIdentifierPart((char)n2);
        if (!bl2) {
            this._reportUnexpectedChar(n2, "was expecting either valid name character (for unquoted name) or double-quote (for quoted) to start field name");
        }
        int n4 = this._inputPtr;
        int n5 = this._hashSeed;
        int n6 = this._inputEnd;
        if (n4 < n6) {
            do {
                char c2;
                if ((c2 = this._inputBuffer[n4]) < n3) {
                    if (nArray[c2] != 0) {
                        int n7 = -1 + this._inputPtr;
                        this._inputPtr = n4;
                        return this._symbols.findSymbol(this._inputBuffer, n7, n4 - n7, n5);
                    }
                } else if (!Character.isJavaIdentifierPart(c2)) {
                    int n8 = -1 + this._inputPtr;
                    this._inputPtr = n4;
                    return this._symbols.findSymbol(this._inputBuffer, n8, n4 - n8, n5);
                }
                n5 = c2 + n5 * 33;
            } while (++n4 < n6);
        }
        int n9 = -1 + this._inputPtr;
        this._inputPtr = n4;
        return this._parseUnusualFieldName2(n9, n5, nArray);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void _matchToken(String string2, int n2) throws IOException, JsonParseException {
        char c2;
        int n3 = string2.length();
        do {
            if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                this._reportInvalidEOFInValue();
            }
            if (this._inputBuffer[this._inputPtr] != string2.charAt(n2)) {
                this._reportInvalidToken(string2.substring(0, n2), "'null', 'true', 'false' or NaN");
            }
            this._inputPtr = 1 + this._inputPtr;
        } while (++n2 < n3);
        if (this._inputPtr >= this._inputEnd && !this.loadMore() || (c2 = this._inputBuffer[this._inputPtr]) < '0' || c2 == ']' || c2 == '}' || !Character.isJavaIdentifierPart(c2)) {
            return;
        }
        this._reportInvalidToken(string2.substring(0, n2), "'null', 'true', 'false' or NaN");
    }

    /*
     * Enabled aggressive block sorting
     */
    protected String _parseApostropheFieldName() throws IOException, JsonParseException {
        int n2 = this._inputPtr;
        int n3 = this._hashSeed;
        int n4 = this._inputEnd;
        if (n2 < n4) {
            int[] nArray = CharTypes.getInputCodeLatin1();
            int n5 = nArray.length;
            do {
                char c2;
                if ((c2 = this._inputBuffer[n2]) == '\'') {
                    int n6 = this._inputPtr;
                    this._inputPtr = n2 + 1;
                    return this._symbols.findSymbol(this._inputBuffer, n6, n2 - n6, n3);
                }
                if (c2 < n5 && nArray[c2] != 0) break;
                n3 = c2 + n3 * 33;
            } while (++n2 < n4);
        }
        int n7 = this._inputPtr;
        this._inputPtr = n2;
        return this._parseFieldName2(n7, n3, 39);
    }

    protected String _parseFieldName(int n2) throws IOException, JsonParseException {
        if (n2 != 34) {
            return this._handleUnusualFieldName(n2);
        }
        int n3 = this._inputPtr;
        int n4 = this._hashSeed;
        int n5 = this._inputEnd;
        if (n3 < n5) {
            int[] nArray = CharTypes.getInputCodeLatin1();
            int n6 = nArray.length;
            do {
                char c2;
                if ((c2 = this._inputBuffer[n3]) < n6 && nArray[c2] != 0) {
                    if (c2 != '\"') break;
                    int n7 = this._inputPtr;
                    this._inputPtr = n3 + 1;
                    return this._symbols.findSymbol(this._inputBuffer, n7, n3 - n7, n4);
                }
                n4 = c2 + n4 * 33;
            } while (++n3 < n5);
        }
        int n8 = this._inputPtr;
        this._inputPtr = n3;
        return this._parseFieldName2(n8, n4, 34);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected int _readBinary(Base64Variant base64Variant, OutputStream outputStream, byte[] byArray) throws IOException, JsonParseException {
        int n2 = 0;
        int n3 = -3 + byArray.length;
        int n4 = 0;
        while (true) {
            int n5;
            int n6;
            block22: {
                block23: {
                    char c2;
                    block24: {
                        block18: {
                            int n7;
                            int n8;
                            block19: {
                                block20: {
                                    char c3;
                                    block21: {
                                        int n9;
                                        block17: {
                                            if (this._inputPtr >= this._inputEnd) {
                                                this.loadMoreGuaranteed();
                                            }
                                            char[] cArray = this._inputBuffer;
                                            int n10 = this._inputPtr;
                                            this._inputPtr = n10 + 1;
                                            char c4 = cArray[n10];
                                            if (c4 <= ' ') continue;
                                            n9 = base64Variant.decodeBase64Char(c4);
                                            if (n9 >= 0) break block17;
                                            if (c4 != '\"') {
                                                n9 = this._decodeBase64Escape(base64Variant, c4, 0);
                                                if (n9 < 0) continue;
                                            }
                                            break block18;
                                        }
                                        if (n2 > n3) {
                                            n4 += n2;
                                            outputStream.write(byArray, 0, n2);
                                            n2 = 0;
                                        }
                                        int n11 = n9;
                                        if (this._inputPtr >= this._inputEnd) {
                                            this.loadMoreGuaranteed();
                                        }
                                        char[] cArray = this._inputBuffer;
                                        int n12 = this._inputPtr;
                                        this._inputPtr = n12 + 1;
                                        char c5 = cArray[n12];
                                        int n13 = base64Variant.decodeBase64Char(c5);
                                        if (n13 < 0) {
                                            n13 = this._decodeBase64Escape(base64Variant, c5, 1);
                                        }
                                        n8 = n13 | n11 << 6;
                                        if (this._inputPtr >= this._inputEnd) {
                                            this.loadMoreGuaranteed();
                                        }
                                        char[] cArray2 = this._inputBuffer;
                                        int n14 = this._inputPtr;
                                        this._inputPtr = n14 + 1;
                                        c3 = cArray2[n14];
                                        n7 = base64Variant.decodeBase64Char(c3);
                                        if (n7 >= 0) break block19;
                                        if (n7 == -2) break block20;
                                        if (c3 != '\"' || base64Variant.usesPadding()) break block21;
                                        int n15 = n8 >> 4;
                                        int n16 = n2 + 1;
                                        byArray[n2] = (byte)n15;
                                        n2 = n16;
                                        break block18;
                                    }
                                    n7 = this._decodeBase64Escape(base64Variant, c3, 2);
                                }
                                if (n7 == -2) {
                                    if (this._inputPtr >= this._inputEnd) {
                                        this.loadMoreGuaranteed();
                                    }
                                    char[] cArray = this._inputBuffer;
                                    int n17 = this._inputPtr;
                                    this._inputPtr = n17 + 1;
                                    char c6 = cArray[n17];
                                    if (!base64Variant.usesPaddingChar(c6)) {
                                        throw this.reportInvalidBase64Char(base64Variant, c6, 3, "expected padding character '" + base64Variant.getPaddingChar() + "'");
                                    }
                                    int n18 = n8 >> 4;
                                    int n19 = n2 + 1;
                                    byArray[n2] = (byte)n18;
                                    n2 = n19;
                                    continue;
                                }
                            }
                            n6 = n7 | n8 << 6;
                            if (this._inputPtr >= this._inputEnd) {
                                this.loadMoreGuaranteed();
                            }
                            char[] cArray = this._inputBuffer;
                            int n20 = this._inputPtr;
                            this._inputPtr = n20 + 1;
                            c2 = cArray[n20];
                            n5 = base64Variant.decodeBase64Char(c2);
                            if (n5 >= 0) break block22;
                            if (n5 == -2) break block23;
                            if (c2 != '\"' || base64Variant.usesPadding()) break block24;
                            int n21 = n6 >> 2;
                            int n22 = n2 + 1;
                            byArray[n2] = (byte)(n21 >> 8);
                            n2 = n22 + 1;
                            byArray[n22] = (byte)n21;
                        }
                        this._tokenIncomplete = false;
                        if (n2 > 0) {
                            n4 += n2;
                            outputStream.write(byArray, 0, n2);
                        }
                        return n4;
                    }
                    n5 = this._decodeBase64Escape(base64Variant, c2, 3);
                }
                if (n5 == -2) {
                    int n23 = n6 >> 2;
                    int n24 = n2 + 1;
                    byArray[n2] = (byte)(n23 >> 8);
                    n2 = n24 + 1;
                    byArray[n24] = (byte)n23;
                    continue;
                }
            }
            int n25 = n5 | n6 << 6;
            int n26 = n2 + 1;
            byArray[n2] = (byte)(n25 >> 16);
            int n27 = n26 + 1;
            byArray[n26] = (byte)(n25 >> 8);
            int n28 = n27 + 1;
            byArray[n27] = (byte)n25;
            n2 = n28;
        }
    }

    @Override
    protected void _releaseBuffers() throws IOException {
        super._releaseBuffers();
        char[] cArray = this._inputBuffer;
        if (cArray != null) {
            this._inputBuffer = null;
            this._ioContext.releaseTokenBuffer(cArray);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void _reportInvalidToken(String string2, String string3) throws IOException, JsonParseException {
        StringBuilder stringBuilder = new StringBuilder(string2);
        while (true) {
            char c2;
            if (this._inputPtr >= this._inputEnd && !this.loadMore() || !Character.isJavaIdentifierPart(c2 = this._inputBuffer[this._inputPtr])) {
                this._reportError("Unrecognized token '" + stringBuilder.toString() + "': was expecting ");
                return;
            }
            this._inputPtr = 1 + this._inputPtr;
            stringBuilder.append(c2);
        }
    }

    protected void _skipCR() throws IOException {
        if ((this._inputPtr < this._inputEnd || this.loadMore()) && this._inputBuffer[this._inputPtr] == '\n') {
            this._inputPtr = 1 + this._inputPtr;
        }
        this._currInputRow = 1 + this._currInputRow;
        this._currInputRowStart = this._inputPtr;
    }

    protected void _skipLF() throws IOException {
        this._currInputRow = 1 + this._currInputRow;
        this._currInputRowStart = this._inputPtr;
    }

    protected void _skipString() throws IOException, JsonParseException {
        this._tokenIncomplete = false;
        int n2 = this._inputPtr;
        int n3 = this._inputEnd;
        char[] cArray = this._inputBuffer;
        while (true) {
            if (n2 >= n3) {
                this._inputPtr = n2;
                if (!this.loadMore()) {
                    this._reportInvalidEOF(": was expecting closing quote for a string value");
                }
                n2 = this._inputPtr;
                n3 = this._inputEnd;
            }
            int n4 = n2 + 1;
            char c2 = cArray[n2];
            if (c2 <= '\\') {
                if (c2 == '\\') {
                    this._inputPtr = n4;
                    this._decodeEscaped();
                    n2 = this._inputPtr;
                    n3 = this._inputEnd;
                    continue;
                }
                if (c2 <= '\"') {
                    if (c2 == '\"') {
                        this._inputPtr = n4;
                        return;
                    }
                    if (c2 < ' ') {
                        this._inputPtr = n4;
                        this._throwUnquotedSpace(c2, "string value");
                    }
                }
            }
            n2 = n4;
        }
    }

    @Override
    public void close() throws IOException {
        super.close();
        this._symbols.release();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] getBinaryValue(Base64Variant base64Variant) throws IOException, JsonParseException {
        if (this._currToken != JsonToken.VALUE_STRING && (this._currToken != JsonToken.VALUE_EMBEDDED_OBJECT || this._binaryValue == null)) {
            this._reportError("Current token (" + (Object)((Object)this._currToken) + ") not VALUE_STRING or VALUE_EMBEDDED_OBJECT, can not access as binary");
        }
        if (!this._tokenIncomplete) {
            if (this._binaryValue != null) return this._binaryValue;
            ByteArrayBuilder byteArrayBuilder = this._getByteArrayBuilder();
            this._decodeBase64(this.getText(), byteArrayBuilder, base64Variant);
            this._binaryValue = byteArrayBuilder.toByteArray();
            return this._binaryValue;
        }
        try {
            this._binaryValue = this._decodeBase64(base64Variant);
            this._tokenIncomplete = false;
            return this._binaryValue;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw this._constructError("Failed to decode VALUE_STRING as base64 (" + base64Variant + "): " + illegalArgumentException.getMessage());
        }
    }

    @Override
    public ObjectCodec getCodec() {
        return this._objectCodec;
    }

    @Override
    public Object getEmbeddedObject() throws IOException, JsonParseException {
        return null;
    }

    @Override
    public Object getInputSource() {
        return this._reader;
    }

    protected char getNextChar(String string2) throws IOException, JsonParseException {
        if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
            this._reportInvalidEOF(string2);
        }
        char[] cArray = this._inputBuffer;
        int n2 = this._inputPtr;
        this._inputPtr = n2 + 1;
        return cArray[n2];
    }

    @Override
    public String getText() throws IOException, JsonParseException {
        JsonToken jsonToken = this._currToken;
        if (jsonToken == JsonToken.VALUE_STRING) {
            if (this._tokenIncomplete) {
                this._tokenIncomplete = false;
                this._finishString();
            }
            return this._textBuffer.contentsAsString();
        }
        return this._getText2(jsonToken);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public char[] getTextCharacters() throws IOException, JsonParseException {
        if (this._currToken == null) {
            return null;
        }
        switch (this._currToken) {
            default: {
                return this._currToken.asCharArray();
            }
            case FIELD_NAME: {
                if (this._nameCopied) return this._nameCopyBuffer;
                String string2 = this._parsingContext.getCurrentName();
                int n2 = string2.length();
                if (this._nameCopyBuffer == null) {
                    this._nameCopyBuffer = this._ioContext.allocNameCopyBuffer(n2);
                } else if (this._nameCopyBuffer.length < n2) {
                    this._nameCopyBuffer = new char[n2];
                }
                string2.getChars(0, n2, this._nameCopyBuffer, 0);
                this._nameCopied = true;
                return this._nameCopyBuffer;
            }
            case VALUE_STRING: {
                if (!this._tokenIncomplete) return this._textBuffer.getTextBuffer();
                this._tokenIncomplete = false;
                this._finishString();
                return this._textBuffer.getTextBuffer();
            }
            case VALUE_NUMBER_INT: 
            case VALUE_NUMBER_FLOAT: 
        }
        return this._textBuffer.getTextBuffer();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int getTextLength() throws IOException, JsonParseException {
        JsonToken jsonToken = this._currToken;
        int n2 = 0;
        if (jsonToken == null) return n2;
        switch (this._currToken) {
            default: {
                return this._currToken.asCharArray().length;
            }
            case FIELD_NAME: {
                return this._parsingContext.getCurrentName().length();
            }
            case VALUE_STRING: {
                if (!this._tokenIncomplete) return this._textBuffer.size();
                this._tokenIncomplete = false;
                this._finishString();
            }
            case VALUE_NUMBER_INT: 
            case VALUE_NUMBER_FLOAT: 
        }
        return this._textBuffer.size();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int getTextOffset() throws IOException, JsonParseException {
        if (this._currToken == null) return 0;
        switch (this._currToken) {
            default: {
                return 0;
            }
            case VALUE_STRING: {
                if (!this._tokenIncomplete) return this._textBuffer.getTextOffset();
                this._tokenIncomplete = false;
                this._finishString();
            }
            case VALUE_NUMBER_INT: 
            case VALUE_NUMBER_FLOAT: 
        }
        return this._textBuffer.getTextOffset();
    }

    @Override
    public String getValueAsString() throws IOException, JsonParseException {
        if (this._currToken == JsonToken.VALUE_STRING) {
            if (this._tokenIncomplete) {
                this._tokenIncomplete = false;
                this._finishString();
            }
            return this._textBuffer.contentsAsString();
        }
        return super.getValueAsString(null);
    }

    @Override
    public String getValueAsString(String string2) throws IOException, JsonParseException {
        if (this._currToken == JsonToken.VALUE_STRING) {
            if (this._tokenIncomplete) {
                this._tokenIncomplete = false;
                this._finishString();
            }
            return this._textBuffer.contentsAsString();
        }
        return super.getValueAsString(string2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean loadMore() throws IOException {
        this._currInputProcessed += (long)this._inputEnd;
        this._currInputRowStart -= this._inputEnd;
        Reader reader = this._reader;
        boolean bl2 = false;
        if (reader == null) return bl2;
        int n2 = this._reader.read(this._inputBuffer, 0, this._inputBuffer.length);
        if (n2 > 0) {
            this._inputPtr = 0;
            this._inputEnd = n2;
            return true;
        }
        this._closeInput();
        bl2 = false;
        if (n2 != 0) return bl2;
        throw new IOException("Reader returned 0 characters when trying to read " + this._inputEnd);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Boolean nextBooleanValue() throws IOException, JsonParseException {
        if (this._currToken == JsonToken.FIELD_NAME) {
            this._nameCopied = false;
            JsonToken jsonToken = this._nextToken;
            this._nextToken = null;
            this._currToken = jsonToken;
            if (jsonToken == JsonToken.VALUE_TRUE) {
                return Boolean.TRUE;
            }
            if (jsonToken == JsonToken.VALUE_FALSE) {
                return Boolean.FALSE;
            }
            if (jsonToken == JsonToken.START_ARRAY) {
                this._parsingContext = this._parsingContext.createChildArrayContext(this._tokenInputRow, this._tokenInputCol);
                return null;
            }
            JsonToken jsonToken2 = JsonToken.START_OBJECT;
            Boolean bl2 = null;
            if (jsonToken != jsonToken2) return bl2;
            this._parsingContext = this._parsingContext.createChildObjectContext(this._tokenInputRow, this._tokenInputCol);
            return null;
        }
        switch (1.$SwitchMap$com$fasterxml$jackson$core$JsonToken[this.nextToken().ordinal()]) {
            default: {
                return null;
            }
            case 5: {
                return Boolean.TRUE;
            }
            case 6: 
        }
        return Boolean.FALSE;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int nextIntValue(int n2) throws IOException, JsonParseException {
        if (this._currToken == JsonToken.FIELD_NAME) {
            this._nameCopied = false;
            JsonToken jsonToken = this._nextToken;
            this._nextToken = null;
            this._currToken = jsonToken;
            if (jsonToken == JsonToken.VALUE_NUMBER_INT) {
                return this.getIntValue();
            }
            if (jsonToken == JsonToken.START_ARRAY) {
                this._parsingContext = this._parsingContext.createChildArrayContext(this._tokenInputRow, this._tokenInputCol);
                return n2;
            }
            if (jsonToken != JsonToken.START_OBJECT) return n2;
            this._parsingContext = this._parsingContext.createChildObjectContext(this._tokenInputRow, this._tokenInputCol);
            return n2;
        }
        if (this.nextToken() != JsonToken.VALUE_NUMBER_INT) return n2;
        return this.getIntValue();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public long nextLongValue(long l2) throws IOException, JsonParseException {
        if (this._currToken == JsonToken.FIELD_NAME) {
            this._nameCopied = false;
            JsonToken jsonToken = this._nextToken;
            this._nextToken = null;
            this._currToken = jsonToken;
            if (jsonToken == JsonToken.VALUE_NUMBER_INT) {
                return this.getLongValue();
            }
            if (jsonToken == JsonToken.START_ARRAY) {
                this._parsingContext = this._parsingContext.createChildArrayContext(this._tokenInputRow, this._tokenInputCol);
                return l2;
            }
            if (jsonToken != JsonToken.START_OBJECT) return l2;
            this._parsingContext = this._parsingContext.createChildObjectContext(this._tokenInputRow, this._tokenInputCol);
            return l2;
        }
        if (this.nextToken() != JsonToken.VALUE_NUMBER_INT) return l2;
        return this.getLongValue();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String nextTextValue() throws IOException, JsonParseException {
        String string2;
        if (this._currToken == JsonToken.FIELD_NAME) {
            this._nameCopied = false;
            JsonToken jsonToken = this._nextToken;
            this._nextToken = null;
            this._currToken = jsonToken;
            if (jsonToken == JsonToken.VALUE_STRING) {
                if (!this._tokenIncomplete) return this._textBuffer.contentsAsString();
                this._tokenIncomplete = false;
                this._finishString();
                return this._textBuffer.contentsAsString();
            }
            if (jsonToken == JsonToken.START_ARRAY) {
                this._parsingContext = this._parsingContext.createChildArrayContext(this._tokenInputRow, this._tokenInputCol);
                return null;
            }
            JsonToken jsonToken2 = JsonToken.START_OBJECT;
            string2 = null;
            if (jsonToken != jsonToken2) return string2;
            this._parsingContext = this._parsingContext.createChildObjectContext(this._tokenInputRow, this._tokenInputCol);
            return null;
        }
        JsonToken jsonToken = this.nextToken();
        JsonToken jsonToken3 = JsonToken.VALUE_STRING;
        string2 = null;
        if (jsonToken != jsonToken3) return string2;
        return this.getText();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public JsonToken nextToken() throws IOException, JsonParseException {
        JsonToken jsonToken;
        boolean bl2;
        int n2;
        this._numTypesValid = 0;
        if (this._currToken == JsonToken.FIELD_NAME) {
            return this._nextAfterName();
        }
        if (this._tokenIncomplete) {
            this._skipString();
        }
        if ((n2 = this._skipWSOrEnd()) < 0) {
            this.close();
            this._currToken = null;
            return null;
        }
        this._tokenInputTotal = this._currInputProcessed + (long)this._inputPtr - 1L;
        this._tokenInputRow = this._currInputRow;
        this._tokenInputCol = -1 + (this._inputPtr - this._currInputRowStart);
        this._binaryValue = null;
        if (n2 == 93) {
            JsonToken jsonToken2;
            if (!this._parsingContext.inArray()) {
                this._reportMismatchedEndMarker(n2, '}');
            }
            this._parsingContext = this._parsingContext.getParent();
            this._currToken = jsonToken2 = JsonToken.END_ARRAY;
            return jsonToken2;
        }
        if (n2 == 125) {
            JsonToken jsonToken3;
            if (!this._parsingContext.inObject()) {
                this._reportMismatchedEndMarker(n2, ']');
            }
            this._parsingContext = this._parsingContext.getParent();
            this._currToken = jsonToken3 = JsonToken.END_OBJECT;
            return jsonToken3;
        }
        if (this._parsingContext.expectComma()) {
            if (n2 != 44) {
                this._reportUnexpectedChar(n2, "was expecting comma to separate " + this._parsingContext.getTypeDesc() + " entries");
            }
            n2 = this._skipWS();
        }
        if (bl2 = this._parsingContext.inObject()) {
            String string2 = this._parseFieldName(n2);
            this._parsingContext.setCurrentName(string2);
            this._currToken = JsonToken.FIELD_NAME;
            int n3 = this._skipWS();
            if (n3 != 58) {
                this._reportUnexpectedChar(n3, "was expecting a colon to separate field name and value");
            }
            n2 = this._skipWS();
        }
        switch (n2) {
            default: {
                jsonToken = this._handleUnexpectedValue(n2);
                break;
            }
            case 34: {
                this._tokenIncomplete = true;
                jsonToken = JsonToken.VALUE_STRING;
                break;
            }
            case 91: {
                if (!bl2) {
                    this._parsingContext = this._parsingContext.createChildArrayContext(this._tokenInputRow, this._tokenInputCol);
                }
                jsonToken = JsonToken.START_ARRAY;
                break;
            }
            case 123: {
                if (!bl2) {
                    this._parsingContext = this._parsingContext.createChildObjectContext(this._tokenInputRow, this._tokenInputCol);
                }
                jsonToken = JsonToken.START_OBJECT;
                break;
            }
            case 93: 
            case 125: {
                this._reportUnexpectedChar(n2, "expected a value");
            }
            case 116: {
                this._matchToken("true", 1);
                jsonToken = JsonToken.VALUE_TRUE;
                break;
            }
            case 102: {
                this._matchToken("false", 1);
                jsonToken = JsonToken.VALUE_FALSE;
                break;
            }
            case 110: {
                this._matchToken("null", 1);
                jsonToken = JsonToken.VALUE_NULL;
                break;
            }
            case 45: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                jsonToken = this.parseNumberText(n2);
            }
        }
        if (bl2) {
            this._nextToken = jsonToken;
            return this._currToken;
        }
        this._currToken = jsonToken;
        return jsonToken;
    }

    /*
     * Unable to fully structure code
     */
    protected JsonToken parseNumberText(int var1_1) throws IOException, JsonParseException {
        block20: {
            block19: {
                block17: {
                    block18: {
                        block15: {
                            block13: {
                                block14: {
                                    if (var1_1 == 45) {
                                        var2_2 = true;
lbl3:
                                        // 2 sources

                                        while (true) {
                                            var3_3 = this._inputPtr;
                                            var4_4 = var3_3 - 1;
                                            var5_5 = this._inputEnd;
                                            if (!var2_2) break block13;
                                            if (var3_3 >= this._inputEnd) lbl-1000:
                                            // 7 sources

                                            {
                                                while (true) {
                                                    if (var2_2) {
                                                        ++var4_4;
                                                    }
                                                    this._inputPtr = var4_4;
                                                    return this.parseNumberText2(var2_2);
                                                }
                                            }
                                            break block14;
                                            break;
                                        }
                                    }
                                    var2_2 = false;
                                    ** while (true)
                                }
                                var25_6 = this._inputBuffer;
                                var26_7 = var3_3 + 1;
                                var1_1 = var25_6[var3_3];
                                if (var1_1 > 57 || var1_1 < 48) {
                                    this._inputPtr = var26_7;
                                    return this._handleInvalidNumberStart(var1_1, true);
                                }
                                var3_3 = var26_7;
                            }
                            if (var1_1 == 48) ** GOTO lbl-1000
                            var6_8 = 1;
                            block2: while (true) {
                                block16: {
                                    if (var3_3 >= this._inputEnd) ** GOTO lbl-1000
                                    var7_9 = this._inputBuffer;
                                    var8_10 = var3_3 + 1;
                                    var9_11 = var7_9[var3_3];
                                    if (var9_11 >= '0' && var9_11 <= '9') break block16;
                                    var10_12 = 0;
                                    if (var9_11 != '.') break block15;
lbl36:
                                    // 2 sources

                                    while (true) {
                                        if (var8_10 < var5_5) break block2;
                                        ** GOTO lbl-1000
                                        break;
                                    }
                                }
                                ++var6_8;
                                var3_3 = var8_10;
                            }
                            var22_13 = this._inputBuffer;
                            var23_14 = var8_10 + 1;
                            var9_11 = var22_13[var8_10];
                            if (var9_11 >= '0' && var9_11 <= '9') break block17;
                            if (var10_12 == 0) {
                                this.reportUnexpectedNumberChar(var9_11, "Decimal point not followed by a digit");
                            }
                            var8_10 = var23_14;
                        }
                        var11_15 = 0;
                        if (var9_11 == 'e') break block18;
                        var11_15 = 0;
                        if (var9_11 != 'E') ** GOTO lbl86
                    }
                    if (var8_10 < var5_5) break block19;
                    ** GOTO lbl-1000
                }
                ++var10_12;
                var8_10 = var23_14;
                ** while (true)
            }
            var14_16 = this._inputBuffer;
            var15_17 = var8_10 + 1;
            var16_18 = var14_16[var8_10];
            if (var16_18 != '-' && var16_18 != '+') break block20;
            if (var15_17 >= var5_5) ** GOTO lbl-1000
            var17_19 = this._inputBuffer;
            var8_10 = var15_17 + 1;
            var16_18 = var17_19[var15_17];
lbl73:
            // 2 sources

            while (true) {
                if (var16_18 <= '9' && var16_18 >= '0') {
                    ++var11_15;
                    if (var8_10 >= var5_5) {
                        ** continue;
                    }
                    var18_20 = this._inputBuffer;
                    var19_21 = var8_10 + 1;
                    var16_18 = var18_20[var8_10];
                    var8_10 = var19_21;
                    continue;
                }
                if (var11_15 == 0) {
                    this.reportUnexpectedNumberChar(var16_18, "Exponent indicator not followed by a digit");
                }
lbl86:
                // 4 sources

                this._inputPtr = var12_22 = -1 + var8_10;
                var13_23 = var12_22 - var4_4;
                this._textBuffer.resetWithShared(this._inputBuffer, var4_4, var13_23);
                return this.reset(var2_2, var6_8, var10_12, var11_15);
            }
        }
        var8_10 = var15_17;
        var11_15 = 0;
        ** while (true)
    }

    @Override
    public int readBinaryValue(Base64Variant base64Variant, OutputStream outputStream) throws IOException, JsonParseException {
        if (!this._tokenIncomplete || this._currToken != JsonToken.VALUE_STRING) {
            byte[] byArray = this.getBinaryValue(base64Variant);
            outputStream.write(byArray);
            return byArray.length;
        }
        byte[] byArray = this._ioContext.allocBase64Buffer();
        try {
            int n2 = this._readBinary(base64Variant, outputStream, byArray);
            return n2;
        }
        finally {
            this._ioContext.releaseBase64Buffer(byArray);
        }
    }

    @Override
    public int releaseBuffered(Writer writer) throws IOException {
        int n2 = this._inputEnd - this._inputPtr;
        if (n2 < 1) {
            return 0;
        }
        int n3 = this._inputPtr;
        writer.write(this._inputBuffer, n3, n2);
        return n2;
    }

    @Override
    public void setCodec(ObjectCodec objectCodec) {
        this._objectCodec = objectCodec;
    }

    @Override
    public Version version() {
        return CoreVersion.instance.version();
    }
}

