/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.json;

import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonStreamContext;
import com.fasterxml.jackson.core.io.CharTypes;

public final class JsonReadContext
extends JsonStreamContext {
    protected JsonReadContext _child = null;
    protected int _columnNr;
    protected String _currentName;
    protected int _lineNr;
    protected final JsonReadContext _parent;

    public JsonReadContext(JsonReadContext jsonReadContext, int n2, int n3, int n4) {
        this._type = n2;
        this._parent = jsonReadContext;
        this._lineNr = n3;
        this._columnNr = n4;
        this._index = -1;
    }

    public static JsonReadContext createRootContext() {
        return new JsonReadContext(null, 0, 1, 0);
    }

    public static JsonReadContext createRootContext(int n2, int n3) {
        return new JsonReadContext(null, 0, n2, n3);
    }

    public JsonReadContext createChildArrayContext(int n2, int n3) {
        JsonReadContext jsonReadContext = this._child;
        if (jsonReadContext == null) {
            JsonReadContext jsonReadContext2;
            this._child = jsonReadContext2 = new JsonReadContext(this, 1, n2, n3);
            return jsonReadContext2;
        }
        jsonReadContext.reset(1, n2, n3);
        return jsonReadContext;
    }

    public JsonReadContext createChildObjectContext(int n2, int n3) {
        JsonReadContext jsonReadContext = this._child;
        if (jsonReadContext == null) {
            JsonReadContext jsonReadContext2;
            this._child = jsonReadContext2 = new JsonReadContext(this, 2, n2, n3);
            return jsonReadContext2;
        }
        jsonReadContext.reset(2, n2, n3);
        return jsonReadContext;
    }

    public boolean expectComma() {
        int n2;
        this._index = n2 = 1 + this._index;
        return this._type != 0 && n2 > 0;
    }

    @Override
    public String getCurrentName() {
        return this._currentName;
    }

    @Override
    public JsonReadContext getParent() {
        return this._parent;
    }

    public JsonLocation getStartLocation(Object object) {
        return new JsonLocation(object, -1L, this._lineNr, this._columnNr);
    }

    protected void reset(int n2, int n3, int n4) {
        this._type = n2;
        this._index = -1;
        this._lineNr = n3;
        this._columnNr = n4;
        this._currentName = null;
    }

    public void setCurrentName(String string2) {
        this._currentName = string2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(64);
        switch (this._type) {
            case 0: {
                stringBuilder.append("/");
                return stringBuilder.toString();
            }
            case 1: {
                stringBuilder.append('[');
                stringBuilder.append(this.getCurrentIndex());
                stringBuilder.append(']');
                return stringBuilder.toString();
            }
            case 2: {
                stringBuilder.append('{');
                if (this._currentName != null) {
                    stringBuilder.append('\"');
                    CharTypes.appendQuoted(stringBuilder, this._currentName);
                    stringBuilder.append('\"');
                } else {
                    stringBuilder.append('?');
                }
                stringBuilder.append('}');
                return stringBuilder.toString();
            }
        }
        return stringBuilder.toString();
    }
}

