/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.json;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.format.InputAccessor;
import com.fasterxml.jackson.core.format.MatchStrength;
import com.fasterxml.jackson.core.io.IOContext;
import com.fasterxml.jackson.core.io.MergedStream;
import com.fasterxml.jackson.core.io.UTF32Reader;
import com.fasterxml.jackson.core.json.ReaderBasedJsonParser;
import com.fasterxml.jackson.core.json.UTF8StreamJsonParser;
import com.fasterxml.jackson.core.sym.BytesToNameCanonicalizer;
import com.fasterxml.jackson.core.sym.CharsToNameCanonicalizer;
import java.io.ByteArrayInputStream;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

public final class ByteSourceJsonBootstrapper {
    static final byte UTF8_BOM_1 = -17;
    static final byte UTF8_BOM_2 = -69;
    static final byte UTF8_BOM_3 = -65;
    protected boolean _bigEndian = true;
    private final boolean _bufferRecyclable;
    protected int _bytesPerChar = 0;
    protected final IOContext _context;
    protected final InputStream _in;
    protected final byte[] _inputBuffer;
    private int _inputEnd;
    protected int _inputProcessed;
    private int _inputPtr;

    public ByteSourceJsonBootstrapper(IOContext iOContext, InputStream inputStream) {
        this._context = iOContext;
        this._in = inputStream;
        this._inputBuffer = iOContext.allocReadIOBuffer();
        this._inputPtr = 0;
        this._inputEnd = 0;
        this._inputProcessed = 0;
        this._bufferRecyclable = true;
    }

    public ByteSourceJsonBootstrapper(IOContext iOContext, byte[] byArray, int n2, int n3) {
        this._context = iOContext;
        this._in = null;
        this._inputBuffer = byArray;
        this._inputPtr = n2;
        this._inputEnd = n2 + n3;
        this._inputProcessed = -n2;
        this._bufferRecyclable = false;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean checkUTF16(int n2) {
        if ((0xFF00 & n2) == 0) {
            this._bigEndian = true;
        } else {
            int n3 = n2 & 0xFF;
            boolean bl2 = false;
            if (n3 != 0) return bl2;
            this._bigEndian = false;
        }
        this._bytesPerChar = 2;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean checkUTF32(int n2) throws IOException {
        if (n2 >> 8 == 0) {
            this._bigEndian = true;
        } else if ((0xFFFFFF & n2) == 0) {
            this._bigEndian = false;
        } else if ((0xFF00FFFF & n2) == 0) {
            this.reportWeirdUCS4("3412");
        } else {
            int n3 = 0xFFFF00FF & n2;
            boolean bl2 = false;
            if (n3 != 0) return bl2;
            this.reportWeirdUCS4("2143");
        }
        this._bytesPerChar = 4;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean handleBOM(int n2) throws IOException {
        switch (n2) {
            case 65279: {
                this._bigEndian = true;
                this._inputPtr = 4 + this._inputPtr;
                this._bytesPerChar = 4;
                return true;
            }
            case -131072: {
                this._inputPtr = 4 + this._inputPtr;
                this._bytesPerChar = 4;
                this._bigEndian = false;
                return true;
            }
            case 65534: {
                this.reportWeirdUCS4("2143");
            }
            case -16842752: {
                this.reportWeirdUCS4("3412");
            }
        }
        int n3 = n2 >>> 16;
        if (n3 == 65279) {
            this._inputPtr = 2 + this._inputPtr;
            this._bytesPerChar = 2;
            this._bigEndian = true;
            return true;
        }
        if (n3 == 65534) {
            this._inputPtr = 2 + this._inputPtr;
            this._bytesPerChar = 2;
            this._bigEndian = false;
            return true;
        }
        if (n2 >>> 8 == 0xEFBBBF) {
            this._inputPtr = 3 + this._inputPtr;
            this._bytesPerChar = 1;
            this._bigEndian = true;
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MatchStrength hasJSONFormat(InputAccessor inputAccessor) throws IOException {
        int n2;
        if (!inputAccessor.hasMoreBytes()) {
            return MatchStrength.INCONCLUSIVE;
        }
        byte by2 = inputAccessor.nextByte();
        if (by2 == -17) {
            if (!inputAccessor.hasMoreBytes()) {
                return MatchStrength.INCONCLUSIVE;
            }
            if (inputAccessor.nextByte() != -69) {
                return MatchStrength.NO_MATCH;
            }
            if (!inputAccessor.hasMoreBytes()) {
                return MatchStrength.INCONCLUSIVE;
            }
            if (inputAccessor.nextByte() != -65) {
                return MatchStrength.NO_MATCH;
            }
            if (!inputAccessor.hasMoreBytes()) {
                return MatchStrength.INCONCLUSIVE;
            }
            by2 = inputAccessor.nextByte();
        }
        if ((n2 = ByteSourceJsonBootstrapper.skipSpace(inputAccessor, by2)) < 0) {
            return MatchStrength.INCONCLUSIVE;
        }
        if (n2 == 123) {
            int n3 = ByteSourceJsonBootstrapper.skipSpace(inputAccessor);
            if (n3 < 0) {
                return MatchStrength.INCONCLUSIVE;
            }
            if (n3 == 34) return MatchStrength.SOLID_MATCH;
            if (n3 != 125) return MatchStrength.NO_MATCH;
            return MatchStrength.SOLID_MATCH;
        }
        if (n2 == 91) {
            int n4 = ByteSourceJsonBootstrapper.skipSpace(inputAccessor);
            if (n4 < 0) {
                return MatchStrength.INCONCLUSIVE;
            }
            if (n4 == 93) return MatchStrength.SOLID_MATCH;
            if (n4 != 91) return MatchStrength.SOLID_MATCH;
            return MatchStrength.SOLID_MATCH;
        }
        MatchStrength matchStrength = MatchStrength.WEAK_MATCH;
        if (n2 == 34) return matchStrength;
        if (n2 <= 57) {
            if (n2 >= 48) return matchStrength;
        }
        if (n2 == 45) {
            int n5 = ByteSourceJsonBootstrapper.skipSpace(inputAccessor);
            if (n5 < 0) {
                return MatchStrength.INCONCLUSIVE;
            }
            if (n5 > 57) return MatchStrength.NO_MATCH;
            if (n5 >= 48) return matchStrength;
            return MatchStrength.NO_MATCH;
        }
        if (n2 == 110) {
            return ByteSourceJsonBootstrapper.tryMatch(inputAccessor, "ull", matchStrength);
        }
        if (n2 == 116) {
            return ByteSourceJsonBootstrapper.tryMatch(inputAccessor, "rue", matchStrength);
        }
        if (n2 != 102) return MatchStrength.NO_MATCH;
        return ByteSourceJsonBootstrapper.tryMatch(inputAccessor, "alse", matchStrength);
    }

    private void reportWeirdUCS4(String string2) throws IOException {
        throw new CharConversionException("Unsupported UCS-4 endianness (" + string2 + ") detected");
    }

    private static int skipSpace(InputAccessor inputAccessor) throws IOException {
        if (!inputAccessor.hasMoreBytes()) {
            return -1;
        }
        return ByteSourceJsonBootstrapper.skipSpace(inputAccessor, inputAccessor.nextByte());
    }

    private static int skipSpace(InputAccessor inputAccessor, byte by2) throws IOException {
        int n2;
        while ((n2 = by2 & 0xFF) == 32 || n2 == 13 || n2 == 10 || n2 == 9) {
            if (!inputAccessor.hasMoreBytes()) {
                return -1;
            }
            by2 = inputAccessor.nextByte();
            int cfr_ignored_0 = by2 & 0xFF;
        }
        return n2;
    }

    private static MatchStrength tryMatch(InputAccessor inputAccessor, String string2, MatchStrength matchStrength) throws IOException {
        int n2 = 0;
        int n3 = string2.length();
        while (true) {
            block6: {
                block5: {
                    if (n2 >= n3) break block5;
                    if (inputAccessor.hasMoreBytes()) break block6;
                    matchStrength = MatchStrength.INCONCLUSIVE;
                }
                return matchStrength;
            }
            if (inputAccessor.nextByte() != string2.charAt(n2)) {
                return MatchStrength.NO_MATCH;
            }
            ++n2;
        }
    }

    public JsonParser constructParser(int n2, ObjectCodec objectCodec, BytesToNameCanonicalizer bytesToNameCanonicalizer, CharsToNameCanonicalizer charsToNameCanonicalizer, boolean bl2, boolean bl3) throws IOException, JsonParseException {
        if (this.detectEncoding() == JsonEncoding.UTF8 && bl2) {
            BytesToNameCanonicalizer bytesToNameCanonicalizer2 = bytesToNameCanonicalizer.makeChild(bl2, bl3);
            return new UTF8StreamJsonParser(this._context, n2, this._in, objectCodec, bytesToNameCanonicalizer2, this._inputBuffer, this._inputPtr, this._inputEnd, this._bufferRecyclable);
        }
        return new ReaderBasedJsonParser(this._context, n2, this.constructReader(), objectCodec, charsToNameCanonicalizer.makeChild(bl2, bl3));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Reader constructReader() throws IOException {
        InputStream inputStream;
        JsonEncoding jsonEncoding = this._context.getEncoding();
        switch (1.$SwitchMap$com$fasterxml$jackson$core$JsonEncoding[jsonEncoding.ordinal()]) {
            default: {
                throw new RuntimeException("Internal error");
            }
            case 1: 
            case 2: {
                return new UTF32Reader(this._context, this._in, this._inputBuffer, this._inputPtr, this._inputEnd, this._context.getEncoding().isBigEndian());
            }
            case 3: 
            case 4: 
            case 5: 
        }
        InputStream inputStream2 = this._in;
        if (inputStream2 == null) {
            inputStream = new ByteArrayInputStream(this._inputBuffer, this._inputPtr, this._inputEnd);
            return new InputStreamReader(inputStream, jsonEncoding.getJavaName());
        }
        if (this._inputPtr < this._inputEnd) {
            inputStream = new MergedStream(this._context, inputStream2, this._inputBuffer, this._inputPtr, this._inputEnd);
            return new InputStreamReader(inputStream, jsonEncoding.getJavaName());
        }
        inputStream = inputStream2;
        return new InputStreamReader(inputStream, jsonEncoding.getJavaName());
    }

    /*
     * Enabled aggressive block sorting
     */
    public JsonEncoding detectEncoding() throws IOException, JsonParseException {
        JsonEncoding jsonEncoding;
        boolean bl2;
        block15: {
            block13: {
                int n2;
                block14: {
                    if (!this.ensureLoaded(4)) break block13;
                    n2 = this._inputBuffer[this._inputPtr] << 24 | (0xFF & this._inputBuffer[1 + this._inputPtr]) << 16 | (0xFF & this._inputBuffer[2 + this._inputPtr]) << 8 | 0xFF & this._inputBuffer[3 + this._inputPtr];
                    if (!this.handleBOM(n2)) break block14;
                    bl2 = true;
                    break block15;
                }
                if (this.checkUTF32(n2)) {
                    bl2 = true;
                    break block15;
                } else {
                    boolean bl3 = this.checkUTF16(n2 >>> 16);
                    bl2 = false;
                    if (bl3) {
                        bl2 = true;
                    }
                }
                break block15;
            }
            boolean bl4 = this.ensureLoaded(2);
            bl2 = false;
            if (bl4) {
                boolean bl5 = this.checkUTF16((0xFF & this._inputBuffer[this._inputPtr]) << 8 | 0xFF & this._inputBuffer[1 + this._inputPtr]);
                bl2 = false;
                if (bl5) {
                    bl2 = true;
                }
            }
        }
        if (!bl2) {
            jsonEncoding = JsonEncoding.UTF8;
        } else {
            switch (this._bytesPerChar) {
                default: {
                    throw new RuntimeException("Internal error");
                }
                case 1: {
                    jsonEncoding = JsonEncoding.UTF8;
                    break;
                }
                case 2: {
                    if (this._bigEndian) {
                        jsonEncoding = JsonEncoding.UTF16_BE;
                        break;
                    }
                    jsonEncoding = JsonEncoding.UTF16_LE;
                    break;
                }
                case 4: {
                    jsonEncoding = this._bigEndian ? JsonEncoding.UTF32_BE : JsonEncoding.UTF32_LE;
                }
            }
        }
        this._context.setEncoding(jsonEncoding);
        return jsonEncoding;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected boolean ensureLoaded(int n2) throws IOException {
        int n3 = 1;
        int n4 = this._inputEnd - this._inputPtr;
        while (n4 < n2) {
            int n5 = this._in == null ? -1 : this._in.read(this._inputBuffer, this._inputEnd, this._inputBuffer.length - this._inputEnd);
            if (n5 < n3) {
                return 0 != 0;
            }
            this._inputEnd = n5 + this._inputEnd;
            n4 += n5;
        }
        return n3 != 0;
    }
}

