/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.io;

import com.fasterxml.jackson.core.io.IOContext;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;

public final class UTF8Writer
extends Writer {
    static final int SURR1_FIRST = 55296;
    static final int SURR1_LAST = 56319;
    static final int SURR2_FIRST = 56320;
    static final int SURR2_LAST = 57343;
    protected final IOContext _context;
    OutputStream _out;
    byte[] _outBuffer;
    final int _outBufferEnd;
    int _outPtr;
    int _surrogate = 0;

    public UTF8Writer(IOContext iOContext, OutputStream outputStream) {
        this._context = iOContext;
        this._out = outputStream;
        this._outBuffer = iOContext.allocWriteEncodingBuffer();
        this._outBufferEnd = -4 + this._outBuffer.length;
        this._outPtr = 0;
    }

    private int convertSurrogate(int n2) throws IOException {
        int n3 = this._surrogate;
        this._surrogate = 0;
        if (n2 < 56320 || n2 > 57343) {
            throw new IOException("Broken surrogate pair: first char 0x" + Integer.toHexString(n3) + ", second 0x" + Integer.toHexString(n2) + "; illegal combination");
        }
        return 65536 + (n3 - 55296 << 10) + (n2 - 56320);
    }

    private void throwIllegal(int n2) throws IOException {
        if (n2 > 0x10FFFF) {
            throw new IOException("Illegal character point (0x" + Integer.toHexString(n2) + ") to output; max is 0x10FFFF as per RFC 4627");
        }
        if (n2 >= 55296) {
            if (n2 <= 56319) {
                throw new IOException("Unmatched first part of surrogate pair (0x" + Integer.toHexString(n2) + ")");
            }
            throw new IOException("Unmatched second part of surrogate pair (0x" + Integer.toHexString(n2) + ")");
        }
        throw new IOException("Illegal character point (0x" + Integer.toHexString(n2) + ") to output");
    }

    @Override
    public Writer append(char c2) throws IOException {
        this.write(c2);
        return this;
    }

    @Override
    public void close() throws IOException {
        if (this._out != null) {
            if (this._outPtr > 0) {
                this._out.write(this._outBuffer, 0, this._outPtr);
                this._outPtr = 0;
            }
            OutputStream outputStream = this._out;
            this._out = null;
            byte[] byArray = this._outBuffer;
            if (byArray != null) {
                this._outBuffer = null;
                this._context.releaseWriteEncodingBuffer(byArray);
            }
            outputStream.close();
            int n2 = this._surrogate;
            this._surrogate = 0;
            if (n2 > 0) {
                this.throwIllegal(n2);
            }
        }
    }

    @Override
    public void flush() throws IOException {
        if (this._out != null) {
            if (this._outPtr > 0) {
                this._out.write(this._outBuffer, 0, this._outPtr);
                this._outPtr = 0;
            }
            this._out.flush();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void write(int n2) throws IOException {
        int n3;
        if (this._surrogate > 0) {
            n2 = this.convertSurrogate(n2);
        } else if (n2 >= 55296 && n2 <= 57343) {
            if (n2 > 56319) {
                this.throwIllegal(n2);
            }
            this._surrogate = n2;
            return;
        }
        if (this._outPtr >= this._outBufferEnd) {
            this._out.write(this._outBuffer, 0, this._outPtr);
            this._outPtr = 0;
        }
        if (n2 < 128) {
            byte[] byArray = this._outBuffer;
            int n4 = this._outPtr;
            this._outPtr = n4 + 1;
            byArray[n4] = (byte)n2;
            return;
        }
        int n5 = this._outPtr;
        if (n2 < 2048) {
            byte[] byArray = this._outBuffer;
            int n6 = n5 + 1;
            byArray[n5] = (byte)(0xC0 | n2 >> 6);
            byte[] byArray2 = this._outBuffer;
            n3 = n6 + 1;
            byArray2[n6] = (byte)(0x80 | n2 & 0x3F);
        } else if (n2 <= 65535) {
            byte[] byArray = this._outBuffer;
            int n7 = n5 + 1;
            byArray[n5] = (byte)(0xE0 | n2 >> 12);
            byte[] byArray3 = this._outBuffer;
            int n8 = n7 + 1;
            byArray3[n7] = (byte)(0x80 | 0x3F & n2 >> 6);
            byte[] byArray4 = this._outBuffer;
            int n9 = n8 + 1;
            byArray4[n8] = (byte)(0x80 | n2 & 0x3F);
            n3 = n9;
        } else {
            if (n2 > 0x10FFFF) {
                this.throwIllegal(n2);
            }
            byte[] byArray = this._outBuffer;
            int n10 = n5 + 1;
            byArray[n5] = (byte)(0xF0 | n2 >> 18);
            byte[] byArray5 = this._outBuffer;
            int n11 = n10 + 1;
            byArray5[n10] = (byte)(0x80 | 0x3F & n2 >> 12);
            byte[] byArray6 = this._outBuffer;
            int n12 = n11 + 1;
            byArray6[n11] = (byte)(0x80 | 0x3F & n2 >> 6);
            byte[] byArray7 = this._outBuffer;
            n3 = n12 + 1;
            byArray7[n12] = (byte)(0x80 | n2 & 0x3F);
        }
        this._outPtr = n3;
    }

    @Override
    public void write(String string2) throws IOException {
        this.write(string2, 0, string2.length());
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void write(String var1_1, int var2_2, int var3_3) throws IOException {
        if (var3_3 < 2) {
            if (var3_3 == 1) {
                this.write(var1_1.charAt(var2_2));
            }
            return;
        }
        if (this._surrogate > 0) {
            var29_4 = var2_2 + 1;
            var30_5 = var1_1.charAt(var2_2);
            --var3_3;
            this.write(this.convertSurrogate(var30_5));
            var2_2 = var29_4;
        }
        var4_6 = this._outPtr;
        var5_7 = this._outBuffer;
        var6_8 = this._outBufferEnd;
        var7_9 = var3_3 + var2_2;
        var8_10 = var2_2;
        block0: while (var8_10 < var7_9) {
            if (var4_6 >= var6_8) {
                this._out.write(var5_7, 0, var4_6);
                var4_6 = 0;
            }
            var10_11 = var8_10 + 1;
            var11_12 = var1_1.charAt(var8_10);
            if (var11_12 < '\u0080') {
                var12_13 = var4_6 + 1;
                var5_7[var4_6] = (byte)var11_12;
                var24_24 = var7_9 - var10_11;
                var25_25 = var6_8 - var12_13;
                if (var24_24 > var25_25) {
                    var24_24 = var25_25;
                }
                var26_26 = var24_24 + var10_11;
                var8_10 = var10_11;
                block1: while (true) {
                    if (var8_10 >= var26_26) {
                        var4_6 = var12_13;
                        continue block0;
                    }
                    var27_27 = var8_10 + 1;
                    var11_12 = var1_1.charAt(var8_10);
                    if (var11_12 >= '\u0080') {
                        var8_10 = var27_27;
lbl39:
                        // 2 sources

                        while (true) {
                            if (var11_12 >= '\u0800') break block1;
                            var22_22 = var12_13 + 1;
                            var5_7[var12_13] = (byte)(192 | var11_12 >> 6);
                            var23_23 = var22_22 + 1;
                            var5_7[var22_22] = (byte)(128 | var11_12 & 63);
                            var4_6 = var23_23;
                            var15_16 = var8_10;
lbl47:
                            // 2 sources

                            while (true) {
                                var8_10 = var15_16;
                                continue block0;
                                break;
                            }
                            break;
                        }
                    }
                    var28_28 = var12_13 + 1;
                    var5_7[var12_13] = (byte)var11_12;
                    var12_13 = var28_28;
                    var8_10 = var27_27;
                }
                if (var11_12 < '\ud800' || var11_12 > '\udfff') {
                    var13_14 = var12_13 + 1;
                    var5_7[var12_13] = (byte)(224 | var11_12 >> 12);
                    var14_15 = var13_14 + 1;
                    var5_7[var13_14] = (byte)(128 | 63 & var11_12 >> 6);
                    var4_6 = var14_15 + 1;
                    var5_7[var14_15] = (byte)(128 | var11_12 & 63);
                    continue;
                }
                if (var11_12 > '\udbff') {
                    this._outPtr = var12_13;
                    this.throwIllegal(var11_12);
                }
                this._surrogate = var11_12;
                if (var8_10 >= var7_9) {
                    var4_6 = var12_13;
lbl70:
                    // 2 sources

                    while (true) {
                        this._outPtr = var4_6;
                        return;
                    }
                }
                var15_16 = var8_10 + 1;
                var16_17 = this.convertSurrogate(var1_1.charAt(var8_10));
                if (var16_17 > 0x10FFFF) {
                    this._outPtr = var12_13;
                    this.throwIllegal(var16_17);
                }
                var17_18 = var12_13 + 1;
                var5_7[var12_13] = (byte)(240 | var16_17 >> 18);
                var18_19 = var17_18 + 1;
                var5_7[var17_18] = (byte)(128 | 63 & var16_17 >> 12);
                var19_20 = var18_19 + 1;
                var5_7[var18_19] = (byte)(128 | 63 & var16_17 >> 6);
                var20_21 = var19_20 + 1;
                var5_7[var19_20] = (byte)(128 | var16_17 & 63);
                var4_6 = var20_21;
                ** continue;
            }
            var12_13 = var4_6;
            var8_10 = var10_11;
            ** continue;
        }
        ** while (true)
    }

    @Override
    public void write(char[] cArray) throws IOException {
        this.write(cArray, 0, cArray.length);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void write(char[] var1_1, int var2_2, int var3_3) throws IOException {
        if (var3_3 < 2) {
            if (var3_3 == 1) {
                this.write(var1_1[var2_2]);
            }
            return;
        }
        if (this._surrogate > 0) {
            var29_4 = var2_2 + 1;
            var30_5 = var1_1[var2_2];
            --var3_3;
            this.write(this.convertSurrogate(var30_5));
            var2_2 = var29_4;
        }
        var4_6 = this._outPtr;
        var5_7 = this._outBuffer;
        var6_8 = this._outBufferEnd;
        var7_9 = var3_3 + var2_2;
        var8_10 = var2_2;
        block0: while (var8_10 < var7_9) {
            if (var4_6 >= var6_8) {
                this._out.write(var5_7, 0, var4_6);
                var4_6 = 0;
            }
            var10_11 = var8_10 + 1;
            var11_12 = var1_1[var8_10];
            if (var11_12 < 128) {
                var12_13 = var4_6 + 1;
                var5_7[var4_6] = (byte)var11_12;
                var24_24 = var7_9 - var10_11;
                var25_25 = var6_8 - var12_13;
                if (var24_24 > var25_25) {
                    var24_24 = var25_25;
                }
                var26_26 = var24_24 + var10_11;
                var8_10 = var10_11;
                block1: while (true) {
                    if (var8_10 >= var26_26) {
                        var4_6 = var12_13;
                        continue block0;
                    }
                    var27_27 = var8_10 + 1;
                    var11_12 = var1_1[var8_10];
                    if (var11_12 >= 128) {
                        var8_10 = var27_27;
lbl39:
                        // 2 sources

                        while (true) {
                            if (var11_12 >= 2048) break block1;
                            var22_22 = var12_13 + 1;
                            var5_7[var12_13] = (byte)(192 | var11_12 >> 6);
                            var23_23 = var22_22 + 1;
                            var5_7[var22_22] = (byte)(128 | var11_12 & 63);
                            var4_6 = var23_23;
                            var15_16 = var8_10;
lbl47:
                            // 2 sources

                            while (true) {
                                var8_10 = var15_16;
                                continue block0;
                                break;
                            }
                            break;
                        }
                    }
                    var28_28 = var12_13 + 1;
                    var5_7[var12_13] = (byte)var11_12;
                    var12_13 = var28_28;
                    var8_10 = var27_27;
                }
                if (var11_12 < 55296 || var11_12 > 57343) {
                    var13_14 = var12_13 + 1;
                    var5_7[var12_13] = (byte)(224 | var11_12 >> 12);
                    var14_15 = var13_14 + 1;
                    var5_7[var13_14] = (byte)(128 | 63 & var11_12 >> 6);
                    var4_6 = var14_15 + 1;
                    var5_7[var14_15] = (byte)(128 | var11_12 & 63);
                    continue;
                }
                if (var11_12 > 56319) {
                    this._outPtr = var12_13;
                    this.throwIllegal(var11_12);
                }
                this._surrogate = var11_12;
                if (var8_10 >= var7_9) {
                    var4_6 = var12_13;
lbl70:
                    // 2 sources

                    while (true) {
                        this._outPtr = var4_6;
                        return;
                    }
                }
                var15_16 = var8_10 + 1;
                var16_17 = this.convertSurrogate(var1_1[var8_10]);
                if (var16_17 > 0x10FFFF) {
                    this._outPtr = var12_13;
                    this.throwIllegal(var16_17);
                }
                var17_18 = var12_13 + 1;
                var5_7[var12_13] = (byte)(240 | var16_17 >> 18);
                var18_19 = var17_18 + 1;
                var5_7[var17_18] = (byte)(128 | 63 & var16_17 >> 12);
                var19_20 = var18_19 + 1;
                var5_7[var18_19] = (byte)(128 | 63 & var16_17 >> 6);
                var20_21 = var19_20 + 1;
                var5_7[var19_20] = (byte)(128 | var16_17 & 63);
                var4_6 = var20_21;
                ** continue;
            }
            var12_13 = var4_6;
            var8_10 = var10_11;
            ** continue;
        }
        ** while (true)
    }
}

