/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.io;

import com.fasterxml.jackson.core.io.BaseReader;
import com.fasterxml.jackson.core.io.IOContext;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.InputStream;

public class UTF32Reader
extends BaseReader {
    protected final boolean _bigEndian;
    protected int _byteCount = 0;
    protected int _charCount = 0;
    protected final boolean _managedBuffers;
    protected char _surrogate = '\u0000';

    public UTF32Reader(IOContext iOContext, InputStream inputStream, byte[] byArray, int n2, int n3, boolean bl2) {
        super(iOContext, inputStream, byArray, n2, n3);
        this._bigEndian = bl2;
        boolean bl3 = false;
        if (inputStream != null) {
            bl3 = true;
        }
        this._managedBuffers = bl3;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean loadMore(int n2) throws IOException {
        this._byteCount += this._length - n2;
        if (n2 > 0) {
            if (this._ptr > 0) {
                for (int i2 = 0; i2 < n2; ++i2) {
                    this._buffer[i2] = this._buffer[i2 + this._ptr];
                }
                this._ptr = 0;
            }
            this._length = n2;
        } else {
            this._ptr = 0;
            int n3 = this._in == null ? -1 : this._in.read(this._buffer);
            if (n3 < 1) {
                this._length = 0;
                if (n3 < 0) {
                    if (this._managedBuffers) {
                        this.freeBuffers();
                    }
                    return false;
                }
                this.reportStrangeStream();
            }
            this._length = n3;
        }
        while (this._length < 4) {
            int n4 = this._in == null ? -1 : this._in.read(this._buffer, this._length, this._buffer.length - this._length);
            if (n4 < 1) {
                if (n4 < 0) {
                    if (this._managedBuffers) {
                        this.freeBuffers();
                    }
                    this.reportUnexpectedEOF(this._length, 4);
                }
                this.reportStrangeStream();
            }
            this._length = n4 + this._length;
        }
        return true;
    }

    private void reportInvalid(int n2, int n3, String string2) throws IOException {
        int n4 = -1 + (this._byteCount + this._ptr);
        int n5 = n3 + this._charCount;
        throw new CharConversionException("Invalid UTF-32 character 0x" + Integer.toHexString(n2) + string2 + " at char #" + n5 + ", byte #" + n4 + ")");
    }

    private void reportUnexpectedEOF(int n2, int n3) throws IOException {
        int n4 = n2 + this._byteCount;
        int n5 = this._charCount;
        throw new CharConversionException("Unexpected EOF in the middle of a 4-byte UTF-32 char: got " + n2 + ", needed " + n3 + ", at char #" + n5 + ", byte #" + n4 + ")");
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public int read(char[] cArray, int n2, int n3) throws IOException {
        int n4;
        block12: {
            int n5;
            int n6;
            block15: {
                block16: {
                    block13: {
                        block14: {
                            if (this._buffer == null) break block13;
                            if (n3 < 1) {
                                return n3;
                            }
                            if (n2 < 0 || n2 + n3 > cArray.length) {
                                this.reportBounds(cArray, n2, n3);
                            }
                            n6 = n3 + n2;
                            if (this._surrogate == '\u0000') break block14;
                            n5 = n2 + 1;
                            cArray[n2] = this._surrogate;
                            this._surrogate = '\u0000';
                            break block15;
                        }
                        int n7 = this._length - this._ptr;
                        if (n7 >= 4 || this.loadMore(n7)) break block16;
                    }
                    return -1;
                }
                n5 = n2;
            }
            while (n5 < n6) {
                int n8 = this._ptr;
                int n9 = this._bigEndian ? this._buffer[n8] << 24 | (0xFF & this._buffer[n8 + 1]) << 16 | (0xFF & this._buffer[n8 + 2]) << 8 | 0xFF & this._buffer[n8 + 3] : 0xFF & this._buffer[n8] | (0xFF & this._buffer[n8 + 1]) << 8 | (0xFF & this._buffer[n8 + 2]) << 16 | this._buffer[n8 + 3] << 24;
                this._ptr = 4 + this._ptr;
                if (n9 > 65535) {
                    if (n9 > 0x10FFFF) {
                        this.reportInvalid(n9, n5 - n2, "(above " + Integer.toHexString(0x10FFFF) + ") ");
                    }
                    int n10 = n9 - 65536;
                    n4 = n5 + 1;
                    cArray[n5] = (char)(55296 + (n10 >> 10));
                    n9 = 0xDC00 | n10 & 0x3FF;
                    if (n4 >= n6) {
                        this._surrogate = (char)n9;
                        break block12;
                    }
                } else {
                    n4 = n5;
                }
                n5 = n4 + 1;
                cArray[n4] = (char)n9;
                if (this._ptr < this._length) continue;
                n4 = n5;
                break block12;
            }
            n4 = n5;
        }
        int n11 = n4 - n2;
        this._charCount = n11 + this._charCount;
        return n11;
    }
}

