/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.io;

public final class NumberOutput {
    private static int BILLION;
    static final char[] FULL_TRIPLETS;
    static final byte[] FULL_TRIPLETS_B;
    static final char[] LEADING_TRIPLETS;
    private static long MAX_INT_AS_LONG;
    private static int MILLION;
    private static long MIN_INT_AS_LONG;
    private static final char NULL_CHAR;
    static final String SMALLEST_LONG;
    private static long TEN_BILLION_L;
    private static long THOUSAND_L;
    static final String[] sSmallIntStrs;
    static final String[] sSmallIntStrs2;

    /*
     * Enabled aggressive block sorting
     */
    static {
        MILLION = 1000000;
        BILLION = 1000000000;
        TEN_BILLION_L = 10000000000L;
        THOUSAND_L = 1000L;
        MIN_INT_AS_LONG = Integer.MIN_VALUE;
        MAX_INT_AS_LONG = Integer.MAX_VALUE;
        SMALLEST_LONG = String.valueOf(Long.MIN_VALUE);
        LEADING_TRIPLETS = new char[4000];
        FULL_TRIPLETS = new char[4000];
        int n2 = 0;
        int n3 = 0;
        while (true) {
            char c2;
            char c3;
            if (n3 < 10) {
                c3 = (char)(n3 + 48);
                c2 = n3 == 0 ? (char)'\u0000' : c3;
            } else {
                FULL_TRIPLETS_B = new byte[4000];
                int n4 = 0;
                while (true) {
                    if (n4 >= 4000) {
                        sSmallIntStrs = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10"};
                        sSmallIntStrs2 = new String[]{"-1", "-2", "-3", "-4", "-5", "-6", "-7", "-8", "-9", "-10"};
                        return;
                    }
                    NumberOutput.FULL_TRIPLETS_B[n4] = (byte)FULL_TRIPLETS[n4];
                    ++n4;
                }
            }
            for (int i2 = 0; i2 < 10; ++i2) {
                char c4 = (char)(i2 + 48);
                char c5 = n3 == 0 && i2 == 0 ? (char)'\u0000' : c4;
                for (int i3 = 0; i3 < 10; n2 += 4, ++i3) {
                    char c6 = (char)(i3 + 48);
                    NumberOutput.LEADING_TRIPLETS[n2] = c2;
                    NumberOutput.LEADING_TRIPLETS[n2 + 1] = c5;
                    NumberOutput.LEADING_TRIPLETS[n2 + 2] = c6;
                    NumberOutput.FULL_TRIPLETS[n2] = c3;
                    NumberOutput.FULL_TRIPLETS[n2 + 1] = c4;
                    NumberOutput.FULL_TRIPLETS[n2 + 2] = c6;
                }
            }
            ++n3;
        }
    }

    private static int calcLongStrLength(long l2) {
        int n2 = 10;
        long l3 = TEN_BILLION_L;
        while (l2 >= l3 && n2 != 19) {
            ++n2;
            l3 = (l3 << 3) + (l3 << 1);
        }
        return n2;
    }

    private static int outputFullTriplet(int n2, byte[] byArray, int n3) {
        int n4 = n2 << 2;
        int n5 = n3 + 1;
        byte[] byArray2 = FULL_TRIPLETS_B;
        int n6 = n4 + 1;
        byArray[n3] = byArray2[n4];
        int n7 = n5 + 1;
        byte[] byArray3 = FULL_TRIPLETS_B;
        int n8 = n6 + 1;
        byArray[n5] = byArray3[n6];
        int n9 = n7 + 1;
        byArray[n7] = FULL_TRIPLETS_B[n8];
        return n9;
    }

    private static int outputFullTriplet(int n2, char[] cArray, int n3) {
        int n4 = n2 << 2;
        int n5 = n3 + 1;
        char[] cArray2 = FULL_TRIPLETS;
        int n6 = n4 + 1;
        cArray[n3] = cArray2[n4];
        int n7 = n5 + 1;
        char[] cArray3 = FULL_TRIPLETS;
        int n8 = n6 + 1;
        cArray[n5] = cArray3[n6];
        int n9 = n7 + 1;
        cArray[n7] = FULL_TRIPLETS[n8];
        return n9;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static int outputInt(int n2, byte[] byArray, int n3) {
        int n4;
        if (n2 < 0) {
            if (n2 == Integer.MIN_VALUE) {
                return NumberOutput.outputLong((long)n2, byArray, n3);
            }
            int n5 = n3 + 1;
            byArray[n3] = 45;
            n2 = -n2;
            n3 = n5;
        }
        if (n2 < MILLION) {
            if (n2 >= 1000) {
                int n6 = n2 / 1000;
                return NumberOutput.outputFullTriplet(n2 - n6 * 1000, byArray, NumberOutput.outputLeadingTriplet(n6, byArray, n3));
            }
            if (n2 >= 10) return NumberOutput.outputLeadingTriplet(n2, byArray, n3);
            int n7 = n3 + 1;
            byArray[n3] = (byte)(n2 + 48);
            return n7;
        }
        boolean bl2 = n2 >= BILLION;
        if (bl2) {
            if ((n2 -= BILLION) >= BILLION) {
                n2 -= BILLION;
                int n8 = n3 + 1;
                byArray[n3] = 50;
                n3 = n8;
            } else {
                int n9 = n3 + 1;
                byArray[n3] = 49;
                n3 = n9;
            }
        }
        int n10 = n2 / 1000;
        int n11 = n2 - n10 * 1000;
        int n12 = n10 / 1000;
        int n13 = n10 - n12 * 1000;
        if (bl2) {
            n4 = NumberOutput.outputFullTriplet(n12, byArray, n3);
            return NumberOutput.outputFullTriplet(n11, byArray, NumberOutput.outputFullTriplet(n13, byArray, n4));
        }
        n4 = NumberOutput.outputLeadingTriplet(n12, byArray, n3);
        return NumberOutput.outputFullTriplet(n11, byArray, NumberOutput.outputFullTriplet(n13, byArray, n4));
    }

    /*
     * Enabled aggressive block sorting
     */
    public static int outputInt(int n2, char[] cArray, int n3) {
        int n4;
        if (n2 < 0) {
            if (n2 == Integer.MIN_VALUE) {
                return NumberOutput.outputLong((long)n2, cArray, n3);
            }
            int n5 = n3 + 1;
            cArray[n3] = 45;
            n2 = -n2;
            n3 = n5;
        }
        if (n2 < MILLION) {
            if (n2 >= 1000) {
                int n6 = n2 / 1000;
                return NumberOutput.outputFullTriplet(n2 - n6 * 1000, cArray, NumberOutput.outputLeadingTriplet(n6, cArray, n3));
            }
            if (n2 >= 10) return NumberOutput.outputLeadingTriplet(n2, cArray, n3);
            int n7 = n3 + 1;
            cArray[n3] = (char)(n2 + 48);
            return n7;
        }
        boolean bl2 = n2 >= BILLION;
        if (bl2) {
            if ((n2 -= BILLION) >= BILLION) {
                n2 -= BILLION;
                int n8 = n3 + 1;
                cArray[n3] = 50;
                n3 = n8;
            } else {
                int n9 = n3 + 1;
                cArray[n3] = 49;
                n3 = n9;
            }
        }
        int n10 = n2 / 1000;
        int n11 = n2 - n10 * 1000;
        int n12 = n10 / 1000;
        int n13 = n10 - n12 * 1000;
        if (bl2) {
            n4 = NumberOutput.outputFullTriplet(n12, cArray, n3);
            return NumberOutput.outputFullTriplet(n11, cArray, NumberOutput.outputFullTriplet(n13, cArray, n4));
        }
        n4 = NumberOutput.outputLeadingTriplet(n12, cArray, n3);
        return NumberOutput.outputFullTriplet(n11, cArray, NumberOutput.outputFullTriplet(n13, cArray, n4));
    }

    private static int outputLeadingTriplet(int n2, byte[] byArray, int n3) {
        int n4 = n2 << 2;
        char[] cArray = LEADING_TRIPLETS;
        int n5 = n4 + 1;
        char c2 = cArray[n4];
        if (c2 != '\u0000') {
            int n6 = n3 + 1;
            byArray[n3] = (byte)c2;
            n3 = n6;
        }
        char[] cArray2 = LEADING_TRIPLETS;
        int n7 = n5 + 1;
        char c3 = cArray2[n5];
        if (c3 != '\u0000') {
            int n8 = n3 + 1;
            byArray[n3] = (byte)c3;
            n3 = n8;
        }
        int n9 = n3 + 1;
        byArray[n3] = (byte)LEADING_TRIPLETS[n7];
        return n9;
    }

    private static int outputLeadingTriplet(int n2, char[] cArray, int n3) {
        int n4 = n2 << 2;
        char[] cArray2 = LEADING_TRIPLETS;
        int n5 = n4 + 1;
        char c2 = cArray2[n4];
        if (c2 != '\u0000') {
            int n6 = n3 + 1;
            cArray[n3] = c2;
            n3 = n6;
        }
        char[] cArray3 = LEADING_TRIPLETS;
        int n7 = n5 + 1;
        char c3 = cArray3[n5];
        if (c3 != '\u0000') {
            int n8 = n3 + 1;
            cArray[n3] = c3;
            n3 = n8;
        }
        int n9 = n3 + 1;
        cArray[n3] = LEADING_TRIPLETS[n7];
        return n9;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static int outputLong(long l2, byte[] byArray, int n2) {
        int n3;
        if (l2 < 0L) {
            if (l2 > MIN_INT_AS_LONG) {
                return NumberOutput.outputInt((int)l2, byArray, n2);
            }
            if (l2 == Long.MIN_VALUE) {
                int n4 = SMALLEST_LONG.length();
                int n5 = 0;
                int n6 = n2;
                while (true) {
                    if (n5 >= n4) {
                        return n6;
                    }
                    int n7 = n6 + 1;
                    byArray[n6] = (byte)SMALLEST_LONG.charAt(n5);
                    ++n5;
                    n6 = n7;
                }
            }
            int n8 = n2 + 1;
            byArray[n2] = 45;
            l2 = -l2;
            n2 = n8;
        } else if (l2 <= MAX_INT_AS_LONG) {
            return NumberOutput.outputInt((int)l2, byArray, n2);
        }
        int n9 = n2;
        int n10 = n3 = n2 + NumberOutput.calcLongStrLength(l2);
        while (l2 > MAX_INT_AS_LONG) {
            long l3 = l2 / THOUSAND_L;
            NumberOutput.outputFullTriplet((int)(l2 - l3 * THOUSAND_L), byArray, n10 -= 3);
            l2 = l3;
        }
        int n11 = (int)l2;
        while (true) {
            if (n11 < 1000) {
                NumberOutput.outputLeadingTriplet(n11, byArray, n9);
                return n3;
            }
            int n12 = n11 / 1000;
            NumberOutput.outputFullTriplet(n11 - n12 * 1000, byArray, n10 -= 3);
            n11 = n12;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static int outputLong(long l2, char[] cArray, int n2) {
        int n3;
        if (l2 < 0L) {
            if (l2 > MIN_INT_AS_LONG) {
                return NumberOutput.outputInt((int)l2, cArray, n2);
            }
            if (l2 == Long.MIN_VALUE) {
                int n4 = SMALLEST_LONG.length();
                SMALLEST_LONG.getChars(0, n4, cArray, n2);
                return n2 + n4;
            }
            int n5 = n2 + 1;
            cArray[n2] = 45;
            l2 = -l2;
            n2 = n5;
        } else if (l2 <= MAX_INT_AS_LONG) {
            return NumberOutput.outputInt((int)l2, cArray, n2);
        }
        int n6 = n2;
        int n7 = n3 = n2 + NumberOutput.calcLongStrLength(l2);
        while (l2 > MAX_INT_AS_LONG) {
            long l3 = l2 / THOUSAND_L;
            NumberOutput.outputFullTriplet((int)(l2 - l3 * THOUSAND_L), cArray, n7 -= 3);
            l2 = l3;
        }
        int n8 = (int)l2;
        while (true) {
            if (n8 < 1000) {
                NumberOutput.outputLeadingTriplet(n8, cArray, n6);
                return n3;
            }
            int n9 = n8 / 1000;
            NumberOutput.outputFullTriplet(n8 - n9 * 1000, cArray, n7 -= 3);
            n8 = n9;
        }
    }

    public static String toString(double d2) {
        return Double.toString(d2);
    }

    public static String toString(int n2) {
        if (n2 < sSmallIntStrs.length) {
            if (n2 >= 0) {
                return sSmallIntStrs[n2];
            }
            int n3 = -1 + -n2;
            if (n3 < sSmallIntStrs2.length) {
                return sSmallIntStrs2[n3];
            }
        }
        return Integer.toString(n2);
    }

    public static String toString(long l2) {
        if (l2 <= Integer.MAX_VALUE && l2 >= Integer.MIN_VALUE) {
            return NumberOutput.toString((int)l2);
        }
        return Long.toString(l2);
    }
}

