/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.io;

public final class NumberInput {
    static final long L_BILLION = 1000000000L;
    static final String MAX_LONG_STR;
    static final String MIN_LONG_STR_NO_SIGN;
    public static final String NASTY_SMALL_DOUBLE = "2.2250738585072012e-308";

    static {
        MIN_LONG_STR_NO_SIGN = String.valueOf(Long.MIN_VALUE).substring(1);
        MAX_LONG_STR = String.valueOf(Long.MAX_VALUE);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean inLongRange(String string2, boolean bl2) {
        String string3 = bl2 ? MIN_LONG_STR_NO_SIGN : MAX_LONG_STR;
        int n2 = string3.length();
        int n3 = string2.length();
        if (n3 >= n2) {
            if (n3 > n2) {
                return false;
            }
            for (int i2 = 0; i2 < n2; ++i2) {
                int n4 = string2.charAt(i2) - string3.charAt(i2);
                if (n4 == 0) continue;
                if (n4 < 0) break;
                return false;
            }
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean inLongRange(char[] cArray, int n2, int n3, boolean bl2) {
        String string2 = bl2 ? MIN_LONG_STR_NO_SIGN : MAX_LONG_STR;
        int n4 = string2.length();
        if (n3 >= n4) {
            if (n3 > n4) {
                return false;
            }
            for (int i2 = 0; i2 < n4; ++i2) {
                int n5 = cArray[n2 + i2] - string2.charAt(i2);
                if (n5 == 0) continue;
                if (n5 < 0) break;
                return false;
            }
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static double parseAsDouble(String string2, double d2) {
        if (string2 == null) {
            return d2;
        }
        String string3 = string2.trim();
        if (string3.length() == 0) return d2;
        try {
            return NumberInput.parseDouble(string3);
        }
        catch (NumberFormatException numberFormatException) {
            return d2;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int parseAsInt(String string2, int n2) {
        if (string2 == null) return n2;
        String string3 = string2.trim();
        int n3 = string3.length();
        if (n3 == 0) {
            return n2;
        }
        int n4 = 0;
        if (n3 < 0) {
            char c2 = string3.charAt(0);
            if (c2 == '+') {
                string3 = string3.substring(1);
                n3 = string3.length();
            } else {
                n4 = 0;
                if (c2 == '-') {
                    n4 = 0 + 1;
                }
            }
        }
        while (n4 < n3) {
            char c3 = string3.charAt(n4);
            if (c3 > '9' || c3 < '0') {
                try {
                    double d2 = NumberInput.parseDouble(string3);
                    return (int)d2;
                }
                catch (NumberFormatException numberFormatException) {
                    return n2;
                }
            }
            ++n4;
        }
        try {
            return Integer.parseInt(string3);
        }
        catch (NumberFormatException numberFormatException) {
            return n2;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long parseAsLong(String string2, long l2) {
        if (string2 == null) return l2;
        String string3 = string2.trim();
        int n2 = string3.length();
        if (n2 == 0) {
            return l2;
        }
        int n3 = 0;
        if (n2 < 0) {
            char c2 = string3.charAt(0);
            if (c2 == '+') {
                string3 = string3.substring(1);
                n2 = string3.length();
            } else {
                n3 = 0;
                if (c2 == '-') {
                    n3 = 0 + 1;
                }
            }
        }
        while (n3 < n2) {
            char c3 = string3.charAt(n3);
            if (c3 > '9' || c3 < '0') {
                try {
                    double d2 = NumberInput.parseDouble(string3);
                    return (long)d2;
                }
                catch (NumberFormatException numberFormatException) {
                    return l2;
                }
            }
            ++n3;
        }
        try {
            return Long.parseLong(string3);
        }
        catch (NumberFormatException numberFormatException) {
            return l2;
        }
    }

    public static double parseDouble(String string2) throws NumberFormatException {
        if (NASTY_SMALL_DOUBLE.equals(string2)) {
            return Double.MIN_VALUE;
        }
        return Double.parseDouble(string2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static int parseInt(String string2) {
        int n2;
        char c2 = string2.charAt(0);
        int n3 = string2.length();
        boolean bl2 = false;
        if (c2 == '-') {
            bl2 = true;
        }
        if (bl2) {
            if (n3 == 1) return Integer.parseInt(string2);
            if (n3 > 10) {
                return Integer.parseInt(string2);
            }
            n2 = 1 + 1;
            c2 = string2.charAt(1);
        } else {
            if (n3 > 9) {
                return Integer.parseInt(string2);
            }
            n2 = 1;
        }
        if (c2 > '9') return Integer.parseInt(string2);
        if (c2 < '0') {
            return Integer.parseInt(string2);
        }
        int n4 = c2 - 48;
        if (n2 < n3) {
            int n5 = n2 + 1;
            char c3 = string2.charAt(n2);
            if (c3 > '9') return Integer.parseInt(string2);
            if (c3 < '0') {
                return Integer.parseInt(string2);
            }
            n4 = n4 * 10 + (c3 - 48);
            if (n5 < n3) {
                n2 = n5 + 1;
                char c4 = string2.charAt(n5);
                if (c4 > '9') return Integer.parseInt(string2);
                if (c4 < '0') {
                    return Integer.parseInt(string2);
                }
                n4 = n4 * 10 + (c4 - 48);
                if (n2 < n3) {
                    do {
                        int n6 = n2;
                        n2 = n6 + 1;
                        char c5 = string2.charAt(n6);
                        if (c5 > '9') return Integer.parseInt(string2);
                        if (c5 < '0') {
                            return Integer.parseInt(string2);
                        }
                        n4 = n4 * 10 + (c5 - 48);
                    } while (n2 < n3);
                }
            }
        }
        if (!bl2) return n4;
        return -n4;
    }

    public static int parseInt(char[] cArray, int n2, int n3) {
        int n4 = -48 + cArray[n2];
        int n5 = n2 + 1;
        int n6 = n3 + n2;
        if (n5 < n6) {
            n4 = n4 * 10 + (-48 + cArray[n5]);
            int n7 = n5 + 1;
            if (n7 < n6) {
                n4 = n4 * 10 + (-48 + cArray[n7]);
                int n8 = n7 + 1;
                if (n8 < n6) {
                    n4 = n4 * 10 + (-48 + cArray[n8]);
                    int n9 = n8 + 1;
                    if (n9 < n6) {
                        n4 = n4 * 10 + (-48 + cArray[n9]);
                        int n10 = n9 + 1;
                        if (n10 < n6) {
                            n4 = n4 * 10 + (-48 + cArray[n10]);
                            int n11 = n10 + 1;
                            if (n11 < n6) {
                                n4 = n4 * 10 + (-48 + cArray[n11]);
                                int n12 = n11 + 1;
                                if (n12 < n6) {
                                    n4 = n4 * 10 + (-48 + cArray[n12]);
                                    int n13 = n12 + 1;
                                    if (n13 < n6) {
                                        n4 = n4 * 10 + (-48 + cArray[n13]);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return n4;
    }

    public static long parseLong(String string2) {
        if (string2.length() <= 9) {
            return NumberInput.parseInt(string2);
        }
        return Long.parseLong(string2);
    }

    public static long parseLong(char[] cArray, int n2, int n3) {
        int n4 = n3 - 9;
        return 1000000000L * (long)NumberInput.parseInt(cArray, n2, n4) + (long)NumberInput.parseInt(cArray, n2 + n4, 9);
    }
}

