/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.io;

import com.fasterxml.jackson.core.io.IOContext;
import java.io.IOException;
import java.io.InputStream;

public final class MergedStream
extends InputStream {
    byte[] _buffer;
    protected final IOContext _context;
    final int _end;
    final InputStream _in;
    int _ptr;

    public MergedStream(IOContext iOContext, InputStream inputStream, byte[] byArray, int n2, int n3) {
        this._context = iOContext;
        this._in = inputStream;
        this._buffer = byArray;
        this._ptr = n2;
        this._end = n3;
    }

    private void freeMergedBuffer() {
        byte[] byArray = this._buffer;
        if (byArray != null) {
            this._buffer = null;
            if (this._context != null) {
                this._context.releaseReadIOBuffer(byArray);
            }
        }
    }

    @Override
    public int available() throws IOException {
        if (this._buffer != null) {
            return this._end - this._ptr;
        }
        return this._in.available();
    }

    @Override
    public void close() throws IOException {
        this.freeMergedBuffer();
        this._in.close();
    }

    @Override
    public void mark(int n2) {
        if (this._buffer == null) {
            this._in.mark(n2);
        }
    }

    @Override
    public boolean markSupported() {
        return this._buffer == null && this._in.markSupported();
    }

    @Override
    public int read() throws IOException {
        if (this._buffer != null) {
            byte[] byArray = this._buffer;
            int n2 = this._ptr;
            this._ptr = n2 + 1;
            int n3 = 0xFF & byArray[n2];
            if (this._ptr >= this._end) {
                this.freeMergedBuffer();
            }
            return n3;
        }
        return this._in.read();
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        if (this._buffer != null) {
            int n4 = this._end - this._ptr;
            if (n3 > n4) {
                n3 = n4;
            }
            System.arraycopy(this._buffer, this._ptr, byArray, n2, n3);
            this._ptr = n3 + this._ptr;
            if (this._ptr >= this._end) {
                this.freeMergedBuffer();
            }
            return n3;
        }
        return this._in.read(byArray, n2, n3);
    }

    @Override
    public void reset() throws IOException {
        if (this._buffer == null) {
            this._in.reset();
        }
    }

    @Override
    public long skip(long l2) throws IOException {
        long l3 = 0L;
        if (this._buffer != null) {
            int n2 = this._end - this._ptr;
            if ((long)n2 > l2) {
                this._ptr += (int)l2;
                return l2;
            }
            this.freeMergedBuffer();
            l3 += (long)n2;
            l2 -= (long)n2;
        }
        if (l2 > 0L) {
            l3 += this._in.skip(l2);
        }
        return l3;
    }
}

