/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.io;

import com.fasterxml.jackson.core.io.CharTypes;
import com.fasterxml.jackson.core.util.ByteArrayBuilder;
import com.fasterxml.jackson.core.util.TextBuffer;
import java.lang.ref.SoftReference;

public final class JsonStringEncoder {
    private static final byte[] HEX_BYTES;
    private static final char[] HEX_CHARS;
    private static final int INT_0 = 48;
    private static final int INT_BACKSLASH = 92;
    private static final int INT_U = 117;
    private static final int SURR1_FIRST = 55296;
    private static final int SURR1_LAST = 56319;
    private static final int SURR2_FIRST = 56320;
    private static final int SURR2_LAST = 57343;
    protected static final ThreadLocal<SoftReference<JsonStringEncoder>> _threadEncoder;
    protected ByteArrayBuilder _byteBuilder;
    protected final char[] _quoteBuffer = new char[6];
    protected TextBuffer _textBuffer;

    static {
        HEX_CHARS = CharTypes.copyHexChars();
        HEX_BYTES = CharTypes.copyHexBytes();
        _threadEncoder = new ThreadLocal();
    }

    public JsonStringEncoder() {
        this._quoteBuffer[0] = 92;
        this._quoteBuffer[2] = 48;
        this._quoteBuffer[3] = 48;
    }

    /*
     * Enabled aggressive block sorting
     */
    private int _appendByteEscape(int n2, int n3, ByteArrayBuilder byteArrayBuilder, int n4) {
        byteArrayBuilder.setCurrentSegmentLength(n4);
        byteArrayBuilder.append(92);
        if (n3 >= 0) {
            byteArrayBuilder.append((byte)n3);
            return byteArrayBuilder.getCurrentSegmentLength();
        }
        byteArrayBuilder.append(117);
        if (n2 > 255) {
            int n5 = n2 >> 8;
            byteArrayBuilder.append(HEX_BYTES[n5 >> 4]);
            byteArrayBuilder.append(HEX_BYTES[n5 & 0xF]);
            n2 &= 0xFF;
        } else {
            byteArrayBuilder.append(48);
            byteArrayBuilder.append(48);
        }
        byteArrayBuilder.append(HEX_BYTES[n2 >> 4]);
        byteArrayBuilder.append(HEX_BYTES[n2 & 0xF]);
        return byteArrayBuilder.getCurrentSegmentLength();
    }

    private int _appendNamedEscape(int n2, char[] cArray) {
        cArray[1] = (char)n2;
        return 2;
    }

    private int _appendNumericEscape(int n2, char[] cArray) {
        cArray[1] = 117;
        cArray[4] = HEX_CHARS[n2 >> 4];
        cArray[5] = HEX_CHARS[n2 & 0xF];
        return 6;
    }

    private int _convertSurrogate(int n2, int n3) {
        if (n3 < 56320 || n3 > 57343) {
            throw new IllegalArgumentException("Broken surrogate pair: first char 0x" + Integer.toHexString(n2) + ", second 0x" + Integer.toHexString(n3) + "; illegal combination");
        }
        return 65536 + (n2 - 55296 << 10) + (n3 - 56320);
    }

    private void _throwIllegalSurrogate(int n2) {
        if (n2 > 0x10FFFF) {
            throw new IllegalArgumentException("Illegal character point (0x" + Integer.toHexString(n2) + ") to output; max is 0x10FFFF as per RFC 4627");
        }
        if (n2 >= 55296) {
            if (n2 <= 56319) {
                throw new IllegalArgumentException("Unmatched first part of surrogate pair (0x" + Integer.toHexString(n2) + ")");
            }
            throw new IllegalArgumentException("Unmatched second part of surrogate pair (0x" + Integer.toHexString(n2) + ")");
        }
        throw new IllegalArgumentException("Illegal character point (0x" + Integer.toHexString(n2) + ") to output");
    }

    /*
     * Enabled aggressive block sorting
     */
    public static JsonStringEncoder getInstance() {
        SoftReference<JsonStringEncoder> softReference = _threadEncoder.get();
        JsonStringEncoder jsonStringEncoder = softReference == null ? null : softReference.get();
        if (jsonStringEncoder == null) {
            jsonStringEncoder = new JsonStringEncoder();
            _threadEncoder.set(new SoftReference<JsonStringEncoder>(jsonStringEncoder));
        }
        return jsonStringEncoder;
    }

    /*
     * Enabled aggressive block sorting
     */
    public byte[] encodeAsUTF8(String string2) {
        ByteArrayBuilder byteArrayBuilder = this._byteBuilder;
        if (byteArrayBuilder == null) {
            this._byteBuilder = byteArrayBuilder = new ByteArrayBuilder(null);
        }
        int n2 = string2.length();
        int n3 = 0;
        byte[] byArray = byteArrayBuilder.resetAndGetFirstSegment();
        int n4 = byArray.length;
        int n5 = 0;
        while (n5 < n2) {
            int n6;
            int n7;
            int n8;
            int n9 = n5 + 1;
            int n10 = string2.charAt(n5);
            int n11 = n9;
            while (n10 <= 127) {
                if (n3 >= n4) {
                    byArray = byteArrayBuilder.finishCurrentSegment();
                    n4 = byArray.length;
                    n3 = 0;
                }
                int n12 = n3 + 1;
                byArray[n3] = (byte)n10;
                if (n11 >= n2) {
                    n3 = n12;
                    return this._byteBuilder.completeAndCoalesce(n3);
                }
                int n13 = n11 + 1;
                n10 = string2.charAt(n11);
                n3 = n12;
                n11 = n13;
            }
            if (n3 >= n4) {
                byArray = byteArrayBuilder.finishCurrentSegment();
                n4 = byArray.length;
                n8 = 0;
            } else {
                n8 = n3;
            }
            if (n10 < 2048) {
                n7 = n8 + 1;
                byArray[n8] = (byte)(0xC0 | n10 >> 6);
                n6 = n11;
            } else if (n10 < 55296 || n10 > 57343) {
                int n14 = n8 + 1;
                byArray[n8] = (byte)(0xE0 | n10 >> 12);
                if (n14 >= n4) {
                    byArray = byteArrayBuilder.finishCurrentSegment();
                    n4 = byArray.length;
                    n14 = 0;
                }
                int n15 = n14 + 1;
                byArray[n14] = (byte)(0x80 | 0x3F & n10 >> 6);
                n7 = n15;
                n6 = n11;
            } else {
                int n16;
                if (n10 > 56319) {
                    this._throwIllegalSurrogate(n10);
                }
                if (n11 >= n2) {
                    this._throwIllegalSurrogate(n10);
                }
                n6 = n11 + 1;
                if ((n10 = this._convertSurrogate(n10, string2.charAt(n11))) > 0x10FFFF) {
                    this._throwIllegalSurrogate(n10);
                }
                int n17 = n8 + 1;
                byArray[n8] = (byte)(0xF0 | n10 >> 18);
                if (n17 >= n4) {
                    byArray = byteArrayBuilder.finishCurrentSegment();
                    n4 = byArray.length;
                    n17 = 0;
                }
                int n18 = n17 + 1;
                byArray[n17] = (byte)(0x80 | 0x3F & n10 >> 12);
                if (n18 >= n4) {
                    byArray = byteArrayBuilder.finishCurrentSegment();
                    n4 = byArray.length;
                    n16 = 0;
                } else {
                    n16 = n18;
                }
                int n19 = n16 + 1;
                byArray[n16] = (byte)(0x80 | 0x3F & n10 >> 6);
                n7 = n19;
            }
            if (n7 >= n4) {
                byArray = byteArrayBuilder.finishCurrentSegment();
                n4 = byArray.length;
                n7 = 0;
            }
            int n20 = n7 + 1;
            byArray[n7] = (byte)(0x80 | n10 & 0x3F);
            n3 = n20;
            n5 = n6;
        }
        return this._byteBuilder.completeAndCoalesce(n3);
    }

    /*
     * Enabled aggressive block sorting
     */
    public char[] quoteAsString(String string2) {
        TextBuffer textBuffer = this._textBuffer;
        if (textBuffer == null) {
            this._textBuffer = textBuffer = new TextBuffer(null);
        }
        char[] cArray = textBuffer.emptyAndGetCurrentSegment();
        int[] nArray = CharTypes.get7BitOutputEscapes();
        int n2 = nArray.length;
        int n3 = 0;
        int n4 = string2.length();
        int n5 = 0;
        block0: while (n3 < n4) {
            int n6;
            block7: {
                int n7;
                while (true) {
                    char c2;
                    if ((c2 = string2.charAt(n3)) < n2 && nArray[c2] != 0) {
                        n6 = n3 + 1;
                        char c3 = string2.charAt(n3);
                        int n8 = nArray[c3];
                        n7 = n8 < 0 ? this._appendNumericEscape(c3, this._quoteBuffer) : this._appendNamedEscape(n8, this._quoteBuffer);
                        if (n5 + n7 <= cArray.length) break;
                        int n9 = cArray.length - n5;
                        if (n9 > 0) {
                            System.arraycopy(this._quoteBuffer, 0, cArray, n5, n9);
                        }
                        cArray = textBuffer.finishCurrentSegment();
                        int n10 = n7 - n9;
                        System.arraycopy(this._quoteBuffer, n9, cArray, 0, n10);
                        n5 = n10;
                        break block7;
                    }
                    if (n5 >= cArray.length) {
                        cArray = textBuffer.finishCurrentSegment();
                        n5 = 0;
                    }
                    int n11 = n5 + 1;
                    cArray[n5] = c2;
                    if (++n3 >= n4) {
                        n5 = n11;
                        break block0;
                    }
                    n5 = n11;
                }
                System.arraycopy(this._quoteBuffer, 0, cArray, n5, n7);
                n5 += n7;
            }
            n3 = n6;
        }
        textBuffer.setCurrentLength(n5);
        return textBuffer.contentsAsArray();
    }

    /*
     * Enabled aggressive block sorting
     */
    public byte[] quoteAsUTF8(String string2) {
        ByteArrayBuilder byteArrayBuilder = this._byteBuilder;
        if (byteArrayBuilder == null) {
            this._byteBuilder = byteArrayBuilder = new ByteArrayBuilder(null);
        }
        int n2 = 0;
        int n3 = string2.length();
        int n4 = 0;
        byte[] byArray = byteArrayBuilder.resetAndGetFirstSegment();
        block0: while (n2 < n3) {
            int n5;
            int n6;
            char c2;
            int n7;
            int[] nArray = CharTypes.get7BitOutputEscapes();
            while (true) {
                char c3;
                if ((c3 = string2.charAt(n2)) > '\u007f' || nArray[c3] != 0) {
                    if (n4 >= byArray.length) {
                        byArray = byteArrayBuilder.finishCurrentSegment();
                        n4 = 0;
                    }
                    n7 = n2 + 1;
                    c2 = string2.charAt(n2);
                    if (c2 > '\u007f') break;
                    n4 = this._appendByteEscape(c2, nArray[c2], byteArrayBuilder, n4);
                    byArray = byteArrayBuilder.getCurrentSegment();
                    n2 = n7;
                    continue block0;
                }
                if (n4 >= byArray.length) {
                    byArray = byteArrayBuilder.finishCurrentSegment();
                    n4 = 0;
                }
                int n8 = n4 + 1;
                byArray[n4] = (byte)c3;
                if (++n2 >= n3) {
                    n4 = n8;
                    return this._byteBuilder.completeAndCoalesce(n4);
                }
                n4 = n8;
            }
            if (c2 <= '\u07ff') {
                int n9 = n4 + 1;
                byArray[n4] = (byte)(0xC0 | c2 >> 6);
                n6 = 0x80 | c2 & 0x3F;
                n5 = n9;
                n2 = n7;
            } else if (c2 < '\ud800' || c2 > '\udfff') {
                int n10;
                int n11 = n4 + 1;
                byArray[n4] = (byte)(0xE0 | c2 >> 12);
                if (n11 >= byArray.length) {
                    byArray = byteArrayBuilder.finishCurrentSegment();
                    n10 = 0;
                } else {
                    n10 = n11;
                }
                int n12 = n10 + 1;
                byArray[n10] = (byte)(0x80 | 0x3F & c2 >> 6);
                n6 = 0x80 | c2 & 0x3F;
                n5 = n12;
                n2 = n7;
            } else {
                int n13;
                int n14;
                if (c2 > '\udbff') {
                    this._throwIllegalSurrogate(c2);
                }
                if (n7 >= n3) {
                    this._throwIllegalSurrogate(c2);
                }
                n2 = n7 + 1;
                int n15 = this._convertSurrogate(c2, string2.charAt(n7));
                if (n15 > 0x10FFFF) {
                    this._throwIllegalSurrogate(n15);
                }
                int n16 = n4 + 1;
                byArray[n4] = (byte)(0xF0 | n15 >> 18);
                if (n16 >= byArray.length) {
                    byArray = byteArrayBuilder.finishCurrentSegment();
                    n14 = 0;
                } else {
                    n14 = n16;
                }
                int n17 = n14 + 1;
                byArray[n14] = (byte)(0x80 | 0x3F & n15 >> 12);
                if (n17 >= byArray.length) {
                    byArray = byteArrayBuilder.finishCurrentSegment();
                    n13 = 0;
                } else {
                    n13 = n17;
                }
                int n18 = n13 + 1;
                byArray[n13] = (byte)(0x80 | 0x3F & n15 >> 6);
                n6 = 0x80 | n15 & 0x3F;
                n5 = n18;
            }
            if (n5 >= byArray.length) {
                byArray = byteArrayBuilder.finishCurrentSegment();
                n5 = 0;
            }
            int n19 = n5 + 1;
            byArray[n5] = (byte)n6;
            n4 = n19;
        }
        return this._byteBuilder.completeAndCoalesce(n4);
    }
}

