/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.io;

import java.util.Arrays;

public final class CharTypes {
    private static final byte[] HEX_BYTES;
    private static final char[] HEX_CHARS;
    static final int[] sHexValues;
    static final int[] sInputCodes;
    static final int[] sInputCodesComment;
    static final int[] sInputCodesJsNames;
    static final int[] sInputCodesUtf8;
    static final int[] sInputCodesUtf8JsNames;
    static final int[] sOutputEscapes128;

    /*
     * Enabled aggressive block sorting
     */
    static {
        HEX_CHARS = "0123456789ABCDEF".toCharArray();
        int n2 = HEX_CHARS.length;
        HEX_BYTES = new byte[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            CharTypes.HEX_BYTES[i2] = (byte)HEX_CHARS[i2];
        }
        int[] nArray = new int[256];
        for (int i3 = 0; i3 < 32; ++i3) {
            nArray[i3] = -1;
        }
        nArray[34] = 1;
        nArray[92] = 1;
        sInputCodes = nArray;
        int[] nArray2 = new int[sInputCodes.length];
        System.arraycopy(sInputCodes, 0, nArray2, 0, sInputCodes.length);
        for (int i4 = 128; i4 < 256; ++i4) {
            int n3 = (i4 & 0xE0) == 192 ? 2 : ((i4 & 0xF0) == 224 ? 3 : ((i4 & 0xF8) == 240 ? 4 : -1));
            nArray2[i4] = n3;
        }
        sInputCodesUtf8 = nArray2;
        int[] nArray3 = new int[256];
        Arrays.fill(nArray3, -1);
        for (int i5 = 33; i5 < 256; ++i5) {
            if (!Character.isJavaIdentifierPart((char)i5)) continue;
            nArray3[i5] = 0;
        }
        nArray3[64] = 0;
        nArray3[35] = 0;
        nArray3[42] = 0;
        nArray3[45] = 0;
        nArray3[43] = 0;
        sInputCodesJsNames = nArray3;
        int[] nArray4 = new int[256];
        System.arraycopy(sInputCodesJsNames, 0, nArray4, 0, sInputCodesJsNames.length);
        Arrays.fill(nArray4, 128, 128, 0);
        sInputCodesUtf8JsNames = nArray4;
        sInputCodesComment = new int[256];
        System.arraycopy(sInputCodesUtf8, 128, sInputCodesComment, 128, 128);
        Arrays.fill(sInputCodesComment, 0, 32, -1);
        CharTypes.sInputCodesComment[9] = 0;
        CharTypes.sInputCodesComment[10] = 10;
        CharTypes.sInputCodesComment[13] = 13;
        CharTypes.sInputCodesComment[42] = 42;
        int[] nArray5 = new int[128];
        for (int i6 = 0; i6 < 32; ++i6) {
            nArray5[i6] = -1;
        }
        nArray5[34] = 34;
        nArray5[92] = 92;
        nArray5[8] = 98;
        nArray5[9] = 116;
        nArray5[12] = 102;
        nArray5[10] = 110;
        nArray5[13] = 114;
        sOutputEscapes128 = nArray5;
        sHexValues = new int[128];
        Arrays.fill(sHexValues, -1);
        for (int i7 = 0; i7 < 10; ++i7) {
            CharTypes.sHexValues[i7 + 48] = i7;
        }
        int n4 = 0;
        while (n4 < 6) {
            CharTypes.sHexValues[n4 + 97] = n4 + 10;
            CharTypes.sHexValues[n4 + 65] = n4 + 10;
            ++n4;
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void appendQuoted(StringBuilder stringBuilder, String string2) {
        int[] nArray = sOutputEscapes128;
        int n2 = nArray.length;
        int n3 = 0;
        int n4 = string2.length();
        while (n3 < n4) {
            char c2 = string2.charAt(n3);
            if (c2 >= n2 || nArray[c2] == 0) {
                stringBuilder.append(c2);
            } else {
                stringBuilder.append('\\');
                int n5 = nArray[c2];
                if (n5 < 0) {
                    stringBuilder.append('u');
                    stringBuilder.append('0');
                    stringBuilder.append('0');
                    int n6 = -(n5 + 1);
                    stringBuilder.append(HEX_CHARS[n6 >> 4]);
                    stringBuilder.append(HEX_CHARS[n6 & 0xF]);
                } else {
                    stringBuilder.append((char)n5);
                }
            }
            ++n3;
        }
        return;
    }

    public static int charToHex(int n2) {
        if (n2 > 127) {
            return -1;
        }
        return sHexValues[n2];
    }

    public static byte[] copyHexBytes() {
        return (byte[])HEX_BYTES.clone();
    }

    public static char[] copyHexChars() {
        return (char[])HEX_CHARS.clone();
    }

    public static int[] get7BitOutputEscapes() {
        return sOutputEscapes128;
    }

    public static int[] getInputCodeComment() {
        return sInputCodesComment;
    }

    public static int[] getInputCodeLatin1() {
        return sInputCodes;
    }

    public static int[] getInputCodeLatin1JsNames() {
        return sInputCodesJsNames;
    }

    public static int[] getInputCodeUtf8() {
        return sInputCodesUtf8;
    }

    public static int[] getInputCodeUtf8JsNames() {
        return sInputCodesUtf8JsNames;
    }
}

