/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.io;

import com.fasterxml.jackson.core.io.IOContext;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

abstract class BaseReader
extends Reader {
    protected static final int LAST_VALID_UNICODE_CHAR = 0x10FFFF;
    protected static final char NULL_BYTE;
    protected static final char NULL_CHAR;
    protected byte[] _buffer;
    protected final IOContext _context;
    protected InputStream _in;
    protected int _length;
    protected int _ptr;
    protected char[] _tmpBuf = null;

    protected BaseReader(IOContext iOContext, InputStream inputStream, byte[] byArray, int n2, int n3) {
        this._context = iOContext;
        this._in = inputStream;
        this._buffer = byArray;
        this._ptr = n2;
        this._length = n3;
    }

    @Override
    public void close() throws IOException {
        InputStream inputStream = this._in;
        if (inputStream != null) {
            this._in = null;
            this.freeBuffers();
            inputStream.close();
        }
    }

    public final void freeBuffers() {
        byte[] byArray = this._buffer;
        if (byArray != null) {
            this._buffer = null;
            this._context.releaseReadIOBuffer(byArray);
        }
    }

    @Override
    public int read() throws IOException {
        if (this._tmpBuf == null) {
            this._tmpBuf = new char[1];
        }
        if (this.read(this._tmpBuf, 0, 1) < 1) {
            return -1;
        }
        return this._tmpBuf[0];
    }

    protected void reportBounds(char[] cArray, int n2, int n3) throws IOException {
        throw new ArrayIndexOutOfBoundsException("read(buf," + n2 + "," + n3 + "), cbuf[" + cArray.length + "]");
    }

    protected void reportStrangeStream() throws IOException {
        throw new IOException("Strange I/O stream, returned 0 bytes on read");
    }
}

