/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core;

import java.io.Serializable;

public class Version
implements Comparable<Version>,
Serializable {
    private static final Version UNKNOWN_VERSION = new Version(0, 0, 0, null, null, null);
    private static final long serialVersionUID = 1L;
    protected final String _artifactId;
    protected final String _groupId;
    protected final int _majorVersion;
    protected final int _minorVersion;
    protected final int _patchLevel;
    protected final String _snapshotInfo;

    @Deprecated
    public Version(int n2, int n3, int n4, String string2) {
        this(n2, n3, n4, string2, null, null);
    }

    public Version(int n2, int n3, int n4, String string2, String string3, String string4) {
        this._majorVersion = n2;
        this._minorVersion = n3;
        this._patchLevel = n4;
        this._snapshotInfo = string2;
        if (string3 == null) {
            string3 = "";
        }
        this._groupId = string3;
        if (string4 == null) {
            string4 = "";
        }
        this._artifactId = string4;
    }

    public static Version unknownVersion() {
        return UNKNOWN_VERSION;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int compareTo(Version version) {
        if (version == this) {
            return 0;
        }
        int n2 = this._groupId.compareTo(version._groupId);
        if (n2 != 0) return n2;
        n2 = this._artifactId.compareTo(version._artifactId);
        if (n2 != 0) return n2;
        n2 = this._majorVersion - version._majorVersion;
        if (n2 != 0) return n2;
        n2 = this._minorVersion - version._minorVersion;
        if (n2 != 0) return n2;
        return this._patchLevel - version._patchLevel;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean equals(Object object) {
        block6: {
            block5: {
                if (object == this) break block5;
                if (object == null) {
                    return false;
                }
                if (object.getClass() != this.getClass()) {
                    return false;
                }
                Version version = (Version)object;
                if (version._majorVersion != this._majorVersion || version._minorVersion != this._minorVersion || version._patchLevel != this._patchLevel || !version._artifactId.equals(this._artifactId) || !version._groupId.equals(this._groupId)) break block6;
            }
            return true;
        }
        return false;
    }

    public String getArtifactId() {
        return this._artifactId;
    }

    public String getGroupId() {
        return this._groupId;
    }

    public int getMajorVersion() {
        return this._majorVersion;
    }

    public int getMinorVersion() {
        return this._minorVersion;
    }

    public int getPatchLevel() {
        return this._patchLevel;
    }

    public int hashCode() {
        return this._artifactId.hashCode() ^ this._groupId.hashCode() + this._majorVersion - this._minorVersion + this._patchLevel;
    }

    public boolean isSnapshot() {
        return this._snapshotInfo != null && this._snapshotInfo.length() > 0;
    }

    public boolean isUknownVersion() {
        return this == UNKNOWN_VERSION;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this._majorVersion).append('.');
        stringBuilder.append(this._minorVersion).append('.');
        stringBuilder.append(this._patchLevel);
        if (this.isSnapshot()) {
            stringBuilder.append('-').append(this._snapshotInfo);
        }
        return stringBuilder.toString();
    }
}

