/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core;

import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.Base64Variants;
import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonStreamContext;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.Versioned;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Iterator;

public abstract class JsonParser
implements Closeable,
Versioned {
    private static final int MAX_BYTE_I = 255;
    private static final int MAX_SHORT_I = Short.MAX_VALUE;
    private static final int MIN_BYTE_I = -128;
    private static final int MIN_SHORT_I = Short.MIN_VALUE;
    protected int _features;

    protected JsonParser() {
    }

    protected JsonParser(int n2) {
        this._features = n2;
    }

    protected JsonParseException _constructError(String string2) {
        return new JsonParseException(string2, this.getCurrentLocation());
    }

    protected void _reportUnsupportedOperation() {
        throw new UnsupportedOperationException("Operation not supported by parser of type " + this.getClass().getName());
    }

    public boolean canUseSchema(FormatSchema formatSchema) {
        return false;
    }

    public abstract void clearCurrentToken();

    @Override
    public abstract void close() throws IOException;

    public JsonParser configure(Feature feature, boolean bl2) {
        if (bl2) {
            this.enable(feature);
            return this;
        }
        this.disable(feature);
        return this;
    }

    public JsonParser disable(Feature feature) {
        this._features &= 0xFFFFFFFF ^ feature.getMask();
        return this;
    }

    public JsonParser enable(Feature feature) {
        this._features |= feature.getMask();
        return this;
    }

    public abstract BigInteger getBigIntegerValue() throws IOException, JsonParseException;

    public byte[] getBinaryValue() throws IOException, JsonParseException {
        return this.getBinaryValue(Base64Variants.getDefaultVariant());
    }

    public abstract byte[] getBinaryValue(Base64Variant var1) throws IOException, JsonParseException;

    public boolean getBooleanValue() throws IOException, JsonParseException {
        JsonToken jsonToken = this.getCurrentToken();
        if (jsonToken == JsonToken.VALUE_TRUE) {
            return true;
        }
        if (jsonToken == JsonToken.VALUE_FALSE) {
            return false;
        }
        throw new JsonParseException("Current token (" + (Object)((Object)jsonToken) + ") not of boolean type", this.getCurrentLocation());
    }

    public byte getByteValue() throws IOException, JsonParseException {
        int n2 = this.getIntValue();
        if (n2 < -128 || n2 > 255) {
            throw this._constructError("Numeric value (" + this.getText() + ") out of range of Java byte");
        }
        return (byte)n2;
    }

    public abstract ObjectCodec getCodec();

    public abstract JsonLocation getCurrentLocation();

    public abstract String getCurrentName() throws IOException, JsonParseException;

    public abstract JsonToken getCurrentToken();

    public abstract BigDecimal getDecimalValue() throws IOException, JsonParseException;

    public abstract double getDoubleValue() throws IOException, JsonParseException;

    public abstract Object getEmbeddedObject() throws IOException, JsonParseException;

    public abstract float getFloatValue() throws IOException, JsonParseException;

    public Object getInputSource() {
        return null;
    }

    public abstract int getIntValue() throws IOException, JsonParseException;

    public abstract JsonToken getLastClearedToken();

    public abstract long getLongValue() throws IOException, JsonParseException;

    public abstract NumberType getNumberType() throws IOException, JsonParseException;

    public abstract Number getNumberValue() throws IOException, JsonParseException;

    public abstract JsonStreamContext getParsingContext();

    public FormatSchema getSchema() {
        return null;
    }

    public short getShortValue() throws IOException, JsonParseException {
        int n2 = this.getIntValue();
        if (n2 < Short.MIN_VALUE || n2 > Short.MAX_VALUE) {
            throw this._constructError("Numeric value (" + this.getText() + ") out of range of Java short");
        }
        return (short)n2;
    }

    public abstract String getText() throws IOException, JsonParseException;

    public abstract char[] getTextCharacters() throws IOException, JsonParseException;

    public abstract int getTextLength() throws IOException, JsonParseException;

    public abstract int getTextOffset() throws IOException, JsonParseException;

    public abstract JsonLocation getTokenLocation();

    public boolean getValueAsBoolean() throws IOException, JsonParseException {
        return this.getValueAsBoolean(false);
    }

    public boolean getValueAsBoolean(boolean bl2) throws IOException, JsonParseException {
        return bl2;
    }

    public double getValueAsDouble() throws IOException, JsonParseException {
        return this.getValueAsDouble(0.0);
    }

    public double getValueAsDouble(double d2) throws IOException, JsonParseException {
        return d2;
    }

    public int getValueAsInt() throws IOException, JsonParseException {
        return this.getValueAsInt(0);
    }

    public int getValueAsInt(int n2) throws IOException, JsonParseException {
        return n2;
    }

    public long getValueAsLong() throws IOException, JsonParseException {
        return this.getValueAsLong(0L);
    }

    public long getValueAsLong(long l2) throws IOException, JsonParseException {
        return l2;
    }

    public String getValueAsString() throws IOException, JsonParseException {
        return this.getValueAsString(null);
    }

    public abstract String getValueAsString(String var1) throws IOException, JsonParseException;

    public abstract boolean hasCurrentToken();

    public abstract boolean hasTextCharacters();

    public abstract boolean isClosed();

    public boolean isEnabled(Feature feature) {
        return (this._features & feature.getMask()) != 0;
    }

    public boolean isExpectedStartArrayToken() {
        return this.getCurrentToken() == JsonToken.START_ARRAY;
    }

    public Boolean nextBooleanValue() throws IOException, JsonParseException {
        switch (1.$SwitchMap$com$fasterxml$jackson$core$JsonToken[this.nextToken().ordinal()]) {
            default: {
                return null;
            }
            case 1: {
                return Boolean.TRUE;
            }
            case 2: 
        }
        return Boolean.FALSE;
    }

    public boolean nextFieldName(SerializableString serializableString) throws IOException, JsonParseException {
        return this.nextToken() == JsonToken.FIELD_NAME && serializableString.getValue().equals(this.getCurrentName());
    }

    public int nextIntValue(int n2) throws IOException, JsonParseException {
        if (this.nextToken() == JsonToken.VALUE_NUMBER_INT) {
            n2 = this.getIntValue();
        }
        return n2;
    }

    public long nextLongValue(long l2) throws IOException, JsonParseException {
        if (this.nextToken() == JsonToken.VALUE_NUMBER_INT) {
            l2 = this.getLongValue();
        }
        return l2;
    }

    public String nextTextValue() throws IOException, JsonParseException {
        if (this.nextToken() == JsonToken.VALUE_STRING) {
            return this.getText();
        }
        return null;
    }

    public abstract JsonToken nextToken() throws IOException, JsonParseException;

    public abstract JsonToken nextValue() throws IOException, JsonParseException;

    public abstract void overrideCurrentName(String var1);

    public int readBinaryValue(Base64Variant base64Variant, OutputStream outputStream) throws IOException, JsonParseException {
        this._reportUnsupportedOperation();
        return 0;
    }

    public int readBinaryValue(OutputStream outputStream) throws IOException, JsonParseException {
        return this.readBinaryValue(Base64Variants.getDefaultVariant(), outputStream);
    }

    public <T> T readValueAs(TypeReference<?> typeReference) throws IOException, JsonProcessingException {
        ObjectCodec objectCodec = this.getCodec();
        if (objectCodec == null) {
            throw new IllegalStateException("No ObjectCodec defined for the parser, can not deserialize JSON into Java objects");
        }
        return objectCodec.readValue(this, typeReference);
    }

    public <T> T readValueAs(Class<T> clazz) throws IOException, JsonProcessingException {
        ObjectCodec objectCodec = this.getCodec();
        if (objectCodec == null) {
            throw new IllegalStateException("No ObjectCodec defined for the parser, can not deserialize JSON into Java objects");
        }
        return objectCodec.readValue(this, clazz);
    }

    public <T extends TreeNode> T readValueAsTree() throws IOException, JsonProcessingException {
        ObjectCodec objectCodec = this.getCodec();
        if (objectCodec == null) {
            throw new IllegalStateException("No ObjectCodec defined for the parser, can not deserialize JSON into JsonNode tree");
        }
        return objectCodec.readTree(this);
    }

    public <T> Iterator<T> readValuesAs(TypeReference<?> typeReference) throws IOException, JsonProcessingException {
        ObjectCodec objectCodec = this.getCodec();
        if (objectCodec == null) {
            throw new IllegalStateException("No ObjectCodec defined for the parser, can not deserialize JSON into Java objects");
        }
        return objectCodec.readValues(this, typeReference);
    }

    public <T> Iterator<T> readValuesAs(Class<T> clazz) throws IOException, JsonProcessingException {
        ObjectCodec objectCodec = this.getCodec();
        if (objectCodec == null) {
            throw new IllegalStateException("No ObjectCodec defined for the parser, can not deserialize JSON into Java objects");
        }
        return objectCodec.readValues(this, clazz);
    }

    public int releaseBuffered(OutputStream outputStream) throws IOException {
        return -1;
    }

    public int releaseBuffered(Writer writer) throws IOException {
        return -1;
    }

    public boolean requiresCustomCodec() {
        return false;
    }

    public abstract void setCodec(ObjectCodec var1);

    public void setSchema(FormatSchema formatSchema) {
        throw new UnsupportedOperationException("Parser of type " + this.getClass().getName() + " does not support schema of type '" + formatSchema.getSchemaType() + "'");
    }

    public abstract JsonParser skipChildren() throws IOException, JsonParseException;

    @Override
    public abstract Version version();

    public static final class Feature
    extends Enum<Feature> {
        private static final /* synthetic */ Feature[] $VALUES;
        public static final /* enum */ Feature ALLOW_BACKSLASH_ESCAPING_ANY_CHARACTER;
        public static final /* enum */ Feature ALLOW_COMMENTS;
        public static final /* enum */ Feature ALLOW_NON_NUMERIC_NUMBERS;
        public static final /* enum */ Feature ALLOW_NUMERIC_LEADING_ZEROS;
        public static final /* enum */ Feature ALLOW_SINGLE_QUOTES;
        public static final /* enum */ Feature ALLOW_UNQUOTED_CONTROL_CHARS;
        public static final /* enum */ Feature ALLOW_UNQUOTED_FIELD_NAMES;
        public static final /* enum */ Feature AUTO_CLOSE_SOURCE;
        private final boolean _defaultState;

        static {
            AUTO_CLOSE_SOURCE = new Feature(true);
            ALLOW_COMMENTS = new Feature(false);
            ALLOW_UNQUOTED_FIELD_NAMES = new Feature(false);
            ALLOW_SINGLE_QUOTES = new Feature(false);
            ALLOW_UNQUOTED_CONTROL_CHARS = new Feature(false);
            ALLOW_BACKSLASH_ESCAPING_ANY_CHARACTER = new Feature(false);
            ALLOW_NUMERIC_LEADING_ZEROS = new Feature(false);
            ALLOW_NON_NUMERIC_NUMBERS = new Feature(false);
            Feature[] featureArray = new Feature[]{AUTO_CLOSE_SOURCE, ALLOW_COMMENTS, ALLOW_UNQUOTED_FIELD_NAMES, ALLOW_SINGLE_QUOTES, ALLOW_UNQUOTED_CONTROL_CHARS, ALLOW_BACKSLASH_ESCAPING_ANY_CHARACTER, ALLOW_NUMERIC_LEADING_ZEROS, ALLOW_NON_NUMERIC_NUMBERS};
            $VALUES = featureArray;
        }

        private Feature(boolean bl2) {
            this._defaultState = bl2;
        }

        public static int collectDefaults() {
            int n2 = 0;
            for (Feature feature : Feature.values()) {
                if (!feature.enabledByDefault()) continue;
                n2 |= feature.getMask();
            }
            return n2;
        }

        public static Feature valueOf(String string2) {
            return Enum.valueOf(Feature.class, string2);
        }

        public static Feature[] values() {
            return (Feature[])$VALUES.clone();
        }

        public boolean enabledByDefault() {
            return this._defaultState;
        }

        public int getMask() {
            return 1 << this.ordinal();
        }
    }

    public static final class NumberType
    extends Enum<NumberType> {
        private static final /* synthetic */ NumberType[] $VALUES;
        public static final /* enum */ NumberType BIG_DECIMAL;
        public static final /* enum */ NumberType BIG_INTEGER;
        public static final /* enum */ NumberType DOUBLE;
        public static final /* enum */ NumberType FLOAT;
        public static final /* enum */ NumberType INT;
        public static final /* enum */ NumberType LONG;

        static {
            INT = new NumberType();
            LONG = new NumberType();
            BIG_INTEGER = new NumberType();
            FLOAT = new NumberType();
            DOUBLE = new NumberType();
            BIG_DECIMAL = new NumberType();
            NumberType[] numberTypeArray = new NumberType[]{INT, LONG, BIG_INTEGER, FLOAT, DOUBLE, BIG_DECIMAL};
            $VALUES = numberTypeArray;
        }

        public static NumberType valueOf(String string2) {
            return Enum.valueOf(NumberType.class, string2);
        }

        public static NumberType[] values() {
            return (NumberType[])$VALUES.clone();
        }
    }
}

