/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core;

import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.Base64Variants;
import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonStreamContext;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.Versioned;
import com.fasterxml.jackson.core.io.CharacterEscapes;
import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;

public abstract class JsonGenerator
implements Closeable,
Flushable,
Versioned {
    protected PrettyPrinter _cfgPrettyPrinter;

    protected JsonGenerator() {
    }

    public boolean canUseSchema(FormatSchema formatSchema) {
        return false;
    }

    @Override
    public abstract void close() throws IOException;

    public final JsonGenerator configure(Feature feature, boolean bl2) {
        if (bl2) {
            this.enable(feature);
            return this;
        }
        this.disable(feature);
        return this;
    }

    public abstract void copyCurrentEvent(JsonParser var1) throws IOException, JsonProcessingException;

    public abstract void copyCurrentStructure(JsonParser var1) throws IOException, JsonProcessingException;

    public abstract JsonGenerator disable(Feature var1);

    public abstract JsonGenerator enable(Feature var1);

    @Override
    public abstract void flush() throws IOException;

    public CharacterEscapes getCharacterEscapes() {
        return null;
    }

    public abstract ObjectCodec getCodec();

    public int getHighestEscapedChar() {
        return 0;
    }

    public abstract JsonStreamContext getOutputContext();

    public Object getOutputTarget() {
        return null;
    }

    public PrettyPrinter getPrettyPrinter() {
        return this._cfgPrettyPrinter;
    }

    public FormatSchema getSchema() {
        return null;
    }

    public abstract boolean isClosed();

    public abstract boolean isEnabled(Feature var1);

    public JsonGenerator setCharacterEscapes(CharacterEscapes characterEscapes) {
        return this;
    }

    public abstract JsonGenerator setCodec(ObjectCodec var1);

    public JsonGenerator setHighestNonEscapedChar(int n2) {
        return this;
    }

    public JsonGenerator setPrettyPrinter(PrettyPrinter prettyPrinter) {
        this._cfgPrettyPrinter = prettyPrinter;
        return this;
    }

    public JsonGenerator setRootValueSeparator(SerializableString serializableString) {
        throw new UnsupportedOperationException();
    }

    public void setSchema(FormatSchema formatSchema) {
        throw new UnsupportedOperationException("Generator of type " + this.getClass().getName() + " does not support schema of type '" + formatSchema.getSchemaType() + "'");
    }

    public abstract JsonGenerator useDefaultPrettyPrinter();

    @Override
    public abstract Version version();

    public final void writeArrayFieldStart(String string2) throws IOException, JsonGenerationException {
        this.writeFieldName(string2);
        this.writeStartArray();
    }

    public abstract int writeBinary(Base64Variant var1, InputStream var2, int var3) throws IOException, JsonGenerationException;

    public int writeBinary(InputStream inputStream, int n2) throws IOException, JsonGenerationException {
        return this.writeBinary(Base64Variants.getDefaultVariant(), inputStream, n2);
    }

    public abstract void writeBinary(Base64Variant var1, byte[] var2, int var3, int var4) throws IOException, JsonGenerationException;

    public void writeBinary(byte[] byArray) throws IOException, JsonGenerationException {
        this.writeBinary(Base64Variants.getDefaultVariant(), byArray, 0, byArray.length);
    }

    public void writeBinary(byte[] byArray, int n2, int n3) throws IOException, JsonGenerationException {
        this.writeBinary(Base64Variants.getDefaultVariant(), byArray, n2, n3);
    }

    public final void writeBinaryField(String string2, byte[] byArray) throws IOException, JsonGenerationException {
        this.writeFieldName(string2);
        this.writeBinary(byArray);
    }

    public abstract void writeBoolean(boolean var1) throws IOException, JsonGenerationException;

    public final void writeBooleanField(String string2, boolean bl2) throws IOException, JsonGenerationException {
        this.writeFieldName(string2);
        this.writeBoolean(bl2);
    }

    public abstract void writeEndArray() throws IOException, JsonGenerationException;

    public abstract void writeEndObject() throws IOException, JsonGenerationException;

    public abstract void writeFieldName(SerializableString var1) throws IOException, JsonGenerationException;

    public abstract void writeFieldName(String var1) throws IOException, JsonGenerationException;

    public abstract void writeNull() throws IOException, JsonGenerationException;

    public final void writeNullField(String string2) throws IOException, JsonGenerationException {
        this.writeFieldName(string2);
        this.writeNull();
    }

    public abstract void writeNumber(double var1) throws IOException, JsonGenerationException;

    public abstract void writeNumber(float var1) throws IOException, JsonGenerationException;

    public abstract void writeNumber(int var1) throws IOException, JsonGenerationException;

    public abstract void writeNumber(long var1) throws IOException, JsonGenerationException;

    public abstract void writeNumber(String var1) throws IOException, JsonGenerationException, UnsupportedOperationException;

    public abstract void writeNumber(BigDecimal var1) throws IOException, JsonGenerationException;

    public abstract void writeNumber(BigInteger var1) throws IOException, JsonGenerationException;

    public final void writeNumberField(String string2, double d2) throws IOException, JsonGenerationException {
        this.writeFieldName(string2);
        this.writeNumber(d2);
    }

    public final void writeNumberField(String string2, float f2) throws IOException, JsonGenerationException {
        this.writeFieldName(string2);
        this.writeNumber(f2);
    }

    public final void writeNumberField(String string2, int n2) throws IOException, JsonGenerationException {
        this.writeFieldName(string2);
        this.writeNumber(n2);
    }

    public final void writeNumberField(String string2, long l2) throws IOException, JsonGenerationException {
        this.writeFieldName(string2);
        this.writeNumber(l2);
    }

    public final void writeNumberField(String string2, BigDecimal bigDecimal) throws IOException, JsonGenerationException {
        this.writeFieldName(string2);
        this.writeNumber(bigDecimal);
    }

    public abstract void writeObject(Object var1) throws IOException, JsonProcessingException;

    public final void writeObjectField(String string2, Object object) throws IOException, JsonProcessingException {
        this.writeFieldName(string2);
        this.writeObject(object);
    }

    public final void writeObjectFieldStart(String string2) throws IOException, JsonGenerationException {
        this.writeFieldName(string2);
        this.writeStartObject();
    }

    public abstract void writeRaw(char var1) throws IOException, JsonGenerationException;

    public void writeRaw(SerializableString serializableString) throws IOException, JsonGenerationException {
        this.writeRaw(serializableString.getValue());
    }

    public abstract void writeRaw(String var1) throws IOException, JsonGenerationException;

    public abstract void writeRaw(String var1, int var2, int var3) throws IOException, JsonGenerationException;

    public abstract void writeRaw(char[] var1, int var2, int var3) throws IOException, JsonGenerationException;

    public abstract void writeRawUTF8String(byte[] var1, int var2, int var3) throws IOException, JsonGenerationException;

    public abstract void writeRawValue(String var1) throws IOException, JsonGenerationException;

    public abstract void writeRawValue(String var1, int var2, int var3) throws IOException, JsonGenerationException;

    public abstract void writeRawValue(char[] var1, int var2, int var3) throws IOException, JsonGenerationException;

    public abstract void writeStartArray() throws IOException, JsonGenerationException;

    public abstract void writeStartObject() throws IOException, JsonGenerationException;

    public abstract void writeString(SerializableString var1) throws IOException, JsonGenerationException;

    public abstract void writeString(String var1) throws IOException, JsonGenerationException;

    public abstract void writeString(char[] var1, int var2, int var3) throws IOException, JsonGenerationException;

    public void writeStringField(String string2, String string3) throws IOException, JsonGenerationException {
        this.writeFieldName(string2);
        this.writeString(string3);
    }

    public abstract void writeTree(TreeNode var1) throws IOException, JsonProcessingException;

    public abstract void writeUTF8String(byte[] var1, int var2, int var3) throws IOException, JsonGenerationException;

    public static final class Feature
    extends Enum<Feature> {
        private static final /* synthetic */ Feature[] $VALUES;
        public static final /* enum */ Feature AUTO_CLOSE_JSON_CONTENT;
        public static final /* enum */ Feature AUTO_CLOSE_TARGET;
        public static final /* enum */ Feature ESCAPE_NON_ASCII;
        public static final /* enum */ Feature FLUSH_PASSED_TO_STREAM;
        public static final /* enum */ Feature QUOTE_FIELD_NAMES;
        public static final /* enum */ Feature QUOTE_NON_NUMERIC_NUMBERS;
        public static final /* enum */ Feature WRITE_NUMBERS_AS_STRINGS;
        private final boolean _defaultState;
        private final int _mask = 1 << this.ordinal();

        static {
            AUTO_CLOSE_TARGET = new Feature(true);
            AUTO_CLOSE_JSON_CONTENT = new Feature(true);
            QUOTE_FIELD_NAMES = new Feature(true);
            QUOTE_NON_NUMERIC_NUMBERS = new Feature(true);
            WRITE_NUMBERS_AS_STRINGS = new Feature(false);
            FLUSH_PASSED_TO_STREAM = new Feature(true);
            ESCAPE_NON_ASCII = new Feature(false);
            Feature[] featureArray = new Feature[]{AUTO_CLOSE_TARGET, AUTO_CLOSE_JSON_CONTENT, QUOTE_FIELD_NAMES, QUOTE_NON_NUMERIC_NUMBERS, WRITE_NUMBERS_AS_STRINGS, FLUSH_PASSED_TO_STREAM, ESCAPE_NON_ASCII};
            $VALUES = featureArray;
        }

        private Feature(boolean bl2) {
            this._defaultState = bl2;
        }

        public static int collectDefaults() {
            int n2 = 0;
            for (Feature feature : Feature.values()) {
                if (!feature.enabledByDefault()) continue;
                n2 |= feature.getMask();
            }
            return n2;
        }

        public static Feature valueOf(String string2) {
            return Enum.valueOf(Feature.class, string2);
        }

        public static Feature[] values() {
            return (Feature[])$VALUES.clone();
        }

        public boolean enabledByDefault() {
            return this._defaultState;
        }

        public int getMask() {
            return this._mask;
        }
    }
}

