/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core;

import com.fasterxml.jackson.core.Base64Variant;

public final class Base64Variants {
    public static final Base64Variant MIME = new Base64Variant("MIME", "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/", true, '=', 76);
    public static final Base64Variant MIME_NO_LINEFEEDS = new Base64Variant(MIME, "MIME-NO-LINEFEEDS", Integer.MAX_VALUE);
    public static final Base64Variant MODIFIED_FOR_URL;
    public static final Base64Variant PEM;
    static final String STD_BASE64_ALPHABET = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";

    static {
        PEM = new Base64Variant(MIME, "PEM", true, '=', 64);
        StringBuffer stringBuffer = new StringBuffer(STD_BASE64_ALPHABET);
        stringBuffer.setCharAt(stringBuffer.indexOf("+"), '-');
        stringBuffer.setCharAt(stringBuffer.indexOf("/"), '_');
        MODIFIED_FOR_URL = new Base64Variant("MODIFIED-FOR-URL", stringBuffer.toString(), false, '\u0000', Integer.MAX_VALUE);
    }

    public static Base64Variant getDefaultVariant() {
        return MIME_NO_LINEFEEDS;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Base64Variant valueOf(String string2) throws IllegalArgumentException {
        String string3;
        if (Base64Variants.MIME._name.equals(string2)) {
            return MIME;
        }
        if (Base64Variants.MIME_NO_LINEFEEDS._name.equals(string2)) {
            return MIME_NO_LINEFEEDS;
        }
        if (Base64Variants.PEM._name.equals(string2)) {
            return PEM;
        }
        if (Base64Variants.MODIFIED_FOR_URL._name.equals(string2)) {
            return MODIFIED_FOR_URL;
        }
        if (string2 == null) {
            string3 = "<null>";
            throw new IllegalArgumentException("No Base64Variant with name " + string3);
        }
        string3 = "'" + string2 + "'";
        throw new IllegalArgumentException("No Base64Variant with name " + string3);
    }
}

