/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core;

import com.fasterxml.jackson.core.Base64Variants;
import java.io.Serializable;
import java.util.Arrays;

public final class Base64Variant
implements Serializable {
    public static final int BASE64_VALUE_INVALID = -1;
    public static final int BASE64_VALUE_PADDING = -2;
    static final char PADDING_CHAR_NONE = '\u0000';
    private static final long serialVersionUID = 1L;
    private final transient int[] _asciiToBase64 = new int[128];
    private final transient byte[] _base64ToAsciiB;
    private final transient char[] _base64ToAsciiC = new char[64];
    protected final transient int _maxLineLength;
    protected final String _name;
    protected final transient char _paddingChar;
    protected final transient boolean _usesPadding;

    public Base64Variant(Base64Variant base64Variant, String string2, int n2) {
        this(base64Variant, string2, base64Variant._usesPadding, base64Variant._paddingChar, n2);
    }

    public Base64Variant(Base64Variant base64Variant, String string2, boolean bl2, char c2, int n2) {
        this._base64ToAsciiB = new byte[64];
        this._name = string2;
        byte[] byArray = base64Variant._base64ToAsciiB;
        System.arraycopy(byArray, 0, this._base64ToAsciiB, 0, byArray.length);
        char[] cArray = base64Variant._base64ToAsciiC;
        System.arraycopy(cArray, 0, this._base64ToAsciiC, 0, cArray.length);
        int[] nArray = base64Variant._asciiToBase64;
        System.arraycopy(nArray, 0, this._asciiToBase64, 0, nArray.length);
        this._usesPadding = bl2;
        this._paddingChar = c2;
        this._maxLineLength = n2;
    }

    public Base64Variant(String string2, String string3, boolean bl2, char c2, int n2) {
        this._base64ToAsciiB = new byte[64];
        this._name = string2;
        this._usesPadding = bl2;
        this._paddingChar = c2;
        this._maxLineLength = n2;
        int n3 = string3.length();
        if (n3 != 64) {
            throw new IllegalArgumentException("Base64Alphabet length must be exactly 64 (was " + n3 + ")");
        }
        string3.getChars(0, n3, this._base64ToAsciiC, 0);
        Arrays.fill(this._asciiToBase64, -1);
        int n4 = 0;
        while (n4 < n3) {
            char c3 = this._base64ToAsciiC[n4];
            this._base64ToAsciiB[n4] = (byte)c3;
            this._asciiToBase64[c3] = n4++;
        }
        if (bl2) {
            this._asciiToBase64[c2] = -2;
        }
    }

    public int decodeBase64Byte(byte by2) {
        if (by2 <= 127) {
            return this._asciiToBase64[by2];
        }
        return -1;
    }

    public int decodeBase64Char(char c2) {
        if (c2 <= '\u007f') {
            return this._asciiToBase64[c2];
        }
        return -1;
    }

    public int decodeBase64Char(int n2) {
        if (n2 <= 127) {
            return this._asciiToBase64[n2];
        }
        return -1;
    }

    public String encode(byte[] byArray) {
        return this.encode(byArray, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    public String encode(byte[] byArray, boolean bl2) {
        int n2 = byArray.length;
        StringBuilder stringBuilder = new StringBuilder(n2 + (n2 >> 2) + (n2 >> 3));
        if (bl2) {
            stringBuilder.append('\"');
        }
        int n3 = this.getMaxLineLength() >> 2;
        int n4 = n2 - 3;
        int n5 = 0;
        while (n5 <= n4) {
            int n6 = n5 + 1;
            int n7 = byArray[n5] << 8;
            int n8 = n6 + 1;
            int n9 = (n7 | 0xFF & byArray[n6]) << 8;
            int n10 = n8 + 1;
            this.encodeBase64Chunk(stringBuilder, n9 | 0xFF & byArray[n8]);
            if (--n3 <= 0) {
                stringBuilder.append('\\');
                stringBuilder.append('n');
                n3 = this.getMaxLineLength() >> 2;
            }
            n5 = n10;
        }
        int n11 = n2 - n5;
        if (n11 > 0) {
            int n12 = n5 + 1;
            int n13 = byArray[n5] << 16;
            if (n11 == 2) {
                int cfr_ignored_0 = n12 + 1;
                n13 |= (0xFF & byArray[n12]) << 8;
            }
            this.encodeBase64Partial(stringBuilder, n13, n11);
        }
        if (bl2) {
            stringBuilder.append('\"');
        }
        return stringBuilder.toString();
    }

    public byte encodeBase64BitsAsByte(int n2) {
        return this._base64ToAsciiB[n2];
    }

    public char encodeBase64BitsAsChar(int n2) {
        return this._base64ToAsciiC[n2];
    }

    public int encodeBase64Chunk(int n2, byte[] byArray, int n3) {
        int n4 = n3 + 1;
        byArray[n3] = this._base64ToAsciiB[0x3F & n2 >> 18];
        int n5 = n4 + 1;
        byArray[n4] = this._base64ToAsciiB[0x3F & n2 >> 12];
        int n6 = n5 + 1;
        byArray[n5] = this._base64ToAsciiB[0x3F & n2 >> 6];
        int n7 = n6 + 1;
        byArray[n6] = this._base64ToAsciiB[n2 & 0x3F];
        return n7;
    }

    public int encodeBase64Chunk(int n2, char[] cArray, int n3) {
        int n4 = n3 + 1;
        cArray[n3] = this._base64ToAsciiC[0x3F & n2 >> 18];
        int n5 = n4 + 1;
        cArray[n4] = this._base64ToAsciiC[0x3F & n2 >> 12];
        int n6 = n5 + 1;
        cArray[n5] = this._base64ToAsciiC[0x3F & n2 >> 6];
        int n7 = n6 + 1;
        cArray[n6] = this._base64ToAsciiC[n2 & 0x3F];
        return n7;
    }

    public void encodeBase64Chunk(StringBuilder stringBuilder, int n2) {
        stringBuilder.append(this._base64ToAsciiC[0x3F & n2 >> 18]);
        stringBuilder.append(this._base64ToAsciiC[0x3F & n2 >> 12]);
        stringBuilder.append(this._base64ToAsciiC[0x3F & n2 >> 6]);
        stringBuilder.append(this._base64ToAsciiC[n2 & 0x3F]);
    }

    /*
     * Enabled aggressive block sorting
     */
    public int encodeBase64Partial(int n2, int n3, byte[] byArray, int n4) {
        int n5 = n4 + 1;
        byArray[n4] = this._base64ToAsciiB[0x3F & n2 >> 18];
        int n6 = n5 + 1;
        byArray[n5] = this._base64ToAsciiB[0x3F & n2 >> 12];
        if (this._usesPadding) {
            byte by2 = (byte)this._paddingChar;
            int n7 = n6 + 1;
            byte by3 = n3 == 2 ? this._base64ToAsciiB[0x3F & n2 >> 6] : by2;
            byArray[n6] = by3;
            n6 = n7 + 1;
            byArray[n7] = by2;
            return n6;
        } else {
            if (n3 != 2) return n6;
            int n8 = n6 + 1;
            byArray[n6] = this._base64ToAsciiB[0x3F & n2 >> 6];
            return n8;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public int encodeBase64Partial(int n2, int n3, char[] cArray, int n4) {
        int n5 = n4 + 1;
        cArray[n4] = this._base64ToAsciiC[0x3F & n2 >> 18];
        int n6 = n5 + 1;
        cArray[n5] = this._base64ToAsciiC[0x3F & n2 >> 12];
        if (this._usesPadding) {
            int n7 = n6 + 1;
            char c2 = n3 == 2 ? this._base64ToAsciiC[0x3F & n2 >> 6] : this._paddingChar;
            cArray[n6] = c2;
            n6 = n7 + 1;
            cArray[n7] = this._paddingChar;
            return n6;
        } else {
            if (n3 != 2) return n6;
            int n8 = n6 + 1;
            cArray[n6] = this._base64ToAsciiC[0x3F & n2 >> 6];
            return n8;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void encodeBase64Partial(StringBuilder stringBuilder, int n2, int n3) {
        stringBuilder.append(this._base64ToAsciiC[0x3F & n2 >> 18]);
        stringBuilder.append(this._base64ToAsciiC[0x3F & n2 >> 12]);
        if (this._usesPadding) {
            char c2 = n3 == 2 ? this._base64ToAsciiC[0x3F & n2 >> 6] : this._paddingChar;
            stringBuilder.append(c2);
            stringBuilder.append(this._paddingChar);
            return;
        } else {
            if (n3 != 2) return;
            stringBuilder.append(this._base64ToAsciiC[0x3F & n2 >> 6]);
            return;
        }
    }

    public int getMaxLineLength() {
        return this._maxLineLength;
    }

    public String getName() {
        return this._name;
    }

    public byte getPaddingByte() {
        return (byte)this._paddingChar;
    }

    public char getPaddingChar() {
        return this._paddingChar;
    }

    protected Object readResolve() {
        return Base64Variants.valueOf(this._name);
    }

    public String toString() {
        return this._name;
    }

    public boolean usesPadding() {
        return this._usesPadding;
    }

    public boolean usesPaddingChar(char c2) {
        return c2 == this._paddingChar;
    }

    public boolean usesPaddingChar(int n2) {
        return n2 == this._paddingChar;
    }
}

