/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.widget;

import android.annotation.SuppressLint;
import android.app.Dialog;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.net.http.SslError;
import android.os.Bundle;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.webkit.SslErrorHandler;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import com.facebook.FacebookDialogException;
import com.facebook.FacebookException;
import com.facebook.FacebookOperationCanceledException;
import com.facebook.FacebookRequestError;
import com.facebook.FacebookServiceException;
import com.facebook.Session;
import com.facebook.android.R;
import com.facebook.android.Util;
import com.facebook.internal.ServerProtocol;
import com.facebook.internal.Utility;
import com.facebook.internal.Validate;

public class WebDialog
extends Dialog {
    private static final int BACKGROUND_GRAY = -872415232;
    static final String CANCEL_URI = "fbconnect://cancel";
    public static final int DEFAULT_THEME = 0x1030010;
    static final boolean DISABLE_SSL_CHECK_FOR_TESTING = false;
    private static final String DISPLAY_TOUCH = "touch";
    private static final String LOG_TAG = "FacebookSDK.WebDialog";
    private static final int MAX_PADDING_SCREEN_HEIGHT = 1280;
    private static final int MAX_PADDING_SCREEN_WIDTH = 800;
    private static final double MIN_SCALE_FACTOR = 0.5;
    private static final int NO_PADDING_SCREEN_HEIGHT = 800;
    private static final int NO_PADDING_SCREEN_WIDTH = 480;
    static final String REDIRECT_URI = "fbconnect://success";
    private static final String USER_AGENT = "user_agent";
    private FrameLayout contentFrameLayout;
    private ImageView crossImageView;
    private boolean isDetached = false;
    private boolean listenerCalled = false;
    private OnCompleteListener onCompleteListener;
    private ProgressDialog spinner;
    private String url;
    private WebView webView;

    public WebDialog(Context context, String string2) {
        this(context, string2, 0x1030010);
    }

    public WebDialog(Context context, String string2, int n2) {
        super(context, n2);
        this.url = string2;
    }

    public WebDialog(Context context, String string2, Bundle bundle, int n2, OnCompleteListener onCompleteListener) {
        super(context, n2);
        if (bundle == null) {
            bundle = new Bundle();
        }
        bundle.putString("display", DISPLAY_TOUCH);
        bundle.putString("type", USER_AGENT);
        this.url = Utility.buildUri(ServerProtocol.getDialogAuthority(), "dialog/" + string2, bundle).toString();
        this.onCompleteListener = onCompleteListener;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void calculateSize() {
        Display display = ((WindowManager)this.getContext().getSystemService("window")).getDefaultDisplay();
        DisplayMetrics displayMetrics = new DisplayMetrics();
        display.getMetrics(displayMetrics);
        int n2 = displayMetrics.widthPixels < displayMetrics.heightPixels ? displayMetrics.widthPixels : displayMetrics.heightPixels;
        int n3 = displayMetrics.widthPixels < displayMetrics.heightPixels ? displayMetrics.heightPixels : displayMetrics.widthPixels;
        int n4 = Math.min(this.getScaledSize(n2, displayMetrics.density, 480, 800), displayMetrics.widthPixels);
        int n5 = Math.min(this.getScaledSize(n3, displayMetrics.density, 800, 1280), displayMetrics.heightPixels);
        this.getWindow().setLayout(n4, n5);
    }

    private void createCrossImage() {
        this.crossImageView = new ImageView(this.getContext());
        this.crossImageView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                WebDialog.this.sendCancelToListener();
                WebDialog.this.dismiss();
            }
        });
        Drawable drawable2 = this.getContext().getResources().getDrawable(R.drawable.com_facebook_close);
        this.crossImageView.setImageDrawable(drawable2);
        this.crossImageView.setVisibility(4);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int getScaledSize(int n2, float f2, int n3, int n4) {
        double d2;
        int n5 = (int)((float)n2 / f2);
        if (n5 <= n3) {
            d2 = 1.0;
            return (int)(d2 * (double)n2);
        }
        if (n5 >= n4) {
            d2 = 0.5;
            return (int)(d2 * (double)n2);
        }
        d2 = 0.5 + 0.5 * ((double)(n4 - n5) / (double)(n4 - n3));
        return (int)(d2 * (double)n2);
    }

    private void sendCancelToListener() {
        this.sendErrorToListener(new FacebookOperationCanceledException());
    }

    /*
     * Enabled aggressive block sorting
     */
    private void sendErrorToListener(Throwable throwable) {
        if (this.onCompleteListener != null && !this.listenerCalled) {
            this.listenerCalled = true;
            FacebookException facebookException = throwable instanceof FacebookException ? (FacebookException)throwable : new FacebookException(throwable);
            this.onCompleteListener.onComplete(null, facebookException);
        }
    }

    private void sendSuccessToListener(Bundle bundle) {
        if (this.onCompleteListener != null && !this.listenerCalled) {
            this.listenerCalled = true;
            this.onCompleteListener.onComplete(bundle, null);
        }
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    private void setUpWebView(int n2) {
        LinearLayout linearLayout = new LinearLayout(this.getContext());
        this.webView = new WebView(this.getContext());
        this.webView.setVerticalScrollBarEnabled(false);
        this.webView.setHorizontalScrollBarEnabled(false);
        this.webView.setWebViewClient((WebViewClient)new DialogWebViewClient());
        this.webView.getSettings().setJavaScriptEnabled(true);
        this.webView.loadUrl(this.url);
        this.webView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.webView.setVisibility(4);
        this.webView.getSettings().setSavePassword(false);
        linearLayout.setPadding(n2, n2, n2, n2);
        linearLayout.addView((View)this.webView);
        linearLayout.setBackgroundColor(-872415232);
        this.contentFrameLayout.addView((View)linearLayout);
    }

    public void dismiss() {
        if (this.webView != null) {
            this.webView.stopLoading();
        }
        if (!this.isDetached) {
            if (this.spinner.isShowing()) {
                this.spinner.dismiss();
            }
            super.dismiss();
        }
    }

    public OnCompleteListener getOnCompleteListener() {
        return this.onCompleteListener;
    }

    public void onAttachedToWindow() {
        this.isDetached = false;
        super.onAttachedToWindow();
    }

    protected void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        this.setOnCancelListener(new DialogInterface.OnCancelListener(){

            public void onCancel(DialogInterface dialogInterface) {
                WebDialog.this.sendCancelToListener();
            }
        });
        this.spinner = new ProgressDialog(this.getContext());
        this.spinner.requestWindowFeature(1);
        this.spinner.setMessage((CharSequence)this.getContext().getString(R.string.com_facebook_loading));
        this.spinner.setOnCancelListener(new DialogInterface.OnCancelListener(){

            public void onCancel(DialogInterface dialogInterface) {
                WebDialog.this.sendCancelToListener();
                WebDialog.this.dismiss();
            }
        });
        this.requestWindowFeature(1);
        this.contentFrameLayout = new FrameLayout(this.getContext());
        this.calculateSize();
        this.getWindow().setGravity(17);
        this.getWindow().setSoftInputMode(16);
        this.createCrossImage();
        this.setUpWebView(1 + this.crossImageView.getDrawable().getIntrinsicWidth() / 2);
        this.contentFrameLayout.addView((View)this.crossImageView, new ViewGroup.LayoutParams(-2, -2));
        this.setContentView((View)this.contentFrameLayout);
    }

    public void onDetachedFromWindow() {
        this.isDetached = true;
        super.onDetachedFromWindow();
    }

    public void setOnCompleteListener(OnCompleteListener onCompleteListener) {
        this.onCompleteListener = onCompleteListener;
    }

    public static class Builder
    extends BuilderBase<Builder> {
        public Builder(Context context, Session session, String string2, Bundle bundle) {
            super(context, session, string2, bundle);
        }

        public Builder(Context context, String string2, String string3, Bundle bundle) {
            super(context, string2, string3, bundle);
        }
    }

    private static class BuilderBase<CONCRETE extends BuilderBase<?>> {
        private String action;
        private String applicationId;
        private Context context;
        private OnCompleteListener listener;
        private Bundle parameters;
        private Session session;
        private int theme = 0x1030010;

        protected BuilderBase(Context context, Session session, String string2, Bundle bundle) {
            Validate.notNull(session, "session");
            if (!session.isOpened()) {
                throw new FacebookException("Attempted to use a Session that was not open.");
            }
            this.session = session;
            this.finishInit(context, string2, bundle);
        }

        protected BuilderBase(Context context, String string2, String string3, Bundle bundle) {
            Validate.notNullOrEmpty(string2, "applicationId");
            this.applicationId = string2;
            this.finishInit(context, string3, bundle);
        }

        private void finishInit(Context context, String string2, Bundle bundle) {
            this.context = context;
            this.action = string2;
            if (bundle != null) {
                this.parameters = bundle;
                return;
            }
            this.parameters = new Bundle();
        }

        /*
         * Enabled aggressive block sorting
         */
        public WebDialog build() {
            if (this.session != null && this.session.isOpened()) {
                this.parameters.putString("app_id", this.session.getApplicationId());
                this.parameters.putString("access_token", this.session.getAccessToken());
            } else {
                this.parameters.putString("app_id", this.applicationId);
            }
            if (!this.parameters.containsKey("redirect_uri")) {
                this.parameters.putString("redirect_uri", WebDialog.REDIRECT_URI);
            }
            return new WebDialog(this.context, this.action, this.parameters, this.theme, this.listener);
        }

        protected String getApplicationId() {
            return this.applicationId;
        }

        protected Context getContext() {
            return this.context;
        }

        protected OnCompleteListener getListener() {
            return this.listener;
        }

        protected Bundle getParameters() {
            return this.parameters;
        }

        protected int getTheme() {
            return this.theme;
        }

        public CONCRETE setOnCompleteListener(OnCompleteListener onCompleteListener) {
            this.listener = onCompleteListener;
            return (CONCRETE)this;
        }

        public CONCRETE setTheme(int n2) {
            this.theme = n2;
            return (CONCRETE)this;
        }
    }

    private class DialogWebViewClient
    extends WebViewClient {
        private DialogWebViewClient() {
        }

        public void onPageFinished(WebView webView, String string2) {
            super.onPageFinished(webView, string2);
            if (!WebDialog.this.isDetached) {
                WebDialog.this.spinner.dismiss();
            }
            WebDialog.this.contentFrameLayout.setBackgroundColor(0);
            WebDialog.this.webView.setVisibility(0);
            WebDialog.this.crossImageView.setVisibility(0);
        }

        public void onPageStarted(WebView webView, String string2, Bitmap bitmap) {
            Utility.logd(WebDialog.LOG_TAG, "Webview loading URL: " + string2);
            super.onPageStarted(webView, string2, bitmap);
            if (!WebDialog.this.isDetached) {
                WebDialog.this.spinner.show();
            }
        }

        public void onReceivedError(WebView webView, int n2, String string2, String string3) {
            super.onReceivedError(webView, n2, string2, string3);
            WebDialog.this.sendErrorToListener(new FacebookDialogException(string2, n2, string3));
            WebDialog.this.dismiss();
        }

        public void onReceivedSslError(WebView webView, SslErrorHandler sslErrorHandler, SslError sslError) {
            super.onReceivedSslError(webView, sslErrorHandler, sslError);
            WebDialog.this.sendErrorToListener(new FacebookDialogException(null, -11, null));
            sslErrorHandler.cancel();
            WebDialog.this.dismiss();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean shouldOverrideUrlLoading(WebView webView, String string2) {
            Utility.logd(WebDialog.LOG_TAG, "Redirect URL: " + string2);
            if (string2.startsWith(WebDialog.REDIRECT_URI)) {
                String string3;
                Bundle bundle = Util.parseUrl(string2);
                String string4 = bundle.getString("error");
                if (string4 == null) {
                    string4 = bundle.getString("error_type");
                }
                if ((string3 = bundle.getString("error_msg")) == null) {
                    string3 = bundle.getString("error_description");
                }
                String string5 = bundle.getString("error_code");
                int n2 = -1;
                if (!Utility.isNullOrEmpty(string5)) {
                    try {
                        int n3;
                        n2 = n3 = Integer.parseInt(string5);
                    }
                    catch (NumberFormatException numberFormatException) {
                        n2 = -1;
                    }
                }
                if (Utility.isNullOrEmpty(string4) && Utility.isNullOrEmpty(string3) && n2 == -1) {
                    WebDialog.this.sendSuccessToListener(bundle);
                } else if (string4 != null && (string4.equals("access_denied") || string4.equals("OAuthAccessDeniedException"))) {
                    WebDialog.this.sendCancelToListener();
                } else {
                    FacebookRequestError facebookRequestError = new FacebookRequestError(n2, string4, string3);
                    WebDialog.this.sendErrorToListener(new FacebookServiceException(facebookRequestError, string3));
                }
                WebDialog.this.dismiss();
                return true;
            }
            if (string2.startsWith(WebDialog.CANCEL_URI)) {
                WebDialog.this.sendCancelToListener();
                WebDialog.this.dismiss();
                return true;
            }
            if (string2.contains(WebDialog.DISPLAY_TOUCH)) {
                return false;
            }
            WebDialog.this.getContext().startActivity(new Intent("android.intent.action.VIEW", Uri.parse((String)string2)));
            return true;
        }
    }

    public static class FeedDialogBuilder
    extends BuilderBase<FeedDialogBuilder> {
        private static final String CAPTION_PARAM = "caption";
        private static final String DESCRIPTION_PARAM = "description";
        private static final String FEED_DIALOG = "feed";
        private static final String FROM_PARAM = "from";
        private static final String LINK_PARAM = "link";
        private static final String NAME_PARAM = "name";
        private static final String PICTURE_PARAM = "picture";
        private static final String SOURCE_PARAM = "source";
        private static final String TO_PARAM = "to";

        public FeedDialogBuilder(Context context, Session session) {
            super(context, session, FEED_DIALOG, null);
        }

        public FeedDialogBuilder(Context context, Session session, Bundle bundle) {
            super(context, session, FEED_DIALOG, bundle);
        }

        public FeedDialogBuilder setCaption(String string2) {
            this.getParameters().putString(CAPTION_PARAM, string2);
            return this;
        }

        public FeedDialogBuilder setDescription(String string2) {
            this.getParameters().putString(DESCRIPTION_PARAM, string2);
            return this;
        }

        public FeedDialogBuilder setFrom(String string2) {
            this.getParameters().putString(FROM_PARAM, string2);
            return this;
        }

        public FeedDialogBuilder setLink(String string2) {
            this.getParameters().putString(LINK_PARAM, string2);
            return this;
        }

        public FeedDialogBuilder setName(String string2) {
            this.getParameters().putString(NAME_PARAM, string2);
            return this;
        }

        public FeedDialogBuilder setPicture(String string2) {
            this.getParameters().putString(PICTURE_PARAM, string2);
            return this;
        }

        public FeedDialogBuilder setSource(String string2) {
            this.getParameters().putString(SOURCE_PARAM, string2);
            return this;
        }

        public FeedDialogBuilder setTo(String string2) {
            this.getParameters().putString(TO_PARAM, string2);
            return this;
        }
    }

    public static interface OnCompleteListener {
        public void onComplete(Bundle var1, FacebookException var2);
    }

    public static class RequestsDialogBuilder
    extends BuilderBase<RequestsDialogBuilder> {
        private static final String APPREQUESTS_DIALOG = "apprequests";
        private static final String DATA_PARAM = "data";
        private static final String MESSAGE_PARAM = "message";
        private static final String TITLE_PARAM = "title";
        private static final String TO_PARAM = "to";

        public RequestsDialogBuilder(Context context, Session session) {
            super(context, session, APPREQUESTS_DIALOG, null);
        }

        public RequestsDialogBuilder(Context context, Session session, Bundle bundle) {
            super(context, session, APPREQUESTS_DIALOG, bundle);
        }

        public RequestsDialogBuilder setData(String string2) {
            this.getParameters().putString(DATA_PARAM, string2);
            return this;
        }

        public RequestsDialogBuilder setMessage(String string2) {
            this.getParameters().putString(MESSAGE_PARAM, string2);
            return this;
        }

        public RequestsDialogBuilder setTitle(String string2) {
            this.getParameters().putString(TITLE_PARAM, string2);
            return this;
        }

        public RequestsDialogBuilder setTo(String string2) {
            this.getParameters().putString(TO_PARAM, string2);
            return this;
        }
    }
}

