/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.widget;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import com.facebook.Request;
import com.facebook.Response;
import com.facebook.Session;
import com.facebook.SessionDefaultAudience;
import com.facebook.SessionLoginBehavior;
import com.facebook.SessionState;
import com.facebook.android.R;
import com.facebook.internal.ImageDownloader;
import com.facebook.internal.ImageRequest;
import com.facebook.internal.ImageResponse;
import com.facebook.model.GraphUser;
import com.facebook.widget.FacebookFragment;
import com.facebook.widget.LoginButton;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.List;

public class UserSettingsFragment
extends FacebookFragment {
    private static final String FIELDS = "fields";
    private static final String ID = "id";
    private static final String NAME = "name";
    private static final String PICTURE = "picture";
    private static final String REQUEST_FIELDS = TextUtils.join((CharSequence)",", (Object[])new String[]{"id", "name", "picture"});
    private TextView connectedStateLabel;
    private LoginButton loginButton;
    private LoginButton.LoginButtonProperties loginButtonProperties = new LoginButton.LoginButtonProperties();
    private Session.StatusCallback sessionStatusCallback;
    private GraphUser user;
    private Session userInfoSession;
    private Drawable userProfilePic;
    private String userProfilePicID;

    static /* synthetic */ GraphUser access$002(UserSettingsFragment userSettingsFragment, GraphUser graphUser) {
        userSettingsFragment.user = graphUser;
        return graphUser;
    }

    private void fetchUserInfo() {
        final Session session = this.getSession();
        if (session != null && session.isOpened()) {
            if (session != this.userInfoSession) {
                Request request = Request.newMeRequest(session, new Request.GraphUserCallback(){

                    @Override
                    public void onCompleted(GraphUser graphUser, Response response) {
                        if (session == UserSettingsFragment.this.getSession()) {
                            UserSettingsFragment.access$002(UserSettingsFragment.this, graphUser);
                            UserSettingsFragment.this.updateUI();
                        }
                        if (response.getError() != null) {
                            UserSettingsFragment.this.loginButton.handleError(response.getError().getException());
                        }
                    }
                });
                Bundle bundle = new Bundle();
                bundle.putString(FIELDS, REQUEST_FIELDS);
                request.setParameters(bundle);
                Request.executeBatchAsync(request);
                this.userInfoSession = session;
            }
            return;
        }
        this.user = null;
    }

    private ImageRequest getImageRequest() {
        try {
            ImageRequest imageRequest = new ImageRequest.Builder((Context)this.getActivity(), ImageRequest.getProfilePictureUrl(this.user.getId(), this.getResources().getDimensionPixelSize(R.dimen.com_facebook_usersettingsfragment_profile_picture_width), this.getResources().getDimensionPixelSize(R.dimen.com_facebook_usersettingsfragment_profile_picture_height))).setCallerTag(this).setCallback(new ImageRequest.Callback(){

                @Override
                public void onCompleted(ImageResponse imageResponse) {
                    UserSettingsFragment.this.processImageResponse(UserSettingsFragment.this.user.getId(), imageResponse);
                }
            }).build();
            return imageRequest;
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }

    private void processImageResponse(String string2, ImageResponse imageResponse) {
        Bitmap bitmap;
        if (imageResponse != null && (bitmap = imageResponse.getBitmap()) != null) {
            BitmapDrawable bitmapDrawable = new BitmapDrawable(this.getResources(), bitmap);
            bitmapDrawable.setBounds(0, 0, this.getResources().getDimensionPixelSize(R.dimen.com_facebook_usersettingsfragment_profile_picture_width), this.getResources().getDimensionPixelSize(R.dimen.com_facebook_usersettingsfragment_profile_picture_height));
            this.userProfilePic = bitmapDrawable;
            this.userProfilePicID = string2;
            this.connectedStateLabel.setCompoundDrawables(null, (Drawable)bitmapDrawable, null, null);
            this.connectedStateLabel.setTag((Object)imageResponse.getRequest().getImageUri());
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void updateUI() {
        URI uRI;
        if (!this.isAdded()) {
            return;
        }
        if (!this.isSessionOpen()) {
            int n2 = this.getResources().getColor(R.color.com_facebook_usersettingsfragment_not_connected_text_color);
            this.connectedStateLabel.setTextColor(n2);
            this.connectedStateLabel.setShadowLayer(0.0f, 0.0f, 0.0f, n2);
            this.connectedStateLabel.setText((CharSequence)this.getResources().getString(R.string.com_facebook_usersettingsfragment_not_logged_in));
            this.connectedStateLabel.setCompoundDrawables(null, null, null, null);
            this.connectedStateLabel.setTag(null);
            return;
        }
        this.connectedStateLabel.setTextColor(this.getResources().getColor(R.color.com_facebook_usersettingsfragment_connected_text_color));
        this.connectedStateLabel.setShadowLayer(1.0f, 0.0f, -1.0f, this.getResources().getColor(R.color.com_facebook_usersettingsfragment_connected_shadow_color));
        if (this.user == null) {
            this.connectedStateLabel.setText((CharSequence)this.getResources().getString(R.string.com_facebook_usersettingsfragment_logged_in));
            Drawable drawable2 = this.getResources().getDrawable(R.drawable.com_facebook_profile_default_icon);
            drawable2.setBounds(0, 0, this.getResources().getDimensionPixelSize(R.dimen.com_facebook_usersettingsfragment_profile_picture_width), this.getResources().getDimensionPixelSize(R.dimen.com_facebook_usersettingsfragment_profile_picture_height));
            this.connectedStateLabel.setCompoundDrawables(null, drawable2, null, null);
            return;
        }
        ImageRequest imageRequest = this.getImageRequest();
        if (imageRequest != null && !(uRI = imageRequest.getImageUri()).equals(this.connectedStateLabel.getTag())) {
            if (this.user.getId().equals(this.userProfilePicID)) {
                this.connectedStateLabel.setCompoundDrawables(null, this.userProfilePic, null, null);
                this.connectedStateLabel.setTag((Object)uRI);
            } else {
                ImageDownloader.downloadAsync(imageRequest);
            }
        }
        this.connectedStateLabel.setText((CharSequence)this.user.getName());
    }

    public void clearPermissions() {
        this.loginButtonProperties.clearPermissions();
    }

    public SessionDefaultAudience getDefaultAudience() {
        return this.loginButtonProperties.getDefaultAudience();
    }

    public SessionLoginBehavior getLoginBehavior() {
        return this.loginButtonProperties.getLoginBehavior();
    }

    public LoginButton.OnErrorListener getOnErrorListener() {
        return this.loginButtonProperties.getOnErrorListener();
    }

    List<String> getPermissions() {
        return this.loginButtonProperties.getPermissions();
    }

    public Session.StatusCallback getSessionStatusCallback() {
        return this.sessionStatusCallback;
    }

    @Override
    public void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        this.setRetainInstance(true);
    }

    @Override
    public View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
        View view = layoutInflater.inflate(R.layout.com_facebook_usersettingsfragment, viewGroup, false);
        this.loginButton = (LoginButton)view.findViewById(R.id.com_facebook_usersettingsfragment_login_button);
        this.loginButton.setProperties(this.loginButtonProperties);
        this.loginButton.setFragment(this);
        this.loginButton.setLoginLogoutEventName("fb_user_settings_vc_usage");
        Session session = this.getSession();
        if (session != null && !session.equals(Session.getActiveSession())) {
            this.loginButton.setSession(session);
        }
        this.connectedStateLabel = (TextView)view.findViewById(R.id.com_facebook_usersettingsfragment_profile_name);
        if (view.getBackground() == null) {
            view.setBackgroundColor(this.getResources().getColor(R.color.com_facebook_blue));
            return view;
        }
        view.getBackground().setDither(true);
        return view;
    }

    @Override
    public void onResume() {
        super.onResume();
        this.fetchUserInfo();
        this.updateUI();
    }

    @Override
    protected void onSessionStateChange(SessionState sessionState, Exception exception) {
        this.fetchUserInfo();
        this.updateUI();
        if (this.sessionStatusCallback != null) {
            this.sessionStatusCallback.call(this.getSession(), sessionState, exception);
        }
    }

    public void setDefaultAudience(SessionDefaultAudience sessionDefaultAudience) {
        this.loginButtonProperties.setDefaultAudience(sessionDefaultAudience);
    }

    public void setLoginBehavior(SessionLoginBehavior sessionLoginBehavior) {
        this.loginButtonProperties.setLoginBehavior(sessionLoginBehavior);
    }

    public void setOnErrorListener(LoginButton.OnErrorListener onErrorListener) {
        this.loginButtonProperties.setOnErrorListener(onErrorListener);
    }

    public void setPublishPermissions(List<String> list) {
        this.loginButtonProperties.setPublishPermissions(list, this.getSession());
    }

    public void setPublishPermissions(String ... stringArray) {
        this.loginButtonProperties.setPublishPermissions(Arrays.asList(stringArray), this.getSession());
    }

    public void setReadPermissions(List<String> list) {
        this.loginButtonProperties.setReadPermissions(list, this.getSession());
    }

    public void setReadPermissions(String ... stringArray) {
        this.loginButtonProperties.setReadPermissions(Arrays.asList(stringArray), this.getSession());
    }

    @Override
    public void setSession(Session session) {
        super.setSession(session);
        if (this.loginButton != null) {
            this.loginButton.setSession(session);
        }
        this.fetchUserInfo();
        this.updateUI();
    }

    public void setSessionStatusCallback(Session.StatusCallback statusCallback) {
        this.sessionStatusCallback = statusCallback;
    }
}

