/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.widget;

import android.database.CursorIndexOutOfBoundsException;
import com.facebook.model.GraphObject;
import com.facebook.widget.GraphObjectCursor;
import java.util.ArrayList;
import java.util.Collection;

class SimpleGraphObjectCursor<T extends GraphObject>
implements GraphObjectCursor<T> {
    private boolean closed = false;
    private boolean fromCache = false;
    private ArrayList<T> graphObjects = new ArrayList();
    private boolean moreObjectsAvailable = false;
    private int pos = -1;

    SimpleGraphObjectCursor() {
    }

    SimpleGraphObjectCursor(SimpleGraphObjectCursor<T> simpleGraphObjectCursor) {
        this.pos = simpleGraphObjectCursor.pos;
        this.closed = simpleGraphObjectCursor.closed;
        this.graphObjects = new ArrayList();
        this.graphObjects.addAll(simpleGraphObjectCursor.graphObjects);
        this.fromCache = simpleGraphObjectCursor.fromCache;
    }

    public void addGraphObjects(Collection<T> collection, boolean bl2) {
        this.graphObjects.addAll(collection);
        this.fromCache = bl2 | this.fromCache;
    }

    @Override
    public boolean areMoreObjectsAvailable() {
        return this.moreObjectsAvailable;
    }

    @Override
    public void close() {
        this.closed = true;
    }

    @Override
    public int getCount() {
        return this.graphObjects.size();
    }

    @Override
    public T getGraphObject() {
        if (this.pos < 0) {
            throw new CursorIndexOutOfBoundsException("Before first object.");
        }
        if (this.pos >= this.graphObjects.size()) {
            throw new CursorIndexOutOfBoundsException("After last object.");
        }
        return (T)((GraphObject)this.graphObjects.get(this.pos));
    }

    @Override
    public int getPosition() {
        return this.pos;
    }

    @Override
    public boolean isAfterLast() {
        int n2 = this.getCount();
        return n2 == 0 || this.pos == n2;
    }

    @Override
    public boolean isBeforeFirst() {
        return this.getCount() == 0 || this.pos == -1;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public boolean isFirst() {
        return this.pos == 0 && this.getCount() != 0;
    }

    @Override
    public boolean isFromCache() {
        return this.fromCache;
    }

    @Override
    public boolean isLast() {
        int n2 = this.getCount();
        return this.pos == n2 - 1 && n2 != 0;
    }

    @Override
    public boolean move(int n2) {
        return this.moveToPosition(n2 + this.pos);
    }

    @Override
    public boolean moveToFirst() {
        return this.moveToPosition(0);
    }

    @Override
    public boolean moveToLast() {
        return this.moveToPosition(-1 + this.getCount());
    }

    @Override
    public boolean moveToNext() {
        return this.moveToPosition(1 + this.pos);
    }

    @Override
    public boolean moveToPosition(int n2) {
        int n3 = this.getCount();
        if (n2 >= n3) {
            this.pos = n3;
            return false;
        }
        if (n2 < 0) {
            this.pos = -1;
            return false;
        }
        this.pos = n2;
        return true;
    }

    @Override
    public boolean moveToPrevious() {
        return this.moveToPosition(-1 + this.pos);
    }

    public void setFromCache(boolean bl2) {
        this.fromCache = bl2;
    }

    public void setMoreObjectsAvailable(boolean bl2) {
        this.moreObjectsAvailable = bl2;
    }
}

