/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.widget;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import com.facebook.FacebookException;
import com.facebook.LoggingBehavior;
import com.facebook.android.R;
import com.facebook.internal.ImageDownloader;
import com.facebook.internal.ImageRequest;
import com.facebook.internal.ImageResponse;
import com.facebook.internal.Logger;
import com.facebook.internal.Utility;
import java.net.URISyntaxException;

public class ProfilePictureView
extends FrameLayout {
    private static final String BITMAP_HEIGHT_KEY = "ProfilePictureView_height";
    private static final String BITMAP_KEY = "ProfilePictureView_bitmap";
    private static final String BITMAP_WIDTH_KEY = "ProfilePictureView_width";
    public static final int CUSTOM = -1;
    private static final boolean IS_CROPPED_DEFAULT_VALUE = true;
    private static final String IS_CROPPED_KEY = "ProfilePictureView_isCropped";
    public static final int LARGE = -4;
    private static final int MIN_SIZE = 1;
    public static final int NORMAL = -3;
    private static final String PENDING_REFRESH_KEY = "ProfilePictureView_refresh";
    private static final String PRESET_SIZE_KEY = "ProfilePictureView_presetSize";
    private static final String PROFILE_ID_KEY = "ProfilePictureView_profileId";
    public static final int SMALL = -2;
    private static final String SUPER_STATE_KEY = "ProfilePictureView_superState";
    public static final String TAG = ProfilePictureView.class.getSimpleName();
    private Bitmap customizedDefaultProfilePicture = null;
    private ImageView image;
    private Bitmap imageContents;
    private boolean isCropped = true;
    private ImageRequest lastRequest;
    private OnErrorListener onErrorListener;
    private int presetSizeType = -1;
    private String profileId;
    private int queryHeight = 0;
    private int queryWidth = 0;

    public ProfilePictureView(Context context) {
        super(context);
        this.initialize(context);
    }

    public ProfilePictureView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.initialize(context);
        this.parseAttributes(attributeSet);
    }

    public ProfilePictureView(Context context, AttributeSet attributeSet, int n2) {
        super(context, attributeSet, n2);
        this.initialize(context);
        this.parseAttributes(attributeSet);
    }

    /*
     * Enabled aggressive block sorting
     */
    private int getPresetSizeInPixels(boolean bl2) {
        int n2;
        switch (this.presetSizeType) {
            default: {
                return 0;
            }
            case -2: {
                n2 = R.dimen.com_facebook_profilepictureview_preset_size_small;
                return this.getResources().getDimensionPixelSize(n2);
            }
            case -3: {
                n2 = R.dimen.com_facebook_profilepictureview_preset_size_normal;
                return this.getResources().getDimensionPixelSize(n2);
            }
            case -4: {
                n2 = R.dimen.com_facebook_profilepictureview_preset_size_large;
                return this.getResources().getDimensionPixelSize(n2);
            }
            case -1: 
        }
        if (!bl2) return 0;
        n2 = R.dimen.com_facebook_profilepictureview_preset_size_normal;
        return this.getResources().getDimensionPixelSize(n2);
    }

    private void initialize(Context context) {
        this.removeAllViews();
        this.image = new ImageView(context);
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, -1);
        this.image.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.image.setScaleType(ImageView.ScaleType.CENTER_INSIDE);
        this.addView((View)this.image);
    }

    private void parseAttributes(AttributeSet attributeSet) {
        TypedArray typedArray = this.getContext().obtainStyledAttributes(attributeSet, R.styleable.com_facebook_profile_picture_view);
        this.setPresetSize(typedArray.getInt(0, -1));
        this.isCropped = typedArray.getBoolean(1, true);
        typedArray.recycle();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void processResponse(ImageResponse imageResponse) {
        if (imageResponse.getRequest() != this.lastRequest) return;
        this.lastRequest = null;
        Bitmap bitmap = imageResponse.getBitmap();
        Exception exception = imageResponse.getError();
        if (exception != null) {
            OnErrorListener onErrorListener = this.onErrorListener;
            if (onErrorListener == null) {
                Logger.log(LoggingBehavior.REQUESTS, 6, TAG, exception.toString());
                return;
            }
            onErrorListener.onError(new FacebookException("Error in downloading profile picture for profileId: " + this.getProfileId(), exception));
            return;
        } else {
            if (bitmap == null) return;
            this.setImageBitmap(bitmap);
            if (!imageResponse.isCachedRedirect()) return;
            this.sendImageRequest(false);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void refreshImage(boolean bl2) {
        boolean bl3 = this.updateImageQueryParameters();
        if (this.profileId == null || this.profileId.length() == 0 || this.queryWidth == 0 && this.queryHeight == 0) {
            this.setBlankProfilePicture();
            return;
        } else {
            if (!bl3 && !bl2) return;
            this.sendImageRequest(true);
            return;
        }
    }

    private void sendImageRequest(boolean bl2) {
        try {
            ImageRequest imageRequest = new ImageRequest.Builder(this.getContext(), ImageRequest.getProfilePictureUrl(this.profileId, this.queryWidth, this.queryHeight)).setAllowCachedRedirects(bl2).setCallerTag((Object)this).setCallback(new ImageRequest.Callback(){

                @Override
                public void onCompleted(ImageResponse imageResponse) {
                    ProfilePictureView.this.processResponse(imageResponse);
                }
            }).build();
            if (this.lastRequest != null) {
                ImageDownloader.cancelRequest(this.lastRequest);
            }
            this.lastRequest = imageRequest;
            ImageDownloader.downloadAsync(imageRequest);
            return;
        }
        catch (URISyntaxException uRISyntaxException) {
            Logger.log(LoggingBehavior.REQUESTS, 6, TAG, uRISyntaxException.toString());
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setBlankProfilePicture() {
        if (this.customizedDefaultProfilePicture != null) {
            this.updateImageQueryParameters();
            this.setImageBitmap(Bitmap.createScaledBitmap((Bitmap)this.customizedDefaultProfilePicture, (int)this.queryWidth, (int)this.queryHeight, (boolean)false));
            return;
        }
        int n2 = this.isCropped() ? R.drawable.com_facebook_profile_picture_blank_square : R.drawable.com_facebook_profile_picture_blank_portrait;
        this.setImageBitmap(BitmapFactory.decodeResource((Resources)this.getResources(), (int)n2));
    }

    private void setImageBitmap(Bitmap bitmap) {
        if (this.image != null && bitmap != null) {
            this.imageContents = bitmap;
            this.image.setImageBitmap(bitmap);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean updateImageQueryParameters() {
        int n2 = 1;
        int n3 = this.getHeight();
        int n4 = this.getWidth();
        if (n4 < n2 || n3 < n2) {
            return false;
        }
        int n5 = this.getPresetSizeInPixels(false);
        if (n5 != 0) {
            n4 = n5;
            n3 = n5;
        }
        if (n4 <= n3) {
            n3 = this.isCropped() ? n4 : 0;
        } else {
            n4 = this.isCropped() ? n3 : 0;
        }
        if (n4 == this.queryWidth && n3 == this.queryHeight) {
            n2 = 0;
        }
        this.queryWidth = n4;
        this.queryHeight = n3;
        return n2 != 0;
    }

    public final OnErrorListener getOnErrorListener() {
        return this.onErrorListener;
    }

    public final int getPresetSize() {
        return this.presetSizeType;
    }

    public final String getProfileId() {
        return this.profileId;
    }

    public final boolean isCropped() {
        return this.isCropped;
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.lastRequest = null;
    }

    protected void onLayout(boolean bl2, int n2, int n3, int n4, int n5) {
        super.onLayout(bl2, n2, n3, n4, n5);
        this.refreshImage(false);
    }

    protected void onMeasure(int n2, int n3) {
        ViewGroup.LayoutParams layoutParams = this.getLayoutParams();
        int n4 = View.MeasureSpec.getSize((int)n3);
        int n5 = View.MeasureSpec.getSize((int)n2);
        int n6 = View.MeasureSpec.getMode((int)n3);
        boolean bl2 = false;
        if (n6 != 0x40000000) {
            int n7 = layoutParams.height;
            bl2 = false;
            if (n7 == -2) {
                n4 = this.getPresetSizeInPixels(true);
                n3 = View.MeasureSpec.makeMeasureSpec((int)n4, (int)0x40000000);
                bl2 = true;
            }
        }
        if (View.MeasureSpec.getMode((int)n2) != 0x40000000 && layoutParams.width == -2) {
            n5 = this.getPresetSizeInPixels(true);
            n2 = View.MeasureSpec.makeMeasureSpec((int)n5, (int)0x40000000);
            bl2 = true;
        }
        if (bl2) {
            this.setMeasuredDimension(n5, n4);
            this.measureChildren(n2, n3);
            return;
        }
        super.onMeasure(n2, n3);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void onRestoreInstanceState(Parcelable parcelable) {
        if (parcelable.getClass() != Bundle.class) {
            super.onRestoreInstanceState(parcelable);
            return;
        } else {
            Bundle bundle = (Bundle)parcelable;
            super.onRestoreInstanceState(bundle.getParcelable(SUPER_STATE_KEY));
            this.profileId = bundle.getString(PROFILE_ID_KEY);
            this.presetSizeType = bundle.getInt(PRESET_SIZE_KEY);
            this.isCropped = bundle.getBoolean(IS_CROPPED_KEY);
            this.queryWidth = bundle.getInt(BITMAP_WIDTH_KEY);
            this.queryHeight = bundle.getInt(BITMAP_HEIGHT_KEY);
            this.setImageBitmap((Bitmap)bundle.getParcelable(BITMAP_KEY));
            if (!bundle.getBoolean(PENDING_REFRESH_KEY)) return;
            this.refreshImage(true);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected Parcelable onSaveInstanceState() {
        Parcelable parcelable = super.onSaveInstanceState();
        Bundle bundle = new Bundle();
        bundle.putParcelable(SUPER_STATE_KEY, parcelable);
        bundle.putString(PROFILE_ID_KEY, this.profileId);
        bundle.putInt(PRESET_SIZE_KEY, this.presetSizeType);
        bundle.putBoolean(IS_CROPPED_KEY, this.isCropped);
        bundle.putParcelable(BITMAP_KEY, (Parcelable)this.imageContents);
        bundle.putInt(BITMAP_WIDTH_KEY, this.queryWidth);
        bundle.putInt(BITMAP_HEIGHT_KEY, this.queryHeight);
        boolean bl2 = this.lastRequest != null;
        bundle.putBoolean(PENDING_REFRESH_KEY, bl2);
        return bundle;
    }

    public final void setCropped(boolean bl2) {
        this.isCropped = bl2;
        this.refreshImage(false);
    }

    public final void setDefaultProfilePicture(Bitmap bitmap) {
        this.customizedDefaultProfilePicture = bitmap;
    }

    public final void setOnErrorListener(OnErrorListener onErrorListener) {
        this.onErrorListener = onErrorListener;
    }

    public final void setPresetSize(int n2) {
        switch (n2) {
            default: {
                throw new IllegalArgumentException("Must use a predefined preset size");
            }
            case -4: 
            case -3: 
            case -2: 
            case -1: 
        }
        this.presetSizeType = n2;
        this.requestLayout();
    }

    public final void setProfileId(String string2) {
        boolean bl2;
        block3: {
            block2: {
                if (Utility.isNullOrEmpty(this.profileId)) break block2;
                boolean bl3 = this.profileId.equalsIgnoreCase(string2);
                bl2 = false;
                if (bl3) break block3;
            }
            this.setBlankProfilePicture();
            bl2 = true;
        }
        this.profileId = string2;
        this.refreshImage(bl2);
    }

    public static interface OnErrorListener {
        public void onError(FacebookException var1);
    }
}

