/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.widget;

import android.app.Activity;
import android.content.Context;
import android.content.res.TypedArray;
import android.location.Location;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcelable;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.ListView;
import com.facebook.AppEventsLogger;
import com.facebook.FacebookException;
import com.facebook.LoggingBehavior;
import com.facebook.Request;
import com.facebook.Session;
import com.facebook.android.R;
import com.facebook.internal.Logger;
import com.facebook.internal.Utility;
import com.facebook.model.GraphPlace;
import com.facebook.widget.GraphObjectAdapter;
import com.facebook.widget.GraphObjectPagingLoader;
import com.facebook.widget.PickerFragment;
import com.facebook.widget.SimpleGraphObjectCursor;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;

public class PlacePickerFragment
extends PickerFragment<GraphPlace> {
    private static final String CATEGORY = "category";
    public static final int DEFAULT_RADIUS_IN_METERS = 1000;
    public static final int DEFAULT_RESULTS_LIMIT = 100;
    private static final String ID = "id";
    private static final String LOCATION = "location";
    public static final String LOCATION_BUNDLE_KEY = "com.facebook.widget.PlacePickerFragment.Location";
    private static final String NAME = "name";
    public static final String RADIUS_IN_METERS_BUNDLE_KEY = "com.facebook.widget.PlacePickerFragment.RadiusInMeters";
    public static final String RESULTS_LIMIT_BUNDLE_KEY = "com.facebook.widget.PlacePickerFragment.ResultsLimit";
    public static final String SEARCH_TEXT_BUNDLE_KEY = "com.facebook.widget.PlacePickerFragment.SearchText";
    public static final String SHOW_SEARCH_BOX_BUNDLE_KEY = "com.facebook.widget.PlacePickerFragment.ShowSearchBox";
    private static final String TAG = "PlacePickerFragment";
    private static final String WERE_HERE_COUNT = "were_here_count";
    private static final int searchTextTimerDelayInMilliseconds = 2000;
    private boolean hasSearchTextChangedSinceLastQuery;
    private Location location;
    private int radiusInMeters = 1000;
    private int resultsLimit = 100;
    private EditText searchBox;
    private String searchText;
    private Timer searchTextTimer;
    private boolean showSearchBox = true;

    public PlacePickerFragment() {
        this(null);
    }

    public PlacePickerFragment(Bundle bundle) {
        super(GraphPlace.class, R.layout.com_facebook_placepickerfragment, bundle);
        this.setPlacePickerSettingsFromBundle(bundle);
    }

    private Request createRequest(Location location, int n2, int n3, String string2, Set<String> set, Session session) {
        Request request = Request.newPlacesSearchRequest(session, location, n2, n3, string2, null);
        HashSet<String> hashSet = new HashSet<String>(set);
        hashSet.addAll(Arrays.asList(ID, NAME, LOCATION, CATEGORY, WERE_HERE_COUNT));
        String string3 = this.adapter.getPictureFieldSpecifier();
        if (string3 != null) {
            hashSet.add(string3);
        }
        Bundle bundle = request.getParameters();
        bundle.putString("fields", TextUtils.join((CharSequence)",", hashSet));
        request.setParameters(bundle);
        return request;
    }

    private Timer createSearchTextTimer() {
        Timer timer = new Timer();
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                PlacePickerFragment.this.onSearchTextTimerTriggered();
            }
        }, 0L, 2000L);
        return timer;
    }

    private void onSearchTextTimerTriggered() {
        if (this.hasSearchTextChangedSinceLastQuery) {
            new Handler(Looper.getMainLooper()).post(new Runnable(){

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public void run() {
                    try {
                        PlacePickerFragment.this.loadData(true);
                        return;
                    }
                    catch (FacebookException facebookException) {
                        if (facebookException == null) return;
                        PickerFragment.OnErrorListener onErrorListener = PlacePickerFragment.this.getOnErrorListener();
                        if (onErrorListener != null) {
                            onErrorListener.onError(PlacePickerFragment.this, facebookException);
                            return;
                        }
                        Logger.log(LoggingBehavior.REQUESTS, PlacePickerFragment.TAG, "Error loading data : %s", facebookException);
                        return;
                    }
                    catch (Exception exception) {
                        FacebookException facebookException = new FacebookException(exception);
                        if (facebookException == null) return;
                        PickerFragment.OnErrorListener onErrorListener = PlacePickerFragment.this.getOnErrorListener();
                        if (onErrorListener != null) {
                            onErrorListener.onError(PlacePickerFragment.this, facebookException);
                            return;
                        }
                        Logger.log(LoggingBehavior.REQUESTS, PlacePickerFragment.TAG, "Error loading data : %s", facebookException);
                        return;
                    }
                }
            });
            return;
        }
        this.searchTextTimer.cancel();
        this.searchTextTimer = null;
    }

    private void setPlacePickerSettingsFromBundle(Bundle bundle) {
        if (bundle != null) {
            this.setRadiusInMeters(bundle.getInt(RADIUS_IN_METERS_BUNDLE_KEY, this.radiusInMeters));
            this.setResultsLimit(bundle.getInt(RESULTS_LIMIT_BUNDLE_KEY, this.resultsLimit));
            if (bundle.containsKey(SEARCH_TEXT_BUNDLE_KEY)) {
                this.setSearchText(bundle.getString(SEARCH_TEXT_BUNDLE_KEY));
            }
            if (bundle.containsKey(LOCATION_BUNDLE_KEY)) {
                this.setLocation((Location)bundle.getParcelable(LOCATION_BUNDLE_KEY));
            }
            this.showSearchBox = bundle.getBoolean(SHOW_SEARCH_BOX_BUNDLE_KEY, this.showSearchBox);
        }
    }

    @Override
    PickerFragment.PickerFragmentAdapter<GraphPlace> createAdapter() {
        PickerFragment.PickerFragmentAdapter<GraphPlace> pickerFragmentAdapter = new PickerFragment.PickerFragmentAdapter<GraphPlace>((Context)this.getActivity()){

            @Override
            protected int getDefaultPicture() {
                return R.drawable.com_facebook_place_default_icon;
            }

            @Override
            protected int getGraphObjectRowLayoutId(GraphPlace graphPlace) {
                return R.layout.com_facebook_placepickerfragment_list_row;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            protected CharSequence getSubTitleOfGraphObject(GraphPlace graphPlace) {
                String string2 = graphPlace.getCategory();
                Integer n2 = (Integer)graphPlace.getProperty(PlacePickerFragment.WERE_HERE_COUNT);
                if (string2 != null && n2 != null) {
                    return PlacePickerFragment.this.getString(R.string.com_facebook_placepicker_subtitle_format, string2, n2);
                }
                if (string2 == null && n2 != null) {
                    return PlacePickerFragment.this.getString(R.string.com_facebook_placepicker_subtitle_were_here_only_format, n2);
                }
                String string3 = null;
                if (string2 == null) return string3;
                string3 = null;
                if (n2 != null) return string3;
                return PlacePickerFragment.this.getString(R.string.com_facebook_placepicker_subtitle_catetory_only_format, string2);
            }
        };
        pickerFragmentAdapter.setShowCheckbox(false);
        pickerFragmentAdapter.setShowPicture(this.getShowPictures());
        return pickerFragmentAdapter;
    }

    @Override
    PickerFragment.LoadingStrategy createLoadingStrategy() {
        return new AsNeededLoadingStrategy();
    }

    @Override
    PickerFragment.SelectionStrategy createSelectionStrategy() {
        return new PickerFragment.SingleSelectionStrategy();
    }

    @Override
    String getDefaultTitleText() {
        return this.getString(R.string.com_facebook_nearby);
    }

    public Location getLocation() {
        return this.location;
    }

    public int getRadiusInMeters() {
        return this.radiusInMeters;
    }

    @Override
    Request getRequestForLoadData(Session session) {
        return this.createRequest(this.location, this.radiusInMeters, this.resultsLimit, this.searchText, this.extraFields, session);
    }

    public int getResultsLimit() {
        return this.resultsLimit;
    }

    public String getSearchText() {
        return this.searchText;
    }

    public GraphPlace getSelection() {
        List list = this.getSelectedGraphObjects();
        if (list != null && !list.isEmpty()) {
            return (GraphPlace)list.iterator().next();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    void logAppEvents(boolean bl2) {
        AppEventsLogger appEventsLogger = AppEventsLogger.newLogger((Context)this.getActivity(), this.getSession());
        Bundle bundle = new Bundle();
        String string2 = bl2 ? "Completed" : "Unknown";
        bundle.putString("fb_dialog_outcome", string2);
        int n2 = this.getSelection() != null ? 1 : 0;
        bundle.putInt("num_places_picked", n2);
        appEventsLogger.logSdkEvent("fb_place_picker_usage", null, bundle);
    }

    @Override
    public void onAttach(Activity activity) {
        super.onAttach(activity);
        if (this.searchBox != null) {
            ((InputMethodManager)this.getActivity().getSystemService("input_method")).showSoftInput((View)this.searchBox, 1);
        }
    }

    @Override
    public void onDetach() {
        super.onDetach();
        if (this.searchBox != null) {
            ((InputMethodManager)this.getActivity().getSystemService("input_method")).hideSoftInputFromWindow(this.searchBox.getWindowToken(), 0);
        }
    }

    @Override
    public void onInflate(Activity activity, AttributeSet attributeSet, Bundle bundle) {
        super.onInflate(activity, attributeSet, bundle);
        TypedArray typedArray = activity.obtainStyledAttributes(attributeSet, R.styleable.com_facebook_place_picker_fragment);
        this.setRadiusInMeters(typedArray.getInt(0, this.radiusInMeters));
        this.setResultsLimit(typedArray.getInt(1, this.resultsLimit));
        if (typedArray.hasValue(1)) {
            this.setSearchText(typedArray.getString(2));
        }
        this.showSearchBox = typedArray.getBoolean(3, this.showSearchBox);
        typedArray.recycle();
    }

    @Override
    void onLoadingData() {
        this.hasSearchTextChangedSinceLastQuery = false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void onSearchBoxTextChanged(String string2, boolean bl2) {
        block5: {
            block4: {
                if (!bl2 && Utility.stringsEqualOrEmpty(this.searchText, string2)) break block4;
                if (TextUtils.isEmpty((CharSequence)string2)) {
                    string2 = null;
                }
                this.searchText = string2;
                this.hasSearchTextChangedSinceLastQuery = true;
                if (this.searchTextTimer == null) break block5;
            }
            return;
        }
        this.searchTextTimer = this.createSearchTextTimer();
    }

    @Override
    void saveSettingsToBundle(Bundle bundle) {
        super.saveSettingsToBundle(bundle);
        bundle.putInt(RADIUS_IN_METERS_BUNDLE_KEY, this.radiusInMeters);
        bundle.putInt(RESULTS_LIMIT_BUNDLE_KEY, this.resultsLimit);
        bundle.putString(SEARCH_TEXT_BUNDLE_KEY, this.searchText);
        bundle.putParcelable(LOCATION_BUNDLE_KEY, (Parcelable)this.location);
        bundle.putBoolean(SHOW_SEARCH_BOX_BUNDLE_KEY, this.showSearchBox);
    }

    public void setLocation(Location location) {
        this.location = location;
    }

    public void setRadiusInMeters(int n2) {
        this.radiusInMeters = n2;
    }

    public void setResultsLimit(int n2) {
        this.resultsLimit = n2;
    }

    public void setSearchText(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            string2 = null;
        }
        this.searchText = string2;
        if (this.searchBox != null) {
            this.searchBox.setText((CharSequence)string2);
        }
    }

    @Override
    public void setSettingsFromBundle(Bundle bundle) {
        super.setSettingsFromBundle(bundle);
        this.setPlacePickerSettingsFromBundle(bundle);
    }

    @Override
    void setupViews(ViewGroup viewGroup) {
        if (this.showSearchBox) {
            ListView listView = (ListView)viewGroup.findViewById(R.id.com_facebook_picker_list_view);
            listView.addHeaderView(this.getActivity().getLayoutInflater().inflate(R.layout.com_facebook_picker_search_box, (ViewGroup)listView, false), null, false);
            this.searchBox = (EditText)viewGroup.findViewById(R.id.com_facebook_picker_search_text);
            this.searchBox.addTextChangedListener((TextWatcher)new SearchTextWatcher());
            if (!TextUtils.isEmpty((CharSequence)this.searchText)) {
                this.searchBox.setText((CharSequence)this.searchText);
            }
        }
    }

    private class AsNeededLoadingStrategy
    extends PickerFragment.LoadingStrategy {
        private AsNeededLoadingStrategy() {
        }

        public void attach(GraphObjectAdapter<GraphPlace> graphObjectAdapter) {
            super.attach(graphObjectAdapter);
            this.adapter.setDataNeededListener(new GraphObjectAdapter.DataNeededListener(){

                @Override
                public void onDataNeeded() {
                    if (!AsNeededLoadingStrategy.this.loader.isLoading()) {
                        AsNeededLoadingStrategy.this.loader.followNextLink();
                    }
                }
            });
        }

        /*
         * Enabled aggressive block sorting
         */
        protected void onLoadFinished(GraphObjectPagingLoader<GraphPlace> graphObjectPagingLoader, SimpleGraphObjectCursor<GraphPlace> simpleGraphObjectCursor) {
            block3: {
                block2: {
                    super.onLoadFinished(graphObjectPagingLoader, simpleGraphObjectCursor);
                    if (simpleGraphObjectCursor == null || graphObjectPagingLoader.isLoading()) break block2;
                    PlacePickerFragment.this.hideActivityCircle();
                    if (simpleGraphObjectCursor.isFromCache()) break block3;
                }
                return;
            }
            long l2 = simpleGraphObjectCursor.areMoreObjectsAvailable() ? 2000L : 0L;
            graphObjectPagingLoader.refreshOriginalRequest(l2);
        }
    }

    private class SearchTextWatcher
    implements TextWatcher {
        private SearchTextWatcher() {
        }

        public void afterTextChanged(Editable editable) {
        }

        public void beforeTextChanged(CharSequence charSequence, int n2, int n3, int n4) {
        }

        public void onTextChanged(CharSequence charSequence, int n2, int n3, int n4) {
            PlacePickerFragment.this.onSearchBoxTextChanged(charSequence.toString(), false);
        }
    }
}

