/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.widget;

import android.app.Activity;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.LoaderManager;
import android.support.v4.content.Loader;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewStub;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.ListView;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.facebook.FacebookException;
import com.facebook.Request;
import com.facebook.Session;
import com.facebook.SessionState;
import com.facebook.android.R;
import com.facebook.internal.SessionTracker;
import com.facebook.model.GraphObject;
import com.facebook.widget.GraphObjectAdapter;
import com.facebook.widget.GraphObjectPagingLoader;
import com.facebook.widget.SimpleGraphObjectCursor;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class PickerFragment<T extends GraphObject>
extends Fragment {
    private static final String ACTIVITY_CIRCLE_SHOW_KEY = "com.facebook.android.PickerFragment.ActivityCircleShown";
    public static final String DONE_BUTTON_TEXT_BUNDLE_KEY = "com.facebook.widget.PickerFragment.DoneButtonText";
    public static final String EXTRA_FIELDS_BUNDLE_KEY = "com.facebook.widget.PickerFragment.ExtraFields";
    private static final int PROFILE_PICTURE_PREFETCH_BUFFER = 5;
    private static final String SELECTION_BUNDLE_KEY = "com.facebook.android.PickerFragment.Selection";
    public static final String SHOW_PICTURES_BUNDLE_KEY = "com.facebook.widget.PickerFragment.ShowPictures";
    public static final String SHOW_TITLE_BAR_BUNDLE_KEY = "com.facebook.widget.PickerFragment.ShowTitleBar";
    public static final String TITLE_TEXT_BUNDLE_KEY = "com.facebook.widget.PickerFragment.TitleText";
    private ProgressBar activityCircle;
    GraphObjectAdapter<T> adapter;
    private boolean appEventsLogged;
    private Button doneButton;
    private Drawable doneButtonBackground;
    private String doneButtonText;
    HashSet<String> extraFields = new HashSet();
    private GraphObjectFilter<T> filter;
    private final Class<T> graphObjectClass;
    private final int layout;
    private ListView listView;
    private LoadingStrategy loadingStrategy;
    private OnDataChangedListener onDataChangedListener;
    private OnDoneButtonClickedListener onDoneButtonClickedListener;
    private OnErrorListener onErrorListener;
    private AbsListView.OnScrollListener onScrollListener = new AbsListView.OnScrollListener(){

        public void onScroll(AbsListView absListView, int n2, int n3, int n4) {
            PickerFragment.this.reprioritizeDownloads();
        }

        public void onScrollStateChanged(AbsListView absListView, int n2) {
        }
    };
    private OnSelectionChangedListener onSelectionChangedListener;
    private SelectionStrategy selectionStrategy;
    private SessionTracker sessionTracker;
    private boolean showPictures = true;
    private boolean showTitleBar = true;
    private Drawable titleBarBackground;
    private String titleText;
    private TextView titleTextView;

    PickerFragment(Class<T> clazz, int n2, Bundle bundle) {
        this.graphObjectClass = clazz;
        this.layout = n2;
        this.setPickerFragmentSettingsFromBundle(bundle);
    }

    static /* synthetic */ boolean access$202(PickerFragment pickerFragment, boolean bl2) {
        pickerFragment.appEventsLogged = bl2;
        return bl2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void clearResults() {
        if (this.adapter != null) {
            boolean bl2 = !this.selectionStrategy.isEmpty();
            boolean bl3 = !this.adapter.isEmpty();
            this.loadingStrategy.clearResults();
            this.selectionStrategy.clear();
            this.adapter.notifyDataSetChanged();
            if (bl3 && this.onDataChangedListener != null) {
                this.onDataChangedListener.onDataChanged(this);
            }
            if (bl2 && this.onSelectionChangedListener != null) {
                this.onSelectionChangedListener.onSelectionChanged(this);
            }
        }
    }

    private void inflateTitleBar(ViewGroup viewGroup) {
        ViewStub viewStub = (ViewStub)viewGroup.findViewById(R.id.com_facebook_picker_title_bar_stub);
        if (viewStub != null) {
            View view = viewStub.inflate();
            RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-1, -1);
            layoutParams.addRule(3, R.id.com_facebook_picker_title_bar);
            this.listView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            if (this.titleBarBackground != null) {
                view.setBackgroundDrawable(this.titleBarBackground);
            }
            this.doneButton = (Button)viewGroup.findViewById(R.id.com_facebook_picker_done_button);
            if (this.doneButton != null) {
                this.doneButton.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        PickerFragment.this.logAppEvents(true);
                        PickerFragment.access$202(PickerFragment.this, true);
                        if (PickerFragment.this.onDoneButtonClickedListener != null) {
                            PickerFragment.this.onDoneButtonClickedListener.onDoneButtonClicked(PickerFragment.this);
                        }
                    }
                });
                if (this.getDoneButtonText() != null) {
                    this.doneButton.setText((CharSequence)this.getDoneButtonText());
                }
                if (this.doneButtonBackground != null) {
                    this.doneButton.setBackgroundDrawable(this.doneButtonBackground);
                }
            }
            this.titleTextView = (TextView)viewGroup.findViewById(R.id.com_facebook_picker_title);
            if (this.titleTextView != null && this.getTitleText() != null) {
                this.titleTextView.setText((CharSequence)this.getTitleText());
            }
        }
    }

    private void loadDataSkippingRoundTripIfCached() {
        this.clearResults();
        Request request = this.getRequestForLoadData(this.getSession());
        if (request != null) {
            this.onLoadingData();
            this.loadingStrategy.startLoading(request);
        }
    }

    private void onListItemClick(ListView listView, View view, int n2) {
        GraphObject graphObject = (GraphObject)listView.getItemAtPosition(n2);
        String string2 = this.adapter.getIdOfGraphObject(graphObject);
        this.selectionStrategy.toggleSelection(string2);
        this.adapter.notifyDataSetChanged();
        if (this.onSelectionChangedListener != null) {
            this.onSelectionChangedListener.onSelectionChanged(this);
        }
    }

    private void reprioritizeDownloads() {
        int n2 = this.listView.getLastVisiblePosition();
        if (n2 >= 0) {
            int n3 = this.listView.getFirstVisiblePosition();
            this.adapter.prioritizeViewRange(n3, n2, 5);
        }
    }

    private static void setAlpha(View view, float f2) {
        AlphaAnimation alphaAnimation = new AlphaAnimation(f2, f2);
        alphaAnimation.setDuration(0L);
        alphaAnimation.setFillAfter(true);
        view.startAnimation((Animation)alphaAnimation);
    }

    private void setPickerFragmentSettingsFromBundle(Bundle bundle) {
        if (bundle != null) {
            String string2;
            this.showPictures = bundle.getBoolean(SHOW_PICTURES_BUNDLE_KEY, this.showPictures);
            String string3 = bundle.getString(EXTRA_FIELDS_BUNDLE_KEY);
            if (string3 != null) {
                this.setExtraFields(Arrays.asList(string3.split(",")));
            }
            this.showTitleBar = bundle.getBoolean(SHOW_TITLE_BAR_BUNDLE_KEY, this.showTitleBar);
            String string4 = bundle.getString(TITLE_TEXT_BUNDLE_KEY);
            if (string4 != null) {
                this.titleText = string4;
                if (this.titleTextView != null) {
                    this.titleTextView.setText((CharSequence)this.titleText);
                }
            }
            if ((string2 = bundle.getString(DONE_BUTTON_TEXT_BUNDLE_KEY)) != null) {
                this.doneButtonText = string2;
                if (this.doneButton != null) {
                    this.doneButton.setText((CharSequence)this.doneButtonText);
                }
            }
        }
    }

    abstract PickerFragmentAdapter<T> createAdapter();

    abstract LoadingStrategy createLoadingStrategy();

    abstract SelectionStrategy createSelectionStrategy();

    void displayActivityCircle() {
        if (this.activityCircle != null) {
            this.layoutActivityCircle();
            this.activityCircle.setVisibility(0);
        }
    }

    boolean filterIncludesItem(T t2) {
        if (this.filter != null) {
            return this.filter.includeItem(t2);
        }
        return true;
    }

    String getDefaultDoneButtonText() {
        return this.getString(R.string.com_facebook_picker_done_button_text);
    }

    String getDefaultTitleText() {
        return null;
    }

    public String getDoneButtonText() {
        if (this.doneButtonText == null) {
            this.doneButtonText = this.getDefaultDoneButtonText();
        }
        return this.doneButtonText;
    }

    public Set<String> getExtraFields() {
        return new HashSet<String>(this.extraFields);
    }

    public GraphObjectFilter<T> getFilter() {
        return this.filter;
    }

    public OnDataChangedListener getOnDataChangedListener() {
        return this.onDataChangedListener;
    }

    public OnDoneButtonClickedListener getOnDoneButtonClickedListener() {
        return this.onDoneButtonClickedListener;
    }

    public OnErrorListener getOnErrorListener() {
        return this.onErrorListener;
    }

    public OnSelectionChangedListener getOnSelectionChangedListener() {
        return this.onSelectionChangedListener;
    }

    abstract Request getRequestForLoadData(Session var1);

    List<T> getSelectedGraphObjects() {
        return this.adapter.getGraphObjectsById(this.selectionStrategy.getSelectedIds());
    }

    public Session getSession() {
        return this.sessionTracker.getSession();
    }

    public boolean getShowPictures() {
        return this.showPictures;
    }

    public boolean getShowTitleBar() {
        return this.showTitleBar;
    }

    public String getTitleText() {
        if (this.titleText == null) {
            this.titleText = this.getDefaultTitleText();
        }
        return this.titleText;
    }

    void hideActivityCircle() {
        if (this.activityCircle != null) {
            this.activityCircle.clearAnimation();
            this.activityCircle.setVisibility(4);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    void layoutActivityCircle() {
        float f2 = !this.adapter.isEmpty() ? 0.25f : 1.0f;
        PickerFragment.setAlpha((View)this.activityCircle, f2);
    }

    public void loadData(boolean bl2) {
        if (!bl2 && this.loadingStrategy.isDataPresentOrLoading()) {
            return;
        }
        this.loadDataSkippingRoundTripIfCached();
    }

    void logAppEvents(boolean bl2) {
    }

    @Override
    public void onActivityCreated(Bundle bundle) {
        block5: {
            block4: {
                super.onActivityCreated(bundle);
                this.sessionTracker = new SessionTracker((Context)this.getActivity(), new Session.StatusCallback(){

                    @Override
                    public void call(Session session, SessionState sessionState, Exception exception) {
                        if (!session.isOpened()) {
                            PickerFragment.this.clearResults();
                        }
                    }
                });
                this.setSettingsFromBundle(bundle);
                this.loadingStrategy = this.createLoadingStrategy();
                this.loadingStrategy.attach(this.adapter);
                this.selectionStrategy = this.createSelectionStrategy();
                this.selectionStrategy.readSelectionFromBundle(bundle, SELECTION_BUNDLE_KEY);
                if (this.showTitleBar) {
                    this.inflateTitleBar((ViewGroup)this.getView());
                }
                if (this.activityCircle == null || bundle == null) break block4;
                if (!bundle.getBoolean(ACTIVITY_CIRCLE_SHOW_KEY, false)) break block5;
                this.displayActivityCircle();
            }
            return;
        }
        this.hideActivityCircle();
    }

    @Override
    public void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        this.adapter = this.createAdapter();
        this.adapter.setFilter(new GraphObjectAdapter.Filter<T>(){

            @Override
            public boolean includeItem(T t2) {
                return PickerFragment.this.filterIncludesItem(t2);
            }
        });
    }

    @Override
    public View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
        ViewGroup viewGroup2 = (ViewGroup)layoutInflater.inflate(this.layout, viewGroup, false);
        this.listView = (ListView)viewGroup2.findViewById(R.id.com_facebook_picker_list_view);
        this.listView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> adapterView, View view, int n2, long l2) {
                PickerFragment.this.onListItemClick((ListView)adapterView, view, n2);
            }
        });
        this.listView.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View view) {
                return false;
            }
        });
        this.listView.setOnScrollListener(this.onScrollListener);
        this.activityCircle = (ProgressBar)viewGroup2.findViewById(R.id.com_facebook_picker_activity_circle);
        this.setupViews(viewGroup2);
        this.listView.setAdapter(this.adapter);
        return viewGroup2;
    }

    @Override
    public void onDetach() {
        super.onDetach();
        this.listView.setOnScrollListener(null);
        this.listView.setAdapter(null);
        this.loadingStrategy.detach();
        this.sessionTracker.stopTracking();
    }

    @Override
    public void onInflate(Activity activity, AttributeSet attributeSet, Bundle bundle) {
        super.onInflate(activity, attributeSet, bundle);
        TypedArray typedArray = activity.obtainStyledAttributes(attributeSet, R.styleable.com_facebook_picker_fragment);
        this.setShowPictures(typedArray.getBoolean(0, this.showPictures));
        String string2 = typedArray.getString(1);
        if (string2 != null) {
            this.setExtraFields(Arrays.asList(string2.split(",")));
        }
        this.showTitleBar = typedArray.getBoolean(2, this.showTitleBar);
        this.titleText = typedArray.getString(3);
        this.doneButtonText = typedArray.getString(4);
        this.titleBarBackground = typedArray.getDrawable(5);
        this.doneButtonBackground = typedArray.getDrawable(6);
        typedArray.recycle();
    }

    void onLoadingData() {
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void onSaveInstanceState(Bundle bundle) {
        super.onSaveInstanceState(bundle);
        this.saveSettingsToBundle(bundle);
        this.selectionStrategy.saveSelectionToBundle(bundle, SELECTION_BUNDLE_KEY);
        if (this.activityCircle != null) {
            boolean bl2 = this.activityCircle.getVisibility() == 0;
            bundle.putBoolean(ACTIVITY_CIRCLE_SHOW_KEY, bl2);
        }
    }

    @Override
    public void onStop() {
        if (!this.appEventsLogged) {
            this.logAppEvents(false);
        }
        super.onStop();
    }

    void saveSettingsToBundle(Bundle bundle) {
        bundle.putBoolean(SHOW_PICTURES_BUNDLE_KEY, this.showPictures);
        if (!this.extraFields.isEmpty()) {
            bundle.putString(EXTRA_FIELDS_BUNDLE_KEY, TextUtils.join((CharSequence)",", this.extraFields));
        }
        bundle.putBoolean(SHOW_TITLE_BAR_BUNDLE_KEY, this.showTitleBar);
        bundle.putString(TITLE_TEXT_BUNDLE_KEY, this.titleText);
        bundle.putString(DONE_BUTTON_TEXT_BUNDLE_KEY, this.doneButtonText);
    }

    @Override
    public void setArguments(Bundle bundle) {
        super.setArguments(bundle);
        this.setSettingsFromBundle(bundle);
    }

    public void setDoneButtonText(String string2) {
        this.doneButtonText = string2;
    }

    public void setExtraFields(Collection<String> collection) {
        this.extraFields = new HashSet();
        if (collection != null) {
            this.extraFields.addAll(collection);
        }
    }

    public void setFilter(GraphObjectFilter<T> graphObjectFilter) {
        this.filter = graphObjectFilter;
    }

    public void setOnDataChangedListener(OnDataChangedListener onDataChangedListener) {
        this.onDataChangedListener = onDataChangedListener;
    }

    public void setOnDoneButtonClickedListener(OnDoneButtonClickedListener onDoneButtonClickedListener) {
        this.onDoneButtonClickedListener = onDoneButtonClickedListener;
    }

    public void setOnErrorListener(OnErrorListener onErrorListener) {
        this.onErrorListener = onErrorListener;
    }

    public void setOnSelectionChangedListener(OnSelectionChangedListener onSelectionChangedListener) {
        this.onSelectionChangedListener = onSelectionChangedListener;
    }

    void setSelectedGraphObjects(List<String> list) {
        for (String string2 : list) {
            if (this.selectionStrategy.isSelected(string2)) continue;
            this.selectionStrategy.toggleSelection(string2);
        }
    }

    void setSelectionStrategy(SelectionStrategy selectionStrategy) {
        if (selectionStrategy != this.selectionStrategy) {
            this.selectionStrategy = selectionStrategy;
            if (this.adapter != null) {
                this.adapter.notifyDataSetChanged();
            }
        }
    }

    public void setSession(Session session) {
        this.sessionTracker.setSession(session);
    }

    public void setSettingsFromBundle(Bundle bundle) {
        this.setPickerFragmentSettingsFromBundle(bundle);
    }

    public void setShowPictures(boolean bl2) {
        this.showPictures = bl2;
    }

    public void setShowTitleBar(boolean bl2) {
        this.showTitleBar = bl2;
    }

    public void setTitleText(String string2) {
        this.titleText = string2;
    }

    void setupViews(ViewGroup viewGroup) {
    }

    /*
     * Enabled aggressive block sorting
     */
    void updateAdapter(SimpleGraphObjectCursor<T> simpleGraphObjectCursor) {
        if (this.adapter != null) {
            int n2;
            View view = this.listView.getChildAt(1);
            int n3 = this.listView.getFirstVisiblePosition();
            if (n3 > 0) {
                ++n3;
            }
            GraphObjectAdapter.SectionAndItem<T> sectionAndItem = this.adapter.getSectionAndItem(n3);
            int n4 = view != null && sectionAndItem.getType() != GraphObjectAdapter.SectionAndItem.Type.ACTIVITY_CIRCLE ? view.getTop() : 0;
            boolean bl2 = this.adapter.changeCursor(simpleGraphObjectCursor);
            if (view != null && sectionAndItem != null && (n2 = this.adapter.getPosition(sectionAndItem.sectionKey, sectionAndItem.graphObject)) != -1) {
                this.listView.setSelectionFromTop(n2, n4);
            }
            if (bl2 && this.onDataChangedListener != null) {
                this.onDataChangedListener.onDataChanged(this);
            }
        }
    }

    public static interface GraphObjectFilter<T> {
        public boolean includeItem(T var1);
    }

    abstract class LoadingStrategy {
        protected static final int CACHED_RESULT_REFRESH_DELAY = 2000;
        protected GraphObjectAdapter<T> adapter;
        protected GraphObjectPagingLoader<T> loader;

        LoadingStrategy() {
        }

        public void attach(GraphObjectAdapter<T> graphObjectAdapter) {
            this.loader = (GraphObjectPagingLoader)PickerFragment.this.getLoaderManager().initLoader(0, null, new LoaderManager.LoaderCallbacks<SimpleGraphObjectCursor<T>>(){

                @Override
                public Loader<SimpleGraphObjectCursor<T>> onCreateLoader(int n2, Bundle bundle) {
                    return LoadingStrategy.this.onCreateLoader();
                }

                @Override
                public void onLoadFinished(Loader<SimpleGraphObjectCursor<T>> loader, SimpleGraphObjectCursor<T> simpleGraphObjectCursor) {
                    if (loader != LoadingStrategy.this.loader) {
                        throw new FacebookException("Received callback for unknown loader.");
                    }
                    LoadingStrategy.this.onLoadFinished((GraphObjectPagingLoader)loader, simpleGraphObjectCursor);
                }

                @Override
                public void onLoaderReset(Loader<SimpleGraphObjectCursor<T>> loader) {
                    if (loader != LoadingStrategy.this.loader) {
                        throw new FacebookException("Received callback for unknown loader.");
                    }
                    LoadingStrategy.this.onLoadReset((GraphObjectPagingLoader)loader);
                }
            });
            this.loader.setOnErrorListener(new GraphObjectPagingLoader.OnErrorListener(){

                @Override
                public void onError(FacebookException facebookException, GraphObjectPagingLoader<?> graphObjectPagingLoader) {
                    PickerFragment.this.hideActivityCircle();
                    if (PickerFragment.this.onErrorListener != null) {
                        PickerFragment.this.onErrorListener.onError(PickerFragment.this, facebookException);
                    }
                }
            });
            this.adapter = graphObjectAdapter;
            this.adapter.changeCursor(this.loader.getCursor());
            this.adapter.setOnErrorListener(new GraphObjectAdapter.OnErrorListener(){

                @Override
                public void onError(GraphObjectAdapter<?> graphObjectAdapter, FacebookException facebookException) {
                    if (PickerFragment.this.onErrorListener != null) {
                        PickerFragment.this.onErrorListener.onError(PickerFragment.this, facebookException);
                    }
                }
            });
        }

        public void clearResults() {
            if (this.loader != null) {
                this.loader.clearResults();
            }
        }

        public void detach() {
            this.adapter.setDataNeededListener(null);
            this.adapter.setOnErrorListener(null);
            this.loader.setOnErrorListener(null);
            this.loader = null;
            this.adapter = null;
        }

        public boolean isDataPresentOrLoading() {
            return !this.adapter.isEmpty() || this.loader.isLoading();
        }

        protected GraphObjectPagingLoader<T> onCreateLoader() {
            return new GraphObjectPagingLoader((Context)PickerFragment.this.getActivity(), PickerFragment.this.graphObjectClass);
        }

        protected void onLoadFinished(GraphObjectPagingLoader<T> graphObjectPagingLoader, SimpleGraphObjectCursor<T> simpleGraphObjectCursor) {
            PickerFragment.this.updateAdapter(simpleGraphObjectCursor);
        }

        protected void onLoadReset(GraphObjectPagingLoader<T> graphObjectPagingLoader) {
            this.adapter.changeCursor(null);
        }

        protected void onStartLoading(GraphObjectPagingLoader<T> graphObjectPagingLoader, Request request) {
            PickerFragment.this.displayActivityCircle();
        }

        public void startLoading(Request request) {
            if (this.loader != null) {
                this.loader.startLoading(request, true);
                this.onStartLoading(this.loader, request);
            }
        }
    }

    class MultiSelectionStrategy
    extends SelectionStrategy {
        private Set<String> selectedIds;

        MultiSelectionStrategy() {
            this.selectedIds = new HashSet<String>();
        }

        @Override
        public void clear() {
            this.selectedIds.clear();
        }

        @Override
        public Collection<String> getSelectedIds() {
            return this.selectedIds;
        }

        @Override
        boolean isEmpty() {
            return this.selectedIds.isEmpty();
        }

        @Override
        boolean isSelected(String string2) {
            return string2 != null && this.selectedIds.contains(string2);
        }

        @Override
        void readSelectionFromBundle(Bundle bundle, String string2) {
            String string3;
            if (bundle != null && (string3 = bundle.getString(string2)) != null) {
                String[] stringArray = TextUtils.split((String)string3, (String)",");
                this.selectedIds.clear();
                Collections.addAll(this.selectedIds, stringArray);
            }
        }

        @Override
        void saveSelectionToBundle(Bundle bundle, String string2) {
            if (!this.selectedIds.isEmpty()) {
                bundle.putString(string2, TextUtils.join((CharSequence)",", this.selectedIds));
            }
        }

        @Override
        boolean shouldShowCheckBoxIfUnselected() {
            return true;
        }

        @Override
        void toggleSelection(String string2) {
            block3: {
                block2: {
                    if (string2 == null) break block2;
                    if (!this.selectedIds.contains(string2)) break block3;
                    this.selectedIds.remove(string2);
                }
                return;
            }
            this.selectedIds.add(string2);
        }
    }

    public static interface OnDataChangedListener {
        public void onDataChanged(PickerFragment<?> var1);
    }

    public static interface OnDoneButtonClickedListener {
        public void onDoneButtonClicked(PickerFragment<?> var1);
    }

    public static interface OnErrorListener {
        public void onError(PickerFragment<?> var1, FacebookException var2);
    }

    public static interface OnSelectionChangedListener {
        public void onSelectionChanged(PickerFragment<?> var1);
    }

    abstract class PickerFragmentAdapter<U extends GraphObject>
    extends GraphObjectAdapter<T> {
        public PickerFragmentAdapter(Context context) {
            super(context);
        }

        @Override
        boolean isGraphObjectSelected(String string2) {
            return PickerFragment.this.selectionStrategy.isSelected(string2);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        void updateCheckboxState(CheckBox checkBox, boolean bl2) {
            checkBox.setChecked(bl2);
            int n2 = bl2 || PickerFragment.this.selectionStrategy.shouldShowCheckBoxIfUnselected() ? 0 : 8;
            checkBox.setVisibility(n2);
        }
    }

    abstract class SelectionStrategy {
        SelectionStrategy() {
        }

        abstract void clear();

        abstract Collection<String> getSelectedIds();

        abstract boolean isEmpty();

        abstract boolean isSelected(String var1);

        abstract void readSelectionFromBundle(Bundle var1, String var2);

        abstract void saveSelectionToBundle(Bundle var1, String var2);

        abstract boolean shouldShowCheckBoxIfUnselected();

        abstract void toggleSelection(String var1);
    }

    class SingleSelectionStrategy
    extends SelectionStrategy {
        private String selectedId;

        SingleSelectionStrategy() {
        }

        @Override
        public void clear() {
            this.selectedId = null;
        }

        @Override
        public Collection<String> getSelectedIds() {
            String[] stringArray = new String[]{this.selectedId};
            return Arrays.asList(stringArray);
        }

        @Override
        boolean isEmpty() {
            return this.selectedId == null;
        }

        @Override
        boolean isSelected(String string2) {
            return this.selectedId != null && string2 != null && this.selectedId.equals(string2);
        }

        @Override
        void readSelectionFromBundle(Bundle bundle, String string2) {
            if (bundle != null) {
                this.selectedId = bundle.getString(string2);
            }
        }

        @Override
        void saveSelectionToBundle(Bundle bundle, String string2) {
            if (!TextUtils.isEmpty((CharSequence)this.selectedId)) {
                bundle.putString(string2, this.selectedId);
            }
        }

        @Override
        boolean shouldShowCheckBoxIfUnselected() {
            return false;
        }

        @Override
        void toggleSelection(String string2) {
            if (this.selectedId != null && this.selectedId.equals(string2)) {
                this.selectedId = null;
                return;
            }
            this.selectedId = string2;
        }
    }
}

