/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.widget;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.res.TypedArray;
import android.graphics.Typeface;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import com.facebook.AppEventsLogger;
import com.facebook.FacebookException;
import com.facebook.Request;
import com.facebook.Response;
import com.facebook.Session;
import com.facebook.SessionDefaultAudience;
import com.facebook.SessionLoginBehavior;
import com.facebook.SessionState;
import com.facebook.android.R;
import com.facebook.internal.SessionAuthorizationType;
import com.facebook.internal.SessionTracker;
import com.facebook.internal.Utility;
import com.facebook.model.GraphUser;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class LoginButton
extends Button {
    private static final String TAG = LoginButton.class.getName();
    private String applicationId = null;
    private boolean confirmLogout;
    private boolean fetchUserInfo;
    private String loginLogoutEventName = "fb_login_view_usage";
    private String loginText;
    private String logoutText;
    private Fragment parentFragment;
    private LoginButtonProperties properties = new LoginButtonProperties();
    private SessionTracker sessionTracker;
    private GraphUser user = null;
    private UserInfoChangedCallback userInfoChangedCallback;
    private Session userInfoSession = null;

    public LoginButton(Context context) {
        super(context);
        this.initializeActiveSessionWithCachedToken(context);
        this.finishInit();
    }

    /*
     * Enabled aggressive block sorting
     */
    public LoginButton(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        if (attributeSet.getStyleAttribute() == 0) {
            this.setGravity(17);
            this.setTextColor(this.getResources().getColor(R.color.com_facebook_loginview_text_color));
            this.setTextSize(0, this.getResources().getDimension(R.dimen.com_facebook_loginview_text_size));
            this.setTypeface(Typeface.DEFAULT_BOLD);
            if (this.isInEditMode()) {
                this.setBackgroundColor(this.getResources().getColor(R.color.com_facebook_blue));
                this.loginText = "Log in with Facebook";
            } else {
                this.setBackgroundResource(R.drawable.com_facebook_button_blue);
                this.setCompoundDrawablesWithIntrinsicBounds(R.drawable.com_facebook_inverse_icon, 0, 0, 0);
                this.setCompoundDrawablePadding(this.getResources().getDimensionPixelSize(R.dimen.com_facebook_loginview_compound_drawable_padding));
                this.setPadding(this.getResources().getDimensionPixelSize(R.dimen.com_facebook_loginview_padding_left), this.getResources().getDimensionPixelSize(R.dimen.com_facebook_loginview_padding_top), this.getResources().getDimensionPixelSize(R.dimen.com_facebook_loginview_padding_right), this.getResources().getDimensionPixelSize(R.dimen.com_facebook_loginview_padding_bottom));
            }
        }
        this.parseAttributes(attributeSet);
        if (!this.isInEditMode()) {
            this.initializeActiveSessionWithCachedToken(context);
        }
    }

    public LoginButton(Context context, AttributeSet attributeSet, int n2) {
        super(context, attributeSet, n2);
        this.parseAttributes(attributeSet);
        this.initializeActiveSessionWithCachedToken(context);
    }

    static /* synthetic */ GraphUser access$402(LoginButton loginButton, GraphUser graphUser) {
        loginButton.user = graphUser;
        return graphUser;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void fetchUserInfo() {
        if (!this.fetchUserInfo) return;
        final Session session = this.sessionTracker.getOpenSession();
        if (session != null) {
            if (session == this.userInfoSession) return;
            Request.executeBatchAsync(Request.newMeRequest(session, new Request.GraphUserCallback(){

                @Override
                public void onCompleted(GraphUser graphUser, Response response) {
                    if (session == LoginButton.this.sessionTracker.getOpenSession()) {
                        LoginButton.access$402(LoginButton.this, graphUser);
                        if (LoginButton.this.userInfoChangedCallback != null) {
                            LoginButton.this.userInfoChangedCallback.onUserInfoFetched(LoginButton.this.user);
                        }
                    }
                    if (response.getError() != null) {
                        LoginButton.this.handleError(response.getError().getException());
                    }
                }
            }));
            this.userInfoSession = session;
            return;
        }
        this.user = null;
        if (this.userInfoChangedCallback == null) return;
        this.userInfoChangedCallback.onUserInfoFetched(this.user);
    }

    private void finishInit() {
        this.setOnClickListener(new LoginClickListener());
        this.setButtonText();
        if (!this.isInEditMode()) {
            this.sessionTracker = new SessionTracker(this.getContext(), new LoginButtonCallback(), null, false);
            this.fetchUserInfo();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean initializeActiveSessionWithCachedToken(Context context) {
        block5: {
            block4: {
                if (context == null) break block4;
                Session session = Session.getActiveSession();
                if (session != null) {
                    return session.isOpened();
                }
                if (Utility.getMetadataApplicationId(context) != null && Session.openActiveSessionFromCache(context) != null) break block5;
            }
            return false;
        }
        return true;
    }

    private void parseAttributes(AttributeSet attributeSet) {
        TypedArray typedArray = this.getContext().obtainStyledAttributes(attributeSet, R.styleable.com_facebook_login_view);
        this.confirmLogout = typedArray.getBoolean(0, true);
        this.fetchUserInfo = typedArray.getBoolean(1, true);
        this.loginText = typedArray.getString(2);
        this.logoutText = typedArray.getString(3);
        typedArray.recycle();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setButtonText() {
        if (this.sessionTracker != null && this.sessionTracker.getOpenSession() != null) {
            String string2 = this.logoutText != null ? this.logoutText : this.getResources().getString(R.string.com_facebook_loginview_log_out_button);
            this.setText(string2);
            return;
        }
        String string3 = this.loginText != null ? this.loginText : this.getResources().getString(R.string.com_facebook_loginview_log_in_button);
        this.setText(string3);
    }

    public void clearPermissions() {
        this.properties.clearPermissions();
    }

    public SessionDefaultAudience getDefaultAudience() {
        return this.properties.getDefaultAudience();
    }

    public SessionLoginBehavior getLoginBehavior() {
        return this.properties.getLoginBehavior();
    }

    public OnErrorListener getOnErrorListener() {
        return this.properties.getOnErrorListener();
    }

    List<String> getPermissions() {
        return this.properties.getPermissions();
    }

    public Session.StatusCallback getSessionStatusCallback() {
        return this.properties.getSessionStatusCallback();
    }

    public UserInfoChangedCallback getUserInfoChangedCallback() {
        return this.userInfoChangedCallback;
    }

    void handleError(Exception exception) {
        block3: {
            block2: {
                if (this.properties.onErrorListener == null) break block2;
                if (!(exception instanceof FacebookException)) break block3;
                this.properties.onErrorListener.onError((FacebookException)exception);
            }
            return;
        }
        this.properties.onErrorListener.onError(new FacebookException(exception));
    }

    public boolean onActivityResult(int n2, int n3, Intent intent) {
        Session session = this.sessionTracker.getSession();
        if (session != null) {
            return session.onActivityResult((Activity)this.getContext(), n2, n3, intent);
        }
        return false;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.sessionTracker != null && !this.sessionTracker.isTracking()) {
            this.sessionTracker.startTracking();
            this.fetchUserInfo();
            this.setButtonText();
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.sessionTracker != null) {
            this.sessionTracker.stopTracking();
        }
    }

    public void onFinishInflate() {
        super.onFinishInflate();
        this.finishInit();
    }

    public void setApplicationId(String string2) {
        this.applicationId = string2;
    }

    public void setDefaultAudience(SessionDefaultAudience sessionDefaultAudience) {
        this.properties.setDefaultAudience(sessionDefaultAudience);
    }

    public void setFragment(Fragment fragment) {
        this.parentFragment = fragment;
    }

    public void setLoginBehavior(SessionLoginBehavior sessionLoginBehavior) {
        this.properties.setLoginBehavior(sessionLoginBehavior);
    }

    void setLoginLogoutEventName(String string2) {
        this.loginLogoutEventName = string2;
    }

    public void setOnErrorListener(OnErrorListener onErrorListener) {
        this.properties.setOnErrorListener(onErrorListener);
    }

    void setProperties(LoginButtonProperties loginButtonProperties) {
        this.properties = loginButtonProperties;
    }

    public void setPublishPermissions(List<String> list) {
        this.properties.setPublishPermissions(list, this.sessionTracker.getSession());
    }

    public void setPublishPermissions(String ... stringArray) {
        this.properties.setPublishPermissions(Arrays.asList(stringArray), this.sessionTracker.getSession());
    }

    public void setReadPermissions(List<String> list) {
        this.properties.setReadPermissions(list, this.sessionTracker.getSession());
    }

    public void setReadPermissions(String ... stringArray) {
        this.properties.setReadPermissions(Arrays.asList(stringArray), this.sessionTracker.getSession());
    }

    public void setSession(Session session) {
        this.sessionTracker.setSession(session);
        this.fetchUserInfo();
        this.setButtonText();
    }

    public void setSessionStatusCallback(Session.StatusCallback statusCallback) {
        this.properties.setSessionStatusCallback(statusCallback);
    }

    public void setUserInfoChangedCallback(UserInfoChangedCallback userInfoChangedCallback) {
        this.userInfoChangedCallback = userInfoChangedCallback;
    }

    private class LoginButtonCallback
    implements Session.StatusCallback {
        private LoginButtonCallback() {
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void call(Session session, SessionState sessionState, Exception exception) {
            LoginButton.this.fetchUserInfo();
            LoginButton.this.setButtonText();
            if (LoginButton.this.properties.sessionStatusCallback != null) {
                LoginButton.this.properties.sessionStatusCallback.call(session, sessionState, exception);
                return;
            } else {
                if (exception == null) return;
                LoginButton.this.handleError(exception);
                return;
            }
        }
    }

    static class LoginButtonProperties {
        private SessionAuthorizationType authorizationType = null;
        private SessionDefaultAudience defaultAudience = SessionDefaultAudience.FRIENDS;
        private SessionLoginBehavior loginBehavior;
        private OnErrorListener onErrorListener;
        private List<String> permissions = Collections.emptyList();
        private Session.StatusCallback sessionStatusCallback;

        LoginButtonProperties() {
            this.loginBehavior = SessionLoginBehavior.SSO_WITH_FALLBACK;
        }

        private boolean validatePermissions(List<String> list, SessionAuthorizationType sessionAuthorizationType, Session session) {
            if (SessionAuthorizationType.PUBLISH.equals((Object)sessionAuthorizationType) && Utility.isNullOrEmpty(list)) {
                throw new IllegalArgumentException("Permissions for publish actions cannot be null or empty.");
            }
            if (session != null && session.isOpened() && !Utility.isSubset(list, session.getPermissions())) {
                Log.e((String)TAG, (String)"Cannot set additional permissions when session is already open.");
                return false;
            }
            return true;
        }

        public void clearPermissions() {
            this.permissions = null;
            this.authorizationType = null;
        }

        public SessionDefaultAudience getDefaultAudience() {
            return this.defaultAudience;
        }

        public SessionLoginBehavior getLoginBehavior() {
            return this.loginBehavior;
        }

        public OnErrorListener getOnErrorListener() {
            return this.onErrorListener;
        }

        List<String> getPermissions() {
            return this.permissions;
        }

        public Session.StatusCallback getSessionStatusCallback() {
            return this.sessionStatusCallback;
        }

        public void setDefaultAudience(SessionDefaultAudience sessionDefaultAudience) {
            this.defaultAudience = sessionDefaultAudience;
        }

        public void setLoginBehavior(SessionLoginBehavior sessionLoginBehavior) {
            this.loginBehavior = sessionLoginBehavior;
        }

        public void setOnErrorListener(OnErrorListener onErrorListener) {
            this.onErrorListener = onErrorListener;
        }

        public void setPublishPermissions(List<String> list, Session session) {
            if (SessionAuthorizationType.READ.equals((Object)this.authorizationType)) {
                throw new UnsupportedOperationException("Cannot call setPublishPermissions after setReadPermissions has been called.");
            }
            if (this.validatePermissions(list, SessionAuthorizationType.PUBLISH, session)) {
                this.permissions = list;
                this.authorizationType = SessionAuthorizationType.PUBLISH;
            }
        }

        public void setReadPermissions(List<String> list, Session session) {
            if (SessionAuthorizationType.PUBLISH.equals((Object)this.authorizationType)) {
                throw new UnsupportedOperationException("Cannot call setReadPermissions after setPublishPermissions has been called.");
            }
            if (this.validatePermissions(list, SessionAuthorizationType.READ, session)) {
                this.permissions = list;
                this.authorizationType = SessionAuthorizationType.READ;
            }
        }

        public void setSessionStatusCallback(Session.StatusCallback statusCallback) {
            this.sessionStatusCallback = statusCallback;
        }
    }

    private class LoginClickListener
    implements View.OnClickListener {
        private LoginClickListener() {
        }

        /*
         * Enabled aggressive block sorting
         */
        public void onClick(View view) {
            Context context = LoginButton.this.getContext();
            final Session session = LoginButton.this.sessionTracker.getOpenSession();
            if (session != null) {
                if (LoginButton.this.confirmLogout) {
                    String string2;
                    String string3 = LoginButton.this.getResources().getString(R.string.com_facebook_loginview_log_out_action);
                    String string4 = LoginButton.this.getResources().getString(R.string.com_facebook_loginview_cancel_action);
                    if (LoginButton.this.user != null && LoginButton.this.user.getName() != null) {
                        String string5 = LoginButton.this.getResources().getString(R.string.com_facebook_loginview_logged_in_as);
                        Object[] objectArray = new Object[]{LoginButton.this.user.getName()};
                        string2 = String.format(string5, objectArray);
                    } else {
                        string2 = LoginButton.this.getResources().getString(R.string.com_facebook_loginview_logged_in_using_facebook);
                    }
                    AlertDialog.Builder builder = new AlertDialog.Builder(context);
                    builder.setMessage((CharSequence)string2).setCancelable(true).setPositiveButton((CharSequence)string3, new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface dialogInterface, int n2) {
                            session.closeAndClearTokenInformation();
                        }
                    }).setNegativeButton((CharSequence)string4, null);
                    builder.create().show();
                } else {
                    session.closeAndClearTokenInformation();
                }
            } else {
                Session session2 = LoginButton.this.sessionTracker.getSession();
                if (session2 == null || session2.getState().isClosed()) {
                    LoginButton.this.sessionTracker.setSession(null);
                    Session session3 = new Session.Builder(context).setApplicationId(LoginButton.this.applicationId).build();
                    Session.setActiveSession(session3);
                    session2 = session3;
                }
                if (!session2.isOpened()) {
                    Session.OpenRequest openRequest;
                    if (LoginButton.this.parentFragment != null) {
                        openRequest = new Session.OpenRequest(LoginButton.this.parentFragment);
                    } else {
                        boolean bl2 = context instanceof Activity;
                        openRequest = null;
                        if (bl2) {
                            openRequest = new Session.OpenRequest((Activity)context);
                        }
                    }
                    if (openRequest != null) {
                        openRequest.setDefaultAudience(LoginButton.this.properties.defaultAudience);
                        openRequest.setPermissions(LoginButton.this.properties.permissions);
                        openRequest.setLoginBehavior(LoginButton.this.properties.loginBehavior);
                        if (SessionAuthorizationType.PUBLISH.equals((Object)LoginButton.this.properties.authorizationType)) {
                            session2.openForPublish(openRequest);
                        } else {
                            session2.openForRead(openRequest);
                        }
                    }
                }
            }
            AppEventsLogger appEventsLogger = AppEventsLogger.newLogger(LoginButton.this.getContext());
            Bundle bundle = new Bundle();
            int n2 = session != null ? 0 : 1;
            bundle.putInt("logging_in", n2);
            appEventsLogger.logSdkEvent(LoginButton.this.loginLogoutEventName, null, bundle);
        }
    }

    public static interface OnErrorListener {
        public void onError(FacebookException var1);
    }

    public static interface UserInfoChangedCallback {
        public void onUserInfoFetched(GraphUser var1);
    }
}

