/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.widget;

import android.content.Context;
import android.os.Handler;
import android.support.v4.content.Loader;
import com.facebook.FacebookException;
import com.facebook.FacebookRequestError;
import com.facebook.Request;
import com.facebook.RequestBatch;
import com.facebook.Response;
import com.facebook.internal.CacheableRequestBatch;
import com.facebook.model.GraphObject;
import com.facebook.model.GraphObjectList;
import com.facebook.widget.SimpleGraphObjectCursor;

class GraphObjectPagingLoader<T extends GraphObject>
extends Loader<SimpleGraphObjectCursor<T>> {
    private boolean appendResults = false;
    private Request currentRequest;
    private SimpleGraphObjectCursor<T> cursor;
    private final Class<T> graphObjectClass;
    private boolean loading = false;
    private Request nextRequest;
    private OnErrorListener onErrorListener;
    private Request originalRequest;
    private boolean skipRoundtripIfCached;

    public GraphObjectPagingLoader(Context context, Class<T> clazz) {
        super(context);
        this.graphObjectClass = clazz;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void addResults(Response response) {
        SimpleGraphObjectCursor<T> simpleGraphObjectCursor = this.cursor == null || !this.appendResults ? new SimpleGraphObjectCursor<T>() : new SimpleGraphObjectCursor<T>(this.cursor);
        PagedResults pagedResults = response.getGraphObjectAs(PagedResults.class);
        boolean bl2 = response.getIsFromCache();
        GraphObjectList<T> graphObjectList = pagedResults.getData().castToListOf(this.graphObjectClass);
        boolean bl3 = graphObjectList.size() > 0;
        if (bl3) {
            this.nextRequest = response.getRequestForPagedResults(Response.PagingDirection.NEXT);
            simpleGraphObjectCursor.addGraphObjects(graphObjectList, bl2);
            simpleGraphObjectCursor.setMoreObjectsAvailable(true);
        }
        if (!bl3) {
            simpleGraphObjectCursor.setMoreObjectsAvailable(false);
            simpleGraphObjectCursor.setFromCache(bl2);
            this.nextRequest = null;
        }
        if (!bl2) {
            this.skipRoundtripIfCached = false;
        }
        this.deliverResult(simpleGraphObjectCursor);
    }

    /*
     * Enabled aggressive block sorting
     */
    private CacheableRequestBatch putRequestIntoBatch(Request request, boolean bl2) {
        boolean bl3 = true;
        Request[] requestArray = new Request[bl3];
        requestArray[0] = request;
        CacheableRequestBatch cacheableRequestBatch = new CacheableRequestBatch(requestArray);
        if (bl2) {
            bl3 = false;
        }
        cacheableRequestBatch.setForceRoundTrip(bl3);
        return cacheableRequestBatch;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void requestCompleted(Response response) {
        FacebookException facebookException;
        block6: {
            block5: {
                if (response.getRequest() != this.currentRequest) break block5;
                this.loading = false;
                this.currentRequest = null;
                FacebookRequestError facebookRequestError = response.getError();
                facebookException = facebookRequestError == null ? null : facebookRequestError.getException();
                if (response.getGraphObject() == null && facebookException == null) {
                    facebookException = new FacebookException("GraphObjectPagingLoader received neither a result nor an error.");
                }
                if (facebookException == null) {
                    this.addResults(response);
                    return;
                }
                this.nextRequest = null;
                if (this.onErrorListener != null) break block6;
            }
            return;
        }
        this.onErrorListener.onError(facebookException, this);
    }

    private void startLoading(Request request, boolean bl2, long l2) {
        this.skipRoundtripIfCached = bl2;
        this.appendResults = false;
        this.nextRequest = null;
        this.currentRequest = request;
        this.currentRequest.setCallback(new Request.Callback(){

            @Override
            public void onCompleted(Response response) {
                GraphObjectPagingLoader.this.requestCompleted(response);
            }
        });
        this.loading = true;
        Runnable runnable = new Runnable(this.putRequestIntoBatch(request, bl2)){
            final /* synthetic */ RequestBatch val$batch;
            {
                this.val$batch = requestBatch;
            }

            @Override
            public void run() {
                Request.executeBatchAsync(this.val$batch);
            }
        };
        if (l2 == 0L) {
            runnable.run();
            return;
        }
        new Handler().postDelayed(runnable, l2);
    }

    public void clearResults() {
        this.nextRequest = null;
        this.originalRequest = null;
        this.currentRequest = null;
        this.deliverResult(null);
    }

    @Override
    public void deliverResult(SimpleGraphObjectCursor<T> simpleGraphObjectCursor) {
        SimpleGraphObjectCursor<T> simpleGraphObjectCursor2 = this.cursor;
        this.cursor = simpleGraphObjectCursor;
        if (this.isStarted()) {
            super.deliverResult(simpleGraphObjectCursor);
            if (simpleGraphObjectCursor2 != null && simpleGraphObjectCursor2 != simpleGraphObjectCursor && !simpleGraphObjectCursor2.isClosed()) {
                simpleGraphObjectCursor2.close();
            }
        }
    }

    public void followNextLink() {
        if (this.nextRequest != null) {
            this.appendResults = true;
            this.currentRequest = this.nextRequest;
            this.currentRequest.setCallback(new Request.Callback(){

                @Override
                public void onCompleted(Response response) {
                    GraphObjectPagingLoader.this.requestCompleted(response);
                }
            });
            this.loading = true;
            Request.executeBatchAsync(this.putRequestIntoBatch(this.currentRequest, this.skipRoundtripIfCached));
        }
    }

    public SimpleGraphObjectCursor<T> getCursor() {
        return this.cursor;
    }

    public OnErrorListener getOnErrorListener() {
        return this.onErrorListener;
    }

    public boolean isLoading() {
        return this.loading;
    }

    @Override
    protected void onStartLoading() {
        super.onStartLoading();
        if (this.cursor != null) {
            this.deliverResult(this.cursor);
        }
    }

    public void refreshOriginalRequest(long l2) {
        if (this.originalRequest == null) {
            throw new FacebookException("refreshOriginalRequest may not be called until after startLoading has been called.");
        }
        this.startLoading(this.originalRequest, false, l2);
    }

    public void setOnErrorListener(OnErrorListener onErrorListener) {
        this.onErrorListener = onErrorListener;
    }

    public void startLoading(Request request, boolean bl2) {
        this.originalRequest = request;
        this.startLoading(request, bl2, 0L);
    }

    public static interface OnErrorListener {
        public void onError(FacebookException var1, GraphObjectPagingLoader<?> var2);
    }

    static interface PagedResults
    extends GraphObject {
        public GraphObjectList<GraphObject> getData();
    }
}

