/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.widget;

import android.content.Context;
import android.graphics.Bitmap;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewStub;
import android.widget.BaseAdapter;
import android.widget.CheckBox;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.SectionIndexer;
import android.widget.TextView;
import com.facebook.FacebookException;
import com.facebook.android.R;
import com.facebook.internal.ImageDownloader;
import com.facebook.internal.ImageRequest;
import com.facebook.internal.ImageResponse;
import com.facebook.model.GraphObject;
import com.facebook.widget.GraphObjectCursor;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;

class GraphObjectAdapter<T extends GraphObject>
extends BaseAdapter
implements SectionIndexer {
    static final /* synthetic */ boolean $assertionsDisabled = false;
    private static final int ACTIVITY_CIRCLE_VIEW_TYPE = 2;
    private static final int DISPLAY_SECTIONS_THRESHOLD = 1;
    private static final int GRAPH_OBJECT_VIEW_TYPE = 1;
    private static final int HEADER_VIEW_TYPE = 0;
    private static final String ID = "id";
    private static final int MAX_PREFETCHED_PICTURES = 20;
    private static final String NAME = "name";
    private static final String PICTURE = "picture";
    private Context context;
    private GraphObjectCursor<T> cursor;
    private DataNeededListener dataNeededListener;
    private boolean displaySections;
    private Filter<T> filter;
    private Map<String, T> graphObjectsById;
    private Map<String, ArrayList<T>> graphObjectsBySection;
    private String groupByField;
    private final LayoutInflater inflater;
    private OnErrorListener onErrorListener;
    private final Map<String, ImageRequest> pendingRequests = new HashMap<String, ImageRequest>();
    private Map<String, ImageResponse> prefetchedPictureCache;
    private ArrayList<String> prefetchedProfilePictureIds;
    private List<String> sectionKeys = new ArrayList<String>();
    private boolean showCheckbox;
    private boolean showPicture;
    private List<String> sortFields;

    /*
     * Enabled aggressive block sorting
     */
    static {
        boolean bl2 = !GraphObjectAdapter.class.desiredAssertionStatus();
        $assertionsDisabled = bl2;
    }

    public GraphObjectAdapter(Context context) {
        this.graphObjectsBySection = new HashMap<String, ArrayList<T>>();
        this.graphObjectsById = new HashMap<String, T>();
        this.prefetchedPictureCache = new HashMap<String, ImageResponse>();
        this.prefetchedProfilePictureIds = new ArrayList();
        this.context = context;
        this.inflater = LayoutInflater.from((Context)context);
    }

    private void callOnErrorListener(Exception exception) {
        if (this.onErrorListener != null) {
            if (!(exception instanceof FacebookException)) {
                exception = new FacebookException(exception);
            }
            this.onErrorListener.onError(this, (FacebookException)exception);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int compareGraphObjects(GraphObject graphObject, GraphObject graphObject2, Collection<String> collection, Collator collator) {
        String string2;
        block3: {
            Iterator<String> iterator = collection.iterator();
            while (iterator.hasNext()) {
                String string3 = iterator.next();
                string2 = (String)graphObject.getProperty(string3);
                String string4 = (String)graphObject2.getProperty(string3);
                if (string2 != null && string4 != null) {
                    int n2 = collator.compare(string2, string4);
                    if (n2 == 0) continue;
                    return n2;
                }
                if (string2 == null && string4 == null) {
                    continue;
                }
                break block3;
            }
            return 0;
        }
        if (string2 != null) return 1;
        return -1;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void downloadProfilePicture(final String string2, URI uRI, final ImageView imageView) {
        boolean bl2;
        if (uRI == null || !(bl2 = imageView == null) && uRI.equals(imageView.getTag())) {
            return;
        }
        if (!bl2) {
            imageView.setTag((Object)string2);
            imageView.setImageResource(this.getDefaultPicture());
        }
        ImageRequest imageRequest = new ImageRequest.Builder(this.context.getApplicationContext(), uRI).setCallerTag((Object)this).setCallback(new ImageRequest.Callback(){

            @Override
            public void onCompleted(ImageResponse imageResponse) {
                GraphObjectAdapter.this.processImageResponse(imageResponse, string2, imageView);
            }
        }).build();
        this.pendingRequests.put(string2, imageRequest);
        ImageDownloader.downloadAsync(imageRequest);
    }

    private View getActivityCircleView(View view, ViewGroup viewGroup) {
        View view2 = view;
        if (view2 == null) {
            view2 = this.inflater.inflate(R.layout.com_facebook_picker_activity_circle_row, null);
        }
        ((ProgressBar)view2.findViewById(R.id.com_facebook_picker_row_activity_circle)).setVisibility(0);
        return view2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void processImageResponse(ImageResponse imageResponse, String string2, ImageView imageView) {
        this.pendingRequests.remove(string2);
        if (imageResponse.getError() != null) {
            this.callOnErrorListener(imageResponse.getError());
        }
        if (imageView == null) {
            if (imageResponse.getBitmap() == null) return;
            if (this.prefetchedPictureCache.size() >= 20) {
                String string3 = this.prefetchedProfilePictureIds.remove(0);
                this.prefetchedPictureCache.remove(string3);
            }
            this.prefetchedPictureCache.put(string2, imageResponse);
            return;
        }
        if (!string2.equals(imageView.getTag())) return;
        Exception exception = imageResponse.getError();
        Bitmap bitmap = imageResponse.getBitmap();
        if (exception != null || bitmap == null) return;
        imageView.setImageBitmap(bitmap);
        imageView.setTag((Object)imageResponse.getRequest().getImageUri());
    }

    /*
     * Enabled aggressive block sorting
     */
    private void rebuildSections() {
        int n2 = 1;
        this.sectionKeys = new ArrayList<String>();
        this.graphObjectsBySection = new HashMap<String, ArrayList<T>>();
        this.graphObjectsById = new HashMap<String, T>();
        this.displaySections = false;
        if (this.cursor == null || this.cursor.getCount() == 0) {
            return;
        }
        int n3 = 0;
        this.cursor.moveToFirst();
        do {
            T t2;
            if (!this.filterIncludesItem(t2 = this.cursor.getGraphObject())) continue;
            ++n3;
            String string2 = this.getSectionKeyOfGraphObject(t2);
            if (!this.graphObjectsBySection.containsKey(string2)) {
                this.sectionKeys.add(string2);
                this.graphObjectsBySection.put(string2, new ArrayList());
            }
            ((List)this.graphObjectsBySection.get(string2)).add(t2);
            this.graphObjectsById.put(this.getIdOfGraphObject(t2), t2);
        } while (this.cursor.moveToNext());
        if (this.sortFields != null) {
            final Collator collator = Collator.getInstance();
            Iterator<ArrayList<T>> iterator = this.graphObjectsBySection.values().iterator();
            while (iterator.hasNext()) {
                Collections.sort((List)iterator.next(), new Comparator<GraphObject>(){

                    @Override
                    public int compare(GraphObject graphObject, GraphObject graphObject2) {
                        return GraphObjectAdapter.compareGraphObjects(graphObject, graphObject2, GraphObjectAdapter.this.sortFields, collator);
                    }
                });
            }
        }
        Collections.sort(this.sectionKeys, Collator.getInstance());
        if (this.sectionKeys.size() <= n2 || n3 <= n2) {
            n2 = 0;
        }
        this.displaySections = n2;
    }

    private boolean shouldShowActivityCircleCell() {
        return this.cursor != null && this.cursor.areMoreObjectsAvailable() && this.dataNeededListener != null && !this.isEmpty();
    }

    public boolean areAllItemsEnabled() {
        return this.displaySections;
    }

    public boolean changeCursor(GraphObjectCursor<T> graphObjectCursor) {
        if (this.cursor == graphObjectCursor) {
            return false;
        }
        if (this.cursor != null) {
            this.cursor.close();
        }
        this.cursor = graphObjectCursor;
        this.rebuildAndNotify();
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected View createGraphObjectView(T t2) {
        View view = this.inflater.inflate(this.getGraphObjectRowLayoutId(t2), null);
        ViewStub viewStub = (ViewStub)view.findViewById(R.id.com_facebook_picker_checkbox_stub);
        if (viewStub != null) {
            if (!this.getShowCheckbox()) {
                viewStub.setVisibility(8);
            } else {
                this.updateCheckboxState((CheckBox)viewStub.inflate(), false);
            }
        }
        ViewStub viewStub2 = (ViewStub)view.findViewById(R.id.com_facebook_picker_profile_pic_stub);
        if (!this.getShowPicture()) {
            viewStub2.setVisibility(8);
            return view;
        }
        ((ImageView)viewStub2.inflate()).setVisibility(0);
        return view;
    }

    boolean filterIncludesItem(T t2) {
        return this.filter == null || this.filter.includeItem(t2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public int getCount() {
        int n2;
        block6: {
            block5: {
                int n3 = this.sectionKeys.size();
                n2 = 0;
                if (n3 == 0) break block5;
                boolean bl2 = this.displaySections;
                n2 = 0;
                if (bl2) {
                    n2 = this.sectionKeys.size();
                }
                Iterator<ArrayList<T>> iterator = this.graphObjectsBySection.values().iterator();
                while (iterator.hasNext()) {
                    n2 += ((List)iterator.next()).size();
                }
                if (this.shouldShowActivityCircleCell()) break block6;
            }
            return n2;
        }
        return n2 + 1;
    }

    public GraphObjectCursor<T> getCursor() {
        return this.cursor;
    }

    public DataNeededListener getDataNeededListener() {
        return this.dataNeededListener;
    }

    protected int getDefaultPicture() {
        return R.drawable.com_facebook_profile_default_icon;
    }

    Filter<T> getFilter() {
        return this.filter;
    }

    protected int getGraphObjectRowLayoutId(T t2) {
        return R.layout.com_facebook_picker_list_row;
    }

    protected View getGraphObjectView(T t2, View view, ViewGroup viewGroup) {
        View view2 = view;
        if (view2 == null) {
            view2 = this.createGraphObjectView(t2);
        }
        this.populateGraphObjectView(view2, t2);
        return view2;
    }

    public List<T> getGraphObjectsById(Collection<String> collection) {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll(collection);
        ArrayList<GraphObject> arrayList = new ArrayList<GraphObject>(hashSet.size());
        for (String string2 : hashSet) {
            GraphObject graphObject = (GraphObject)this.graphObjectsById.get(string2);
            if (graphObject == null) continue;
            arrayList.add(graphObject);
        }
        return arrayList;
    }

    public String getGroupByField() {
        return this.groupByField;
    }

    String getIdOfGraphObject(T t2) {
        Object object;
        if (t2.asMap().containsKey(ID) && (object = t2.getProperty(ID)) instanceof String) {
            return (String)object;
        }
        throw new FacebookException("Received an object without an ID.");
    }

    public Object getItem(int n2) {
        SectionAndItem<T> sectionAndItem = this.getSectionAndItem(n2);
        if (sectionAndItem.getType() == SectionAndItem.Type.GRAPH_OBJECT) {
            return sectionAndItem.graphObject;
        }
        return null;
    }

    public long getItemId(int n2) {
        String string2;
        SectionAndItem<T> sectionAndItem = this.getSectionAndItem(n2);
        if (sectionAndItem != null && sectionAndItem.graphObject != null && (string2 = this.getIdOfGraphObject(sectionAndItem.graphObject)) != null) {
            return Long.parseLong(string2);
        }
        return 0L;
    }

    public int getItemViewType(int n2) {
        SectionAndItem<T> sectionAndItem = this.getSectionAndItem(n2);
        switch (3.$SwitchMap$com$facebook$widget$GraphObjectAdapter$SectionAndItem$Type[sectionAndItem.getType().ordinal()]) {
            default: {
                throw new FacebookException("Unexpected type of section and item.");
            }
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 3: 
        }
        return 2;
    }

    public OnErrorListener getOnErrorListener() {
        return this.onErrorListener;
    }

    String getPictureFieldSpecifier() {
        ImageView imageView = (ImageView)this.createGraphObjectView(null).findViewById(R.id.com_facebook_picker_image);
        if (imageView == null) {
            return null;
        }
        ViewGroup.LayoutParams layoutParams = imageView.getLayoutParams();
        Object[] objectArray = new Object[]{layoutParams.height, layoutParams.width};
        return String.format("picture.height(%d).width(%d)", objectArray);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected URI getPictureUriOfGraphObject(T t2) {
        String string2;
        Object object = t2.getProperty(PICTURE);
        if (object instanceof String) {
            string2 = (String)object;
        } else {
            boolean bl2 = object instanceof JSONObject;
            string2 = null;
            if (bl2) {
                ItemPictureData itemPictureData = GraphObject.Factory.create((JSONObject)object).cast(ItemPicture.class).getData();
                string2 = null;
                if (itemPictureData != null) {
                    string2 = itemPictureData.getUrl();
                }
            }
        }
        if (string2 == null) return null;
        try {
            return new URI(string2);
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    int getPosition(String string2, T t2) {
        int n2 = 0;
        Iterator<String> iterator = this.sectionKeys.iterator();
        while (true) {
            String string3;
            block11: {
                boolean bl2;
                block10: {
                    boolean bl3 = iterator.hasNext();
                    bl2 = false;
                    if (!bl3) break block10;
                    string3 = iterator.next();
                    if (this.displaySections) {
                        ++n2;
                    }
                    if (!string3.equals(string2)) break block11;
                    bl2 = true;
                }
                if (bl2) break;
                return -1;
            }
            n2 += this.graphObjectsBySection.get(string3).size();
        }
        if (t2 == null) {
            int n3;
            if (this.displaySections) {
                n3 = 1;
                return n2 - n3;
            }
            n3 = 0;
            return n2 - n3;
        }
        Iterator<T> iterator2 = this.graphObjectsBySection.get(string2).iterator();
        while (iterator2.hasNext()) {
            if (GraphObject.Factory.hasSameId((GraphObject)iterator2.next(), t2)) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public int getPositionForSection(int n2) {
        boolean bl2 = this.displaySections;
        int n3 = 0;
        if (bl2) {
            int n4 = Math.max(0, Math.min(n2, -1 + this.sectionKeys.size()));
            int n5 = this.sectionKeys.size();
            n3 = 0;
            if (n4 < n5) {
                n3 = this.getPosition(this.sectionKeys.get(n4), null);
            }
        }
        return n3;
    }

    /*
     * Unable to fully structure code
     */
    SectionAndItem<T> getSectionAndItem(int var1_1) {
        block6: {
            block4: {
                block5: {
                    if (this.sectionKeys.size() == 0) {
                        return null;
                    }
                    if (this.displaySections) break block4;
                    var5_2 = this.sectionKeys.get(0);
                    var9_3 = this.graphObjectsBySection.get(var5_2);
                    if (var1_1 < 0 || var1_1 >= var9_3.size()) break block5;
                    var4_4 = (GraphObject)this.graphObjectsBySection.get(var5_2).get(var1_1);
lbl8:
                    // 4 sources

                    while (var5_2 != null) {
                        return new SectionAndItem<Object>(var5_2, var4_4);
                    }
                    break block6;
                }
                if (!(GraphObjectAdapter.$assertionsDisabled || this.dataNeededListener != null && this.cursor.areMoreObjectsAvailable())) {
                    throw new AssertionError();
                }
                return new SectionAndItem<Object>(null, null);
            }
            var2_5 = this.sectionKeys.iterator();
            while (true) {
                block8: {
                    block7: {
                        var3_6 = var2_5.hasNext();
                        var4_4 = null;
                        var5_2 = null;
                        if (!var3_6) ** GOTO lbl8
                        var6_7 = var2_5.next();
                        var7_8 = var1_1 - 1;
                        if (var1_1 != 0) break block7;
                        var5_2 = var6_7;
                        var4_4 = null;
                        ** GOTO lbl8
                    }
                    var8_9 = this.graphObjectsBySection.get(var6_7);
                    if (var7_8 >= var8_9.size()) break block8;
                    var5_2 = var6_7;
                    var4_4 = (GraphObject)var8_9.get(var7_8);
                    ** GOTO lbl8
                }
                var1_1 = var7_8 - var8_9.size();
            }
        }
        throw new IndexOutOfBoundsException("position");
    }

    public int getSectionForPosition(int n2) {
        SectionAndItem<T> sectionAndItem = this.getSectionAndItem(n2);
        int n3 = 0;
        if (sectionAndItem != null) {
            SectionAndItem.Type type = sectionAndItem.getType();
            SectionAndItem.Type type2 = SectionAndItem.Type.ACTIVITY_CIRCLE;
            n3 = 0;
            if (type != type2) {
                n3 = Math.max(0, Math.min(this.sectionKeys.indexOf(sectionAndItem.sectionKey), -1 + this.sectionKeys.size()));
            }
        }
        return n3;
    }

    protected View getSectionHeaderView(String string2, View view, ViewGroup viewGroup) {
        TextView textView = (TextView)view;
        if (textView == null) {
            textView = (TextView)this.inflater.inflate(R.layout.com_facebook_picker_list_section_header, null);
        }
        textView.setText((CharSequence)string2);
        return textView;
    }

    protected String getSectionKeyOfGraphObject(T t2) {
        String string2 = this.groupByField;
        String string3 = null;
        if (string2 != null && (string3 = (String)t2.getProperty(this.groupByField)) != null && string3.length() > 0) {
            string3 = string3.substring(0, 1).toUpperCase();
        }
        if (string3 != null) {
            return string3;
        }
        return "";
    }

    public Object[] getSections() {
        if (this.displaySections) {
            return this.sectionKeys.toArray();
        }
        return new Object[0];
    }

    public boolean getShowCheckbox() {
        return this.showCheckbox;
    }

    public boolean getShowPicture() {
        return this.showPicture;
    }

    public List<String> getSortFields() {
        return this.sortFields;
    }

    protected CharSequence getSubTitleOfGraphObject(T t2) {
        return null;
    }

    protected CharSequence getTitleOfGraphObject(T t2) {
        return (String)t2.getProperty(NAME);
    }

    public View getView(int n2, View view, ViewGroup viewGroup) {
        SectionAndItem<T> sectionAndItem = this.getSectionAndItem(n2);
        switch (3.$SwitchMap$com$facebook$widget$GraphObjectAdapter$SectionAndItem$Type[sectionAndItem.getType().ordinal()]) {
            default: {
                throw new FacebookException("Unexpected type of section and item.");
            }
            case 1: {
                return this.getSectionHeaderView(sectionAndItem.sectionKey, view, viewGroup);
            }
            case 2: {
                return this.getGraphObjectView(sectionAndItem.graphObject, view, viewGroup);
            }
            case 3: 
        }
        if (!($assertionsDisabled || this.cursor.areMoreObjectsAvailable() && this.dataNeededListener != null)) {
            throw new AssertionError();
        }
        this.dataNeededListener.onDataNeeded();
        return this.getActivityCircleView(view, viewGroup);
    }

    public int getViewTypeCount() {
        return 3;
    }

    public boolean hasStableIds() {
        return true;
    }

    public boolean isEmpty() {
        return this.sectionKeys.size() == 0;
    }

    public boolean isEnabled(int n2) {
        return this.getSectionAndItem(n2).getType() == SectionAndItem.Type.GRAPH_OBJECT;
    }

    boolean isGraphObjectSelected(String string2) {
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void populateGraphObjectView(View view, T t2) {
        URI uRI;
        String string2 = this.getIdOfGraphObject(t2);
        view.setTag((Object)string2);
        CharSequence charSequence = this.getTitleOfGraphObject(t2);
        TextView textView = (TextView)view.findViewById(R.id.com_facebook_picker_title);
        if (textView != null) {
            textView.setText(charSequence, TextView.BufferType.SPANNABLE);
        }
        CharSequence charSequence2 = this.getSubTitleOfGraphObject(t2);
        TextView textView2 = (TextView)view.findViewById(R.id.picker_subtitle);
        if (textView2 != null) {
            if (charSequence2 != null) {
                textView2.setText(charSequence2, TextView.BufferType.SPANNABLE);
                textView2.setVisibility(0);
            } else {
                textView2.setVisibility(8);
            }
        }
        if (this.getShowCheckbox()) {
            this.updateCheckboxState((CheckBox)view.findViewById(R.id.com_facebook_picker_checkbox), this.isGraphObjectSelected(string2));
        }
        if (this.getShowPicture() && (uRI = this.getPictureUriOfGraphObject(t2)) != null) {
            ImageView imageView = (ImageView)view.findViewById(R.id.com_facebook_picker_image);
            if (!this.prefetchedPictureCache.containsKey(string2)) {
                this.downloadProfilePicture(string2, uRI, imageView);
                return;
            }
            ImageResponse imageResponse = this.prefetchedPictureCache.get(string2);
            imageView.setImageBitmap(imageResponse.getBitmap());
            imageView.setTag((Object)imageResponse.getRequest().getImageUri());
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void prioritizeViewRange(int n2, int n3, int n4) {
        if (n3 >= n2 && this.sectionKeys.size() != 0) {
            for (int i2 = n3; i2 >= 0; --i2) {
                String string2;
                ImageRequest imageRequest;
                SectionAndItem<T> sectionAndItem = this.getSectionAndItem(i2);
                if (sectionAndItem.graphObject == null || (imageRequest = this.pendingRequests.get(string2 = this.getIdOfGraphObject(sectionAndItem.graphObject))) == null) continue;
                ImageDownloader.prioritizeRequest(imageRequest);
            }
            int n5 = Math.max(0, n2 - n4);
            int n6 = Math.min(n3 + n4, -1 + this.getCount());
            ArrayList arrayList = new ArrayList();
            for (int i3 = n5; i3 < n2; ++i3) {
                SectionAndItem<T> sectionAndItem = this.getSectionAndItem(i3);
                if (sectionAndItem.graphObject == null) continue;
                arrayList.add(sectionAndItem.graphObject);
            }
            for (int i4 = n3 + 1; i4 <= n6; ++i4) {
                SectionAndItem<T> sectionAndItem = this.getSectionAndItem(i4);
                if (sectionAndItem.graphObject == null) continue;
                arrayList.add(sectionAndItem.graphObject);
            }
            for (GraphObject graphObject : arrayList) {
                URI uRI = this.getPictureUriOfGraphObject(graphObject);
                String string3 = this.getIdOfGraphObject(graphObject);
                boolean bl2 = this.prefetchedProfilePictureIds.remove(string3);
                this.prefetchedProfilePictureIds.add(string3);
                if (bl2) continue;
                this.downloadProfilePicture(string3, uRI, null);
            }
        }
    }

    public void rebuildAndNotify() {
        this.rebuildSections();
        this.notifyDataSetChanged();
    }

    public void setDataNeededListener(DataNeededListener dataNeededListener) {
        this.dataNeededListener = dataNeededListener;
    }

    void setFilter(Filter<T> filter) {
        this.filter = filter;
    }

    public void setGroupByField(String string2) {
        this.groupByField = string2;
    }

    public void setOnErrorListener(OnErrorListener onErrorListener) {
        this.onErrorListener = onErrorListener;
    }

    public void setShowCheckbox(boolean bl2) {
        this.showCheckbox = bl2;
    }

    public void setShowPicture(boolean bl2) {
        this.showPicture = bl2;
    }

    public void setSortFields(List<String> list) {
        this.sortFields = list;
    }

    void updateCheckboxState(CheckBox checkBox, boolean bl2) {
    }

    public static interface DataNeededListener {
        public void onDataNeeded();
    }

    static interface Filter<T> {
        public boolean includeItem(T var1);
    }

    private static interface ItemPicture
    extends GraphObject {
        public ItemPictureData getData();
    }

    private static interface ItemPictureData
    extends GraphObject {
        public String getUrl();
    }

    public static interface OnErrorListener {
        public void onError(GraphObjectAdapter<?> var1, FacebookException var2);
    }

    public static class SectionAndItem<T extends GraphObject> {
        public T graphObject;
        public String sectionKey;

        public SectionAndItem(String string2, T t2) {
            this.sectionKey = string2;
            this.graphObject = t2;
        }

        public Type getType() {
            if (this.sectionKey == null) {
                return Type.ACTIVITY_CIRCLE;
            }
            if (this.graphObject == null) {
                return Type.SECTION_HEADER;
            }
            return Type.GRAPH_OBJECT;
        }

        public static final class Type
        extends Enum<Type> {
            private static final /* synthetic */ Type[] $VALUES;
            public static final /* enum */ Type ACTIVITY_CIRCLE;
            public static final /* enum */ Type GRAPH_OBJECT;
            public static final /* enum */ Type SECTION_HEADER;

            static {
                GRAPH_OBJECT = new Type();
                SECTION_HEADER = new Type();
                ACTIVITY_CIRCLE = new Type();
                Type[] typeArray = new Type[]{GRAPH_OBJECT, SECTION_HEADER, ACTIVITY_CIRCLE};
                $VALUES = typeArray;
            }

            public static Type valueOf(String string2) {
                return Enum.valueOf(Type.class, string2);
            }

            public static Type[] values() {
                return (Type[])$VALUES.clone();
            }
        }
    }
}

