/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.widget;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.res.TypedArray;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.AttributeSet;
import com.facebook.AppEventsLogger;
import com.facebook.FacebookException;
import com.facebook.Request;
import com.facebook.Session;
import com.facebook.android.R;
import com.facebook.model.GraphUser;
import com.facebook.widget.GraphObjectPagingLoader;
import com.facebook.widget.PickerFragment;
import com.facebook.widget.SimpleGraphObjectCursor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class FriendPickerFragment
extends PickerFragment<GraphUser> {
    private static final String ID = "id";
    public static final String MULTI_SELECT_BUNDLE_KEY = "com.facebook.widget.FriendPickerFragment.MultiSelect";
    private static final String NAME = "name";
    public static final String USER_ID_BUNDLE_KEY = "com.facebook.widget.FriendPickerFragment.UserId";
    private boolean multiSelect = true;
    private List<String> preSelectedFriendIds = new ArrayList<String>();
    private String userId;

    public FriendPickerFragment() {
        this(null);
    }

    @SuppressLint(value={"ValidFragment"})
    public FriendPickerFragment(Bundle bundle) {
        super(GraphUser.class, R.layout.com_facebook_friendpickerfragment, bundle);
        this.setFriendPickerSettingsFromBundle(bundle);
    }

    private Request createRequest(String string2, Set<String> set, Session session) {
        Request request = Request.newGraphPathRequest(session, string2 + "/friends", null);
        HashSet<String> hashSet = new HashSet<String>(set);
        hashSet.addAll(Arrays.asList(ID, NAME));
        String string3 = this.adapter.getPictureFieldSpecifier();
        if (string3 != null) {
            hashSet.add(string3);
        }
        Bundle bundle = request.getParameters();
        bundle.putString("fields", TextUtils.join((CharSequence)",", hashSet));
        request.setParameters(bundle);
        return request;
    }

    private void setFriendPickerSettingsFromBundle(Bundle bundle) {
        if (bundle != null) {
            if (bundle.containsKey(USER_ID_BUNDLE_KEY)) {
                this.setUserId(bundle.getString(USER_ID_BUNDLE_KEY));
            }
            this.setMultiSelect(bundle.getBoolean(MULTI_SELECT_BUNDLE_KEY, this.multiSelect));
        }
    }

    @Override
    PickerFragment.PickerFragmentAdapter<GraphUser> createAdapter() {
        PickerFragment.PickerFragmentAdapter<GraphUser> pickerFragmentAdapter = new PickerFragment.PickerFragmentAdapter<GraphUser>((Context)this.getActivity()){

            @Override
            protected int getDefaultPicture() {
                return R.drawable.com_facebook_profile_default_icon;
            }

            @Override
            protected int getGraphObjectRowLayoutId(GraphUser graphUser) {
                return R.layout.com_facebook_picker_list_row;
            }
        };
        pickerFragmentAdapter.setShowCheckbox(true);
        pickerFragmentAdapter.setShowPicture(this.getShowPictures());
        pickerFragmentAdapter.setSortFields(Arrays.asList(NAME));
        pickerFragmentAdapter.setGroupByField(NAME);
        return pickerFragmentAdapter;
    }

    @Override
    PickerFragment.LoadingStrategy createLoadingStrategy() {
        return new ImmediateLoadingStrategy();
    }

    @Override
    PickerFragment.SelectionStrategy createSelectionStrategy() {
        if (this.multiSelect) {
            return new PickerFragment.MultiSelectionStrategy();
        }
        return new PickerFragment.SingleSelectionStrategy();
    }

    @Override
    String getDefaultTitleText() {
        return this.getString(R.string.com_facebook_choose_friends);
    }

    public boolean getMultiSelect() {
        return this.multiSelect;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    Request getRequestForLoadData(Session session) {
        String string2;
        if (this.adapter == null) {
            throw new FacebookException("Can't issue requests until Fragment has been created.");
        }
        if (this.userId != null) {
            string2 = this.userId;
            return this.createRequest(string2, this.extraFields, session);
        }
        string2 = "me";
        return this.createRequest(string2, this.extraFields, session);
    }

    public List<GraphUser> getSelection() {
        return this.getSelectedGraphObjects();
    }

    public String getUserId() {
        return this.userId;
    }

    @Override
    public void loadData(boolean bl2) {
        super.loadData(bl2);
        this.setSelectedGraphObjects(this.preSelectedFriendIds);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    void logAppEvents(boolean bl2) {
        AppEventsLogger appEventsLogger = AppEventsLogger.newLogger((Context)this.getActivity(), this.getSession());
        Bundle bundle = new Bundle();
        String string2 = bl2 ? "Completed" : "Unknown";
        bundle.putString("fb_dialog_outcome", string2);
        bundle.putInt("num_friends_picked", this.getSelection().size());
        appEventsLogger.logSdkEvent("fb_friend_picker_usage", null, bundle);
    }

    @Override
    public void onInflate(Activity activity, AttributeSet attributeSet, Bundle bundle) {
        super.onInflate(activity, attributeSet, bundle);
        TypedArray typedArray = activity.obtainStyledAttributes(attributeSet, R.styleable.com_facebook_friend_picker_fragment);
        this.setMultiSelect(typedArray.getBoolean(0, this.multiSelect));
        typedArray.recycle();
    }

    @Override
    void saveSettingsToBundle(Bundle bundle) {
        super.saveSettingsToBundle(bundle);
        bundle.putString(USER_ID_BUNDLE_KEY, this.userId);
        bundle.putBoolean(MULTI_SELECT_BUNDLE_KEY, this.multiSelect);
    }

    public void setMultiSelect(boolean bl2) {
        if (this.multiSelect != bl2) {
            this.multiSelect = bl2;
            this.setSelectionStrategy(this.createSelectionStrategy());
        }
    }

    public void setSelection(List<GraphUser> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator<GraphUser> iterator = list.iterator();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next().getId());
        }
        this.setSelectionByIds(arrayList);
    }

    public void setSelection(GraphUser ... graphUserArray) {
        this.setSelection(Arrays.asList(graphUserArray));
    }

    public void setSelectionByIds(List<String> list) {
        this.preSelectedFriendIds.addAll(list);
    }

    public void setSelectionByIds(String ... stringArray) {
        this.setSelectionByIds(Arrays.asList(stringArray));
    }

    @Override
    public void setSettingsFromBundle(Bundle bundle) {
        super.setSettingsFromBundle(bundle);
        this.setFriendPickerSettingsFromBundle(bundle);
    }

    public void setUserId(String string2) {
        this.userId = string2;
    }

    private class ImmediateLoadingStrategy
    extends PickerFragment.LoadingStrategy {
        private ImmediateLoadingStrategy() {
        }

        private void followNextLink() {
            FriendPickerFragment.this.displayActivityCircle();
            this.loader.followNextLink();
        }

        /*
         * Enabled aggressive block sorting
         */
        protected void onLoadFinished(GraphObjectPagingLoader<GraphUser> graphObjectPagingLoader, SimpleGraphObjectCursor<GraphUser> simpleGraphObjectCursor) {
            block5: {
                block4: {
                    super.onLoadFinished(graphObjectPagingLoader, simpleGraphObjectCursor);
                    if (simpleGraphObjectCursor == null || graphObjectPagingLoader.isLoading()) break block4;
                    if (simpleGraphObjectCursor.areMoreObjectsAvailable()) {
                        this.followNextLink();
                        return;
                    }
                    FriendPickerFragment.this.hideActivityCircle();
                    if (simpleGraphObjectCursor.isFromCache()) break block5;
                }
                return;
            }
            long l2 = simpleGraphObjectCursor.getCount() == 0 ? 2000L : 0L;
            graphObjectPagingLoader.refreshOriginalRequest(l2);
        }
    }
}

